/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VoidValue;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jde.debugger.LispForm;
import jde.debugger.ObjectStore;
import jde.debugger.Protocol;

public class Rep
implements Protocol {
    static LispForm getLocationRep(Location location) {
        String string = "(list \"" + location.declaringType().name() + "\"";
        try {
            string = string + " \"" + location.sourceName() + "\"";
        }
        catch (AbsentInformationException absentInformationException) {
            string = string + " nil";
        }
        string = string + " " + location.lineNumber() + ")";
        return new LispForm(string);
    }

    static LispForm getMethodRep(Method method) {
        List<String> list = method.argumentTypeNames();
        String string = "(list";
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            string = string + " \"" + iterator.next().toString() + "\"";
        }
        string = string + ")";
        return new LispForm("(list \"" + method.declaringType().name() + "\"" + " \"" + method.name() + "\"" + " \"" + method.returnTypeName() + "\"" + Protocol.BR + string + (method.isFinal() ? " \"final\"" : "") + (method.isStatic() ? " \"static\"" : "") + (method.isNative() ? " \"native\"" : "") + (method.isConstructor() ? " \"constructor\"" : "") + (method.isAbstract() ? " \"abstract\"" : "") + (method.isSynchronized() ? " \"synchronized\"" : "") + (method.isStaticInitializer() ? " \"static_initializer\"" : "") + ")");
    }

    public static LispForm getLocalVariableRep(LocalVariable localVariable) {
        return new LispForm("(list \"" + localVariable.name() + "\"" + " \"" + localVariable.typeName() + "\")");
    }

    public static LispForm getLocalVariableValueRep(LocalVariable localVariable, Value value, ObjectStore objectStore) {
        return new LispForm("(cons " + Rep.getLocalVariableRep(localVariable) + " " + Rep.getValueRep(value, objectStore) + ")");
    }

    public static LispForm getLocalVariableValueMapRep(Map map, ObjectStore objectStore) {
        String string = "(list ";
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            LocalVariable localVariable = (LocalVariable)iterator.next();
            Value value = (Value)map.get(localVariable);
            string = string + Protocol.BR + Rep.getLocalVariableValueRep(localVariable, value, objectStore);
        }
        string = string + ")";
        return new LispForm(string);
    }

    static LispForm getFieldRep(Field field) {
        return new LispForm("(list \"" + field.name() + "\"" + " \"" + field.typeName() + "\"" + (field.isTransient() ? " \"transient\"" : "") + (field.isVolatile() ? " \"volatile\"" : "") + (field.isFinal() ? " \"final\"" : "") + (field.isStatic() ? " \"static\"" : "") + ")");
    }

    static LispForm getFieldValueRep(Field field, Value value, ObjectStore objectStore) {
        return new LispForm("(cons " + Rep.getFieldRep(field) + " " + Rep.getValueRep(value, objectStore) + ")");
    }

    static LispForm getFieldValueMapRep(Map map, ObjectStore objectStore) {
        String string = "(list ";
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            Value value = (Value)map.get(field);
            string = string + Protocol.BR + Rep.getFieldValueRep(field, value, objectStore);
        }
        string = string + ")";
        return new LispForm(string);
    }

    private static String filterFPValue(String string) {
        if (string.equals("NaN")) {
            return "\"NaN\"";
        }
        if (string.equals("-Infinity")) {
            return "\"-Infinity\"";
        }
        if (string.equals("Infinity")) {
            return "\"Infinity\"";
        }
        return string;
    }

    public static LispForm getValueRep(Value value, ObjectStore objectStore) {
        if (value == null) {
            return new LispForm("(list \"null\")");
        }
        if (value instanceof VoidValue) {
            return new LispForm("(list \"void\")");
        }
        if (value instanceof ObjectReference) {
            return Rep.getObjectRep((ObjectReference)value, objectStore);
        }
        PrimitiveValue primitiveValue = (PrimitiveValue)value;
        if (primitiveValue instanceof BooleanValue) {
            return new LispForm("(list \"boolean\" \"" + primitiveValue.booleanValue() + "\")");
        }
        if (primitiveValue instanceof ByteValue) {
            return new LispForm("(list \"byte\" \"" + primitiveValue.byteValue() + "\")");
        }
        if (primitiveValue instanceof CharValue) {
            return new LispForm("(list \"char\" \"" + primitiveValue.charValue() + "\")");
        }
        if (primitiveValue instanceof DoubleValue) {
            String string = "" + primitiveValue.doubleValue();
            return new LispForm("(list \"double\" " + Rep.filterFPValue(string) + ")");
        }
        if (primitiveValue instanceof FloatValue) {
            String string = "" + primitiveValue.floatValue();
            return new LispForm("(list \"float\" " + Rep.filterFPValue(string) + ")");
        }
        if (primitiveValue instanceof IntegerValue) {
            return new LispForm("(list \"int\" \"" + primitiveValue.intValue() + "\")");
        }
        if (primitiveValue instanceof LongValue) {
            return new LispForm("(list \"long\" \"" + primitiveValue.longValue() + "\")");
        }
        if (primitiveValue instanceof ShortValue) {
            return new LispForm("(list \"short\" " + primitiveValue.shortValue() + ")");
        }
        return null;
    }

    public static LispForm getArrayRep(ArrayReference arrayReference, ObjectStore objectStore, int n, int n2) {
        if (arrayReference == null) {
            return new LispForm("\"Error!\"");
        }
        objectStore.put(arrayReference);
        String string = "";
        try {
            if (n != -1) {
                List<Value> list = arrayReference.getValues(n, n2);
                Iterator<Value> iterator = list.iterator();
                while (iterator.hasNext()) {
                    string = string + " " + Rep.getValueRep(iterator.next(), objectStore);
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            string = "\"Index out of bounds\"";
        }
        catch (ObjectCollectedException objectCollectedException) {
            string = "\"The object has already been collected\"";
        }
        return new LispForm("(list \"" + arrayReference.referenceType().name() + "\"" + " " + arrayReference.uniqueID() + (arrayReference.isCollected() ? " 't" : " nil") + " " + arrayReference.length() + string + ")");
    }

    public static String escapeString(String string) {
        if (string.indexOf(92) == -1 && string.indexOf(34) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 16);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static LispForm getStringRep(StringReference stringReference, ObjectStore objectStore) {
        if (stringReference == null) {
            return new LispForm("\"Error!\"");
        }
        objectStore.put(stringReference);
        return new LispForm("(list \"" + stringReference.referenceType().name() + "\"" + " " + stringReference.uniqueID() + (stringReference.isCollected() ? " 't" : " nil") + " \"" + Rep.escapeString(stringReference.value()) + "\")");
    }

    public static LispForm getObjectRep(ObjectReference objectReference, ObjectStore objectStore) {
        return Rep.getObjectRep(objectReference, objectStore, false);
    }

    public static LispForm getObjectRep(ObjectReference objectReference, ObjectStore objectStore, boolean bl) {
        if (objectReference == null) {
            return new LispForm("(list \"null\")");
        }
        objectStore.put(objectReference);
        if (bl) {
            String string;
            try {
                string = Rep.getFieldValueMapRep(objectReference.getValues(objectReference.referenceType().visibleFields()), objectStore).toString();
            }
            catch (ClassNotPreparedException classNotPreparedException) {
                string = "\"The class isn't prepared\"";
            }
            catch (ObjectCollectedException objectCollectedException) {
                string = "\"The object has already been collected\"";
            }
            catch (Exception exception) {
                string = "\"Unable to access fields and values. Optimized class?\"";
            }
            return new LispForm("(list \"" + objectReference.referenceType().name() + "\"" + " " + objectReference.uniqueID() + (objectReference.isCollected() ? " 't" : " nil") + Protocol.BR + string + ")");
        }
        return new LispForm("(list \"" + objectReference.referenceType().name() + "\"" + " " + objectReference.uniqueID() + (objectReference.isCollected() ? " 't" : " nil") + ")");
    }

    static LispForm getObjectMonitorsRep(ObjectReference objectReference, ObjectStore objectStore) {
        String string;
        Object object;
        if (objectReference == null) {
            return new LispForm("null");
        }
        objectStore.put(objectReference);
        try {
            object = objectReference.owningThread();
            string = object == null ? "nil" : Rep.getThreadRep((ThreadReference)object, objectStore).toString();
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            string = "\"Information Not Available\"";
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            string = "\"VM has no information\"";
        }
        try {
            object = "(list";
            List<ThreadReference> list = objectReference.waitingThreads();
            Iterator<ThreadReference> iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (String)object + Protocol.BR + Rep.getThreadRep(iterator.next(), objectStore);
            }
            object = (String)object + ")";
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            object = "\"Information Not Available\"";
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            object = "\"VM has no information\"";
        }
        return new LispForm("(list " + objectReference.uniqueID() + " " + "\"" + objectReference.referenceType().name() + "\"" + (objectReference.isCollected() ? " 't" : " nil") + Protocol.BR + string + Protocol.BR + (String)object + ")");
    }

    static LispForm getThreadGroupRep(ThreadGroupReference threadGroupReference, ObjectStore objectStore) {
        objectStore.put(threadGroupReference);
        String string = "(list \"ThreadGroup\" " + threadGroupReference.uniqueID() + " \"" + threadGroupReference.name() + "\" ";
        List<ObjectReference> list = threadGroupReference.threads();
        Iterator<ObjectReference> iterator = list.iterator();
        string = string + Protocol.BR + "(list";
        while (iterator.hasNext()) {
            string = string + Protocol.BR + Rep.getThreadRep(iterator.next(), objectStore);
        }
        string = string + ")";
        list = threadGroupReference.threadGroups();
        iterator = list.iterator();
        string = string + Protocol.BR + "(list";
        while (iterator.hasNext()) {
            string = string + Protocol.BR + Rep.getThreadGroupRep((ThreadGroupReference)iterator.next(), objectStore);
        }
        string = string + ")";
        string = string + ")";
        return new LispForm(string);
    }

    static LispForm getThreadRep(ThreadReference threadReference, ObjectStore objectStore) {
        return Rep.getThreadRep(threadReference, objectStore, true);
    }

    static LispForm getThreadRep(ThreadReference threadReference, ObjectStore objectStore, boolean bl) {
        int n = threadReference.status();
        String string = "unknown";
        switch (n) {
            case 3: {
                string = "waiting on monitor";
                break;
            }
            case 5: {
                string = "not started";
                break;
            }
            case 1: {
                string = "runnable";
                break;
            }
            case 2: {
                string = "sleeping";
                break;
            }
            case 4: {
                string = "waiting";
                break;
            }
            case 0: {
                string = "zombie";
                break;
            }
            case -1: {
                string = "unknown";
                break;
            }
        }
        String string2 = "normal";
        if (threadReference.isAtBreakpoint()) {
            string2 = "suspended at breakpoint";
        } else if (threadReference.suspendCount() > 0) {
            string2 = "suspended by debugger";
        }
        if (bl) {
            Object object;
            Object object2;
            String string3;
            try {
                string3 = "(list";
                object2 = threadReference.frames();
                object = object2.iterator();
                int n2 = 0;
                while (object.hasNext()) {
                    string3 = string3 + Protocol.BR + Rep.getStackFrameRep((StackFrame)object.next(), n2++);
                }
                string3 = string3 + ")";
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                string3 = "\"Information Not Available\"";
            }
            try {
                object2 = "(list";
                object = threadReference.ownedMonitors();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    object2 = (String)object2 + Protocol.BR + Rep.getObjectRep((ObjectReference)iterator.next(), objectStore);
                }
                object2 = (String)object2 + ")";
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                object2 = "\"Information Not Available\"";
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                object2 = "\"VM has no information\"";
            }
            catch (ObjectCollectedException objectCollectedException) {
                object2 = "\"The object has been collected\"";
            }
            try {
                ObjectReference objectReference = threadReference.currentContendedMonitor();
                object = objectReference == null ? "nil" : Rep.getObjectRep(objectReference, objectStore).toString();
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                object = "\"Information Not Available\"";
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                object = "\"VM has no information\"";
            }
            catch (ObjectCollectedException objectCollectedException) {
                object = "\"The object has been collected\"";
            }
            objectStore.put(threadReference);
            return new LispForm("(list \"Thread\" " + threadReference.uniqueID() + " \"" + threadReference.name() + "\"" + " \"" + string + "\"" + " \"" + string2 + "\"" + Protocol.BR + string3 + Protocol.BR + (String)object2 + Protocol.BR + (String)object + ")");
        }
        objectStore.put(threadReference);
        return new LispForm("(list \"Thread\" " + threadReference.uniqueID() + " \"" + threadReference.name() + "\"" + " \"" + string + "\"" + " \"" + string2 + "\")");
    }

    static LispForm getStackFrameRep(StackFrame stackFrame, int n) {
        try {
            Location location = stackFrame.location();
            Method method = location.method();
            return new LispForm("(list " + n + " " + "\"" + location.declaringType().name() + "\" " + "\"" + location.sourceName() + "\" " + location.lineNumber() + " " + "\"" + method.name() + "\")");
        }
        catch (AbsentInformationException absentInformationException) {
            return new LispForm("(list \"StackFrame\" " + n + " \"Information not available\")");
        }
    }
}

