/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.encryption;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.security.Provider;
import java.security.Security;
import java.util.Hashtable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.pdfbox.pdmodel.encryption.BadSecurityHandlerException;
import org.pdfbox.pdmodel.encryption.ProtectionPolicy;
import org.pdfbox.pdmodel.encryption.SecurityHandler;

public class SecurityHandlersManager {
    private static SecurityHandlersManager instance;
    private Hashtable handlers_names = new Hashtable();
    private Hashtable handlers_policy_classes = new Hashtable();
    static /* synthetic */ Class class$org$pdfbox$pdmodel$encryption$StandardSecurityHandler;
    static /* synthetic */ Class class$org$pdfbox$pdmodel$encryption$PublicKeySecurityHandler;
    static /* synthetic */ Class class$org$pdfbox$pdmodel$encryption$SecurityHandler;

    private SecurityHandlersManager() {
        try {
            this.registerHandler(class$org$pdfbox$pdmodel$encryption$StandardSecurityHandler == null ? (class$org$pdfbox$pdmodel$encryption$StandardSecurityHandler = SecurityHandlersManager.class$("org.pdfbox.pdmodel.encryption.StandardSecurityHandler")) : class$org$pdfbox$pdmodel$encryption$StandardSecurityHandler);
            this.registerHandler(class$org$pdfbox$pdmodel$encryption$PublicKeySecurityHandler == null ? (class$org$pdfbox$pdmodel$encryption$PublicKeySecurityHandler = SecurityHandlersManager.class$("org.pdfbox.pdmodel.encryption.PublicKeySecurityHandler")) : class$org$pdfbox$pdmodel$encryption$PublicKeySecurityHandler);
        }
        catch (Exception e) {
            System.err.println("SecurityHandlersManager strange error with builtin handlers: " + e.getMessage());
            System.exit(1);
        }
    }

    public void registerHandler(Class securityHandlerClass) throws BadSecurityHandlerException {
        if (this.handlers_names.contains(securityHandlerClass) || this.handlers_policy_classes.contains(securityHandlerClass)) {
            throw new BadSecurityHandlerException("the following security handler was already registered: " + securityHandlerClass.getName());
        }
        if ((class$org$pdfbox$pdmodel$encryption$SecurityHandler == null ? (class$org$pdfbox$pdmodel$encryption$SecurityHandler = SecurityHandlersManager.class$("org.pdfbox.pdmodel.encryption.SecurityHandler")) : class$org$pdfbox$pdmodel$encryption$SecurityHandler).isAssignableFrom(securityHandlerClass)) {
            try {
                Field filterField = securityHandlerClass.getField("FILTER");
                String filterName = (String)filterField.get(null);
                Field classField = securityHandlerClass.getField("protectionPolicyClass");
                Class policyClass = (Class)classField.get(null);
                if (this.handlers_names.containsKey(filterName)) {
                    throw new BadSecurityHandlerException("a security handler was already registered for the filter name " + filterName);
                }
                if (this.handlers_policy_classes.containsKey(policyClass)) {
                    throw new BadSecurityHandlerException("a security handler was already registered for the policy class " + policyClass.getName());
                }
                this.handlers_names.put(filterName, securityHandlerClass);
                this.handlers_policy_classes.put(policyClass, securityHandlerClass);
            }
            catch (Exception e) {
                throw new BadSecurityHandlerException(e);
            }
        } else {
            throw new BadSecurityHandlerException("The class is not a super class of SecurityHandler");
        }
    }

    public static SecurityHandlersManager getInstance() {
        if (instance == null) {
            instance = new SecurityHandlersManager();
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
        return instance;
    }

    public SecurityHandler getSecurityHandler(ProtectionPolicy policy) throws BadSecurityHandlerException {
        Object found = this.handlers_policy_classes.get(policy.getClass());
        if (found == null) {
            throw new BadSecurityHandlerException("Cannot find an appropriate security handler for " + policy.getClass().getName());
        }
        Class handlerclass = (Class)found;
        Class[] args_classes = new Class[]{policy.getClass()};
        Object[] args = new Object[]{policy};
        try {
            Constructor c = handlerclass.getDeclaredConstructor(args_classes);
            SecurityHandler handler = (SecurityHandler)c.newInstance(args);
            return handler;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BadSecurityHandlerException("problem while trying to instanciate the security handler " + handlerclass.getName() + ": " + e.getMessage());
        }
    }

    public SecurityHandler getSecurityHandler(String filtername) throws BadSecurityHandlerException {
        Object found = this.handlers_names.get(filtername);
        if (found == null) {
            throw new BadSecurityHandlerException("Cannot find an appropriate security handler for " + filtername);
        }
        Class handlerclass = (Class)found;
        Class[] args_classes = new Class[]{};
        Object[] args = new Object[]{};
        try {
            Constructor c = handlerclass.getDeclaredConstructor(args_classes);
            SecurityHandler handler = (SecurityHandler)c.newInstance(args);
            return handler;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BadSecurityHandlerException("problem while trying to instanciate the security handler " + handlerclass.getName() + ": " + e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

