/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamRewriteEngine;
import antlr.TokenWithIndex;
import antlr.collections.AST;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.antlr.Tool;
import org.antlr.analysis.DFA;
import org.antlr.analysis.LookaheadSet;
import org.antlr.analysis.NFA;
import org.antlr.analysis.NFAConversionThread;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.NFAToDFAConverter;
import org.antlr.analysis.RuleClosureTransition;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.Transition;
import org.antlr.codegen.CodeGenerator;
import org.antlr.misc.Barrier;
import org.antlr.misc.IntSet;
import org.antlr.misc.IntervalSet;
import org.antlr.misc.Utils;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.tool.ANTLRLexer;
import org.antlr.tool.ANTLRParser;
import org.antlr.tool.ANTLRTreePrinter;
import org.antlr.tool.AssignTokenTypesWalker;
import org.antlr.tool.AttributeScope;
import org.antlr.tool.DefineGrammarItemsWalker;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.GrammarAST;
import org.antlr.tool.NFAFactory;
import org.antlr.tool.NameSpaceChecker;
import org.antlr.tool.Rule;
import org.antlr.tool.TreeToNFAConverter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Grammar {
    public static final String SYNPRED_RULE_PREFIX = "synpred";
    public static final String GRAMMAR_FILE_EXTENSION = ".g";
    public static final int INITIAL_DECISION_LIST_SIZE = 300;
    public static final int INVALID_RULE_INDEX = -1;
    public static final int RULE_LABEL = 1;
    public static final int TOKEN_LABEL = 2;
    public static final int RULE_LIST_LABEL = 3;
    public static final int TOKEN_LIST_LABEL = 4;
    public static String[] LabelTypeToString = new String[]{"<invalid>", "rule", "token", "rule-list", "token-list"};
    public static final String ARTIFICIAL_TOKENS_RULENAME = "Tokens";
    public static final String FRAGMENT_RULE_MODIFIER = "fragment";
    public static final String SYNPREDGATE_ACTION_NAME = "synpredgate";
    public static int[] ANTLRLiteralEscapedCharValue = new int[255];
    public static String[] ANTLRLiteralCharValueEscape = new String[255];
    public static final int LEXER = 1;
    public static final int PARSER = 2;
    public static final int TREE_PARSER = 3;
    public static final int COMBINED = 4;
    public static final String[] grammarTypeToString;
    public static final String[] grammarTypeToFileNameSuffix;
    public static final String IGNORE_STRING_IN_GRAMMAR_FILE_NAME = "__";
    public static final Set legalOptions;
    public static final Set doNotCopyOptionsToLexer;
    public static final Map defaultOptions;
    protected TokenStreamRewriteEngine tokenBuffer;
    public String name;
    public int type;
    protected Map options;
    protected int global_k;
    protected Map actions;
    protected NFA nfa;
    protected int maxTokenType;
    protected IntSet charVocabulary;
    protected Map tokenIDToTypeMap;
    protected Map stringLiteralToTypeMap;
    protected Vector typeToTokenList;
    protected Grammar importTokenVocabularyFromGrammar;
    Map lineColumnToLookaheadDFAMap;
    protected Tool tool;
    protected Set ruleRefs;
    protected Set tokenIDRefs;
    protected Set lexerRules;
    protected int decisionNumber;
    protected int ruleIndex;
    protected Set leftRecursiveRules;
    protected boolean externalAnalysisAbort;
    protected LinkedHashMap nameToSynpredASTMap;
    protected LinkedHashMap nameToRuleMap;
    protected Map scopes;
    protected Vector ruleIndexToRuleList;
    protected GrammarAST grammarTree;
    protected Vector indexToDecision;
    protected CodeGenerator generator;
    NameSpaceChecker nameSpaceChecker;
    protected Set lookBusy;
    protected Set visitedDuringRecursionCheck;
    protected boolean watchNFAConversion;
    protected StringTemplate lexerGrammarST;
    protected String fileName;
    public long DFACreationWallClockTimeInMS;
    public int numberOfSemanticPredicates;
    public int numberOfManualLookaheadOptions;
    public Set setOfNondeterministicDecisionNumbers;
    public Set setOfNondeterministicDecisionNumbersResolvedWithPredicates;
    public Set setOfDFAWhoseConversionTerminatedEarly;
    public Set blocksWithSynPreds;
    public Set decisionsWhoseDFAsUsesSynPreds;
    public Set synPredNamesUsedInDFA;
    public Set blocksWithSemPreds;
    public Set decisionsWhoseDFAsUsesSemPreds;
    protected boolean allDecisionDFACreated;
    protected boolean builtFromString;
    static /* synthetic */ Class class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer;

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setName(String name) {
        if (name == null) {
            return;
        }
        String saneFile = this.fileName.replace('\\', '/');
        int lastSlash = saneFile.lastIndexOf(47);
        String onlyFileName = saneFile.substring(lastSlash + 1, this.fileName.length());
        if (!this.builtFromString) {
            int lastDot = onlyFileName.lastIndexOf(46);
            String onlyFileNameNoSuffix = null;
            if (lastDot < 0) {
                ErrorManager.error(9, this.fileName);
                onlyFileNameNoSuffix = onlyFileName + GRAMMAR_FILE_EXTENSION;
            } else {
                onlyFileNameNoSuffix = onlyFileName.substring(0, lastDot);
            }
            if (!name.equals(onlyFileNameNoSuffix)) {
                ErrorManager.error(8, (Object)name, this.fileName);
            }
        }
        this.name = name;
    }

    public String getFileDirectory() {
        File f = new File(this.fileName);
        String parentDir = f.getParent();
        return parentDir;
    }

    public void setGrammarContent(String grammarString) throws RecognitionException, TokenStreamException {
        this.setGrammarContent(new StringReader(grammarString));
    }

    public void setGrammarContent(Reader r) throws RecognitionException, TokenStreamException {
        ErrorManager.resetErrorState();
        ANTLRLexer lexer = new ANTLRLexer(r);
        lexer.setFilename(this.getFileName());
        lexer.setTokenObjectClass("antlr.TokenWithIndex");
        this.tokenBuffer = new TokenStreamRewriteEngine((TokenStream)lexer);
        this.tokenBuffer.discard(83);
        this.tokenBuffer.discard(86);
        this.tokenBuffer.discard(84);
        this.tokenBuffer.discard(85);
        ANTLRParser parser = new ANTLRParser((TokenStream)this.tokenBuffer);
        parser.setFilename(this.getFileName());
        parser.setASTNodeClass("org.antlr.tool.GrammarAST");
        parser.grammar(this);
        this.grammarTree = (GrammarAST)parser.getAST();
        this.setFileName(lexer.getFilename());
        if (this.grammarTree.findFirstType(8) == null) {
            ErrorManager.error(150, this.getFileName());
            return;
        }
        List synpredRules = this.getArtificialRulesForSyntacticPredicates(parser, this.nameToSynpredASTMap);
        int i = 0;
        while (i < synpredRules.size()) {
            GrammarAST rAST = (GrammarAST)((Object)synpredRules.get(i));
            this.grammarTree.addChild((AST)rAST);
            ++i;
        }
        if (Tool.internalOption_PrintGrammarTree) {
            System.out.println(this.grammarTree.toStringList());
        }
        AssignTokenTypesWalker ttypesWalker = new AssignTokenTypesWalker();
        ttypesWalker.setASTNodeClass("org.antlr.tool.GrammarAST");
        try {
            ttypesWalker.grammar((AST)this.grammarTree, this);
        }
        catch (RecognitionException re) {
            ErrorManager.error(15, re);
        }
        DefineGrammarItemsWalker defineItemsWalker = new DefineGrammarItemsWalker();
        defineItemsWalker.setASTNodeClass("org.antlr.tool.GrammarAST");
        try {
            defineItemsWalker.grammar((AST)this.grammarTree, this);
        }
        catch (RecognitionException re) {
            ErrorManager.error(15, re);
        }
        this.nameSpaceChecker.checkConflicts();
    }

    public String getLexerGrammar() {
        if (this.lexerGrammarST.getAttribute("literals") == null && this.lexerGrammarST.getAttribute("rules") == null) {
            return null;
        }
        this.lexerGrammarST.setAttribute("name", (Object)this.name);
        if (this.actions.get("lexer") != null) {
            this.lexerGrammarST.setAttribute("actionNames", ((Map)this.actions.get("lexer")).keySet());
            this.lexerGrammarST.setAttribute("actions", ((Map)this.actions.get("lexer")).values());
        }
        if (this.options != null) {
            Iterator optionNames = this.options.keySet().iterator();
            while (optionNames.hasNext()) {
                String optionName = (String)optionNames.next();
                if (doNotCopyOptionsToLexer.contains(optionName)) continue;
                Object value = this.options.get(optionName);
                this.lexerGrammarST.setAttribute("options.{name,value}", (Object)optionName, value);
            }
        }
        return this.lexerGrammarST.toString();
    }

    public GrammarAST addArtificialMatchTokensRule(GrammarAST grammarAST, List ruleNames, boolean filterMode) {
        StringTemplate matchTokenRuleST = null;
        if (filterMode) {
            Class clazz = class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer;
            if (clazz == null) {
                clazz = class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = Grammar.class("[Lorg.antlr.stringtemplate.language.AngleBracketTemplateLexer;", false);
            }
            matchTokenRuleST = new StringTemplate("Tokens options {k=1;} : <rules:{r| (<r>)=><r>}; separator=\"|\">;", clazz);
        } else {
            Class clazz = class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer;
            if (clazz == null) {
                clazz = class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = Grammar.class("[Lorg.antlr.stringtemplate.language.AngleBracketTemplateLexer;", false);
            }
            matchTokenRuleST = new StringTemplate("Tokens : <rules; separator=\"|\">;", clazz);
        }
        int numAlts = 0;
        int i = 0;
        while (i < ruleNames.size()) {
            String rname = (String)ruleNames.get(i);
            matchTokenRuleST.setAttribute("rules", (Object)rname);
            ++numAlts;
            ++i;
        }
        ANTLRLexer lexer = new ANTLRLexer(new StringReader(matchTokenRuleST.toString()));
        lexer.setTokenObjectClass("antlr.TokenWithIndex");
        TokenStreamRewriteEngine tokbuf = new TokenStreamRewriteEngine((TokenStream)lexer);
        tokbuf.discard(83);
        tokbuf.discard(86);
        tokbuf.discard(84);
        tokbuf.discard(85);
        ANTLRParser parser = new ANTLRParser((TokenStream)tokbuf);
        parser.grammar = this;
        parser.gtype = 27;
        parser.setASTNodeClass("org.antlr.tool.GrammarAST");
        try {
            parser.rule();
            if (Tool.internalOption_PrintGrammarTree) {
                System.out.println("Tokens rule: " + parser.getAST().toStringTree());
            }
            GrammarAST p = grammarAST;
            while (p.getType() != 27) {
                p = (GrammarAST)p.getNextSibling();
            }
            p.addChild(parser.getAST());
        }
        catch (Exception e) {
            ErrorManager.error(12, e);
        }
        return (GrammarAST)parser.getAST();
    }

    protected List getArtificialRulesForSyntacticPredicates(ANTLRParser parser, LinkedHashMap nameToSynpredASTMap) {
        ArrayList<GrammarAST> rules = new ArrayList<GrammarAST>();
        if (nameToSynpredASTMap == null) {
            return rules;
        }
        Set predNames = nameToSynpredASTMap.keySet();
        boolean bl = false;
        if (this.grammarTree.getType() == 27) {
            bl = true;
        }
        boolean isLexer = bl;
        Iterator it = predNames.iterator();
        while (it.hasNext()) {
            String synpredName = (String)it.next();
            GrammarAST fragmentAST = (GrammarAST)((Object)nameToSynpredASTMap.get(synpredName));
            GrammarAST ruleAST = parser.createSimpleRuleAST(synpredName, fragmentAST, isLexer);
            rules.add(ruleAST);
        }
        return rules;
    }

    protected void initTokenSymbolTables() {
        this.typeToTokenList.setSize(9);
        this.typeToTokenList.set(0, "<INVALID>");
        this.typeToTokenList.set(4, "<EOT>");
        this.typeToTokenList.set(2, "<SEMPRED>");
        this.typeToTokenList.set(3, "<SET>");
        this.typeToTokenList.set(1, "<EPSILON>");
        this.typeToTokenList.set(5, "EOF");
        this.typeToTokenList.set(6, "<EOR>");
        this.typeToTokenList.set(7, "Token.DOWN");
        this.typeToTokenList.set(8, "Token.UP");
        this.tokenIDToTypeMap.put("<INVALID>", Utils.integer(-6));
        this.tokenIDToTypeMap.put("<EOT>", Utils.integer(-2));
        this.tokenIDToTypeMap.put("<SEMPRED>", Utils.integer(-4));
        this.tokenIDToTypeMap.put("<SET>", Utils.integer(-3));
        this.tokenIDToTypeMap.put("<EPSILON>", Utils.integer(-5));
        this.tokenIDToTypeMap.put("EOF", Utils.integer(-1));
        this.tokenIDToTypeMap.put("<EOR>", Utils.integer(1));
        this.tokenIDToTypeMap.put("DOWN", Utils.integer(2));
        this.tokenIDToTypeMap.put("UP", Utils.integer(3));
    }

    public void createNFAs() {
        if (this.nfa != null) {
            return;
        }
        if (this.getRules().size() == 0) {
            return;
        }
        this.nfa = new NFA(this);
        NFAFactory factory = new NFAFactory(this.nfa);
        TreeToNFAConverter nfaBuilder = new TreeToNFAConverter(this, this.nfa, factory);
        try {
            nfaBuilder.grammar((AST)this.grammarTree);
        }
        catch (RecognitionException re) {
            ErrorManager.error(15, (Object)this.name, re);
        }
    }

    public void createLookaheadDFAs() {
        if (this.nfa == null) {
            this.createNFAs();
        }
        long start = System.currentTimeMillis();
        int numDecisions = this.getNumberOfDecisions();
        if (NFAToDFAConverter.SINGLE_THREADED_NFA_CONVERSION) {
            int decision = 1;
            while (decision <= numDecisions) {
                NFAState decisionStartState = this.getDecisionNFAStartState(decision);
                if (!this.externalAnalysisAbort && decisionStartState.getNumberOfTransitions() > 1) {
                    this.createLookaheadDFA(decision);
                }
                ++decision;
            }
        } else {
            ErrorManager.info("two-threaded DFA conversion");
            Barrier barrier = new Barrier(3);
            int midpoint = numDecisions / 2;
            NFAConversionThread t1 = new NFAConversionThread(this, barrier, 1, midpoint);
            new Thread(t1).start();
            if (midpoint == numDecisions / 2) {
                ++midpoint;
            }
            NFAConversionThread t2 = new NFAConversionThread(this, barrier, midpoint, numDecisions);
            new Thread(t2).start();
            try {
                barrier.waitForRelease();
            }
            catch (InterruptedException e) {
                ErrorManager.internalError("what the hell? DFA interruptus", e);
            }
        }
        long stop = System.currentTimeMillis();
        this.DFACreationWallClockTimeInMS = stop - start;
        this.allDecisionDFACreated = true;
    }

    public void createLookaheadDFA(int decision) {
        DFA lookaheadDFA;
        Decision d = this.getDecision(decision);
        String enclosingRule = d.startState.getEnclosingRule();
        Rule r = this.getRule(enclosingRule);
        if (r.isSynPred && !this.synPredNamesUsedInDFA.contains(enclosingRule)) {
            return;
        }
        NFAState decisionStartState = this.getDecisionNFAStartState(decision);
        long startDFA = 0L;
        long stopDFA = 0L;
        if (this.watchNFAConversion) {
            System.out.println("--------------------\nbuilding lookahead DFA (d=" + decisionStartState.getDecisionNumber() + ") for " + decisionStartState.getDescription());
            startDFA = System.currentTimeMillis();
        }
        if ((lookaheadDFA = new DFA(decision, decisionStartState)).analysisAborted() && lookaheadDFA.getUserMaxLookahead() != 1 || lookaheadDFA.probe.nonRegularDecision() && lookaheadDFA.getAutoBacktrackMode()) {
            this.decisionsWhoseDFAsUsesSynPreds.remove(lookaheadDFA);
            lookaheadDFA = null;
            d.blockAST.setOption(this, "k", Utils.integer(1));
            lookaheadDFA = new DFA(decision, decisionStartState);
            if (lookaheadDFA.analysisAborted()) {
                ErrorManager.internalError("could not even do k=1 for decision " + decision);
            }
        }
        this.setLookaheadDFA(decision, lookaheadDFA);
        GrammarAST decisionAST = this.nfa.grammar.getDecisionBlockAST(lookaheadDFA.decisionNumber);
        int line = decisionAST.getLine();
        int col = decisionAST.getColumn();
        this.lineColumnToLookaheadDFAMap.put("" + line + ':' + col, lookaheadDFA);
        if (this.watchNFAConversion) {
            stopDFA = System.currentTimeMillis();
            System.out.println("cost: " + lookaheadDFA.getNumberOfStates() + " states, " + (int)(stopDFA - startDFA) + " ms");
        }
    }

    public void abortNFAToDFAConversion() {
        this.externalAnalysisAbort = true;
    }

    public int getNewTokenType() {
        ++this.maxTokenType;
        return this.maxTokenType;
    }

    public void defineToken(String text, int tokenType) {
        String prevToken;
        if (this.tokenIDToTypeMap.get(text) != null) {
            return;
        }
        if (text.charAt(0) == '\'') {
            this.stringLiteralToTypeMap.put(text, Utils.integer(tokenType));
        } else {
            this.tokenIDToTypeMap.put(text, Utils.integer(tokenType));
        }
        int index = 6 + tokenType - 1;
        this.maxTokenType = Math.max(this.maxTokenType, tokenType);
        if (index >= this.typeToTokenList.size()) {
            this.typeToTokenList.setSize(index + 1);
        }
        if ((prevToken = (String)this.typeToTokenList.get(index)) == null || prevToken.charAt(0) == '\'') {
            this.typeToTokenList.set(index, text);
        }
    }

    public void defineRule(Token ruleToken, String modifier, Map options, GrammarAST tree, GrammarAST argActionAST, int numAlts) {
        String ruleName = ruleToken.getText();
        if (this.getRule(ruleName) != null) {
            ErrorManager.grammarError(101, this, ruleToken, ruleName);
        }
        Rule r = new Rule(this, ruleName, this.ruleIndex, numAlts);
        r.modifier = modifier;
        this.nameToRuleMap.put(ruleName, r);
        this.setRuleAST(ruleName, tree);
        r.setOptions(options, ruleToken);
        r.argActionAST = argActionAST;
        this.ruleIndexToRuleList.setSize(this.ruleIndex + 1);
        this.ruleIndexToRuleList.set(this.ruleIndex, ruleName);
        ++this.ruleIndex;
        if (ruleName.startsWith(SYNPRED_RULE_PREFIX)) {
            r.isSynPred = true;
        }
    }

    public String defineSyntacticPredicate(GrammarAST blockAST, String currentRuleName) {
        if (this.nameToSynpredASTMap == null) {
            this.nameToSynpredASTMap = new LinkedHashMap();
        }
        String predName = null;
        predName = SYNPRED_RULE_PREFIX + (this.nameToSynpredASTMap.size() + 1);
        this.nameToSynpredASTMap.put(predName, blockAST);
        return predName;
    }

    public LinkedHashMap getSyntacticPredicates() {
        return this.nameToSynpredASTMap;
    }

    public GrammarAST getSyntacticPredicate(String name) {
        if (this.nameToSynpredASTMap == null) {
            return null;
        }
        return (GrammarAST)((Object)this.nameToSynpredASTMap.get(name));
    }

    public void synPredUsedInDFA(DFA dfa, SemanticContext semCtx) {
        this.decisionsWhoseDFAsUsesSynPreds.add(dfa);
        semCtx.trackUseOfSyntacticPredicates(this);
    }

    public void defineAction(GrammarAST ampersandAST, String scope, GrammarAST nameAST, GrammarAST actionAST) {
        GrammarAST a;
        if (scope == null) {
            scope = this.getDefaultActionScope(this.type);
        }
        String actionName = nameAST.getText();
        HashMap<String, GrammarAST> scopeActions = (HashMap<String, GrammarAST>)this.actions.get(scope);
        if (scopeActions == null) {
            scopeActions = new HashMap<String, GrammarAST>();
            this.actions.put(scope, scopeActions);
        }
        if ((a = (GrammarAST)((Object)scopeActions.get(actionName))) != null) {
            ErrorManager.grammarError(144, this, nameAST.getToken(), nameAST.getText());
        } else {
            scopeActions.put(actionName, actionAST);
        }
    }

    public Map getActions() {
        return this.actions;
    }

    public String getDefaultActionScope(int grammarType) {
        switch (grammarType) {
            case 1: {
                return "lexer";
            }
            case 2: 
            case 4: {
                return "parser";
            }
            case 3: {
                return "treeparser";
            }
        }
        return null;
    }

    public void defineLexerRuleFoundInParser(Token ruleToken, GrammarAST ruleAST) {
        StringBuffer buf = new StringBuffer();
        buf.append("// $ANTLR src \"");
        buf.append(this.getFileName());
        buf.append("\" ");
        buf.append(ruleAST.getLine());
        buf.append("\n");
        int i = ruleAST.ruleStartTokenIndex;
        while (i <= ruleAST.ruleStopTokenIndex && i < this.tokenBuffer.size()) {
            TokenWithIndex t = this.tokenBuffer.getToken(i);
            if (t.getType() == 9) {
                buf.append("(");
            } else if (t.getType() == 38) {
                buf.append("{");
                buf.append(t.getText());
                buf.append("}");
            } else if (t.getType() == 69 || t.getType() == 36 || t.getType() == 35) {
                buf.append("{");
                buf.append(t.getText());
                buf.append("}?");
            } else if (t.getType() == 57) {
                buf.append("[");
                buf.append(t.getText());
                buf.append("]");
            } else {
                buf.append(t.getText());
            }
            ++i;
        }
        String ruleText = buf.toString();
        this.lexerGrammarST.setAttribute("rules", (Object)ruleText);
        this.lexerRules.add(ruleToken.getText());
    }

    public void defineLexerRuleForAliasedStringLiteral(String tokenID, String literal, int tokenType) {
        this.lexerGrammarST.setAttribute("literals.{ruleName,type,literal}", (Object)tokenID, (Object)Utils.integer(tokenType), (Object)literal);
        this.lexerRules.add(tokenID);
    }

    public void defineLexerRuleForStringLiteral(String literal, int tokenType) {
        this.lexerGrammarST.setAttribute("literals.{ruleName,type,literal}", (Object)this.computeTokenNameFromLiteral(tokenType, literal), (Object)Utils.integer(tokenType), (Object)literal);
    }

    public Rule getRule(String ruleName) {
        Rule r = (Rule)this.nameToRuleMap.get(ruleName);
        return r;
    }

    public int getRuleIndex(String ruleName) {
        Rule r = this.getRule(ruleName);
        if (r != null) {
            return r.index;
        }
        return -1;
    }

    public String getRuleName(int ruleIndex) {
        return (String)this.ruleIndexToRuleList.get(ruleIndex);
    }

    public AttributeScope defineGlobalScope(String name, Token scopeAction) {
        AttributeScope scope = new AttributeScope(this, name, scopeAction);
        this.scopes.put(name, scope);
        return scope;
    }

    public AttributeScope createReturnScope(String ruleName, Token retAction) {
        AttributeScope scope = new AttributeScope(this, ruleName, retAction);
        scope.isReturnScope = true;
        return scope;
    }

    public AttributeScope createRuleScope(String ruleName, Token scopeAction) {
        AttributeScope scope = new AttributeScope(this, ruleName, scopeAction);
        scope.isDynamicRuleScope = true;
        return scope;
    }

    public AttributeScope createParameterScope(String ruleName, Token argAction) {
        AttributeScope scope = new AttributeScope(this, ruleName, argAction);
        scope.isParameterScope = true;
        return scope;
    }

    public AttributeScope getGlobalScope(String name) {
        return (AttributeScope)this.scopes.get(name);
    }

    public Map getGlobalScopes() {
        return this.scopes;
    }

    protected void defineLabel(Rule r, Token label, GrammarAST element, int type) {
        boolean err = this.nameSpaceChecker.checkForLabelTypeMismatch(r, label, type);
        if (err) {
            return;
        }
        r.defineLabel(label, element, type);
    }

    public void defineTokenRefLabel(String ruleName, Token label, GrammarAST tokenRef) {
        Rule r = this.getRule(ruleName);
        if (r != null) {
            this.defineLabel(r, label, tokenRef, 2);
        }
    }

    public void defineRuleRefLabel(String ruleName, Token label, GrammarAST ruleRef) {
        Rule r = this.getRule(ruleName);
        if (r != null) {
            this.defineLabel(r, label, ruleRef, 1);
        }
    }

    public void defineTokenListLabel(String ruleName, Token label, GrammarAST element) {
        Rule r = this.getRule(ruleName);
        if (r != null) {
            this.defineLabel(r, label, element, 4);
        }
    }

    public void defineRuleListLabel(String ruleName, Token label, GrammarAST element) {
        Rule r = this.getRule(ruleName);
        if (r != null) {
            if (!r.getHasMultipleReturnValues()) {
                ErrorManager.grammarError(134, this, label, label.getText());
            }
            this.defineLabel(r, label, element, 3);
        }
    }

    public void altReferencesRule(String ruleName, GrammarAST refAST, int outerAltNum) {
        Rule r = this.getRule(ruleName);
        if (r == null) {
            return;
        }
        r.trackRuleReferenceInAlt(refAST, outerAltNum);
        Token refToken = refAST.getToken();
        if (!this.ruleRefs.contains(refToken)) {
            this.ruleRefs.add(refToken);
        }
    }

    public void altReferencesTokenID(String ruleName, GrammarAST refAST, int outerAltNum) {
        Rule r = this.getRule(ruleName);
        if (r == null) {
            return;
        }
        r.trackTokenReferenceInAlt(refAST, outerAltNum);
        if (!this.tokenIDRefs.contains(refAST.getToken())) {
            this.tokenIDRefs.add(refAST.getToken());
        }
    }

    public void referenceRuleLabelPredefinedAttribute(String ruleName) {
        Rule r = this.getRule(ruleName);
        if (r != null && this.type != 1) {
            r.referencedPredefinedRuleAttributes = true;
        }
    }

    public void checkRuleReference(GrammarAST refAST, GrammarAST argsAST, String currentRuleName) {
        Rule r = this.getRule(refAST.getText());
        if (refAST.getType() == 75) {
            if (argsAST != null) {
                if (r != null && r.argActionAST == null) {
                    ErrorManager.grammarError(130, this, argsAST.getToken(), r.name);
                }
            } else if (r != null && r.argActionAST != null) {
                ErrorManager.grammarError(129, this, refAST.getToken(), r.name);
            }
        } else if (refAST.getType() == 52) {
            if (this.type != 1) {
                if (argsAST != null) {
                    ErrorManager.grammarError(131, this, refAST.getToken(), refAST.getText());
                }
                return;
            }
            if (argsAST != null) {
                if (r != null && r.argActionAST == null) {
                    ErrorManager.grammarError(130, this, argsAST.getToken(), r.name);
                }
            } else if (r != null && r.argActionAST != null) {
                ErrorManager.grammarError(129, this, refAST.getToken(), r.name);
            }
        }
    }

    public Set getLeftRecursiveRules() {
        if (this.nfa == null) {
            this.createNFAs();
        }
        if (this.leftRecursiveRules != null) {
            return this.leftRecursiveRules;
        }
        this.checkAllRulesForLeftRecursion();
        return this.leftRecursiveRules;
    }

    public List checkAllRulesForLeftRecursion() {
        this.createNFAs();
        this.leftRecursiveRules = new HashSet();
        ArrayList listOfRecursiveCycles = new ArrayList();
        int i = 0;
        while (i < this.ruleIndexToRuleList.size()) {
            String ruleName = (String)this.ruleIndexToRuleList.elementAt(i);
            if (ruleName != null) {
                NFAState s = this.getRuleStartState(ruleName);
                this.visitedDuringRecursionCheck = new HashSet();
                this.visitedDuringRecursionCheck.add(ruleName);
                HashSet visitedStates = new HashSet();
                this.traceStatesLookingForLeftRecursion(s, visitedStates, listOfRecursiveCycles);
            }
            ++i;
        }
        if (listOfRecursiveCycles.size() > 0) {
            ErrorManager.leftRecursionCycles(listOfRecursiveCycles);
        }
        return listOfRecursiveCycles;
    }

    protected boolean traceStatesLookingForLeftRecursion(NFAState s, Set visitedStates, List listOfRecursiveCycles) {
        if (s.isAcceptState()) {
            return true;
        }
        if (visitedStates.contains(s)) {
            return false;
        }
        visitedStates.add(s);
        boolean stateReachesAcceptState = false;
        Transition t0 = s.transition(0);
        if (t0 instanceof RuleClosureTransition) {
            String targetRuleName = ((NFAState)t0.target).getEnclosingRule();
            if (this.visitedDuringRecursionCheck.contains(targetRuleName)) {
                this.leftRecursiveRules.add(targetRuleName);
                this.addRulesToCycle(targetRuleName, s.getEnclosingRule(), listOfRecursiveCycles);
            } else {
                this.visitedDuringRecursionCheck.add(targetRuleName);
                boolean callReachedAcceptState = this.traceStatesLookingForLeftRecursion((NFAState)t0.target, new HashSet(), listOfRecursiveCycles);
                this.visitedDuringRecursionCheck.remove(targetRuleName);
                if (callReachedAcceptState) {
                    NFAState followingState = ((RuleClosureTransition)t0).getFollowState();
                    stateReachesAcceptState |= this.traceStatesLookingForLeftRecursion(followingState, visitedStates, listOfRecursiveCycles);
                }
            }
        } else if (t0.label.isEpsilon()) {
            stateReachesAcceptState |= this.traceStatesLookingForLeftRecursion((NFAState)t0.target, visitedStates, listOfRecursiveCycles);
        }
        Transition t1 = s.transition(1);
        if (t1 != null) {
            stateReachesAcceptState |= this.traceStatesLookingForLeftRecursion((NFAState)t1.target, visitedStates, listOfRecursiveCycles);
        }
        return stateReachesAcceptState;
    }

    protected void addRulesToCycle(String targetRuleName, String enclosingRuleName, List listOfRecursiveCycles) {
        boolean foundCycle = false;
        int i = 0;
        while (i < listOfRecursiveCycles.size()) {
            Set rulesInCycle = (Set)listOfRecursiveCycles.get(i);
            if (rulesInCycle.contains(targetRuleName)) {
                rulesInCycle.add(enclosingRuleName);
                foundCycle = true;
            }
            if (rulesInCycle.contains(enclosingRuleName)) {
                rulesInCycle.add(targetRuleName);
                foundCycle = true;
            }
            ++i;
        }
        if (!foundCycle) {
            HashSet<String> cycle = new HashSet<String>();
            cycle.add(targetRuleName);
            cycle.add(enclosingRuleName);
            listOfRecursiveCycles.add(cycle);
        }
    }

    public boolean isEmptyRule(GrammarAST block) {
        GrammarAST aTokenRefNode = block.findFirstType(52);
        GrammarAST aStringLiteralRefNode = block.findFirstType(48);
        GrammarAST aCharLiteralRefNode = block.findFirstType(49);
        GrammarAST aWildcardRefNode = block.findFirstType(76);
        GrammarAST aRuleRefNode = block.findFirstType(75);
        return aTokenRefNode == null && aStringLiteralRefNode == null && aCharLiteralRefNode == null && aWildcardRefNode == null && aRuleRefNode == null;
    }

    public int getTokenType(String tokenName) {
        Integer I = null;
        I = tokenName.charAt(0) == '\'' ? (Integer)this.stringLiteralToTypeMap.get(tokenName) : (Integer)this.tokenIDToTypeMap.get(tokenName);
        int i = I != null ? I : -6;
        return i;
    }

    public Set getTokenIDs() {
        return this.tokenIDToTypeMap.keySet();
    }

    public Collection getTokenTypesWithoutID() {
        ArrayList<Integer> types = new ArrayList<Integer>();
        int t = 4;
        while (t <= this.getMaxTokenType()) {
            String name = this.getTokenDisplayName(t);
            if (name.charAt(0) == '\'') {
                types.add(Utils.integer(t));
            }
            ++t;
        }
        return types;
    }

    public Set getTokenDisplayNames() {
        HashSet<String> names = new HashSet<String>();
        int t = 4;
        while (t <= this.getMaxTokenType()) {
            names.add(this.getTokenDisplayName(t));
            ++t;
        }
        return names;
    }

    public static int getCharValueFromGrammarCharLiteral(String literal) {
        if (literal.length() == 3) {
            return literal.charAt(1);
        }
        if (literal.length() == 4) {
            char escChar = literal.charAt(2);
            int charVal = ANTLRLiteralEscapedCharValue[escChar];
            if (charVal == 0) {
                return escChar;
            }
            return charVal;
        }
        if (literal.length() == 8) {
            String unicodeChars = literal.substring(3, literal.length() - 1);
            return Integer.parseInt(unicodeChars, 16);
        }
        ErrorManager.assertTrue(false, "invalid char literal: " + literal);
        return -1;
    }

    public static StringBuffer getUnescapedStringFromGrammarStringLiteral(String literal) {
        StringBuffer buf = new StringBuffer();
        int last = literal.length() - 1;
        int i = 1;
        while (i < last) {
            char c = literal.charAt(i);
            if (c == '\\') {
                if (Character.toUpperCase(c = literal.charAt(++i)) == 'U') {
                    String unicodeChars = literal.substring(++i, i + 4);
                    int val = Integer.parseInt(unicodeChars, 16);
                    i += 3;
                    buf.append((char)val);
                } else {
                    buf.append((char)ANTLRLiteralEscapedCharValue[c]);
                }
            } else {
                buf.append(c);
            }
            ++i;
        }
        return buf;
    }

    public int importTokenVocabulary(Grammar importFromGr) {
        Set importedTokenIDs = importFromGr.getTokenIDs();
        Iterator it = importedTokenIDs.iterator();
        while (it.hasNext()) {
            String tokenID = (String)it.next();
            int tokenType = importFromGr.getTokenType(tokenID);
            this.maxTokenType = Math.max(this.maxTokenType, tokenType);
            if (tokenType < 4) continue;
            this.defineToken(tokenID, tokenType);
        }
        return this.maxTokenType;
    }

    public int importTokenVocabulary(String vocabName) {
        String fullName = this.tool.getLibraryDirectory() + File.separator + vocabName + ".tokens";
        try {
            BufferedReader br = this.tool.getLibraryFile(vocabName + ".tokens");
            StreamTokenizer tokenizer = new StreamTokenizer(br);
            tokenizer.parseNumbers();
            tokenizer.wordChars(95, 95);
            tokenizer.eolIsSignificant(true);
            tokenizer.slashSlashComments(true);
            tokenizer.slashStarComments(true);
            tokenizer.ordinaryChar(61);
            tokenizer.quoteChar(39);
            tokenizer.whitespaceChars(32, 32);
            tokenizer.whitespaceChars(9, 9);
            int lineNum = 1;
            int token = tokenizer.nextToken();
            while (token != -1) {
                String tokenID;
                if (token == -3) {
                    tokenID = tokenizer.sval;
                } else if (token == 39) {
                    tokenID = "'" + tokenizer.sval + '\'';
                } else {
                    ErrorManager.error(13, (Object)(vocabName + ".tokens"), Utils.integer(lineNum));
                    while (tokenizer.nextToken() != 10) {
                    }
                    token = tokenizer.nextToken();
                    continue;
                }
                token = tokenizer.nextToken();
                if (token != 61) {
                    ErrorManager.error(13, (Object)(vocabName + ".tokens"), Utils.integer(lineNum));
                    while (tokenizer.nextToken() != 10) {
                    }
                    token = tokenizer.nextToken();
                    continue;
                }
                token = tokenizer.nextToken();
                if (token != -2) {
                    ErrorManager.error(13, (Object)(vocabName + ".tokens"), Utils.integer(lineNum));
                    while (tokenizer.nextToken() != 10) {
                    }
                    token = tokenizer.nextToken();
                    continue;
                }
                int tokenType = (int)tokenizer.nval;
                token = tokenizer.nextToken();
                this.maxTokenType = Math.max(this.maxTokenType, tokenType);
                this.defineToken(tokenID, tokenType);
                ++lineNum;
                if (token != 10) {
                    ErrorManager.error(13, (Object)(vocabName + ".tokens"), Utils.integer(lineNum));
                    while (tokenizer.nextToken() != 10) {
                    }
                    token = tokenizer.nextToken();
                    continue;
                }
                token = tokenizer.nextToken();
            }
            br.close();
        }
        catch (FileNotFoundException fnfe) {
            ErrorManager.error(3, fullName);
        }
        catch (IOException ioe) {
            ErrorManager.error(4, (Object)fullName, ioe);
        }
        catch (Exception e) {
            ErrorManager.error(4, (Object)fullName, e);
        }
        return this.maxTokenType;
    }

    public String getTokenDisplayName(int ttype) {
        String tokenName = null;
        int index = 0;
        if (this.type == 1 && ttype >= 0 && ttype <= 65534) {
            return Grammar.getANTLRCharLiteralForChar(ttype);
        }
        if (ttype < 0) {
            tokenName = (String)this.typeToTokenList.get(6 + ttype);
        } else {
            index = ttype - 1;
            tokenName = (index += 6) < this.typeToTokenList.size() ? (String)this.typeToTokenList.get(index) : String.valueOf(ttype);
        }
        return tokenName;
    }

    public Set getStringLiterals() {
        return this.stringLiteralToTypeMap.keySet();
    }

    public int getGrammarMaxLookahead() {
        if (this.global_k >= 0) {
            return this.global_k;
        }
        Object k = this.getOption("k");
        if (k == null) {
            this.global_k = 0;
        } else if (k instanceof Integer) {
            Integer kI = (Integer)k;
            this.global_k = kI;
        } else if (k.equals("*")) {
            this.global_k = 0;
        }
        return this.global_k;
    }

    public String setOption(String key, Object value, Token optionsStartToken) {
        if (!legalOptions.contains(key)) {
            ErrorManager.grammarError(133, this, optionsStartToken, key);
            return null;
        }
        if (!this.optionIsValid(key, value)) {
            return null;
        }
        if (this.options == null) {
            this.options = new HashMap();
        }
        this.options.put(key, value);
        return key;
    }

    public void setOptions(Map options, Token optionsStartToken) {
        if (options == null) {
            this.options = null;
            return;
        }
        Set keys = options.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Object optionValue;
            String optionName = (String)it.next();
            String stored = this.setOption(optionName, optionValue = options.get(optionName), optionsStartToken);
            if (stored != null) continue;
            it.remove();
        }
    }

    public Object getOption(String key) {
        Object value = null;
        if (this.options != null) {
            value = this.options.get(key);
        }
        if (value == null) {
            value = defaultOptions.get(key);
        }
        return value;
    }

    public boolean optionIsValid(String key, Object value) {
        return true;
    }

    public boolean buildAST() {
        String outputType = (String)this.getOption("output");
        if (outputType != null) {
            return outputType.equals("AST");
        }
        return false;
    }

    public boolean isBuiltFromString() {
        return this.builtFromString;
    }

    public boolean buildTemplate() {
        String outputType = (String)this.getOption("output");
        if (outputType != null) {
            return outputType.equals("template");
        }
        return false;
    }

    public Collection getRules() {
        return this.nameToRuleMap.values();
    }

    public void setRuleAST(String ruleName, GrammarAST t) {
        Rule r = (Rule)this.nameToRuleMap.get(ruleName);
        if (r != null) {
            r.tree = t;
            r.EORNode = t.getLastChild();
        }
    }

    public void setRuleStartState(String ruleName, NFAState startState) {
        Rule r = (Rule)this.nameToRuleMap.get(ruleName);
        if (r != null) {
            r.startState = startState;
        }
    }

    public void setRuleStopState(String ruleName, NFAState stopState) {
        Rule r = (Rule)this.nameToRuleMap.get(ruleName);
        if (r != null) {
            r.stopState = stopState;
        }
    }

    public NFAState getRuleStartState(String ruleName) {
        Rule r = (Rule)this.nameToRuleMap.get(ruleName);
        if (r != null) {
            return r.startState;
        }
        return null;
    }

    public String getRuleModifier(String ruleName) {
        Rule r = (Rule)this.nameToRuleMap.get(ruleName);
        if (r != null) {
            return r.modifier;
        }
        return null;
    }

    public NFAState getRuleStopState(String ruleName) {
        Rule r = (Rule)this.nameToRuleMap.get(ruleName);
        if (r != null) {
            return r.stopState;
        }
        return null;
    }

    public int assignDecisionNumber(NFAState state) {
        ++this.decisionNumber;
        state.setDecisionNumber(this.decisionNumber);
        return this.decisionNumber;
    }

    protected Decision getDecision(int decision) {
        int index = decision - 1;
        if (index >= this.indexToDecision.size()) {
            return null;
        }
        Decision d = (Decision)this.indexToDecision.get(index);
        return d;
    }

    protected Decision createDecision(int decision) {
        int index = decision - 1;
        if (index < this.indexToDecision.size()) {
            return this.getDecision(decision);
        }
        Decision d = new Decision();
        d.decision = decision;
        this.indexToDecision.setSize(this.getNumberOfDecisions());
        this.indexToDecision.set(index, d);
        return d;
    }

    public List getDecisionNFAStartStateList() {
        ArrayList<NFAState> states = new ArrayList<NFAState>(100);
        int d = 0;
        while (d < this.indexToDecision.size()) {
            Decision dec = (Decision)this.indexToDecision.elementAt(d);
            states.add(dec.startState);
            ++d;
        }
        return states;
    }

    public NFAState getDecisionNFAStartState(int decision) {
        Decision d = this.getDecision(decision);
        if (d == null) {
            return null;
        }
        return d.startState;
    }

    public DFA getLookaheadDFA(int decision) {
        Decision d = this.getDecision(decision);
        if (d == null) {
            return null;
        }
        return d.dfa;
    }

    public GrammarAST getDecisionBlockAST(int decision) {
        Decision d = this.getDecision(decision);
        if (d == null) {
            return null;
        }
        return d.blockAST;
    }

    public List getLookaheadDFAColumnsForLineInFile(int line) {
        String prefix = "" + line + ':';
        ArrayList<Integer> columns = new ArrayList<Integer>();
        Iterator iter = this.lineColumnToLookaheadDFAMap.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith(prefix)) continue;
            columns.add(Integer.valueOf(key.substring(prefix.length())));
        }
        return columns;
    }

    public DFA getLookaheadDFAFromPositionInFile(int line, int col) {
        return (DFA)this.lineColumnToLookaheadDFAMap.get("" + line + ':' + col);
    }

    public int getNumberOfDecisions() {
        return this.decisionNumber;
    }

    public int getNumberOfCyclicDecisions() {
        int n = 0;
        int i = 1;
        while (i <= this.getNumberOfDecisions()) {
            Decision d = this.getDecision(i);
            if (d.dfa != null && d.dfa.isCyclic()) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    public void setLookaheadDFA(int decision, DFA lookaheadDFA) {
        Decision d = this.createDecision(decision);
        d.dfa = lookaheadDFA;
        GrammarAST ast = d.startState.getAssociatedASTNode();
        ast.setLookaheadDFA(lookaheadDFA);
    }

    public void setDecisionNFA(int decision, NFAState state) {
        Decision d = this.createDecision(decision);
        d.startState = state;
    }

    public void setDecisionBlockAST(int decision, GrammarAST blockAST) {
        Decision d = this.createDecision(decision);
        d.blockAST = blockAST;
    }

    public boolean allDecisionDFAHaveBeenCreated() {
        return this.allDecisionDFACreated;
    }

    public int getMaxTokenType() {
        return this.maxTokenType;
    }

    public int getMaxCharValue() {
        if (this.generator != null) {
            return this.generator.target.getMaxCharValue(this.generator);
        }
        return 65534;
    }

    public IntSet getTokenTypes() {
        if (this.type == 1) {
            return this.getAllCharValues();
        }
        return IntervalSet.of(4, this.getMaxTokenType());
    }

    public IntSet getAllCharValues() {
        if (this.charVocabulary != null) {
            return this.charVocabulary;
        }
        IntervalSet allChar = IntervalSet.of(0, this.getMaxCharValue());
        return allChar;
    }

    public static String getANTLRCharLiteralForChar(int c) {
        if (c < 0) {
            ErrorManager.internalError("invalid char value " + c);
            return "'<INVALID>'";
        }
        if (c < ANTLRLiteralCharValueEscape.length && ANTLRLiteralCharValueEscape[c] != null) {
            return "'" + ANTLRLiteralCharValueEscape[c] + '\'';
        }
        if (Character.UnicodeBlock.of((char)c) == Character.UnicodeBlock.BASIC_LATIN && !Character.isISOControl((char)c)) {
            if (c == 92) {
                return "'\\\\'";
            }
            if (c == 39) {
                return "'\\''";
            }
            return "'" + Character.toString((char)c) + '\'';
        }
        String hex = Integer.toHexString(c | 0x10000).toUpperCase().substring(1, 5);
        String unicodeStr = "'\\u" + hex + '\'';
        return unicodeStr;
    }

    public IntSet complement(IntSet set) {
        IntSet c = set.complement(this.getTokenTypes());
        return c;
    }

    public IntSet complement(int atom) {
        return this.complement(IntervalSet.of(atom));
    }

    public int getNumberOfAltsForDecisionNFA(NFAState decisionState) {
        if (decisionState == null) {
            return 0;
        }
        int n = 1;
        NFAState p = decisionState;
        while (p.transition(1) != null) {
            ++n;
            p = (NFAState)p.transition((int)1).target;
        }
        return n;
    }

    public NFAState getNFAStateForAltOfDecision(NFAState decisionState, int alt) {
        if (decisionState == null || alt <= 0) {
            return null;
        }
        int n = 1;
        NFAState p = decisionState;
        while (p != null) {
            if (n == alt) {
                return p;
            }
            ++n;
            Transition next = p.transition(1);
            p = null;
            if (next == null) continue;
            p = (NFAState)next.target;
        }
        return null;
    }

    public LookaheadSet LOOK(NFAState s) {
        this.lookBusy.clear();
        return this._LOOK(s);
    }

    protected LookaheadSet _LOOK(NFAState s) {
        Transition transition1;
        if (s.isAcceptState()) {
            return new LookaheadSet(1);
        }
        if (this.lookBusy.contains(s)) {
            return new LookaheadSet();
        }
        this.lookBusy.add(s);
        Transition transition0 = s.transition(0);
        if (transition0 == null) {
            return null;
        }
        if (transition0.label.isAtom()) {
            int atom = transition0.label.getAtom();
            if (atom == -1) {
                return LookaheadSet.EOF();
            }
            return new LookaheadSet(atom);
        }
        if (transition0.label.isSet()) {
            IntSet sl = transition0.label.getSet();
            LookaheadSet laSet = new LookaheadSet(sl);
            if (laSet.member(-1)) {
                laSet.remove(-1);
                laSet.hasEOF = true;
            }
            return laSet;
        }
        LookaheadSet tset = this._LOOK((NFAState)transition0.target);
        if (tset.member(1) && transition0 instanceof RuleClosureTransition) {
            RuleClosureTransition ruleInvocationTrans = (RuleClosureTransition)transition0;
            tset.remove(1);
            LookaheadSet fset = this._LOOK(ruleInvocationTrans.getFollowState());
            tset.orInPlace(fset);
        }
        if ((transition1 = s.transition(1)) != null) {
            LookaheadSet tset1 = this._LOOK((NFAState)transition1.target);
            tset.orInPlace(tset1);
        }
        return tset;
    }

    public void setCodeGenerator(CodeGenerator generator) {
        this.generator = generator;
    }

    public CodeGenerator getCodeGenerator() {
        return this.generator;
    }

    public GrammarAST getGrammarTree() {
        return this.grammarTree;
    }

    public Tool getTool() {
        return this.tool;
    }

    public void setTool(Tool tool) {
        this.tool = tool;
    }

    public String computeTokenNameFromLiteral(int tokenType, String literal) {
        return "T" + tokenType;
    }

    public String toString() {
        return this.grammarTreeToString(this.grammarTree);
    }

    public String grammarTreeToString(GrammarAST t) {
        return this.grammarTreeToString(t, true);
    }

    public String grammarTreeToString(GrammarAST t, boolean showActions) {
        String s = null;
        try {
            s = "" + t.getLine() + ':' + t.getColumn() + ": ";
            s = s + new ANTLRTreePrinter().toString((AST)t, this, showActions);
        }
        catch (Exception e) {
            ErrorManager.error(15, (Object)t, e);
        }
        return s;
    }

    public void setWatchNFAConversion(boolean watchNFAConversion) {
        this.watchNFAConversion = watchNFAConversion;
    }

    public boolean getWatchNFAConversion() {
        return this.watchNFAConversion;
    }

    public void printGrammar(PrintStream output) {
        ANTLRTreePrinter printer = new ANTLRTreePrinter();
        printer.setASTNodeClass("org.antlr.tool.GrammarAST");
        try {
            String g = printer.toString((AST)this.grammarTree, this, false);
            output.println(g);
        }
        catch (RecognitionException re) {
            ErrorManager.error(100, re);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.global_k = -1;
        this.actions = new HashMap();
        this.maxTokenType = 3;
        this.charVocabulary = null;
        this.tokenIDToTypeMap = new HashMap();
        this.stringLiteralToTypeMap = new HashMap();
        this.typeToTokenList = new Vector();
        this.lineColumnToLookaheadDFAMap = new HashMap();
        this.ruleRefs = new HashSet();
        this.tokenIDRefs = new HashSet();
        this.lexerRules = new HashSet();
        this.decisionNumber = 0;
        this.ruleIndex = 1;
        this.nameToRuleMap = new LinkedHashMap();
        this.scopes = new HashMap();
        this.ruleIndexToRuleList = new Vector();
        this.grammarTree = null;
        this.indexToDecision = new Vector(300);
        this.nameSpaceChecker = new NameSpaceChecker(this);
        this.lookBusy = new HashSet();
        this.visitedDuringRecursionCheck = null;
        this.watchNFAConversion = false;
        Class clazz = class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer;
        if (clazz == null) {
            clazz = class$org$antlr$stringtemplate$language$AngleBracketTemplateLexer = Grammar.class("[Lorg.antlr.stringtemplate.language.AngleBracketTemplateLexer;", false);
        }
        this.lexerGrammarST = new StringTemplate("lexer grammar <name>;\n<if(options)>options {\n  <options:{<it.name>=<it.value>;<\\n>}>\n}<\\n>\n<endif>\n<actionNames,actions:{n,a|@<n> {<a>}\n}>\n<literals:{<it.ruleName> : <it.literal> ;\n}>\n<rules>", clazz);
        this.numberOfSemanticPredicates = 0;
        this.numberOfManualLookaheadOptions = 0;
        this.setOfNondeterministicDecisionNumbers = new HashSet();
        this.setOfNondeterministicDecisionNumbersResolvedWithPredicates = new HashSet();
        this.setOfDFAWhoseConversionTerminatedEarly = new HashSet();
        this.blocksWithSynPreds = new HashSet();
        this.decisionsWhoseDFAsUsesSynPreds = new HashSet();
        this.synPredNamesUsedInDFA = new HashSet();
        this.blocksWithSemPreds = new HashSet();
        this.decisionsWhoseDFAsUsesSemPreds = new HashSet();
        this.allDecisionDFACreated = false;
        this.builtFromString = false;
    }

    public Grammar() {
        this.this();
        this.initTokenSymbolTables();
        this.builtFromString = true;
    }

    public Grammar(String grammarString) throws RecognitionException, TokenStreamException {
        this.this();
        this.builtFromString = true;
        this.initTokenSymbolTables();
        this.setFileName("<string>");
        this.setGrammarContent(new StringReader(grammarString));
    }

    public Grammar(String fileName, String grammarString) throws RecognitionException, TokenStreamException {
        this(null, fileName, new StringReader(grammarString));
    }

    public Grammar(Tool tool, String fileName, Reader r) throws RecognitionException, TokenStreamException {
        this.this();
        this.initTokenSymbolTables();
        this.setTool(tool);
        this.setFileName(fileName);
        this.setGrammarContent(r);
    }

    static {
        Grammar.ANTLRLiteralEscapedCharValue[110] = 10;
        Grammar.ANTLRLiteralEscapedCharValue[114] = 13;
        Grammar.ANTLRLiteralEscapedCharValue[116] = 9;
        Grammar.ANTLRLiteralEscapedCharValue[98] = 8;
        Grammar.ANTLRLiteralEscapedCharValue[102] = 12;
        Grammar.ANTLRLiteralEscapedCharValue[92] = 92;
        Grammar.ANTLRLiteralEscapedCharValue[39] = 39;
        Grammar.ANTLRLiteralEscapedCharValue[34] = 34;
        Grammar.ANTLRLiteralCharValueEscape[10] = "\\n";
        Grammar.ANTLRLiteralCharValueEscape[13] = "\\r";
        Grammar.ANTLRLiteralCharValueEscape[9] = "\\t";
        Grammar.ANTLRLiteralCharValueEscape[8] = "\\b";
        Grammar.ANTLRLiteralCharValueEscape[12] = "\\f";
        Grammar.ANTLRLiteralCharValueEscape[92] = "\\\\";
        Grammar.ANTLRLiteralCharValueEscape[39] = "\\'";
        grammarTypeToString = new String[]{"<invalid>", "lexer", "parser", "tree", "combined"};
        grammarTypeToFileNameSuffix = new String[]{"<invalid>", "Lexer", "Parser", "TreeParser", "Parser"};
        legalOptions = new HashSet(){

            private final /* synthetic */ void this() {
                this.add("language");
                this.add("tokenVocab");
                this.add("output");
                this.add("ASTLabelType");
                this.add("TokenLabelType");
                this.add("superClass");
                this.add("filter");
                this.add("k");
                this.add("backtrack");
                this.add("memoize");
            }
            {
                this.this();
            }
        };
        doNotCopyOptionsToLexer = new HashSet(){

            private final /* synthetic */ void this() {
                this.add("output");
                this.add("ASTLabelType");
                this.add("superClass");
                this.add("k");
                this.add("backtrack");
                this.add("memoize");
            }
            {
                this.this();
            }
        };
        defaultOptions = new HashMap(){

            private final /* synthetic */ void this() {
                this.put("language", "Java");
            }
            {
                this.this();
            }
        };
    }

    public static class Decision {
        public int decision;
        public NFAState startState;
        public GrammarAST blockAST;
        public DFA dfa;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class LabelElementPair {
        public Token label;
        public GrammarAST elementRef;
        public String referencedRuleName;
        public int type;

        public Rule getReferencedRule() {
            return Grammar.this.getRule(this.referencedRuleName);
        }

        public String toString() {
            return this.elementRef.toString();
        }

        public LabelElementPair(Token label, GrammarAST elementRef) {
            this.label = label;
            this.elementRef = elementRef;
            this.referencedRuleName = elementRef.getText();
        }
    }
}

