/*
 * Copyright 2003-2007 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.codehaus.groovy.tools.shell.commands

import org.codehaus.groovy.tools.shell.ExitNotification

/**
 * Tests for the {@link ExitCommand} class.
 *
 * @version $Id: ExitCommandTest.groovy 8443 2007-10-07 09:42:31Z user57 $
 * @author <a href="mailto:jason@planet57.com">Jason Dillon</a>
 */
class ExitCommandTest
    extends CommandTestSupport
{
    void testWithNoArgs() {
        try {
            shell << 'exit'
            fail()
        }
        catch (ExitNotification e) {
            // expected
        }
    }
    
    /*
    FIXME: Errors don't currently throw anything, just io.error.println()'s...
    
    void testWithArgs() {
        try {
            shell << 'exit foo'
            fail()
        }
        catch (Exception e) {
            // expected
        }
    }
    */
}
