package dguitar.gui;

/*
 * ScoreInformationDialog.java
 *
 * Created on 20 de diciembre de 2004, 08:16 AM
 */
import i18n.Internationalized;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import dguitar.codecs.guitarPro.GPMIDIChannel;
import dguitar.codecs.guitarPro.GPSong;
import dguitar.codecs.guitarPro.GPTrackLyrics;

/**
 * 
 * @author Mauricio Gracia Gutirrez
 */
public class ScoreInformationDialog extends JDialog implements
        Internationalized {
    GPSong p;

    public ScoreInformationDialog() {
        super();
        initComponents();
    }

    public ScoreInformationDialog(JFrame parent, boolean modal) {
        super(parent, modal);
        initComponents();
    }

    public void setPiece(GPSong song) {
        int i;
        GPTrackLyrics TL;

        p = song;
        this.version.setText(p.getVersion());
        this.title.setText(p.getTitle());
        this.subtitle.setText(p.getSubtitle());
        this.artist.setText(p.getInterpret());
        this.author.setText(p.getAuthorSong());
        this.album.setText(p.getAlbum());
        this.copyright.setText(p.getCopyright());
        this.authorTablature.setText(p.getAuthorPiece());
        this.instructions.setText(p.getInstruction());
        this.notice.setText(p.getNote());
        this.triplet.setSelected(p.tripletFeel);
        //Fill information about the lyrics
        TL = p.getLyrics();
        this.lyricsTrack.setText("" + TL.getTrackNumber());

        for (i = 0; i < 5; i++) {
            this.line[i].setText(TL.getLines(0));
            this.StartLine[i].setText("" + TL.getMeasureNumber(i));
        }

        //Fill the inforamtion abouth the midi channels
        this.fillMidiChannel();
    }

    private void fillMidiChannel() {
        int port;
        int channel;
        int i;
        GPMIDIChannel MC;
        boolean MCempty;

        MCempty = false ;
        for (i = 0; i < 64; i++) {
            port = 1 + (i / 16);
            channel = 1 + (i % 16);
            MC = p.getChannels(i);

            //Port number
            this.midiChannels.setValueAt(new Integer(port), i, 0);
            //Channel number
            this.midiChannels.setValueAt(new Integer(channel), i, 1);

            //NEW when GP2,GP1 decoding was introduced this IF was added
            MCempty = MCempty || (MC == null);
            if (MC != null) {
                //Instrument Number
                this.midiChannels.setValueAt(new Integer(MC.getInstrument()),
                        i, 2);
                //Volume value
                this.midiChannels.setValueAt(new Integer(MC.getVolume()), i, 3);
                //Balance value
                this.midiChannels.setValueAt(new Integer(MC.getBalance() - 8),
                        i, 4);
                //Chorus value
                this.midiChannels.setValueAt(new Integer(MC.getChorus()), i, 5);
                //Reverb value
                this.midiChannels.setValueAt(new Integer(MC.getReverb()), i, 6);
                //Phaser value
                this.midiChannels.setValueAt(new Integer(MC.getPhaser()), i, 7);
                //Tremolo value
                this.midiChannels
                        .setValueAt(new Integer(MC.getTremolo()), i, 8);
            }
        }
        if (MCempty) {
            System.err
                    .println("some MidiChannel on this song are empty(null)");

        }
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        createComponents();
    }//GEN-END:initComponents

    private void createComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        scoreInfo = new javax.swing.JTabbedPane();
        info = new javax.swing.JPanel();
        lbl1 = new javax.swing.JLabel();
        lbl2 = new javax.swing.JLabel();
        lbl3 = new javax.swing.JLabel();
        lbl4 = new javax.swing.JLabel();
        lbl5 = new javax.swing.JLabel();
        lbl6 = new javax.swing.JLabel();
        lbl7 = new javax.swing.JLabel();
        lbl8 = new javax.swing.JLabel();
        lbl9 = new javax.swing.JLabel();
        lbl10 = new javax.swing.JLabel();
        version = new javax.swing.JTextField();
        title = new javax.swing.JTextField();
        subtitle = new javax.swing.JTextField();
        artist = new javax.swing.JTextField();
        album = new javax.swing.JTextField();
        author = new javax.swing.JTextField();
        copyright = new javax.swing.JTextField();
        authorTablature = new javax.swing.JTextField();
        instructions = new javax.swing.JTextField();
        noticeSP = new javax.swing.JScrollPane();
        notice = new javax.swing.JTextArea();
        triplet = new javax.swing.JCheckBox();
        lyrics = new javax.swing.JPanel();
        lyricsTabs = new javax.swing.JTabbedPane();

        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        lyricsTrack = new javax.swing.JTextField();
        mc = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        midiChannels = new javax.swing.JTable();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setResizable(false);
        info.setLayout(new java.awt.GridBagLayout());

        lbl1.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        lbl1.setLabelFor(version);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.1;
        info.add(lbl1, gridBagConstraints);

        lbl2.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        lbl2.setLabelFor(title);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.1;
        info.add(lbl2, gridBagConstraints);

        lbl3.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        lbl3.setLabelFor(subtitle);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.1;
        info.add(lbl3, gridBagConstraints);

        lbl4.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        lbl4.setLabelFor(album);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.1;
        info.add(lbl4, gridBagConstraints);

        lbl5.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        lbl5.setLabelFor(author);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.1;
        info.add(lbl5, gridBagConstraints);

        lbl6.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        lbl6.setLabelFor(copyright);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.1;
        info.add(lbl6, gridBagConstraints);

        lbl7.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        lbl7.setLabelFor(authorTablature);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.1;
        info.add(lbl7, gridBagConstraints);

        lbl8.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        lbl8.setLabelFor(artist);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.1;
        info.add(lbl8, gridBagConstraints);

        lbl9.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        lbl9.setLabelFor(instructions);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.1;
        info.add(lbl9, gridBagConstraints);

        lbl10.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        lbl10.setLabelFor(noticeSP);

        lbl10.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.1;
        info.add(lbl10, gridBagConstraints);

        version.setEditable(false);
        version.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        info.add(version, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        info.add(title, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        info.add(subtitle, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        info.add(artist, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        info.add(album, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        info.add(author, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        info.add(copyright, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        info.add(authorTablature, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        info.add(instructions, gridBagConstraints);

        notice.setColumns(30);
        notice.setLineWrap(true);
        notice.setRows(5);
        notice.setBorder(new javax.swing.border.LineBorder(new java.awt.Color(
                0, 0, 0)));
        noticeSP.setViewportView(notice);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        info.add(noticeSP, gridBagConstraints);

        triplet.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        info.add(triplet, gridBagConstraints);

        //      adding the first TAB to the scoreInformation
        scoreInfo.addTab(DGuitar.lang.getString("SI"), info);

        //	add a tab for each of the 5 lines
        this.addLyricsTabs();

        //      adding the second TAB to the scoreInformation
        scoreInfo.addTab(DGuitar.lang.getString("Lyrics"), lyrics);

        mc.setLayout(new java.awt.BorderLayout());

        DTM = new javax.swing.table.DefaultTableModel(new Object[][] {
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null },
                { null, null, null, null, null, null, null, null, null } },
                new String[] { DGuitar.lang.getString("MIDIchannelPort"),
                        DGuitar.lang.getString("MIDIchannelChannel"),
                        DGuitar.lang.getString("MIDIchannelInstrument"),
                        DGuitar.lang.getString("MIDIchannelVolume"),
                        DGuitar.lang.getString("MIDIchannelBalance"),
                        DGuitar.lang.getString("MIDIchannelChorus"),
                        DGuitar.lang.getString("MIDIchannelReverb"),
                        DGuitar.lang.getString("MIDIchannelPhaser"),
                        DGuitar.lang.getString("MIDIchannelTremolo") }

        ) {
            Class[] types = new Class[] { java.lang.Integer.class,
                    java.lang.Integer.class, java.lang.Integer.class,
                    java.lang.Integer.class, java.lang.Integer.class,
                    java.lang.Integer.class, java.lang.Integer.class,
                    java.lang.Integer.class, java.lang.Integer.class };

            boolean[] canEdit = new boolean[] { false, false, false, false,
                    false, false, false, false, false };

            public Class getColumnClass(int columnIndex) {
                return types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit[columnIndex];
            }
        };
        midiChannels.setModel(DTM);
        jScrollPane1.setViewportView(midiChannels);

        mc.add(jScrollPane1, java.awt.BorderLayout.CENTER);
        scoreInfo.addTab(DGuitar.lang.getString("SImidiChannels"), mc);

        getContentPane().add(scoreInfo, java.awt.BorderLayout.CENTER);

        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit()
                .getScreenSize();
        setBounds((screenSize.width - 447) / 2, (screenSize.height - 371) / 2,
                447, 371);

        //INTERNATIONALIZATION
        setLangText();
    }

    private void addLyricsTabs() {
        lyrics.setLayout(new java.awt.BorderLayout());
        int i;

        for (i = 0; i < 5; i++) {
            l[i] = new javax.swing.JPanel();
            start[i] = new javax.swing.JPanel();
            jscroll[i] = new javax.swing.JScrollPane();
            line[i] = new javax.swing.JTextArea();
            lblLine[i] = new javax.swing.JLabel();
            StartLine[i] = new javax.swing.JTextField();

            l[i].setLayout(new java.awt.BorderLayout());

            line[i].setLineWrap(true);
            line[i].setWrapStyleWord(true);

            jscroll[i].setViewportView(line[i]);

            l[i].add(jscroll[i], java.awt.BorderLayout.CENTER);

            start[i].add(lblLine[i]);

            start[i].add(StartLine[i]);

            l[i].add(start[i], java.awt.BorderLayout.NORTH);
            lyricsTabs.addTab(DGuitar.lang.getString("SIline") + " " + i, l[i]);

        }

        lyrics.add(lyricsTabs, java.awt.BorderLayout.CENTER);

        jPanel1.add(jLabel1);

        jPanel1.add(lyricsTrack);

        lyrics.add(jPanel1, java.awt.BorderLayout.NORTH);
    }

    public void setLangText() {
        int i;

        setTitle(DGuitar.lang.getString("SI") + ": ");
        lbl1.setText(DGuitar.lang.getString("SIversion") + ": ");
        lbl2.setText(DGuitar.lang.getString("SItitle") + ": ");
        lbl3.setText(DGuitar.lang.getString("SIsubtitle") + ": ");
        lbl4.setText(DGuitar.lang.getString("SIalbum") + ": ");
        lbl5.setText(DGuitar.lang.getString("SIauthor") + ": ");
        lbl6.setText(DGuitar.lang.getString("SIcopyright") + ": ");
        lbl7.setText(DGuitar.lang.getString("SItabAuthor") + ": ");
        lbl8.setText(DGuitar.lang.getString("SIartist") + ": ");
        lbl9.setText(DGuitar.lang.getString("SIinstructions") + ": ");
        lbl10.setText(DGuitar.lang.getString("SInotice") + ": ");
        triplet.setText(DGuitar.lang.getString("SItriplet"));

        scoreInfo.setTitleAt(0, DGuitar.lang.getString("SI"));

        scoreInfo.setTitleAt(1, DGuitar.lang.getString("Lyrics"));

        for (i = 0; i < 5; i++) {
            lblLine[i].setText(DGuitar.lang.getString("SIstartsFromMeasure")
                    + ": ");
            lyricsTabs
                    .setTitleAt(i, DGuitar.lang.getString("SIline") + " " + i);
        }

        jLabel1.setText(DGuitar.lang.getString("SIapplyToTrack") + ": ");
        scoreInfo.setTitleAt(2, DGuitar.lang.getString("SImidiChannels"));
        DTM.setColumnIdentifiers(new String[] {
                DGuitar.lang.getString("MIDIchannelPort"),
                DGuitar.lang.getString("MIDIchannelChannel"),
                DGuitar.lang.getString("MIDIchannelInstrument"),
                DGuitar.lang.getString("MIDIchannelVolume"),
                DGuitar.lang.getString("MIDIchannelBalance"),
                DGuitar.lang.getString("MIDIchannelChorus"),
                DGuitar.lang.getString("MIDIchannelReverb"),
                DGuitar.lang.getString("MIDIchannelPhaser"),
                DGuitar.lang.getString("MIDIchannelTremolo") });
    }

    private javax.swing.JTextField album;

    private javax.swing.JTextField artist;

    private javax.swing.JTextField author;

    private javax.swing.JTextField authorTablature;

    private javax.swing.JTextField copyright;

    private javax.swing.JPanel info;

    private javax.swing.JTextField instructions;

    private javax.swing.JLabel jLabel1;

    private javax.swing.JPanel jPanel1;

    private javax.swing.JScrollPane jScrollPane1;

    //Begin of variables for the lyrics
    private JTextField StartLine[] = new JTextField[5];

    private JScrollPane jscroll[] = new JScrollPane[5];

    private javax.swing.JPanel l[] = new JPanel[5];

    private JPanel start[] = new JPanel[5];

    private JTextArea line[] = new JTextArea[5];

    private JLabel lblLine[] = new JLabel[5];

    private javax.swing.JPanel lyrics;

    private javax.swing.JTabbedPane lyricsTabs;

    private javax.swing.JTextField lyricsTrack;

    //end of variables for the lyrics

    private javax.swing.JLabel lbl1;

    private javax.swing.JLabel lbl10;

    private javax.swing.JLabel lbl2;

    private javax.swing.JLabel lbl3;

    private javax.swing.JLabel lbl4;

    private javax.swing.JLabel lbl5;

    private javax.swing.JLabel lbl6;

    private javax.swing.JLabel lbl7;

    private javax.swing.JLabel lbl8;

    private javax.swing.JLabel lbl9;

    private javax.swing.JPanel mc;

    private javax.swing.JTable midiChannels;

    private javax.swing.JTextArea notice;

    private javax.swing.JScrollPane noticeSP;

    private javax.swing.JTabbedPane scoreInfo;

    private javax.swing.JTextField subtitle;

    private javax.swing.JTextField title;

    private javax.swing.JCheckBox triplet;

    private javax.swing.JTextField version;

    private javax.swing.table.DefaultTableModel DTM;
}