/*
 * File:          sidlx_rmi_SimpleServer_Impl.c
 * Symbol:        sidlx.rmi.SimpleServer-v0.1
 * Symbol Type:   class
 * Babel Version: 0.10.2
 * Description:   Server-side implementation for sidlx.rmi.SimpleServer
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.10.2
 */

/*
 * DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS
 * FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.
 */

/*
 * Symbol "sidlx.rmi.SimpleServer" (version 0.1)
 * 
 * A multi-threaded base class for simple network servers.
 */

#include "sidlx_rmi_SimpleServer_Impl.h"

#line 26 "../../../babel/runtime/sidlx/sidlx_rmi_SimpleServer_Impl.c"
/* DO-NOT-DELETE splicer.begin(sidlx.rmi.SimpleServer._includes) */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include "sidlx_common.h"
#define LISTENQ 1024
#define MAXLINE 1023
/* DO-NOT-DELETE splicer.end(sidlx.rmi.SimpleServer._includes) */
#line 36 "sidlx_rmi_SimpleServer_Impl.c"

/*
 * Static class initializer called exactly once before any user-defined method is dispatched
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_SimpleServer__load"

void
impl_sidlx_rmi_SimpleServer__load(
  void)
{
#line 47 "../../../babel/runtime/sidlx/sidlx_rmi_SimpleServer_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.rmi.SimpleServer._load) */
  /* Insert the implementation of the static class initializer method here... */
  /* DO-NOT-DELETE splicer.end(sidlx.rmi.SimpleServer._load) */
#line 53 "sidlx_rmi_SimpleServer_Impl.c"
}
/*
 * Class constructor called when the class is created.
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_SimpleServer__ctor"

void
impl_sidlx_rmi_SimpleServer__ctor(
  /* in */ sidlx_rmi_SimpleServer self)
{
#line 62 "../../../babel/runtime/sidlx/sidlx_rmi_SimpleServer_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.rmi.SimpleServer._ctor) */
  struct sidlx_rmi_SimpleServer__data *dptr;
  dptr = malloc(sizeof(struct sidlx_rmi_SimpleServer__data));
  dptr->s_sock = sidlx_rmi_ServerSocket__create();
  sidlx_rmi_SimpleServer__set_data(self, dptr);
  /* DO-NOT-DELETE splicer.end(sidlx.rmi.SimpleServer._ctor) */
#line 73 "sidlx_rmi_SimpleServer_Impl.c"
}

/*
 * Class destructor called when the class is deleted.
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_SimpleServer__dtor"

void
impl_sidlx_rmi_SimpleServer__dtor(
  /* in */ sidlx_rmi_SimpleServer self)
{
#line 81 "../../../babel/runtime/sidlx/sidlx_rmi_SimpleServer_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.rmi.SimpleServer._dtor) */
  struct sidlx_rmi_SimpleServer__data * data = sidlx_rmi_SimpleServer__get_data( self );
  if (data) {
    sidlx_rmi_ServerSocket_deleteRef(data->s_sock);
    free((void*) data);
  }
  sidlx_rmi_SimpleServer__set_data( self, NULL );
  /* DO-NOT-DELETE splicer.end(sidlx.rmi.SimpleServer._dtor) */
#line 96 "sidlx_rmi_SimpleServer_Impl.c"
}

/*
 * set which port number to bind to
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_SimpleServer_setPort"

void
impl_sidlx_rmi_SimpleServer_setPort(
  /* in */ sidlx_rmi_SimpleServer self,
  /* in */ int32_t port,
  /* out */ sidl_BaseInterface *_ex)
{
#line 104 "../../../babel/runtime/sidlx/sidlx_rmi_SimpleServer_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.rmi.SimpleServer.setPort) */
  struct sidlx_rmi_SimpleServer__data *data=sidlx_rmi_SimpleServer__get_data(self);
  
  sidlx_rmi_ServerSocket_init(data->s_sock, port, _ex); SIDL_CHECK(*_ex);
  return;
 EXIT:
  printf("Exception caught in impl_sidlx_rmi_SimpleServer_setPort\n\n");
  return;
  /* DO-NOT-DELETE splicer.end(sidlx.rmi.SimpleServer.setPort) */
#line 122 "sidlx_rmi_SimpleServer_Impl.c"
}

/*
 * run the server (must have port specified first)
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_SimpleServer_run"

void
impl_sidlx_rmi_SimpleServer_run(
  /* in */ sidlx_rmi_SimpleServer self,
  /* out */ sidl_BaseInterface *_ex)
{
#line 127 "../../../babel/runtime/sidlx/sidlx_rmi_SimpleServer_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.rmi.SimpleServer.run) */
  int i;
  int len;
  int connection_socket;
  int pid;
  char buff[MAXLINE];
  sidlx_rmi_Socket ac_sock = NULL;
  struct sidlx_rmi_SimpleServer__data *dptr=sidlx_rmi_SimpleServer__get_data(self);
  if(dptr) {
    /*
      data=sidlx_rmi_SimpleServer__get_data(self);
      
      data->d_listen_socket = 
      s_socket( AF_INET, SOCK_STREAM, 0, _ex); SIDL_CHECK(*_ex);
      
      s_bind( data->d_listen_socket, (struct sockaddr*) &(data->d_serv_addr), 
      sizeof (data->d_serv_addr), _ex); SIDL_CHECK(*_ex);
      
      s_listen( data->d_listen_socket, LISTENQ, _ex); SIDL_CHECK(*_ex);
    */
    /*for(;;) {*/ 
      /* len = sizeof(cliaddr); */
      ac_sock = sidlx_rmi_ServerSocket_accept(dptr->s_sock, _ex); SIDL_CHECK(*_ex);
      
      /*Basically, I need our ORB to be single process
      #define GARY_K
      #ifdef GARY_K
            pid = s_fork(_ex); SIDL_CHECK(*_ex);
      if ( pid == 0 ) {*/ 
      /* child closes listening socket 
      sidlx_rmi_ServerSocket_close( dptr->s_sock, _ex); SIDL_CHECK(*_ex);
      sidlx_rmi_Socket_deleteRef(dptr->s_sock);*/
      /* SHOULD clean up here */
      /*#endif*/
	/* process request */
      printf("SimpleServer: connection\n");
      /*
	from %s port %d\n",
	inet_ntop(AF_INET, &cliaddr.sin_addr, buff, sizeof(buff)),
	ntohs(cliaddr.sin_port ));
      */
      sidlx_rmi_SimpleServer_serviceRequest( self, ac_sock,_ex );SIDL_CHECK(*_ex);
      /*s_close(connection_socket, _ex); SIDL_CHECK(*_ex);
      exit(0);
      #ifdef GARY_K
      } 
      sidlx_rmi_Socket_close( ac_sock, _ex); SIDL_CHECK(*_ex);
      sidlx_rmi_Socket_deleteRef(ac_sock);
      s_close(connection_socket, _ex); SIDL_CHECK(*_ex); 
      #endif
      }*/
      return;
  }
  SIDL_THROW( *_ex, sidlx_rmi_GenNetworkException, "Simple Server not initialized");

 EXIT:
  return;
  /* DO-NOT-DELETE splicer.end(sidlx.rmi.SimpleServer.run) */
#line 196 "sidlx_rmi_SimpleServer_Impl.c"
}
