// 
// File:          sort_MergeSort_Impl.cc
// Symbol:        sort.MergeSort-v0.1
// Symbol Type:   class
// Babel Version: 0.10.2
// Description:   Server-side implementation for sort.MergeSort
// 
// WARNING: Automatically generated; only changes within splicers preserved
// 
// babel-version = 0.10.2
// 
#include "sort_MergeSort_Impl.hh"

#line 14 "../../../../babel/regression/sort/libCxx/sort_MergeSort_Impl.cc"
// DO-NOT-DELETE splicer.begin(sort.MergeSort._includes)
static void
mergeLists(sort::Container  &elems,
           sort::Comparator &comp,
           sort::Counter    &cmp,
           sort::Counter    &swp,
           int32_t          start,
           int32_t          mid,
           const int32_t    end)
{
  int32_t j;
  while ((start < mid) && (mid < end)) {
    cmp.inc();
    if (elems.compare(start, mid, comp) > 0) {
      /* move first element of upper list into place */
      for(j = mid;j > start; --j) {
	swp.inc();
	elems.swap(j, j - 1);
      }
      ++mid;
    }
    ++start;
  }
}

/**
 * end is one past the end
 */
static void
mergeSort(sort::Container  &elems,
          sort::Comparator &comp,
          sort::Counter    &cmp,
          sort::Counter    &swp,
          const int32_t   start,
          const int32_t   end)
{
  if ((end - start) > 1) {
    int32_t mid = (start + end) >> 1;
    mergeSort(elems, comp, cmp, swp, start, mid);
    mergeSort(elems, comp, cmp, swp, mid, end);
    mergeLists(elems, comp, cmp, swp, start, mid, end);
  }
}
// DO-NOT-DELETE splicer.end(sort.MergeSort._includes)
#line 59 "sort_MergeSort_Impl.cc"

// user-defined constructor.
void sort::MergeSort_impl::_ctor() {
#line 61 "../../../../babel/regression/sort/libCxx/sort_MergeSort_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.MergeSort._ctor)
  // add construction details here
  // DO-NOT-DELETE splicer.end(sort.MergeSort._ctor)
#line 67 "sort_MergeSort_Impl.cc"
}

// user-defined destructor.
void sort::MergeSort_impl::_dtor() {
#line 68 "../../../../babel/regression/sort/libCxx/sort_MergeSort_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.MergeSort._dtor)
  // add destruction details here
  // DO-NOT-DELETE splicer.end(sort.MergeSort._dtor)
#line 76 "sort_MergeSort_Impl.cc"
}

// static class initializer.
void sort::MergeSort_impl::_load() {
#line 75 "../../../../babel/regression/sort/libCxx/sort_MergeSort_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.MergeSort._load)
  // guaranteed to be called at most once before any other method in this class
  // DO-NOT-DELETE splicer.end(sort.MergeSort._load)
#line 85 "sort_MergeSort_Impl.cc"
}

// user-defined static methods: (none)

// user-defined non-static methods:
/**
 * Sort elements using Merge Sort.
 */
void
sort::MergeSort_impl::sort (
  /* in */ ::sort::Container elems,
  /* in */ ::sort::Comparator comp ) 
throw () 
{
#line 92 "../../../../babel/regression/sort/libCxx/sort_MergeSort_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.MergeSort.sort)
  const int32_t num = elems.getLength();
  sort::Counter cmp = self.getCompareCounter();
  sort::Counter swp = self.getSwapCounter();
  mergeSort(elems, comp, cmp, swp, 0, num);
  // DO-NOT-DELETE splicer.end(sort.MergeSort.sort)
#line 107 "sort_MergeSort_Impl.cc"
}

/**
 * Return merge sort.
 */
::std::string
sort::MergeSort_impl::getName ()
throw () 

{
#line 108 "../../../../babel/regression/sort/libCxx/sort_MergeSort_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.MergeSort.getName)
  return "Merge sort";
  // DO-NOT-DELETE splicer.end(sort.MergeSort.getName)
#line 122 "sort_MergeSort_Impl.cc"
}


#line 114 "../../../../babel/regression/sort/libCxx/sort_MergeSort_Impl.cc"
// DO-NOT-DELETE splicer.begin(sort.MergeSort._misc)
// Put miscellaneous code here
// DO-NOT-DELETE splicer.end(sort.MergeSort._misc)
#line 130 "sort_MergeSort_Impl.cc"

