// 
// File:        ArgsTest.java
// Copyright:   (c) 2001 The Regents of the University of California
// Revision:    @(#) $Revision: 4434 $
// Date:        $Date: 2005-03-17 09:05:29 -0800 (Thu, 17 Mar 2005) $
// Description: argument regression test case for Java calling other languages
// 

/**
 * The following class runs the argument regression test cases for Java.
 */
public class ArgsTest {
  private final static int FAIL        = 0;
  private final static int XFAIL       = 1;
  private final static int PASS        = 2;
  private final static int XPASS       = 3;
  private final static int UNSUPPORTED = 4;

  private final static String[] s_results = {
    "FAIL",
    "XFAIL",
    "PASS",
    "XPASS",
    "UNSUPPORTED"
  };

  private static int s_part = 0;
  private static int s_result =  synch.ResultType.PASS;
  private static synch.RegOut tracker; 
  /**
   * Check the results of the test case.
   */
  //Comments should really be passed in here.
  private static void startTest(String test) {
    tracker.startPart(++s_part);
    if(test != null)
      tracker.writeComment(test);
  }

  private static void check(int expected, boolean pass, String test ) {
    if (test != null)
      tracker.writeComment(test);

    if(expected == synch.ResultType.PASS)
      if(pass)
        tracker.endPart(s_part, synch.ResultType.PASS);
      else
        tracker.endPart(s_part, synch.ResultType.FAIL);
    else if (expected == synch.ResultType.XFAIL)
      if(pass)
        tracker.endPart(s_part, synch.ResultType.XPASS);
      else
        tracker.endPart(s_part, synch.ResultType.XFAIL);
    else
      tracker.endPart(s_part, synch.ResultType.FAIL);
  }

  /**
   * The main test driver takes no command-line arguments and runs the
   * regression tests.
   */
  public static void main(String args[]) {
    try {
      /*
       * Begin the test
       */
      tracker = new synch.RegOut();
      tracker.setExpectations(-1);
      s_part   = 0;
      s_result = synch.ResultType.PASS;

      /*
       * Boolean arguments
       */
      if (true) {
        Args.Cbool obj = new Args.Cbool();

        sidl.Boolean.Holder out   = new sidl.Boolean.Holder(false);
        sidl.Boolean.Holder inout = new sidl.Boolean.Holder(true);

        startTest(null);
        check(synch.ResultType.PASS,
              (obj.returnback() == true),
              "(obj.returnback() == true)");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passin(true) == true),
              "(obj.passin(true) == true)");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passout(out) == true && out.get() == true),
              "(obj.passout(out) == true && out.get() == true)");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passinout(inout) == true && inout.get() == false),
              "(obj.passinout(inout) == true && inout.get() == false)");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passeverywhere(true, out, inout) == true
               && out.get() == true
               && inout.get() == true),
              "(obj.passeverywhere(true, out, inout) == true"
              + " && out.get() == true"
              + " && inout.get() == true)");
      }

      /*
       * Character arguments
       */
      if (true) {
        Args.Cchar obj = new Args.Cchar();

        sidl.Character.Holder out   = new sidl.Character.Holder();
        sidl.Character.Holder inout = new sidl.Character.Holder('A');

        startTest(null);
        check(synch.ResultType.PASS,
              (obj.returnback() == '3'),
              "(obj.returnback() == '3')");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passin('3') == true),
              "(obj.passin('3') == true)");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passout(out) == true && out.get() == '3'),
              "(obj.passout(out) == true && out.get() == '3')");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passinout(inout) == true && inout.get() == 'a'),
              "(obj.passinout(inout) == true && inout.get() == 'a')");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passeverywhere('3', out, inout) == '3' 
               && out.get() == '3'
               && inout.get() == 'A'),
              "(obj.passeverywhere('3', out, inout) == '3'"
              + " && out.get() == '3'"
              + " && inout.get() == 'A')");
      }

      /*
       * Integer arguments
       */
      if (true) {
        Args.Cint obj = new Args.Cint();

        sidl.Integer.Holder out   = new sidl.Integer.Holder();
        sidl.Integer.Holder inout = new sidl.Integer.Holder(3);

        startTest(null);
        check(synch.ResultType.PASS,
              (obj.returnback() == 3),
              "(obj.returnback() == 3)");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passin(3) == true),
              "(obj.passin(3) == true)");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passout(out) == true && out.get() == 3),
              "(obj.passout(out) == true && out.get() == 3)");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passinout(inout) == true && inout.get() == -3),
              "(obj.passinout(inout) == true && inout.get() == -3)");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passeverywhere(3, out, inout) == 3 
               && out.get() == 3
               && inout.get() == 3),
              "(obj.passeverywhere(3, out, inout) == 3"
              + " && out.get() == 3"
              + " && inout.get() == 3)");
      }

      /*
       * Long arguments
       */
      if (true) {
        Args.Clong obj = new Args.Clong();

        sidl.Long.Holder out   = new sidl.Long.Holder();
        sidl.Long.Holder inout = new sidl.Long.Holder(3);

        startTest(null);
        check(synch.ResultType.PASS,
              (obj.returnback() == 3),
              "(obj.returnback() == 3)");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passin(3) == true),
              "(obj.passin(3) == true)");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passout(out) == true && out.get() == 3),
              "(obj.passout(out) == true && out.get() == 3)");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passinout(inout) == true && inout.get() == -3),
              "(obj.passinout(inout) == true && inout.get() == -3)");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passeverywhere(3, out, inout) == 3 
               && out.get() == 3
               && inout.get() == 3),
              "(obj.passeverywhere(3, out, inout) == 3"
              + " && out.get() == 3"
              + " && inout.get() == 3)");
      }

      /*
       * Float arguments
       */
      if (true) {
        Args.Cfloat obj = new Args.Cfloat();

        sidl.Float.Holder out   = new sidl.Float.Holder();
        sidl.Float.Holder inout = new sidl.Float.Holder(3.1F);

        startTest(null);
        check(synch.ResultType.PASS,
              (obj.returnback() == 3.1F),
              "(obj.returnback() == 3.1F)");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passin(3.1F) == true),
              "(obj.passin(3.1F) == true)");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passout(out) == true && out.get() == 3.1F),
              "(obj.passout(out) == true && out.get() == 3.1F)");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passinout(inout) == true && inout.get() == -3.1F),
              "(obj.passinout(inout) == true && inout.get() == -3.1F)");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passeverywhere(3.1F, out, inout) == 3.1F
               && out.get() == 3.1F
               && inout.get() == 3.1F),
              "(obj.passeverywhere(3.1F, out, inout) == 3.1F"
              + " && out.get() == 3.1F"
              + " && inout.get() == 3.1F)");
      }

      /*
       * Double arguments
       */
      if (true) {
        Args.Cdouble obj = new Args.Cdouble();

        sidl.Double.Holder out   = new sidl.Double.Holder();
        sidl.Double.Holder inout = new sidl.Double.Holder(3.14);

        startTest(null);
        check(synch.ResultType.PASS,
              (obj.returnback() == 3.14),
              "(obj.returnback() == 3.14)");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passin(3.14) == true),
              "(obj.passin(3.14) == true)");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passout(out) == true && out.get() == 3.14),
              "(obj.passout(out) == true && out.get() == 3.14)");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passinout(inout) == true && inout.get() == -3.14),
              "(obj.passinout(inout) == true && inout.get() == -3.14)");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passeverywhere(3.14, out, inout) == 3.14
               && out.get() == 3.14
               && inout.get() == 3.14),
              "(obj.passeverywhere(3.14, out, inout) == 3.14"
              + " && out.get() == 3.14"
              + " && inout.get() == 3.1)");
      }

      /*
       * FComplex arguments
       */
      if (true) {
        Args.Cfcomplex obj = new Args.Cfcomplex();

        sidl.FloatComplex retval       = null;
        sidl.FloatComplex in           = new sidl.FloatComplex(3.1F, 3.1F);
        sidl.FloatComplex.Holder out   = new sidl.FloatComplex.Holder();
        sidl.FloatComplex.Holder inout = new sidl.FloatComplex.Holder(new sidl.FloatComplex(3.1F, 3.1F));

        startTest(null);
        check(synch.ResultType.PASS,
              ((retval = obj.returnback()) != null
               && retval.real() == 3.1F && retval.imag() == 3.1F),
              "((retval = obj.returnback()) != null)"
              + " && (retval.real() == 3.1F) && (retval.imag() == 3.1F))");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passin(in) == true),
              "(obj.passin(in) == true)");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passout(out) == true
               && out.get().real() == 3.1F && out.get().imag() == 3.1F),
              "(obj.passout(out) == true"
              + " && out.get().real() == 3.1F && out.get().imag() == 3.1F)");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passinout(inout) == true
               && inout.get().real() == 3.1F && inout.get().imag() == -3.1F),
              "(obj.passinout(inout) == true"
              + " && inout.get().real() == 3.1F && inout.get().imag() == -3.1F)");
        startTest(null);
        check(synch.ResultType.PASS,
              ((retval = obj.passeverywhere(in, out, inout)) != null
               && retval.real() == 3.1F && retval.imag() == 3.1F
               && out.get().real() == 3.1F && out.get().imag() == 3.1F
               && inout.get().real() == 3.1F && inout.get().imag() == 3.1F),
              "((retval = obj.passeverywhere(in, out, inout)) != null"
              + " && retval.real() == 3.1F && retval.imag() == 3.1F"
              + " && out.get().real() == 3.1F && out.get().imag() == 3.1F"
              + " && inout.get().real() == 3.1F && inout.get().imag() == 3.1F)");
      }

      /*
       * DComplex arguments
       */
      if (true) {
        Args.Cdcomplex obj = new Args.Cdcomplex();

        sidl.DoubleComplex retval       = null;
        sidl.DoubleComplex in           = new sidl.DoubleComplex(3.14, 3.14);
        sidl.DoubleComplex.Holder out   = new sidl.DoubleComplex.Holder();
        sidl.DoubleComplex.Holder inout = new sidl.DoubleComplex.Holder(
                                                                        new sidl.DoubleComplex(3.14, 3.14));

        startTest(null);
        check(synch.ResultType.PASS,
              ((retval = obj.returnback()) != null
               && retval.real() == 3.14 && retval.imag() == 3.14),
              "((retval = obj.returnback()) != null)"
              + " && (retval.real() == 3.14) && (retval.imag() == 3.14))");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passin(in) == true),
              "(obj.passin(in) == true)");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passout(out) == true
               && out.get().real() == 3.14 && out.get().imag() == 3.14),
              "(obj.passout(out) == true"
              + " && out.get().real() == 3.14 && out.get().imag() == 3.14)");
        startTest(null);
        check(synch.ResultType.PASS,
              (obj.passinout(inout) == true
               && inout.get().real() == 3.14 && inout.get().imag() == -3.14),
              "(obj.passinout(inout) == true"
              + " && inout.get().real() == 3.14 && inout.get().imag() == -3.14)");
        startTest(null);
        check(synch.ResultType.PASS,
              ((retval = obj.passeverywhere(in, out, inout)) != null
               && retval.real() == 3.14 && retval.imag() == 3.14
               && out.get().real() == 3.14 && out.get().imag() == 3.14
               && inout.get().real() == 3.14 && inout.get().imag() == 3.14),
              "((retval = obj.passeverywhere(in, out, inout)) != null"
              + " && retval.real() == 3.14 && retval.imag() == 3.14"
              + " && out.get().real() == 3.14 && out.get().imag() == 3.14"
              + " && inout.get().real() == 3.14 && inout.get().imag() == 3.14)");
      }

      /*
       * Output final test results
       */

      //System.out.println("TEST_RESULT " + s_results[s_result]);
      tracker.close();
      Runtime.getRuntime().exit(0); /* workaround for Linux JVM 1.3.1 bug */

      /*
       * Catch any unexpected exceptions and return a test failure
       */
    } catch (Throwable ex) {
      tracker.close();
      //System.out.println("TEST_RESULT FAIL");
      //System.out.println(ex.toString());
      //System.exit(1);
    }
  }
}
