// 
// File:          gov_cca_CCAExceptionType.hh
// Symbol:        gov.cca.CCAExceptionType-v0.6.3
// Symbol Type:   enumeration
// Babel Version: 0.10.2
// Description:   Client-side glue code for gov.cca.CCAExceptionType
// 
// WARNING: Automatically generated; changes will be lost
// 
// babel-version = 0.10.2
// 

#ifndef included_gov_cca_CCAExceptionType_hh
#define included_gov_cca_CCAExceptionType_hh


#include "sidl_cxx.hh"
#include "gov_cca_CCAExceptionType_IOR.h"

namespace gov { 
  namespace cca { 

    enum CCAExceptionType {
      /**
       *  Someone caught a non-CCAException that was declared
       *  at an interface that claims it throws ONLY CCAException. 
       */
      CCAExceptionType_Unexpected = -1,

      /**
       * A CCAException that is carrying a non-standard message. 
       */
      CCAExceptionType_Nonstandard = 1,

      /**
       * Action attempted on a port name that is neither registered
       * nor added. 
       */
      CCAExceptionType_PortNotDefined = 2,

      /**
       * Adding/registering an already added/registered Port was
       *  attempted. 
       */
      CCAExceptionType_PortAlreadyDefined = 3,

      /**
       * Attempt to getPort, getPortNonblocking, or releasePort
       * with a port named that is not connected. 
       */
      CCAExceptionType_PortNotConnected = 4,

      /**
       * Redundant attempt to release a Port. 
       */
      CCAExceptionType_PortNotInUse = 5,

      /**
       * Attempt to unregister a Port that is still being used. 
       */
      CCAExceptionType_UsesPortNotReleased = 6,

      /**
       * Port name given to createPortInfo is bogus. 
       */
      CCAExceptionType_BadPortName = 7,

      /**
       * Port class/type given to createPortInfo is bogus. 
       */
      CCAExceptionType_BadPortType = 8,

      /**
       * Port properties given to createPortInfo is bogus.
       * Note: null is NOT a bogus input, but a fairly common one. 
       */
      CCAExceptionType_BadProperties = 9,

      /**
       * PortInfo given in port add/register call is bogus or null. 
       */
      CCAExceptionType_BadPortInfo = 10,

      /**
       * Services implementation failed to allocate memory. 
       */
      CCAExceptionType_OutOfMemory = 11,

      /**
       * Port (or function within it) died on a remote error. 
       */
      CCAExceptionType_NetworkError = 12

    };

  } // end namespace cca
} // end namespace gov


struct gov_cca_CCAExceptionType__array;
namespace sidl {
  // traits specialization
  template<>
  struct array_traits< ::gov::cca::CCAExceptionType > {
    typedef array< ::gov::cca::CCAExceptionType > cxx_array_t;
    typedef ::gov::cca::CCAExceptionType cxx_item_t;
    typedef struct gov_cca_CCAExceptionType__array ior_array_t;
    typedef  sidl_int__array ior_array_internal_t;
    typedef enum gov_cca_CCAExceptionType__enum ior_item_t;
    typedef  cxx_item_t value_type;
    typedef  value_type& reference;
    typedef  value_type* pointer;
    typedef  const value_type& const_reference;
    typedef  const value_type* const_pointer;
    typedef  array_iter< array_traits< ::gov::cca::CCAExceptionType > > 
      iterator;
    typedef  const_array_iter< array_traits< ::gov::cca::CCAExceptionType > > 
      const_iterator;
  };

  // array specialization
  template<>
  class array< ::gov::cca::CCAExceptionType >: public enum_array< array_traits< 
    ::gov::cca::CCAExceptionType > > {
  public:
    typedef enum_array< array_traits< ::gov::cca::CCAExceptionType > > Base;
    typedef array_traits< ::gov::cca::CCAExceptionType >::cxx_array_t          
      cxx_array_t;
    typedef array_traits< ::gov::cca::CCAExceptionType >::cxx_item_t           
      cxx_item_t;
    typedef array_traits< ::gov::cca::CCAExceptionType >::ior_array_t          
      ior_array_t;
    typedef array_traits< ::gov::cca::CCAExceptionType >::ior_array_internal_t 
      ior_array_internal_t;
    typedef array_traits< ::gov::cca::CCAExceptionType >::ior_item_t           
      ior_item_t;

    /**
     * conversion from ior to C++ class
     * (constructor/casting operator)
     */
    array( struct gov_cca_CCAExceptionType__array* src = 0) : Base(src) {}

    /**
     * copy constructor
     */
    array( const array< ::gov::cca::CCAExceptionType > &src) {
      d_array = src.d_array;
      if (d_array) addRef();
    }

    /**
     * assignment
     */
    array< ::gov::cca::CCAExceptionType >&
    operator =( const array< ::gov::cca::CCAExceptionType > &rhs) {
      if (d_array != rhs.d_array) {
        if (d_array) deleteRef();
        d_array = rhs.d_array;
        if (d_array) addRef();
      }
      return *this;
    }

  };
}


#endif
