// 
// File:          gov_cca_AbstractFramework.cc
// Symbol:        gov.cca.AbstractFramework-v0.6.3
// Symbol Type:   interface
// Babel Version: 0.10.2
// Description:   Client-side glue code for gov.cca.AbstractFramework
// 
// WARNING: Automatically generated; changes will be lost
// 
// babel-version = 0.10.2
// 

#ifndef included_gov_cca_AbstractFramework_hh
#include "gov_cca_AbstractFramework.hh"
#endif
#ifndef included_sidl_BaseInterface_hh
#include "sidl_BaseInterface.hh"
#endif
#ifndef included_sidl_BaseClass_hh
#include "sidl_BaseClass.hh"
#endif
#ifndef included_sidl_BaseException_hh
#include "sidl_BaseException.hh"
#endif
#include "sidl_String.h"
#include "babel_config.h"
#ifdef SIDL_DYNAMIC_LIBRARY
#include <stdio.h>
#include <stdlib.h>
#include "sidl_Loader.hh"
#endif


//////////////////////////////////////////////////
// 
// User Defined Methods
// 


/**
 * Return true if and only if <code>obj</code> refers to the same
 * object as this object.
 */
bool
gov::cca::AbstractFramework::isSame( /* in */ ::sidl::BaseInterface iobj )
throw ()

{
  bool _result;
  sidl_bool _local_result;
  /*pack args to dispatch to ior*/
  _local_result = (*(d_self->d_epv->f_isSame))(d_self->d_object,
    /* in */ iobj._get_ior() );
  /*dispatch to ior*/
  _result = _local_result;
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Check whether the object can support the specified interface or
 * class.  If the <code>sidl</code> type name in <code>name</code>
 * is supported, then a reference to that object is returned with the
 * reference count incremented.  The callee will be responsible for
 * calling <code>deleteRef</code> on the returned object.  If
 * the specified type is not supported, then a null reference is
 * returned.
 */
::sidl::BaseInterface
gov::cca::AbstractFramework::queryInt( /* in */ const ::std::string& name )
throw ()

{
  ::sidl::BaseInterface _result;
  /*pack args to dispatch to ior*/
  _result = ::sidl::BaseInterface( 
    (*(d_self->d_epv->f_queryInt))(d_self->d_object, /* in */ name.c_str() ),
    false);
  /*dispatch to ior*/
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Return whether this object is an instance of the specified type.
 * The string name must be the <code>sidl</code> type name.  This
 * routine will return <code>true</code> if and only if a cast to
 * the string type name would succeed.
 */
bool
gov::cca::AbstractFramework::isType( /* in */ const ::std::string& name )
throw ()

{
  bool _result;
  sidl_bool _local_result;
  /*pack args to dispatch to ior*/
  _local_result = (*(d_self->d_epv->f_isType))(d_self->d_object,
    /* in */ name.c_str() );
  /*dispatch to ior*/
  _result = _local_result;
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Return the meta-data about the class implementing this interface.
 */
::sidl::ClassInfo
gov::cca::AbstractFramework::getClassInfo(  )
throw ()

{
  ::sidl::ClassInfo _result;
  /*pack args to dispatch to ior*/
  _result = ::sidl::ClassInfo( 
    (*(d_self->d_epv->f_getClassInfo))(d_self->d_object ), false);
  /*dispatch to ior*/
  /*unpack results and cleanup*/
  return _result;
}



/**
 *  Create an empty TypeMap. Presumably this would be used in 
 *  an ensuing call to <code>getServices()</code>. The "normal" method of
 *  creating typemaps is found in the <code>Services</code> interface. It
 *  is duplicated here to break the "chicken and egg" problem.
 */
::gov::cca::TypeMap
gov::cca::AbstractFramework::createTypeMap(  )
throw ( ::gov::cca::CCAException)

{
  ::gov::cca::TypeMap _result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _result = ::gov::cca::TypeMap( 
    (*(d_self->d_epv->f_createTypeMap))(d_self->d_object, &_exception ), false);
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Retrieve a Services handle to the underlying framework. 
 * This interface effectively causes the calling program to 
 * appear as the image of a component inside the framework.
 * This method may be called any number of times
 * with different arguments, creating a new component image 
 * each time. 
 * The only proper method to destroy a Services obtained 
 * from this interface is to pass it to releaseServices.
 * 
 * @param selfInstanceName the Component instance name,
 * as it will appear in the framework.
 * 
 * @param selfClassName the Component type of the 
 * calling program, as it will appear in the framework. 
 * 
 * @param selfProperties (which can be null) the properties 
 * of the component image to appear. 
 * 
 * @throws CCAException in the event that selfInstanceName 
 * is already in use by another component.
 * 
 * @return  A Services object that pertains to the
 * 	    image of the this component. This is identical
 * 	    to the object passed into Component.setServices() 
 * 	    when a component is created.
 */
::gov::cca::Services
gov::cca::AbstractFramework::getServices( /* in */ const ::std::string& 
  selfInstanceName, /* in */ const ::std::string& selfClassName,
  /* in */ ::gov::cca::TypeMap selfProperties )
throw ( ::gov::cca::CCAException)

{
  ::gov::cca::Services _result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _result = ::gov::cca::Services( 
    (*(d_self->d_epv->f_getServices))(d_self->d_object,
    /* in */ selfInstanceName.c_str(), /* in */ selfClassName.c_str(),
    /* in */ selfProperties._get_ior(), &_exception ), false);
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Inform framework that the <code>Services</code> handle is no longer needed by the 
 * caller and that the reference to its component image is to be
 * deleted from the context of the underlying framework. This invalidates
 * any <code>ComponentID</code>'s or <code>ConnectionID</code>'s associated 
 * with the given <code>Services</code>' component image. 
 * 
 * @param svc The result of getServices earlier obtained.
 * 
 * @throws CCAException if the <code>Services</code>
 *         handle has already been released or is otherwise rendered invalid 
 *         or was not obtained from <code>getServices()</code>.
 */
void
gov::cca::AbstractFramework::releaseServices( /* in */ ::gov::cca::Services svc 
  )
throw ( ::gov::cca::CCAException)

{

  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  (*(d_self->d_epv->f_releaseServices))(d_self->d_object,
    /* in */ svc._get_ior(), &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
}



/**
 * Tell the framework it is no longer needed and to clean up after itself. 
 *  @throws CCAException if the framework has already been shutdown.
 */
void
gov::cca::AbstractFramework::shutdownFramework(  )
throw ( ::gov::cca::CCAException)

{

  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  (*(d_self->d_epv->f_shutdownFramework))(d_self->d_object, &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
}



/**
 * Creates a new framework instance based on the same underlying 
 * framework implementation. This does not copy the existing 
 * framework, nor are any of the user-instantiated components in
 * the original framework available in the newly created 
 * <code>AbstractFramework</code>. 
 * 
 * @throws CCAException when one of the following conditions occur:
 * 
 * (1)the AbstractFramework previously had shutdownFramework() called on it, or 
 * (2)the underlying framework implementation does not permit creation 
 * of another instance.	 
 */
::gov::cca::AbstractFramework
gov::cca::AbstractFramework::createEmptyFramework(  )
throw ( ::gov::cca::CCAException)

{
  ::gov::cca::AbstractFramework _result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _result = ::gov::cca::AbstractFramework( 
    (*(d_self->d_epv->f_createEmptyFramework))(d_self->d_object, &_exception ),
    false);
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
  return _result;
}



//////////////////////////////////////////////////
// 
// End User Defined Methods
// (everything else in this file is specific to
//  Babel's C++ bindings)
// 

// default destructor
gov::cca::AbstractFramework::~AbstractFramework () {
  if ( d_self != 0 ) {
    deleteRef();
  }
}

// copy constructor
gov::cca::AbstractFramework::AbstractFramework ( const 
  ::gov::cca::AbstractFramework& original ) {
  d_self = const_cast< ior_t*>(original.d_self);
  d_weak_reference = original.d_weak_reference;
  if (d_self != 0 ) {
    addRef();
  }
}

// assignment operator
::gov::cca::AbstractFramework&
gov::cca::AbstractFramework::operator=( const ::gov::cca::AbstractFramework& 
  rhs ) {
  if ( d_self != rhs.d_self ) {
    if ( d_self != 0 ) {
      deleteRef();
    }
    d_self = const_cast< ior_t*>(rhs.d_self);
    d_weak_reference = rhs.d_weak_reference;
    if ( d_self != 0 ) {
      addRef();
    }
  }
  return *this;
}

// conversion from ior to C++ class
gov::cca::AbstractFramework::AbstractFramework ( 
  ::gov::cca::AbstractFramework::ior_t* ior ) 
    : d_self( ior ), d_weak_reference(false) {
  if ( d_self != 0 ) {
    addRef();
  }
}

// Alternate constructor: does not call addRef()
// (sets d_weak_reference=isWeak)
// For internal use by Impls (fixes bug#275)
gov::cca::AbstractFramework::AbstractFramework ( 
  ::gov::cca::AbstractFramework::ior_t* ior, bool isWeak ) 
    : d_self( ior ), d_weak_reference(isWeak) { 
}

// conversion from a StubBase
gov::cca::AbstractFramework::AbstractFramework ( const ::sidl::StubBase& base )
{
  d_self = reinterpret_cast< ior_t*>(base._cast("gov.cca.AbstractFramework"));
  d_weak_reference = false;
  if (d_self != 0) {
    addRef();
  }
}

// protected method that implements casting
void* gov::cca::AbstractFramework::_cast(const char* type) const
{
  void* ptr = 0;
  if ( d_self != 0 ) {
    ptr = reinterpret_cast< void*>((*d_self->d_epv->f__cast)(d_self->d_object,
      type));
  }
  return ptr;
}

extern "C" {


} // end extern "C"
