/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.parsers.xml;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.parsers.xml.DTDManager;
import gov.llnl.babel.parsers.xml.StringXML;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Assertion;
import gov.llnl.babel.symbols.AssertionException;
import gov.llnl.babel.symbols.AssertionExpression;
import gov.llnl.babel.symbols.BinaryExpression;
import gov.llnl.babel.symbols.BooleanLiteral;
import gov.llnl.babel.symbols.CharacterLiteral;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.DComplexLiteral;
import gov.llnl.babel.symbols.DoubleLiteral;
import gov.llnl.babel.symbols.Enumeration;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.FComplexLiteral;
import gov.llnl.babel.symbols.FloatLiteral;
import gov.llnl.babel.symbols.IdentifierLiteral;
import gov.llnl.babel.symbols.IntegerLiteral;
import gov.llnl.babel.symbols.Interface;
import gov.llnl.babel.symbols.LongLiteral;
import gov.llnl.babel.symbols.Metadata;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.MethodCall;
import gov.llnl.babel.symbols.Package;
import gov.llnl.babel.symbols.StringLiteral;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;
import gov.llnl.babel.symbols.UnaryExpression;
import gov.llnl.babel.xml.XMLUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SymbolToDOM {
    private static final String EOL = "\n";
    private static final String INDENT = "   ";
    private Document d_document;
    private int d_indent;

    public static Document convert(Symbol symbol) {
        SymbolToDOM sym2dom = new SymbolToDOM(symbol);
        return sym2dom.getDocument();
    }

    public static String convertToString(Symbol symbol) {
        return XMLUtilities.getXMLString(SymbolToDOM.convert(symbol));
    }

    public static String getDTDPath(String dtd) {
        BabelConfiguration b_config = BabelConfiguration.getInstance();
        String repoPath = b_config.getRepositoryPath();
        StringTokenizer tokenizer = new StringTokenizer(repoPath, ";");
        while (tokenizer.hasMoreTokens()) {
            File sidlfile;
            String path = tokenizer.nextToken();
            if (path == null || path.equals("") || path.equals("null") || !(sidlfile = new File(path + dtd)).exists()) continue;
            return path;
        }
        return "";
    }

    public SymbolToDOM(Symbol symbol) {
        DOMImplementation dom = XMLUtilities.createDOMImplementation();
        DocumentType doctype = dom.createDocumentType("Symbol", "-//CCA//sidl Symbol DTD v1.1//EN", SymbolToDOM.getDTDPath("sidl.dtd") + "sidl.dtd");
        this.d_document = dom.createDocument(null, "Symbol", doctype);
        if (symbol != null) {
            this.d_indent = 0;
            Element docsymbol = this.d_document.getDocumentElement();
            switch (symbol.getSymbolType()) {
                case 12: {
                    this.convertClass((Class)symbol, docsymbol);
                    break;
                }
                case 11: {
                    this.convertEnumeration((Enumeration)symbol, docsymbol);
                    break;
                }
                case 13: {
                    this.convertInterface((Interface)symbol, docsymbol);
                    break;
                }
                case 14: {
                    this.convertPackage((Package)symbol, docsymbol);
                }
            }
            docsymbol.appendChild(this.d_document.createTextNode(EOL));
        }
    }

    public Document getDocument() {
        return this.d_document;
    }

    private void convertClass(Class cls, Node parent) {
        this.convertSymbolID(cls.getSymbolID(), parent);
        this.convertMetadata(cls.getMetadata(), parent);
        this.convertComment(cls.getComment(), parent);
        Element class_element = this.createElement("Class");
        class_element.setAttribute("abstract", String.valueOf(cls.isAbstract()));
        Element extends_element = this.createElement("Extends");
        if (cls.getParentClass() != null) {
            this.convertSymbolID(cls.getParentClass().getSymbolID(), extends_element);
        }
        this.appendChild(extends_element, class_element);
        this.convertParentInterfaces(cls, class_element, false, false);
        Element all_classes_element = this.createElement("AllParentClasses");
        for (Class parent_class = cls.getParentClass(); parent_class != null; parent_class = parent_class.getParentClass()) {
            this.convertSymbolID(parent_class.getSymbolID(), all_classes_element);
        }
        this.appendChild(all_classes_element, class_element);
        this.convertParentInterfaces(cls, class_element, true, false);
        this.convertMethods(cls, class_element);
        this.convertInvariants(cls, class_element);
        this.appendChild(class_element, parent);
    }

    private void convertEnumeration(Enumeration e, Node parent) {
        this.convertSymbolID(e.getSymbolID(), parent);
        this.convertMetadata(e.getMetadata(), parent);
        this.convertComment(e.getComment(), parent);
        Element enumeration_element = this.createElement("Enumeration");
        Iterator i = e.getIterator();
        while (i.hasNext()) {
            String n = (String)i.next();
            Element enumerator_element = this.createElement("Enumerator");
            enumerator_element.setAttribute("name", n);
            enumerator_element.setAttribute("value", String.valueOf(e.getEnumeratorValue(n)));
            enumerator_element.setAttribute("fromuser", String.valueOf(e.definedByUser(n)));
            Comment ecmt = e.getEnumeratorComment(n);
            if (ecmt != null && !ecmt.isEmpty()) {
                this.convertComment(ecmt, enumerator_element);
            }
            this.appendChild(enumerator_element, enumeration_element);
        }
        this.appendChild(enumeration_element, parent);
    }

    private void convertInterface(Interface ifc, Node parent) {
        this.convertSymbolID(ifc.getSymbolID(), parent);
        this.convertMetadata(ifc.getMetadata(), parent);
        this.convertComment(ifc.getComment(), parent);
        Element interface_element = this.createElement("Interface");
        this.convertParentInterfaces(ifc, interface_element, false, true);
        this.convertParentInterfaces(ifc, interface_element, true, true);
        this.convertMethods(ifc, interface_element);
        this.convertInvariants(ifc, interface_element);
        this.appendChild(interface_element, parent);
    }

    private void convertParentInterfaces(Extendable ext, Node parent, boolean doAll, boolean isInterface) {
        Element list_elem = doAll ? this.createElement("AllParentInterfaces") : (isInterface ? this.createElement("ExtendsBlock") : this.createElement("ImplementsBlock"));
        Collection parents = ext.getParentInterfaces(doAll);
        Iterator p = parents.iterator();
        while (p.hasNext()) {
            Interface i = (Interface)p.next();
            this.convertSymbolID(i.getSymbolID(), list_elem);
        }
        this.appendChild(list_elem, parent);
    }

    private void convertMethods(Extendable ext, Node parent) {
        Element methodblock_element = this.createElement("MethodsBlock");
        Iterator m = ext.getMethods(false).iterator();
        while (m.hasNext()) {
            this.convertMethod((Method)m.next(), methodblock_element);
        }
        this.appendChild(methodblock_element, parent);
    }

    private void convertInvariants(Extendable ext, Node parent) {
        this.convertAssertions(ext.getInvariants(), parent);
    }

    private void convertPackage(Package p, Node parent) {
        this.convertSymbolID(p.getSymbolID(), parent);
        this.convertMetadata(p.getMetadata(), parent);
        this.convertComment(p.getComment(), parent);
        Element package_element = this.createElement("Package");
        package_element.setAttribute("final", p.getFinal() ? "true" : "false");
        Collection children = p.getOrderedSymbolReferences();
        Map map = p.getSymbols();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            SymbolID entry = (SymbolID)i.next();
            Integer intValue = (Integer)map.get(entry);
            Element packagesymbol_element = this.createElement("PackageSymbol");
            packagesymbol_element.setAttribute("name", entry.getShortName());
            packagesymbol_element.setAttribute("type", StringXML.toSymbolXML(intValue));
            packagesymbol_element.setAttribute("version", entry.getVersion().getVersionString());
            this.appendChild(packagesymbol_element, package_element);
        }
        this.appendChild(package_element, parent);
    }

    private void convertComment(Comment c, Node parent) {
        Element comment_element = null;
        BabelConfiguration b_config = BabelConfiguration.getInstance();
        if (c.isEmpty()) {
            comment_element = this.createElement("Comment");
        } else {
            String[] lines = c.getComment();
            StringBuffer buffer = new StringBuffer();
            buffer.append("<Comment>");
            for (int i = 0; i < lines.length; ++i) {
                buffer.append(EOL);
                buffer.append(lines[i]);
            }
            buffer.append("</Comment>");
            Document document = XMLUtilities.validateXML("-//CCA//sidl Comment DTD v1.0//EN", SymbolToDOM.getDTDPath("comment.dtd") + "comment.dtd", DTDManager.getInstance(), "Comment", buffer.toString());
            if (document != null) {
                Element root = document.getDocumentElement();
                comment_element = (Element)XMLUtilities.cloneDOM(root, this.d_document);
                ++this.d_indent;
            }
            if (comment_element == null) {
                comment_element = this.createElement("Comment");
                Text text = this.d_document.createTextNode("");
                for (int i = 0; i < lines.length; ++i) {
                    text.appendData(EOL);
                    text.appendData(lines[i]);
                }
                comment_element.appendChild(text);
            }
        }
        this.appendChild(comment_element, parent);
    }

    private void convertMetadata(Metadata m, Node parent) {
        Element metadata_element = this.createElement("Metadata");
        if (BabelConfiguration.getInstance().suppressTimestamps()) {
            metadata_element.setAttribute("date", "20010101 00:00:00 GMT");
        } else {
            metadata_element.setAttribute("date", m.getDateAsString());
        }
        Set entries = m.getMetadataDatabase().entrySet();
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Element data_element = this.createElement("MetadataEntry");
            data_element.setAttribute("key", (String)entry.getKey());
            data_element.setAttribute("value", (String)entry.getValue());
            this.appendChild(data_element, metadata_element);
        }
        this.appendChild(metadata_element, parent);
    }

    private void convertMethod(Method m, Node parent) {
        Element method_element = this.createElement("Method");
        method_element.setAttribute("shortname", m.getShortMethodName());
        method_element.setAttribute("extension", m.getNameExtension());
        method_element.setAttribute("copy", String.valueOf(m.isReturnCopy()));
        method_element.setAttribute("definition", StringXML.toDefXML(m.getDefinitionModifier()));
        method_element.setAttribute("communication", StringXML.toComXML(m.getCommunicationModifier()));
        this.convertComment(m.getComment(), method_element);
        this.convertType(m.getReturnType(), method_element);
        Element arglist_element = this.createElement("ArgumentList");
        ArrayList args = m.getArgumentListWithIndices();
        for (int a = 0; a < args.size(); ++a) {
            this.convertArgument((Argument)args.get(a), arglist_element);
        }
        this.appendChild(arglist_element, method_element);
        Element throwslist_element = this.createElement("ThrowsList");
        Iterator t = m.getThrows().iterator();
        while (t.hasNext()) {
            this.convertSymbolID((SymbolID)t.next(), throwslist_element);
        }
        this.appendChild(throwslist_element, method_element);
        this.convertAssertions(m, (Node)method_element);
        this.appendChild(method_element, parent);
    }

    private void convertArgument(Argument arg, Node parent) {
        Element arg_element = this.createElement("Argument");
        arg_element.setAttribute("copy", String.valueOf(arg.isCopy()));
        arg_element.setAttribute("mode", StringXML.toModeXML(arg.getMode()));
        arg_element.setAttribute("name", arg.getFormalName());
        this.convertType(arg.getType(), arg_element);
        this.appendChild(arg_element, parent);
    }

    private void convertType(Type type, Node parent) {
        Element type_element = this.createElement("Type");
        int typeid = type.getType();
        type_element.setAttribute("type", StringXML.toTypeXML(typeid));
        if (typeid == 15) {
            this.convertSymbolID(type.getSymbolID(), type_element);
        } else if (typeid == 16) {
            Element array_element = this.createElement("Array");
            array_element.setAttribute("order", StringXML.toOrderXML(type.getArrayOrder()));
            if (null != type.getArrayType()) {
                array_element.setAttribute("dim", String.valueOf(type.getArrayDimension()));
                this.convertType(type.getArrayType(), array_element);
                if (type.isRarray()) {
                    Element index_element = this.createElement("Index");
                    index_element.setAttribute("name", type.getIndexString());
                    this.appendChild(index_element, array_element);
                }
            }
            this.appendChild(array_element, type_element);
        }
        this.appendChild(type_element, parent);
    }

    private void convertSymbolID(SymbolID id, Node parent) {
        Element symbol_element = this.createElement("SymbolName");
        symbol_element.setAttribute("name", id.getFullName());
        symbol_element.setAttribute("version", id.getVersion().getVersionString());
        this.appendChild(symbol_element, parent);
    }

    private void convertAssertions(Method meth, Node parent) {
        ArrayList list = meth.getPreconditions();
        list.addAll(meth.getPostconditions());
        this.convertAssertions(list, parent);
    }

    private void convertAssertions(ArrayList list, Node parent) {
        if (!list.isEmpty()) {
            Element list_elem = this.createElement("AssertionList");
            Iterator i = list.iterator();
            while (i.hasNext()) {
                this.convertAssertion((Assertion)i.next(), list_elem);
            }
            this.appendChild(list_elem, parent);
        }
    }

    private void convertAssertion(Assertion as, Node parent) {
        if (as != null) {
            Element e = this.createElement("Assertion");
            e.setAttribute("tag", as.getTag());
            e.setAttribute("type", StringXML.toAssertionXML(as.getType()));
            this.convertComment(as.getComment(), e);
            try {
                this.convertAssertionExpression(as.getExpression(), e);
            }
            catch (AssertionException ex) {
                System.err.println("FATAL: " + ex.getMessage());
                System.exit(1);
            }
            this.appendChild(e, parent);
        }
    }

    private void convertAssertionExpression(AssertionExpression ae, Node parent) throws AssertionException {
        if (ae != null) {
            if (ae.isValid()) {
                boolean ok = true;
                Element e = this.createElement("AssertionExpression");
                e.setAttribute("parens", String.valueOf(ae.hasParens()));
                String classname = ae.getClass().getName();
                String pathprefix = "gov.llnl.babel.symbols.";
                if (classname.equals(pathprefix + "BinaryExpression")) {
                    this.convertBinaryExpression((BinaryExpression)ae, e);
                } else if (classname.equals(pathprefix + "BooleanLiteral")) {
                    this.convertBooleanLiteral((BooleanLiteral)ae, e);
                } else if (classname.equals(pathprefix + "CharacterLiteral")) {
                    this.convertCharacterLiteral((CharacterLiteral)ae, e);
                } else if (classname.equals(pathprefix + "DComplexLiteral")) {
                    this.convertDComplexLiteral((DComplexLiteral)ae, e);
                } else if (classname.equals(pathprefix + "DoubleLiteral")) {
                    this.convertDoubleLiteral((DoubleLiteral)ae, e);
                } else if (classname.equals(pathprefix + "FComplexLiteral")) {
                    this.convertFComplexLiteral((FComplexLiteral)ae, e);
                } else if (classname.equals(pathprefix + "FloatLiteral")) {
                    this.convertFloatLiteral((FloatLiteral)ae, e);
                } else if (classname.equals(pathprefix + "IdentifierLiteral")) {
                    this.convertIdentifierLiteral((IdentifierLiteral)ae, e);
                } else if (classname.equals(pathprefix + "IntegerLiteral")) {
                    this.convertIntegerLiteral((IntegerLiteral)ae, e);
                } else if (classname.equals(pathprefix + "LongLiteral")) {
                    this.convertLongLiteral((LongLiteral)ae, e);
                } else if (classname.equals(pathprefix + "MethodCall")) {
                    this.convertMethodCall((MethodCall)ae, e);
                } else if (classname.equals(pathprefix + "StringLiteral")) {
                    this.convertStringLiteral((StringLiteral)ae, e);
                } else if (classname.equals(pathprefix + "UnaryExpression")) {
                    this.convertUnaryExpression((UnaryExpression)ae, e);
                } else {
                    ok = false;
                }
                if (ok) {
                    this.appendChild(e, parent);
                }
            } else {
                throw new AssertionException("convertAssertionExpression: Cannot perform conversion on the unvalidated assertion expression \"" + ae.toString() + "\".");
            }
        }
    }

    private void convertBinaryExpression(BinaryExpression expr, Node parent) {
        AssertionExpression lhs = expr.getLeftExpression();
        AssertionExpression rhs = expr.getRightExpression();
        if (lhs != null && rhs != null) {
            Element e = this.createElement("BinaryExpression");
            e.setAttribute("op", StringXML.toBinaryOpXML(expr.getOp()));
            try {
                this.convertAssertionExpression(lhs, e);
                this.convertAssertionExpression(rhs, e);
            }
            catch (AssertionException ex) {
                System.err.println(ex.getMessage());
                System.exit(1);
            }
            this.appendChild(e, parent);
        }
    }

    private void convertBooleanLiteral(BooleanLiteral expr, Node parent) {
        Element e = this.createElement("SimpleExpression");
        e.setAttribute("etype", "constant");
        e.setAttribute("value", expr.getValue() ? "true" : "false");
        this.convertType(expr.getReturnType(), e);
        this.appendChild(e, parent);
    }

    private void convertCharacterLiteral(CharacterLiteral expr, Node parent) {
        Element e = this.createElement("SimpleExpression");
        e.setAttribute("etype", "constant");
        e.setAttribute("value", String.valueOf(expr.getValue()));
        this.convertType(expr.getReturnType(), e);
        this.appendChild(e, parent);
    }

    private void convertDComplexLiteral(DComplexLiteral expr, Node parent) {
        Element e = this.createElement("ComplexNumber");
        e.setAttribute("type", "float");
        e.setAttribute("real", expr.getRealImage());
        e.setAttribute("imaginary", expr.getImaginaryImage());
        this.appendChild(e, parent);
    }

    private void convertDoubleLiteral(DoubleLiteral expr, Node parent) {
        Element e = this.createElement("SimpleExpression");
        e.setAttribute("etype", "constant");
        e.setAttribute("value", expr.getImage());
        this.convertType(expr.getReturnType(), e);
        this.appendChild(e, parent);
    }

    private void convertFComplexLiteral(FComplexLiteral expr, Node parent) {
        Element e = this.createElement("ComplexNumber");
        e.setAttribute("type", "float");
        e.setAttribute("real", expr.getRealImage());
        e.setAttribute("imaginary", expr.getImaginaryImage());
        this.appendChild(e, parent);
    }

    private void convertFloatLiteral(FloatLiteral expr, Node parent) {
        Element e = this.createElement("SimpleExpression");
        e.setAttribute("etype", "constant");
        e.setAttribute("value", expr.getImage());
        this.convertType(expr.getReturnType(), e);
        this.appendChild(e, parent);
    }

    private void convertIdentifierLiteral(IdentifierLiteral expr, Node parent) {
        Element e = this.createElement("SimpleExpression");
        e.setAttribute("etype", "identifier");
        e.setAttribute("value", expr.getIdentifier());
        this.convertType(expr.getReturnType(), e);
        this.appendChild(e, parent);
    }

    private void convertIntegerLiteral(IntegerLiteral expr, Node parent) {
        Element e = this.createElement("SimpleExpression");
        e.setAttribute("etype", "constant");
        e.setAttribute("value", expr.getImage());
        this.convertType(expr.getReturnType(), e);
        this.appendChild(e, parent);
    }

    private void convertLongLiteral(LongLiteral expr, Node parent) {
        Element e = this.createElement("SimpleExpression");
        e.setAttribute("etype", "constant");
        e.setAttribute("value", expr.getImage());
        this.convertType(expr.getReturnType(), e);
        this.appendChild(e, parent);
    }

    private void convertMethodCall(MethodCall expr, Node parent) {
        Element e = this.createElement("MethodCall");
        e.setAttribute("name", expr.getMethodName());
        try {
            Iterator i = expr.getArguments().iterator();
            while (i.hasNext()) {
                this.convertAssertionExpression((AssertionExpression)i.next(), e);
            }
        }
        catch (AssertionException ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
        this.appendChild(e, parent);
    }

    private void convertStringLiteral(StringLiteral expr, Node parent) {
        Element e = this.createElement("SimpleExpression");
        e.setAttribute("etype", "constant");
        e.setAttribute("value", expr.getValue());
        this.convertType(expr.getReturnType(), e);
        this.appendChild(e, parent);
    }

    private void convertUnaryExpression(UnaryExpression expr, Node parent) {
        AssertionExpression ae = expr.getExpression();
        if (ae != null) {
            Element e = this.createElement("UnaryExpression");
            e.setAttribute("op", StringXML.toUnaryOpXML(expr.getOp()));
            try {
                this.convertAssertionExpression(ae, e);
            }
            catch (AssertionException ex) {
                System.err.println(ex.getMessage());
                System.exit(1);
            }
            this.appendChild(e, parent);
        }
    }

    private String getIndentString() {
        StringBuffer indent = new StringBuffer();
        indent.append(EOL);
        for (int i = 0; i < this.d_indent; ++i) {
            indent.append(INDENT);
        }
        return indent.toString();
    }

    private Element createElement(String name) {
        ++this.d_indent;
        return this.d_document.createElement(name);
    }

    private void appendChild(Element child, Node parent) {
        String indent = this.getIndentString();
        parent.appendChild(this.d_document.createTextNode(indent));
        if (child.hasChildNodes()) {
            child.appendChild(this.d_document.createTextNode(indent));
        }
        parent.appendChild(child);
        --this.d_indent;
    }
}

