/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.c;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.c.ArrayMethods;
import gov.llnl.babel.backend.c.C;
import gov.llnl.babel.backend.c.StubHeader;
import gov.llnl.babel.backend.rmi.RMI;
import gov.llnl.babel.backend.rmi.RMIStubSource;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class StubSource {
    private LanguageWriterForC d_writer;
    private static final String s_self = "self";
    private static final String s_epv = StubHeader.s_epv;
    private static final String s_externals = "_externals";
    private static final String s_externals_func = "_getExternals";

    public static void generateCode(Symbol symbol, LanguageWriterForC writer) throws CodeGenerationException {
        StubSource source = new StubSource(writer);
        source.generateCode(symbol);
    }

    public static void generateSupers(Collection methods, Class cls, LanguageWriterForC writer) throws CodeGenerationException {
        StubSource source = new StubSource(writer);
        source.generateSupers(methods, cls);
    }

    public static void generateGetExternals(Class cls, LanguageWriterForC writer) throws CodeGenerationException {
        StubSource source = new StubSource(writer);
        source.generateGetExternals(cls.getSymbolID());
    }

    public StubSource(LanguageWriterForC writer) {
        this.d_writer = writer;
    }

    public void generateCode(Symbol symbol) throws CodeGenerationException {
        block6: {
            block5: {
                if (symbol == null) break block5;
                switch (symbol.getSymbolType()) {
                    case 12: 
                    case 13: {
                        this.generateExtendable((Extendable)symbol);
                        break block6;
                    }
                    case 11: {
                        this.generateEnum(symbol);
                        break block6;
                    }
                    case 14: {
                        break block6;
                    }
                    default: {
                        throw new CodeGenerationException("Unsupported symbol type.");
                    }
                }
            }
            throw new CodeGenerationException("Unexpected null Symbol.");
        }
    }

    public void generateSupers(Collection methods, Class cls) throws CodeGenerationException {
        SymbolID clsID = cls.getSymbolID();
        String self = s_self;
        if (methods != null) {
            if (methods.size() > 0) {
                this.d_writer.println("static const struct " + C.getObjectName(cls.getParentClass().getSymbolID()) + "__epv* superEPV = " + "NULL" + ";");
                this.d_writer.println();
                this.d_writer.println("void " + C.getObjectName(clsID) + "__superEPV(");
                this.d_writer.println("struct " + C.getObjectName(cls.getParentClass().getSymbolID()) + "__epv* parentEPV){");
                this.d_writer.tab();
                this.d_writer.println("superEPV = parentEPV;");
                this.d_writer.backTab();
                this.d_writer.println("}");
                Iterator m = methods.iterator();
                while (m.hasNext()) {
                    Method method = (Method)m.next();
                    this.generateMethodSignature(self, false, clsID, method, true);
                    this.d_writer.println("{");
                    this.d_writer.tab();
                    if (method.hasRarray()) {
                        this.generateRarrays(method);
                    }
                    if (StubSource.getReturnString(method.getReturnType()) != "void") {
                        this.d_writer.print("return ");
                    }
                    this.d_writer.print("(*superEPV");
                    this.d_writer.print("->");
                    this.d_writer.print(IOR.getVectorEntry(method.getLongMethodName()));
                    this.d_writer.println(")((" + IOR.getObjectName(cls.getParentClass().getSymbolID()) + "*)");
                    this.d_writer.tab();
                    C.generateArgumentList(this.d_writer, self, false, clsID, method, false, false, false, true, false, false, true);
                    this.d_writer.println(");");
                    this.d_writer.backTab();
                    this.d_writer.backTab();
                    this.d_writer.println("}");
                    this.d_writer.println();
                }
            }
        } else {
            throw new CodeGenerationException("Unexpected null Symbol.");
        }
    }

    private static String getReturnString(Type type) throws CodeGenerationException {
        return IOR.getReturnString(type, false, false);
    }

    private void generateExtendable(Extendable ext) throws CodeGenerationException {
        SymbolID id = ext.getSymbolID();
        String source = C.getStubFile(id);
        String header = C.getHeaderFile(id);
        String iorHeader = IOR.getHeaderFile(id);
        this.d_writer.writeBanner(ext, source, false, "Client-side glue code for " + id.getFullName());
        this.d_writer.generateInclude(header, false);
        this.d_writer.generateInclude(iorHeader, false);
        this.d_writer.generateInclude("sidl_interface_IOR.h", true);
        this.d_writer.printlnUnformatted("#include <stddef.h>");
        if (!iorHeader.equals("sidl_BaseInterface_IOR.h")) {
            this.d_writer.generateInclude("sidl_BaseInterface_IOR.h", false);
        }
        if (!BabelConfiguration.isSIDLBaseClass(id)) {
            this.d_writer.printlnUnformatted("#include \"babel_config.h\"");
            this.d_writer.printlnUnformatted("#ifdef SIDL_DYNAMIC_LIBRARY");
            this.d_writer.printlnUnformatted("#include <stdio.h>");
            this.d_writer.printlnUnformatted("#include <stdlib.h>");
            this.d_writer.printlnUnformatted("#include <string.h>");
            this.d_writer.printlnUnformatted("#include \"sidl_Loader.h\"");
            this.d_writer.printlnUnformatted("#endif");
        }
        this.d_writer.println();
        if (!ext.isInterface()) {
            this.generateGetExternals(id);
        }
        if (ext.hasStaticMethod(true)) {
            this.generateGetStaticEPV(id);
        }
        this.generateMethodStubs(ext);
        ArrayMethods ar = new ArrayMethods(id, false);
        ar.generateStub(this.d_writer);
        RMIStubSource.generateCode(ext, this.d_writer);
    }

    private void generateEnum(Symbol enm) throws CodeGenerationException {
        SymbolID id = enm.getSymbolID();
        String source = C.getStubFile(id);
        String header = C.getHeaderFile(id);
        this.d_writer.writeBanner(enm, source, false, "Client-side glue code for " + id.getFullName());
        this.d_writer.generateInclude(header, false);
        this.d_writer.generateInclude("sidl_int_IOR.h", true);
        this.d_writer.printlnUnformatted("#include <stddef.h>");
        this.d_writer.println();
        ArrayMethods ar = new ArrayMethods(id, true);
        ar.generateStub(this.d_writer);
    }

    private void generateBuiltinStub(SymbolID id, int stubType, int iorType, boolean doStatic) throws CodeGenerationException {
        this.d_writer.writeComment(StubHeader.getBuiltinComment(stubType, doStatic), false);
        StubHeader.generateBuiltinSignature(this.d_writer, stubType, id, doStatic, "");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println(StubHeader.getDerefFunctionPtr(IOR.getBuiltinName(iorType, doStatic), doStatic) + "(");
        if (!doStatic) {
            this.d_writer.println("self,");
        }
        this.d_writer.println(StubHeader.getBuiltinArgList(stubType) + ");");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateAssertionStubs(SymbolID id, boolean doStatic) throws CodeGenerationException {
        this.generateBuiltinStub(id, 1, 6, doStatic);
        this.generateBuiltinStub(id, 0, 9, doStatic);
    }

    private void generateMethodStubs(Extendable ext) throws CodeGenerationException {
        Class cls;
        Class cls2;
        SymbolID id = ext.getSymbolID();
        String self = s_self;
        if (!ext.isAbstract()) {
            this.d_writer.writeComment("Constructor function for the class.", false);
            this.d_writer.println(C.getSymbolName(id));
            this.d_writer.println(C.getFullMethodName(id, "_create") + "()");
            this.d_writer.println("{");
            this.d_writer.tab();
            this.d_writer.println("return (*(_getExternals()->createObject))();");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
            this.d_writer.println("static " + C.getSymbolName(id) + " " + C.getFullMethodName(id, "_remote") + "(const char* url, sidl_BaseInterface *_ex);");
            this.d_writer.writeComment("RMI constructor function for the class.", false);
            this.d_writer.println(C.getSymbolName(id));
            this.d_writer.println(C.getFullMethodName(id, "_createRemote") + "(const char* url, sidl_BaseInterface *_ex)");
            this.d_writer.println("{");
            this.d_writer.tab();
            this.d_writer.println("return " + C.getFullMethodName(id, "_remote") + "(url, _ex);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
        }
        if (!ext.isInterface() && !ext.isAbstract()) {
            boolean hasStatic = ext.hasStaticMethod(true);
            if (IOR.supportAssertions(ext)) {
                if (hasStatic) {
                    this.generateAssertionStubs(id, true);
                }
                this.generateAssertionStubs(id, false);
            }
            if (IOR.supportInterceptors(ext)) {
                if (hasStatic) {
                    this.generateBuiltinStub(id, 2, 7, true);
                }
                this.generateBuiltinStub(id, 2, 7, false);
            }
        }
        Collection methods = ext.getMethods(true);
        Iterator m = methods.iterator();
        while (m.hasNext()) {
            Method method = (Method)m.next();
            this.generateMethodSignature(self, ext.isInterface(), id, method, false);
            this.d_writer.println("{");
            this.d_writer.tab();
            if (method.hasRarray()) {
                this.generateRarrays(method);
            }
            if (StubSource.getReturnString(method.getReturnType()) != "void") {
                this.d_writer.print("return ");
            }
            this.d_writer.println(StubHeader.getDerefFunctionPtr(method.getLongMethodName(), method.isStatic()) + "(");
            this.d_writer.tab();
            C.generateArgumentList(this.d_writer, self, ext.isInterface(), id, method, false, false, false, true, false, false, true);
            this.d_writer.println(");");
            this.d_writer.backTab();
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
        }
        if (!ext.isInterface() && (cls2 = (Class)ext).hasStaticMethod(true)) {
            this.generateMethodExecs(cls2);
        }
        Method castMethod = IOR.getBuiltinMethod(0, id);
        this.d_writer.writeComment("Cast method for interface and class type conversions.", false);
        this.d_writer.println(C.getSymbolName(id));
        this.d_writer.println(C.getFullMethodName(id, "_cast") + "(");
        this.d_writer.tab();
        this.d_writer.println("void* obj)");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println(C.getSymbolName(id) + " cast = " + "NULL" + ";");
        this.d_writer.println();
        this.d_writer.println("if (obj != NULL) {");
        this.d_writer.tab();
        this.d_writer.println("sidl_BaseInterface base = (sidl_BaseInterface) obj;");
        this.d_writer.println("cast = (" + C.getSymbolName(id) + ") (*base->" + s_epv + "->" + IOR.getVectorEntry(castMethod.getLongMethodName()) + ")(");
        this.d_writer.tab();
        this.d_writer.println("base->d_object,");
        this.d_writer.println("\"" + id.getFullName() + "\");");
        this.d_writer.backTab();
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.println("return cast;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.writeComment("String cast method for interface and class type conversions.", false);
        this.d_writer.println("void*");
        this.d_writer.println(C.getFullMethodName(id, "_cast2") + "(");
        this.d_writer.tab();
        this.d_writer.println("void* obj,");
        this.d_writer.println("const char* type)");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("void* cast = NULL;");
        this.d_writer.println();
        this.d_writer.println("if (obj != NULL) {");
        this.d_writer.tab();
        this.d_writer.println("sidl_BaseInterface base = (sidl_BaseInterface) obj;");
        this.d_writer.println("cast = (*base->" + s_epv + "->" + IOR.getVectorEntry(castMethod.getLongMethodName()) + ")(base->d_object, type);");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.println("return cast;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        Method m_exec = C.getExecMethod();
        this.generateMethodSignature(self, ext.isInterface(), id, m_exec, false);
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("(*self->" + IOR.getEPVVar(0) + "->" + IOR.getVectorEntry(m_exec.getLongMethodName()) + ")(");
        C.generateArgumentList(this.d_writer, self, ext.isInterface(), id, m_exec, false, false, false, true, false, false, true);
        this.d_writer.println(");");
        this.d_writer.backTab();
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
        if (!ext.isInterface() && (cls = (Class)ext).hasStaticMethod(true)) {
            this.generateMainSExec(cls);
        }
    }

    private void generateMethodSignature(String self, boolean is_interface, SymbolID id, Method method, boolean is_super) throws CodeGenerationException {
        this.d_writer.writeComment(method, false);
        if (is_super) {
            this.d_writer.print("static ");
        }
        this.d_writer.println(StubSource.getReturnString(method.getReturnType()));
        if (is_super) {
            this.d_writer.print("super_" + method.getShortMethodName());
        } else {
            this.d_writer.print(C.getFullMethodName(id, method));
        }
        this.d_writer.println("(");
        this.d_writer.tab();
        C.generateArgumentList(this.d_writer, self, is_interface, id, method, true, true, false, true, false, true, true);
        this.d_writer.println(")");
        this.d_writer.backTab();
    }

    private void generateGetExternals(SymbolID id) {
        String ext_name = IOR.getExternalName(id);
        this.d_writer.writeComment("Hold pointer to IOR functions.", false);
        this.d_writer.println("static const " + ext_name + " *" + s_externals + " = " + "NULL" + ";");
        this.d_writer.writeComment("Lookup the symbol to get the IOR functions.", false);
        this.d_writer.println("static const " + ext_name + "* _loadIOR(void)");
        this.d_writer.writeComment("Return pointer to internal IOR functions.", false);
        this.d_writer.println("{");
        this.d_writer.tab();
        if (BabelConfiguration.isSIDLBaseClass(id)) {
            this.d_writer.println("_externals = " + IOR.getExternalFunc(id) + "();");
        } else {
            this.d_writer.printlnUnformatted("#ifdef SIDL_STATIC_LIBRARY");
            this.d_writer.println("_externals = " + IOR.getExternalFunc(id) + "();");
            this.d_writer.printlnUnformatted("#else");
            this.d_writer.println("sidl_DLL dll = sidl_DLL__create();");
            this.d_writer.println("const " + ext_name + "*(*dll_f)(void);");
            this.d_writer.writeCommentLine("check global namespace for symbol first");
            this.d_writer.println("if (dll && sidl_DLL_loadLibrary(dll, \"main:\", TRUE, FALSE)) {");
            this.d_writer.tab();
            this.d_writer.println("dll_f =");
            this.d_writer.tab();
            this.d_writer.print("(const " + ext_name + "*(*)(void)) ");
            this.d_writer.println("sidl_DLL_lookupSymbol(");
            this.d_writer.tab();
            this.d_writer.println("dll, \"" + IOR.getExternalFunc(id) + "\");");
            this.d_writer.backTab();
            this.d_writer.backTab();
            this.d_writer.println("_externals = (dll_f ? (*dll_f)() : NULL);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println("if (dll) sidl_DLL_deleteRef(dll);");
            this.d_writer.println("if (!_externals) {");
            this.d_writer.tab();
            this.d_writer.println("dll = sidl_Loader_findLibrary(\"" + id.getFullName() + "\",");
            this.d_writer.tab();
            this.d_writer.println("\"ior/impl\", sidl_Scope_SCLSCOPE,");
            this.d_writer.println("sidl_Resolve_SCLRESOLVE);");
            this.d_writer.backTab();
            this.d_writer.println("if (dll) {");
            this.d_writer.tab();
            this.d_writer.println("dll_f =");
            this.d_writer.tab();
            this.d_writer.print("(const " + ext_name + "*(*)(void)) ");
            this.d_writer.println("sidl_DLL_lookupSymbol(");
            this.d_writer.tab();
            this.d_writer.println("dll, \"" + IOR.getExternalFunc(id) + "\");");
            this.d_writer.backTab();
            this.d_writer.backTab();
            this.d_writer.println("_externals = (dll_f ? (*dll_f)() : NULL);");
            this.d_writer.println("sidl_DLL_deleteRef(dll);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println("if (!_externals) {");
            this.d_writer.tab();
            this.d_writer.disableLineBreak();
            this.d_writer.println("fputs(\"Babel: unable to load the implementation for " + id.getFullName() + "; please set sidl_DLL_PATH\\n\", stderr);");
            this.d_writer.enableLineBreak();
            this.d_writer.println("exit(-1);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.printlnUnformatted("#endif");
        }
        this.d_writer.println("return _externals;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.printlnUnformatted("#define _getExternals() (_externals ? _externals : _loadIOR())");
        this.d_writer.println();
    }

    private void generateGetStaticEPV(SymbolID id) {
        String sepv_name = IOR.getSEPVName(id);
        this.d_writer.writeComment("Hold pointer to static entry point vector", false);
        this.d_writer.println("static const " + sepv_name + " *_sepv = " + "NULL" + ";");
        this.d_writer.writeComment("Return pointer to static functions.", false);
        this.d_writer.printlnUnformatted("#define _getSEPV() (_sepv ? _sepv : (_sepv = (*(_getExternals()->getStaticEPV))()))");
        this.d_writer.println();
    }

    private void generateRarrays(Method m) throws CodeGenerationException {
        Type type;
        String r_name;
        Argument rarray;
        ArrayList args = m.getArgumentList();
        ArrayList<Argument> rarrays = new ArrayList<Argument>();
        Iterator a = args.iterator();
        while (a.hasNext()) {
            Argument arg = (Argument)a.next();
            if (!arg.getType().isRarray()) continue;
            rarrays.add(arg);
        }
        Iterator r = rarrays.iterator();
        while (r.hasNext()) {
            rarray = (Argument)r.next();
            r_name = rarray.getFormalName();
            type = rarray.getType();
            int dim = type.getArrayDimension();
            this.d_writer.println("int32_t " + r_name + "_lower[" + dim + "], " + r_name + "_upper[" + dim + "], " + r_name + "_stride[" + dim + "]; ");
            String sidl_array_name = StubSource.getReturnString(type);
            this.d_writer.println(sidl_array_name.substring(0, sidl_array_name.length() - 1) + " " + r_name + "_real;");
            this.d_writer.println(sidl_array_name + r_name + "_tmp" + " = &" + r_name + "_real;");
        }
        r = rarrays.iterator();
        while (r.hasNext()) {
            rarray = (Argument)r.next();
            r_name = rarray.getFormalName();
            type = rarray.getType();
            List indices = type.getArrayIndices();
            String init_func_name = IOR.getArrayNameForFunctions(rarray.getType().getArrayType().getType()) + "_init";
            int x = 0;
            Iterator i = indices.iterator();
            while (i.hasNext()) {
                this.d_writer.println(r_name + "_upper[" + x + "] = " + (String)i.next() + "-1;");
                ++x;
            }
            this.d_writer.println(init_func_name + "(" + r_name + ", " + r_name + "_tmp" + ", " + type.getArrayDimension() + ", " + r_name + "_lower, " + r_name + "_upper, " + r_name + "_stride);");
        }
    }

    private void generateMainSExec(Class cls) {
        SymbolID id = cls.getSymbolID();
        String my_symbolName = IOR.getSymbolName(id);
        this.d_writer.println("struct " + my_symbolName + "__method {");
        this.d_writer.tab();
        this.d_writer.println("const char *d_name;");
        this.d_writer.println("void (*d_func)(struct sidl_io_Deserializer__object *,");
        this.d_writer.tab();
        this.d_writer.println("struct sidl_io_Serializer__object *);");
        this.d_writer.backTab();
        this.d_writer.backTab();
        this.d_writer.println("};");
        this.d_writer.println();
        this.d_writer.println("void");
        this.d_writer.println(my_symbolName + "__sexec(");
        this.d_writer.println("        const char* methodName,");
        this.d_writer.println("        struct sidl_io_Deserializer__object* inArgs,");
        this.d_writer.println("        struct sidl_io_Serializer__object* outArgs ) { ");
        this.d_writer.tab();
        ArrayList methods = new ArrayList(cls.getStaticMethods(true));
        Collections.sort(methods, new IOR.CompareMethods());
        this.d_writer.println("static const struct " + my_symbolName + "__method  s_methods[] = {");
        this.d_writer.tab();
        Iterator i = methods.iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            this.d_writer.println("{ \"" + m.getLongMethodName() + "\", " + my_symbolName + '_' + m.getLongMethodName() + "__sexec }" + (i.hasNext() ? "," : ""));
        }
        this.d_writer.backTab();
        this.d_writer.println("};");
        this.d_writer.println("int i, cmp, l = 0;");
        this.d_writer.println("int u = sizeof(s_methods)/sizeof(struct " + my_symbolName + "__method);");
        this.d_writer.println("if (methodName) {");
        this.d_writer.tab();
        this.d_writer.writeCommentLine("Use binary search to locate method");
        this.d_writer.println("while (l < u) {");
        this.d_writer.tab();
        this.d_writer.println("i = (l + u) >> 1;");
        this.d_writer.println("if (!(cmp=strcmp(methodName, s_methods[i].d_name))) {");
        this.d_writer.tab();
        this.d_writer.println("(s_methods[i].d_func)(inArgs, outArgs);");
        this.d_writer.println("return;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println("else if (cmp < 0) u = i;");
        this.d_writer.println("else l = i + 1;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.writeCommentLine("TODO: add code for method not found");
        this.d_writer.backTab();
        this.d_writer.println("}");
    }

    private void generateMethodExecs(Class cls) throws CodeGenerationException {
        SymbolID id = cls.getSymbolID();
        String my_symbolName = IOR.getSymbolName(id);
        Collection c = cls.getStaticMethods(true);
        String self = C.getObjectName(id) + " self";
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Argument arg;
            Iterator a;
            boolean hasArgs;
            Method m = (Method)i.next();
            boolean hasThrows = !m.getThrows().isEmpty();
            String name = m.getLongMethodName();
            Type returnType = m.getReturnType();
            this.d_writer.println("void");
            this.d_writer.println(my_symbolName + "_" + name + "__sexec(");
            this.d_writer.println("        struct sidl_io_Deserializer__object* inArgs,");
            this.d_writer.println("        struct sidl_io_Serializer__object* outArgs) {");
            this.d_writer.tab();
            this.d_writer.writeCommentLine("stack space for arguments");
            ArrayList args = m.getArgumentList();
            int numSerialized = args.size();
            Iterator a2 = args.iterator();
            while (a2.hasNext()) {
                Argument arg2 = (Argument)a2.next();
                if (arg2.getType().getType() == 10 && arg2.getMode() == 0) {
                    if (arg2.getType().isRarray()) {
                        this.d_writer.println(StubSource.getReturnString(arg2.getType()) + " " + arg2.getFormalName() + "_tmp" + ";");
                        continue;
                    }
                    this.d_writer.println(StubSource.getReturnString(arg2.getType()) + " " + arg2.getFormalName() + ";");
                    continue;
                }
                if (arg2.getType().isRarray()) {
                    this.d_writer.println(StubSource.getArgumentWithFormal(arg2) + "_tmp" + ";");
                    continue;
                }
                this.d_writer.println(StubSource.getArgumentWithFormal(arg2) + ";");
            }
            if (returnType.getType() != 0) {
                ++numSerialized;
                this.d_writer.println(IOR.getReturnString(returnType, false, false) + " _retval;");
            }
            boolean allObj = true;
            boolean hasReturn = returnType.getType() != 0;
            boolean bl = hasArgs = numSerialized > 0;
            if (returnType.getType() != 0 && returnType.getType() < 12) {
                allObj = false;
            }
            if (allObj) {
                a = args.iterator();
                while (a.hasNext()) {
                    arg = (Argument)a.next();
                    if (arg.getType().getType() >= 12) continue;
                    allObj = false;
                }
            }
            if ((hasReturn || hasArgs) && !allObj || hasThrows) {
                this.d_writer.println("sidl_BaseInterface _ex   = NULL;");
                this.d_writer.println("sidl_BaseInterface *_ex2 = &_ex;");
            }
            this.d_writer.println();
            this.d_writer.writeCommentLine("unpack in and inout argments");
            a = args.iterator();
            while (a.hasNext()) {
                arg = (Argument)a.next();
                if (arg.getType().isArray() || arg.getType().isSymbol() || arg.getType().getType() == 9 || arg.getMode() != 0 && arg.getMode() != 1) continue;
                this.d_writer.println();
                this.d_writer.println(RMI.unpackType("sidl_io_Deserializer", "inArgs", arg.getType(), arg.getFormalName(), "&" + arg.getFormalName()));
            }
            this.d_writer.println();
            this.d_writer.writeCommentLine("make the call");
            if (returnType.getType() != 0) {
                this.d_writer.print("_retval = ");
            }
            this.d_writer.print("(_getSEPV()->" + IOR.getVectorEntry(m.getLongMethodName()) + ")");
            this.d_writer.println("(");
            this.d_writer.tab();
            C.generateArguments(this.d_writer, self, (List)m.getArgumentList(), m.isStatic(), hasThrows ? "_ex2" : "", null, false, false, true);
            this.d_writer.println(");");
            this.d_writer.backTab();
            this.d_writer.println();
            if (hasThrows) {
                this.d_writer.writeCommentLine("check if exception thrown");
                this.d_writer.writeCommentLine("FIXME");
                this.d_writer.println();
            }
            this.d_writer.writeCommentLine("pack return value");
            if (!returnType.isArray() && !returnType.isSymbol() && returnType.getType() != 9 && returnType.getType() != 0) {
                this.d_writer.println(RMI.packType("sidl_io_Serializer", "outArgs", returnType, "_retval", "_retval"));
                this.d_writer.println();
            }
            this.d_writer.writeCommentLine("pack out and inout argments");
            a = args.iterator();
            while (a.hasNext()) {
                arg = (Argument)a.next();
                if (arg.getType().isArray() || arg.getType().isSymbol() || arg.getType().getType() == 9 || arg.getMode() != 2 && arg.getMode() != 1) continue;
                this.d_writer.println(RMI.packType("sidl_io_Serializer", "outArgs", arg.getType(), arg.getFormalName(), "*" + arg.getFormalName()));
            }
            this.d_writer.println();
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println("");
        }
    }

    private static String getArgumentWithFormal(Argument arg) throws CodeGenerationException {
        return IOR.getArgumentWithFormal(arg, false, false, false);
    }
}

