/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.sharing;

import com.aelitis.azureus.core.AzureusCore;
import java.io.File;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;

public class ShareUtils {
    public static void shareFile(final AzureusCore azureus_core, final Shell shell) {
        new AEThread("shareFile"){

            public void runSupport() {
                Display display = shell.getDisplay();
                String[] path = new String[1];
                AESemaphore sem = new AESemaphore("ShareUtils:file");
                display.asyncExec((Runnable)new AERunnable(this, sem, shell, path){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ AESemaphore val$sem;
                    private final /* synthetic */ Shell val$shell;
                    private final /* synthetic */ String[] val$path;
                    {
                        this.this$1 = var1_1;
                        this.val$sem = aESemaphore;
                        this.val$shell = shell;
                        this.val$path = stringArray;
                    }

                    public void runSupport() {
                        try {
                            FileDialog dialog = new FileDialog(this.val$shell, 135168);
                            dialog.setFilterPath(TorrentOpener.getFilterPathData());
                            dialog.setText(MessageText.getString("MainWindow.dialog.share.sharefile"));
                            this.val$path[0] = TorrentOpener.setFilterPathData(dialog.open());
                        }
                        finally {
                            this.val$sem.release();
                        }
                    }
                });
                sem.reserve();
                if (path[0] != null) {
                    ShareUtils.shareFile(azureus_core, path[0]);
                }
            }
        }.start();
    }

    public static void shareDir(AzureusCore azureus_core, Shell shell) {
        ShareUtils.shareDirSupport(azureus_core, shell, false, false);
    }

    public static void shareDirContents(AzureusCore azureus_core, Shell shell, boolean recursive) {
        ShareUtils.shareDirSupport(azureus_core, shell, true, recursive);
    }

    protected static void shareDirSupport(final AzureusCore azureus_core, final Shell shell, final boolean contents, final boolean recursive) {
        new AEThread("shareDirSupport"){

            public void runSupport() {
                Display display = shell.getDisplay();
                String[] path = new String[1];
                AESemaphore sem = new AESemaphore("ShareUtils:dir");
                display.asyncExec((Runnable)new AERunnable(this, sem, shell, contents, recursive, path){
                    final /* synthetic */ 3 this$1;
                    private final /* synthetic */ AESemaphore val$sem;
                    private final /* synthetic */ Shell val$shell;
                    private final /* synthetic */ boolean val$contents;
                    private final /* synthetic */ boolean val$recursive;
                    private final /* synthetic */ String[] val$path;
                    {
                        this.this$1 = var1_1;
                        this.val$sem = aESemaphore;
                        this.val$shell = shell;
                        this.val$contents = bl;
                        this.val$recursive = bl2;
                        this.val$path = stringArray;
                    }

                    public void runSupport() {
                        try {
                            DirectoryDialog dialog = new DirectoryDialog(this.val$shell, 131072);
                            dialog.setFilterPath(TorrentOpener.getFilterPathData());
                            dialog.setText(this.val$contents ? String.valueOf(MessageText.getString("MainWindow.dialog.share.sharedircontents")) + (this.val$recursive ? "(" + MessageText.getString("MainWindow.dialog.share.sharedircontents.recursive") + ")" : "") : MessageText.getString("MainWindow.dialog.share.sharedir"));
                            this.val$path[0] = TorrentOpener.setFilterPathData(dialog.open());
                        }
                        finally {
                            this.val$sem.release();
                        }
                    }
                });
                sem.reserve();
                if (path[0] != null) {
                    if (contents) {
                        ShareUtils.shareDirContents(azureus_core, path[0], recursive);
                    } else {
                        ShareUtils.shareDir(azureus_core, path[0]);
                    }
                }
            }
        }.start();
    }

    public static void shareFile(final AzureusCore azureus_core, final String file_name) {
        new AEThread("shareFile"){

            public void runSupport() {
                try {
                    azureus_core.getPluginManager().getDefaultPluginInterface().getShareManager().addFile(new File(file_name));
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }.start();
    }

    public static void shareDir(final AzureusCore azureus_core, final String file_name) {
        new AEThread("shareDir"){

            public void runSupport() {
                try {
                    azureus_core.getPluginManager().getDefaultPluginInterface().getShareManager().addDir(new File(file_name));
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }.start();
    }

    public static void shareDirContents(final AzureusCore azureus_core, final String file_name, final boolean recursive) {
        new AEThread("shareDirCntents"){

            public void runSupport() {
                try {
                    azureus_core.getPluginManager().getDefaultPluginInterface().getShareManager().addDirContents(new File(file_name), recursive);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }.start();
    }
}

