/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderBaseImpl;

public class ResourceDownloaderFileImpl
extends ResourceDownloaderBaseImpl {
    protected boolean cancelled;
    protected File file;
    protected Object result;
    protected AESemaphore done_sem = new AESemaphore("RDTimeout");
    protected long size = -2L;

    public ResourceDownloaderFileImpl(ResourceDownloaderBaseImpl _parent, File _file) {
        super(_parent);
        this.file = _file;
    }

    public String getName() {
        return this.file.toString();
    }

    public long getSize() throws ResourceDownloaderException {
        return FileUtil.getFileOrDirectorySize(this.file);
    }

    public ResourceDownloader getClone(ResourceDownloaderBaseImpl parent) {
        ResourceDownloaderFileImpl c = new ResourceDownloaderFileImpl(this.getParent(), this.file);
        return c;
    }

    public InputStream download() throws ResourceDownloaderException {
        this.asyncDownload();
        this.done_sem.reserve();
        if (this.result instanceof ResourceDownloaderException) {
            throw (ResourceDownloaderException)this.result;
        }
        return (InputStream)this.result;
    }

    public void asyncDownload() {
        try {
            this.this_mon.enter();
            if (!this.cancelled) {
                this.informActivity(String.valueOf(this.getLogIndent()) + (this.file.isDirectory() ? "Processing: " : "Downloading: ") + this.getName());
                AEThread t = new AEThread("ResourceDownloaderTimeout"){

                    public void runSupport() {
                        try {
                            if (ResourceDownloaderFileImpl.this.file.isDirectory()) {
                                ResourceDownloaderFileImpl.this.completed(ResourceDownloaderFileImpl.this, null);
                            } else {
                                ResourceDownloaderFileImpl.this.completed(ResourceDownloaderFileImpl.this, new FileInputStream(ResourceDownloaderFileImpl.this.file));
                            }
                        }
                        catch (Throwable e) {
                            ResourceDownloaderFileImpl.this.failed(ResourceDownloaderFileImpl.this, new ResourceDownloaderException("Failed to read file", e));
                            Debug.printStackTrace(e);
                        }
                    }
                };
                t.setDaemon(true);
                t.start();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void cancel() {
        this.cancel(new ResourceDownloaderException("Download cancelled"));
    }

    protected void cancel(ResourceDownloaderException reason) {
        this.setCancelled();
        try {
            this.this_mon.enter();
            this.result = reason;
            this.cancelled = true;
            this.informFailed((ResourceDownloaderException)this.result);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public boolean completed(ResourceDownloader downloader, InputStream data) {
        if (this.informComplete(data)) {
            this.result = data;
            this.done_sem.release();
            return true;
        }
        return false;
    }

    public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
        this.result = e;
        this.done_sem.release();
        this.informFailed(e);
    }
}

