/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcherWithException;

public class ListenerManager {
    protected String name;
    protected ListenerManagerDispatcher target;
    protected ListenerManagerDispatcherWithException target_with_exception;
    protected boolean async;
    protected Thread async_thread;
    protected List listeners = new ArrayList();
    protected List dispatch_queue;
    protected AESemaphore dispatch_sem;

    public static ListenerManager createManager(String name, ListenerManagerDispatcher target) {
        return new ListenerManager(name, target, false);
    }

    public static ListenerManager createAsyncManager(String name, ListenerManagerDispatcher target) {
        return new ListenerManager(name, target, true);
    }

    protected ListenerManager(String _name, ListenerManagerDispatcher _target, boolean _async) {
        this.name = _name;
        this.target = _target;
        this.async = _async;
        if (this.target instanceof ListenerManagerDispatcherWithException) {
            this.target_with_exception = (ListenerManagerDispatcherWithException)this.target;
        }
        if (this.async) {
            this.dispatch_sem = new AESemaphore("ListenerManager::" + this.name);
            this.dispatch_queue = new LinkedList();
            if (this.target_with_exception != null) {
                throw new RuntimeException("Can't have an async manager with exceptions!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Object listener) {
        ListenerManager listenerManager = this;
        synchronized (listenerManager) {
            ArrayList<Object> new_listeners = new ArrayList<Object>(this.listeners);
            new_listeners.add(listener);
            this.listeners = new_listeners;
            if (this.async && this.listeners.size() == 1) {
                this.async_thread = new AEThread(this.name){

                    public void runSupport() {
                        ListenerManager.this.dispatchLoop();
                    }
                };
                this.async_thread.setDaemon(true);
                this.async_thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Object listener) {
        ListenerManager listenerManager = this;
        synchronized (listenerManager) {
            ArrayList new_listeners = new ArrayList(this.listeners);
            new_listeners.remove(listener);
            this.listeners = new_listeners;
            if (this.async && this.listeners.size() == 0) {
                this.async_thread = null;
                this.dispatch_sem.release();
            }
        }
    }

    public List getListenersCopy() {
        return this.listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(int type, Object value) {
        if (this.async) {
            ListenerManager listenerManager = this;
            synchronized (listenerManager) {
                if (this.listeners.size() == 0) {
                    return;
                }
                this.dispatch_queue.add(new Object[]{this.listeners, new Integer(type), value});
            }
            this.dispatch_sem.release();
        } else {
            List listeners_ref;
            if (this.target_with_exception != null) {
                throw new RuntimeException("call dispatchWithException, not dispatch");
            }
            ListenerManager listenerManager = this;
            synchronized (listenerManager) {
                listeners_ref = this.listeners;
            }
            try {
                this.dispatchInternal(listeners_ref, type, value);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchWithException(int type, Object value) throws Throwable {
        List listeners_ref;
        ListenerManager listenerManager = this;
        synchronized (listenerManager) {
            listeners_ref = this.listeners;
        }
        this.dispatchInternal(listeners_ref, type, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(Object listener, int type, Object value) {
        if (this.async) {
            ListenerManager listenerManager = this;
            synchronized (listenerManager) {
                if (this.listeners.size() == 0) {
                    return;
                }
                Object[] objectArray = new Object[4];
                objectArray[0] = listener;
                objectArray[1] = new Integer(type);
                objectArray[2] = value;
                this.dispatch_queue.add(objectArray);
            }
            this.dispatch_sem.release();
        } else {
            if (this.target_with_exception != null) {
                throw new RuntimeException("call dispatchWithException, not dispatch");
            }
            try {
                this.target.dispatch(listener, type, value);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void dispatchInternal(List listeners_ref, int type, Object value) throws Throwable {
        int i = 0;
        while (i < listeners_ref.size()) {
            if (this.target_with_exception != null) {
                this.target_with_exception.dispatchWithException(listeners_ref.get(i), type, value);
            } else {
                try {
                    this.target.dispatch(listeners_ref.get(i), type, value);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            ++i;
        }
    }

    protected void dispatchInternal(Object listener, int type, Object value) throws Throwable {
        if (this.target_with_exception != null) {
            this.target_with_exception.dispatchWithException(listener, type, value);
        } else {
            try {
                this.target.dispatch(listener, type, value);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchLoop() {
        while (true) {
            this.dispatch_sem.reserve();
            Object[] data = null;
            ListenerManager listenerManager = this;
            synchronized (listenerManager) {
                if (this.async_thread != Thread.currentThread()) {
                    this.dispatch_sem.release();
                    break;
                }
                if (this.dispatch_queue.size() > 0) {
                    data = (Object[])this.dispatch_queue.remove(0);
                }
            }
            if (data == null) continue;
            try {
                if (data.length == 3) {
                    this.dispatchInternal((List)data[0], (int)((Integer)data[1]), data[2]);
                    continue;
                }
                this.dispatchInternal(data[0], (int)((Integer)data[1]), data[2]);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }
}

