/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerPeer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrent;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrentListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrentStats;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerNATChecker;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerPeerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerTorrentStatsImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SystemTime;

public class TRTrackerServerTorrentImpl
implements TRTrackerServerTorrent {
    public static final int MIN_CACHE_ENTRY_SIZE = 10;
    public static final int MAX_UPLOAD_BYTES_PER_SEC = 0x100000;
    public static final int MAX_DOWNLOAD_BYTES_PER_SEC = 0x100000;
    public static final boolean USE_LIGHTWEIGHT_SEEDS = true;
    protected HashWrapper hash;
    protected Map peer_map = new HashMap();
    protected Map peer_reuse_map = new HashMap();
    protected List peer_list = new ArrayList();
    protected int peer_list_hole_count;
    protected boolean peer_list_compaction_suspended;
    protected Map lightweight_seed_map = new HashMap();
    protected int seed_count;
    protected int removed_count;
    protected int bad_NAT_count;
    protected Random random = new Random(SystemTime.getCurrentTime());
    protected long last_scrape_calc_time;
    protected Map last_scrape;
    protected LinkedHashMap announce_cache = new LinkedHashMap();
    protected TRTrackerServerTorrentStatsImpl stats;
    protected List listeners = new ArrayList();
    protected boolean deleted;
    protected boolean map_size_diff_reported;
    protected byte duplicate_peer_checker_index = 0;
    protected byte[] duplicate_peer_checker = new byte[0];
    protected boolean caching_enabled = true;
    protected AEMonitor this_mon = new AEMonitor("TRTrackerServerTorrent");

    public TRTrackerServerTorrentImpl(HashWrapper _hash) {
        this.hash = _hash;
        this.stats = new TRTrackerServerTorrentStatsImpl(this);
    }

    public TRTrackerServerPeerImpl peerContact(String event, HashWrapper peer_id, int port, String ip_address, boolean loopback, String tracker_key, long uploaded, long downloaded, long left, long interval_requested) throws Exception {
        try {
            int seed_retention;
            this.this_mon.enter();
            boolean stopped = event != null && event.equalsIgnoreCase("stopped");
            boolean completed = event != null && event.equalsIgnoreCase("completed");
            long now = SystemTime.getCurrentTime();
            int tracker_key_hash_code = tracker_key == null ? 0 : tracker_key.hashCode();
            TRTrackerServerPeerImpl peer = (TRTrackerServerPeerImpl)this.peer_map.get(peer_id);
            boolean new_peer = false;
            boolean already_completed = false;
            long last_contact_time = 0L;
            long ul_diff = 0L;
            long dl_diff = 0L;
            long le_diff = 0L;
            byte[] ip_address_bytes = ip_address.getBytes("ISO-8859-1");
            if (peer == null) {
                String reuse_key = String.valueOf(new String(ip_address_bytes, "ISO-8859-1")) + ":" + port;
                byte last_NAT_status = loopback ? (byte)3 : 0;
                new_peer = true;
                TRTrackerServerPeerImpl old_peer = (TRTrackerServerPeerImpl)this.peer_reuse_map.get(reuse_key);
                if (old_peer != null) {
                    last_contact_time = old_peer.getLastContactTime();
                    already_completed = old_peer.getDownloadCompleted();
                    this.removePeer(old_peer);
                    this.lightweight_seed_map.remove(old_peer.getPeerId());
                } else {
                    lightweightSeed lws = (lightweightSeed)this.lightweight_seed_map.remove(peer_id);
                    if (lws != null) {
                        last_contact_time = lws.getLastContactTime();
                        ul_diff = uploaded - lws.getUploaded();
                        if (ul_diff < 0L) {
                            ul_diff = 0L;
                        }
                        last_NAT_status = lws.getNATStatus();
                    } else {
                        last_contact_time = now;
                    }
                }
                if (!stopped) {
                    peer = new TRTrackerServerPeerImpl(peer_id, tracker_key_hash_code, ip_address_bytes, port, last_contact_time, already_completed, last_NAT_status);
                    this.peer_map.put(peer_id, peer);
                    this.peer_list.add(peer);
                    this.peer_reuse_map.put(reuse_key, peer);
                }
            } else {
                int existing_tracker_key_hash_code = peer.getKeyHashCode();
                if (existing_tracker_key_hash_code != tracker_key_hash_code) {
                    throw new Exception("Unauthorised: key mismatch ");
                }
                already_completed = peer.getDownloadCompleted();
                last_contact_time = peer.getLastContactTime();
                if (stopped) {
                    this.removePeer(peer);
                } else {
                    byte[] old_ip = peer.getIPAsRead();
                    int old_port = peer.getPort();
                    if (peer.checkForIPOrPortChange(ip_address_bytes, port)) {
                        String old_key = String.valueOf(new String(old_ip, "ISO-8859-1")) + ":" + old_port;
                        String new_key = String.valueOf(new String(ip_address_bytes, "ISO-8859-1")) + ":" + port;
                        TRTrackerServerPeerImpl old_peer = (TRTrackerServerPeerImpl)this.peer_reuse_map.get(new_key);
                        if (old_peer != null) {
                            this.removePeer(old_peer);
                        }
                        if (this.peer_reuse_map.remove(old_key) == null) {
                            Debug.out("TRTrackerServerTorrent: IP address change: '" + old_key + "' -> '" + new_key + "': old key not found");
                        }
                        this.peer_reuse_map.put(new_key, peer);
                    }
                }
            }
            long new_timeout = now + interval_requested * 1000L * (long)TRTrackerServerImpl.CLIENT_TIMEOUT_MULTIPLIER;
            if (peer != null) {
                long elapsed_time;
                peer.setTimeout(now, new_timeout);
                if (!new_peer) {
                    ul_diff = uploaded - peer.getUploaded();
                    dl_diff = downloaded - peer.getDownloaded();
                }
                if ((elapsed_time = now - last_contact_time) == 0L) {
                    elapsed_time = 20L;
                }
                long ul_rate = ul_diff * 1000L / elapsed_time;
                long dl_rate = dl_diff * 1000L / elapsed_time;
                if (ul_rate > 0x100000L) {
                    Debug.out("TRTrackerPeer: peer " + peer.getIPRaw() + "/" + new String(peer.getPeerId().getHash()) + " reported an upload rate of " + ul_rate + " bytes per second");
                    ul_diff = 0L;
                }
                if (dl_rate > 0x100000L) {
                    Debug.out("TRTrackerPeer: peer " + peer.getIPRaw() + "/" + new String(peer.getPeerId().getHash()) + " reported a download rate of " + dl_rate + " bytes per second");
                    dl_diff = 0L;
                }
                le_diff = stopped ? 0L : left - peer.getAmountLeft();
                boolean was_seed = new_peer ? false : peer.isSeed();
                peer.setStats(uploaded, downloaded, left);
                boolean is_seed = peer.isSeed();
                if (!stopped && !was_seed && is_seed) {
                    ++this.seed_count;
                }
            }
            this.stats.addAnnounce(ul_diff, dl_diff, le_diff);
            if (completed && !already_completed) {
                peer.setDownloadCompleted();
                this.stats.addCompleted();
            }
            if (peer != null && peer.isSeed() && (seed_retention = TRTrackerServerImpl.getMaxSeedRetention()) != 0 && this.seed_count > seed_retention) {
                int to_remove = seed_retention / 20 + 1;
                try {
                    this.peer_list_compaction_suspended = true;
                    int bad_nat_loop = TRTrackerServerNATChecker.getSingleton().isEnabled() ? 0 : 1;
                    while (bad_nat_loop < 2) {
                        int i = 0;
                        while (i < this.peer_list.size()) {
                            TRTrackerServerPeerImpl this_peer = (TRTrackerServerPeerImpl)this.peer_list.get(i);
                            if (this_peer != null && this_peer.isSeed()) {
                                boolean bad_nat = this_peer.isNATStatusBad();
                                if (bad_nat_loop == 0 && bad_nat || bad_nat_loop == 1) {
                                    this.lightweight_seed_map.put(this_peer.getPeerId(), new lightweightSeed(now, new_timeout, this_peer.getUploaded(), this_peer.getNATStatus()));
                                    this.removePeer(this_peer, i);
                                    if (--to_remove == 0) break;
                                }
                            }
                            ++i;
                        }
                        if (to_remove == 0) {
                            break;
                        }
                        ++bad_nat_loop;
                    }
                }
                finally {
                    this.peer_list_compaction_suspended = false;
                }
                this.checkForPeerListCompaction(false);
            }
            TRTrackerServerPeerImpl tRTrackerServerPeerImpl = peer;
            this.this_mon.exit();
            return tRTrackerServerPeerImpl;
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected void removePeer(TRTrackerServerPeerImpl peer) {
        this.removePeer(peer, -1);
    }

    protected void removePeer(TRTrackerServerPeerImpl peer, int peer_list_index) {
        try {
            Object o;
            this.this_mon.enter();
            this.stats.removeLeft(peer.getAmountLeft());
            if (this.peer_map.size() != this.peer_reuse_map.size() && !this.map_size_diff_reported) {
                this.map_size_diff_reported = true;
                Debug.out("TRTrackerServerTorrent::removePeer: maps size different ( " + this.peer_map.size() + "/" + this.peer_reuse_map.size() + ")");
            }
            if ((o = this.peer_map.remove(peer.getPeerId())) == null) {
                Debug.out(" TRTrackerServerTorrent::removePeer: peer_map doesn't contain peer");
            }
            if (peer_list_index == -1) {
                int peer_index = this.peer_list.indexOf(peer);
                if (peer_index == -1) {
                    Debug.out(" TRTrackerServerTorrent::removePeer: peer_list doesn't contain peer");
                } else {
                    this.peer_list.set(peer_index, null);
                }
            } else if (this.peer_list.get(peer_list_index) == peer) {
                this.peer_list.set(peer_list_index, null);
            } else {
                Debug.out(" TRTrackerServerTorrent::removePeer: peer_list doesn't contain peer at index");
            }
            ++this.peer_list_hole_count;
            this.checkForPeerListCompaction(false);
            try {
                o = this.peer_reuse_map.remove(String.valueOf(new String(peer.getIPAsRead(), "ISO-8859-1")) + ":" + peer.getPort());
                if (o == null) {
                    Debug.out(" TRTrackerServerTorrent::removePeer: peer_reuse_map doesn't contain peer");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (peer.isSeed()) {
                --this.seed_count;
            }
            ++this.removed_count;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Map exportAnnounceToMap(TRTrackerServerPeerImpl requesting_peer, boolean include_seeds, int num_want, long interval, boolean no_peer_id, boolean compact) {
        try {
            ArrayList rep_peers;
            boolean add_to_cache;
            boolean send_peer_ids;
            boolean nat_warning;
            block36: {
                long now;
                block42: {
                    int total_peers;
                    block37: {
                        int i;
                        this.this_mon.enter();
                        now = SystemTime.getCurrentTime();
                        nat_warning = requesting_peer != null && requesting_peer.getNATStatus() == 4;
                        total_peers = this.peer_map.size();
                        int cache_millis = TRTrackerServerImpl.getAnnounceCachePeriod();
                        send_peer_ids = TRTrackerServerImpl.getSendPeerIds();
                        if (no_peer_id || compact) {
                            send_peer_ids = false;
                        }
                        add_to_cache = false;
                        int max_peers = TRTrackerServerImpl.getMaxPeersToSend();
                        if (num_want < 0) {
                            num_want = total_peers;
                        }
                        if (max_peers > 0 && num_want > max_peers) {
                            num_want = max_peers;
                        }
                        if (this.caching_enabled && !nat_warning && cache_millis > 0 && num_want >= 10 && total_peers >= TRTrackerServerImpl.getAnnounceCachePeerThreshold()) {
                            announceCacheEntry entry2;
                            Iterator it = this.announce_cache.keySet().iterator();
                            while (it.hasNext()) {
                                Integer key = (Integer)it.next();
                                entry2 = (announceCacheEntry)this.announce_cache.get(key);
                                if (now - entry2.getTime() <= (long)cache_millis) continue;
                                it.remove();
                            }
                            i = num_want / 10;
                            while (i > num_want / 20) {
                                entry2 = (announceCacheEntry)this.announce_cache.get(new Integer(i));
                                if (entry2 != null) {
                                    if (now - entry2.getTime() > (long)cache_millis) {
                                        this.announce_cache.remove(new Integer(i));
                                    } else if (entry2.getSendPeerIds() == send_peer_ids && entry2.getCompact() == compact) {
                                        Map map = entry2.getData();
                                        this.this_mon.exit();
                                        return map;
                                    }
                                }
                                --i;
                            }
                            add_to_cache = true;
                        }
                        rep_peers = new ArrayList();
                        if (num_want <= 0) break block36;
                        if (num_want < total_peers) break block37;
                        i = 0;
                        while (i < this.peer_list.size()) {
                            block38: {
                                HashMap<String, Object> rep_peer;
                                TRTrackerServerPeerImpl peer;
                                block41: {
                                    block40: {
                                        block39: {
                                            peer = (TRTrackerServerPeerImpl)this.peer_list.get(i);
                                            if (peer == null) break block38;
                                            if (now <= peer.getTimeout()) break block39;
                                            this.removePeer(peer, i);
                                            break block38;
                                        }
                                        if (peer.getPort() == 0 || !include_seeds && peer.isSeed()) break block38;
                                        rep_peer = new HashMap<String, Object>(3);
                                        if (send_peer_ids) {
                                            rep_peer.put("peer id", peer.getPeerId().getHash());
                                        }
                                        if (!compact) break block40;
                                        byte[] peer_bytes = peer.getIPBytes();
                                        if (peer_bytes == null) break block38;
                                        rep_peer.put("ip", peer_bytes);
                                        break block41;
                                    }
                                    rep_peer.put("ip", peer.getIPAsRead());
                                }
                                rep_peer.put("port", new Long(peer.getPort()));
                                rep_peers.add(rep_peer);
                            }
                            ++i;
                        }
                        break block36;
                    }
                    if (num_want >= total_peers * 3) break block42;
                    int peer_list_size = this.peer_list.size();
                    if (this.duplicate_peer_checker.length < peer_list_size) {
                        this.duplicate_peer_checker = new byte[peer_list_size * 2];
                        this.duplicate_peer_checker_index = 1;
                    } else if (this.duplicate_peer_checker.length > peer_list_size * 2) {
                        this.duplicate_peer_checker = new byte[3 * peer_list_size / 2];
                        this.duplicate_peer_checker_index = 1;
                    } else {
                        this.duplicate_peer_checker_index = (byte)(this.duplicate_peer_checker_index + 1);
                        if (this.duplicate_peer_checker_index == 0) {
                            Arrays.fill(this.duplicate_peer_checker, (byte)0);
                            this.duplicate_peer_checker_index = 1;
                        }
                    }
                    boolean peer_removed = false;
                    try {
                        this.peer_list_compaction_suspended = true;
                        int added = 0;
                        int bad_nat_loop = TRTrackerServerNATChecker.getSingleton().isEnabled() ? 0 : 1;
                        while (bad_nat_loop < 2) {
                            int limit = num_want * 2;
                            int i = 0;
                            while (i < limit && added < num_want) {
                                block43: {
                                    HashMap<String, Object> rep_peer;
                                    TRTrackerServerPeerImpl peer;
                                    block46: {
                                        block45: {
                                            int index;
                                            block44: {
                                                index = this.random.nextInt(peer_list_size);
                                                peer = (TRTrackerServerPeerImpl)this.peer_list.get(index);
                                                if (peer == null) break block43;
                                                if (now <= peer.getTimeout()) break block44;
                                                this.removePeer(peer);
                                                peer_removed = true;
                                                break block43;
                                            }
                                            if (peer.getPort() == 0 || !include_seeds && peer.isSeed()) break block43;
                                            boolean bad_nat = peer.isNATStatusBad();
                                            if ((bad_nat_loop != 0 || bad_nat) && bad_nat_loop != 1 || this.duplicate_peer_checker[index] == this.duplicate_peer_checker_index) break block43;
                                            this.duplicate_peer_checker[index] = this.duplicate_peer_checker_index;
                                            ++added;
                                            rep_peer = new HashMap<String, Object>(3);
                                            if (send_peer_ids) {
                                                rep_peer.put("peer id", peer.getPeerId().getHash());
                                            }
                                            if (!compact) break block45;
                                            byte[] peer_bytes = peer.getIPBytes();
                                            if (peer_bytes == null) break block43;
                                            rep_peer.put("ip", peer_bytes);
                                            break block46;
                                        }
                                        rep_peer.put("ip", peer.getIPAsRead());
                                    }
                                    rep_peer.put("port", new Long(peer.getPort()));
                                    rep_peers.add(rep_peer);
                                }
                                ++i;
                            }
                            ++bad_nat_loop;
                        }
                    }
                    finally {
                        this.peer_list_compaction_suspended = false;
                        if (peer_removed) {
                            this.checkForPeerListCompaction(false);
                        }
                    }
                }
                LinkedList peers = new LinkedList(this.peer_map.keySet());
                int added = 0;
                while (added < num_want && peers.size() > 0) {
                    String key = (String)peers.remove(this.random.nextInt(peers.size()));
                    TRTrackerServerPeerImpl peer = (TRTrackerServerPeerImpl)this.peer_map.get(key);
                    if (now > peer.getTimeout()) {
                        this.removePeer(peer);
                        continue;
                    }
                    if (peer.getPort() == 0 || !include_seeds && peer.isSeed()) continue;
                    ++added;
                    HashMap<String, Object> rep_peer = new HashMap<String, Object>(3);
                    if (send_peer_ids) {
                        rep_peer.put("peer id", peer.getPeerId().getHash());
                    }
                    if (compact) {
                        byte[] peer_bytes = peer.getIPBytes();
                        if (peer_bytes == null) continue;
                        rep_peer.put("ip", peer_bytes);
                    } else {
                        rep_peer.put("ip", peer.getIPAsRead());
                    }
                    rep_peer.put("port", new Long(peer.getPort()));
                    rep_peers.add(rep_peer);
                }
            }
            TreeMap<String, Object> root = new TreeMap<String, Object>();
            int num_peers_returned = rep_peers.size();
            if (compact) {
                byte[] compact_peers = new byte[rep_peers.size() * 6];
                int i = 0;
                while (i < num_peers_returned) {
                    Map rep_peer = (Map)rep_peers.get(i);
                    byte[] ip = (byte[])rep_peer.get("ip");
                    int port = ((Long)rep_peer.get("port")).intValue();
                    int pos = i * 6;
                    System.arraycopy(ip, 0, compact_peers, pos, 4);
                    pos += 4;
                    compact_peers[pos++] = (byte)(port >> 8);
                    compact_peers[pos++] = (byte)(port & 0xFF);
                    ++i;
                }
                root.put("peers", compact_peers);
            } else {
                root.put("peers", rep_peers);
            }
            root.put("interval", new Long(interval));
            if (nat_warning) {
                requesting_peer.setNATStatus((byte)5);
                root.put("warning message", ("Unable to connect to your incoming data port (" + requesting_peer.getIP() + ":" + requesting_peer.getPort() + "). " + "This will result in slow downloads. Please check your firewall/router settings").getBytes());
            }
            root.put("complete", new Long(this.getSeedCount()));
            root.put("incomplete", new Long(this.getLeecherCount()));
            root.put("downloaded", new Long(this.stats.getCompletedCount()));
            if (add_to_cache) {
                this.announce_cache.put(new Integer((num_peers_returned + 9) / 10), new announceCacheEntry(root, send_peer_ids, compact));
            }
            TreeMap<String, Object> treeMap = root;
            this.this_mon.exit();
            return treeMap;
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    public Map exportScrapeToMap(boolean allow_cache) {
        long now;
        block3: {
            try {
                this.this_mon.enter();
                this.stats.addScrape();
                now = SystemTime.getCurrentTime();
                if (!allow_cache || SystemTime.isErrorLast1min() || this.last_scrape == null || now - this.last_scrape_calc_time >= (long)TRTrackerServerImpl.getScrapeCachePeriod()) break block3;
                Map map = this.last_scrape;
                this.this_mon.exit();
                return map;
            }
            catch (Throwable throwable) {
                this.this_mon.exit();
                throw throwable;
            }
        }
        this.last_scrape = new TreeMap();
        this.last_scrape_calc_time = now;
        this.last_scrape.put("complete", new Long(this.getSeedCount()));
        this.last_scrape.put("incomplete", new Long(this.getLeecherCount()));
        this.last_scrape.put("downloaded", new Long(this.stats.getCompletedCount()));
        Map map = this.last_scrape;
        this.this_mon.exit();
        return map;
    }

    protected void checkTimeouts() {
        try {
            this.this_mon.enter();
            long now = SystemTime.getCurrentTime();
            int new_bad_NAT_count = 0;
            try {
                this.peer_list_compaction_suspended = true;
                int i = 0;
                while (i < this.peer_list.size()) {
                    TRTrackerServerPeerImpl peer = (TRTrackerServerPeerImpl)this.peer_list.get(i);
                    if (peer != null) {
                        if (now > peer.getTimeout()) {
                            this.removePeer(peer, i);
                        } else if (peer.isNATStatusBad()) {
                            ++new_bad_NAT_count;
                        }
                    }
                    ++i;
                }
            }
            finally {
                this.peer_list_compaction_suspended = false;
            }
            this.bad_NAT_count = new_bad_NAT_count;
            if (this.removed_count > 1000) {
                this.removed_count = 0;
                this.checkForPeerListCompaction(true);
                HashMap new_peer_map = new HashMap(this.peer_map);
                HashMap new_peer_reuse_map = new HashMap(this.peer_reuse_map);
                this.peer_map = new_peer_map;
                this.peer_reuse_map = new_peer_reuse_map;
            } else {
                this.checkForPeerListCompaction(false);
            }
            Iterator it = this.lightweight_seed_map.values().iterator();
            while (it.hasNext()) {
                lightweightSeed lws = (lightweightSeed)it.next();
                if (now <= lws.getTimeout()) continue;
                it.remove();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void checkForPeerListCompaction(boolean force) {
        if (this.peer_list_hole_count > 0 && !this.peer_list_compaction_suspended && (force || this.peer_list_hole_count > this.peer_map.size() / 10)) {
            ArrayList new_peer_list = new ArrayList(this.peer_list.size() - this.peer_list_hole_count / 2);
            int holes_found = 0;
            int i = 0;
            while (i < this.peer_list.size()) {
                Object obj = this.peer_list.get(i);
                if (obj == null) {
                    ++holes_found;
                } else {
                    new_peer_list.add(obj);
                }
                ++i;
            }
            if (holes_found != this.peer_list_hole_count) {
                Debug.out("TRTrackerTorrent:compactHoles: count mismatch");
            }
            this.peer_list = new_peer_list;
            this.peer_list_hole_count = 0;
        }
    }

    protected void updateXferStats(int bytes_in, int bytes_out) {
        this.stats.addXferStats(bytes_in, bytes_out);
    }

    public TRTrackerServerTorrentStats getStats() {
        return this.stats;
    }

    public int getPeerCount() {
        return this.peer_map.size() + this.lightweight_seed_map.size();
    }

    public int getSeedCount() {
        if (this.seed_count < 0) {
            Debug.out("seed count negative");
        }
        return this.seed_count + this.lightweight_seed_map.size();
    }

    public int getLeecherCount() {
        int res = this.peer_map.size() - this.seed_count;
        return res < 0 ? 0 : res;
    }

    public TRTrackerServerPeer[] getPeers() {
        try {
            this.this_mon.enter();
            TRTrackerServerPeer[] res = new TRTrackerServerPeer[this.peer_map.size()];
            this.peer_map.values().toArray(res);
            TRTrackerServerPeer[] tRTrackerServerPeerArray = res;
            this.this_mon.exit();
            return tRTrackerServerPeerArray;
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    public HashWrapper getHash() {
        return this.hash;
    }

    public void addListener(TRTrackerServerTorrentListener l) {
        this.listeners.add(l);
        if (this.deleted) {
            l.deleted(this);
        }
    }

    public void removeListener(TRTrackerServerTorrentListener l) {
        this.listeners.remove(l);
    }

    public void disableCaching() {
        this.caching_enabled = false;
    }

    public boolean isCachingEnabled() {
        return this.caching_enabled;
    }

    public int getBadNATPeerCount() {
        return this.bad_NAT_count;
    }

    protected void delete() {
        this.deleted = true;
        int i = 0;
        while (i < this.listeners.size()) {
            ((TRTrackerServerTorrentListener)this.listeners.get(i)).deleted(this);
            ++i;
        }
    }

    static class announceCacheEntry {
        protected Map data;
        protected boolean send_peer_ids;
        protected boolean compact;
        protected long time;

        protected announceCacheEntry(Map _data, boolean _send_peer_ids, boolean _compact) {
            this.data = _data;
            this.send_peer_ids = _send_peer_ids;
            this.compact = _compact;
            this.time = SystemTime.getCurrentTime();
        }

        protected boolean getSendPeerIds() {
            return this.send_peer_ids;
        }

        protected boolean getCompact() {
            return this.compact;
        }

        protected long getTime() {
            return this.time;
        }

        protected Map getData() {
            return this.data;
        }
    }

    protected static class lightweightSeed {
        long timeout;
        long last_contact_time;
        long uploaded;
        byte nat_status;

        protected lightweightSeed(long _now, long _timeout, long _uploaded, byte _nat_status) {
            this.last_contact_time = _now;
            this.timeout = _timeout;
            this.uploaded = _uploaded;
            this.nat_status = _nat_status;
        }

        protected long getTimeout() {
            return this.timeout;
        }

        protected long getLastContactTime() {
            return this.last_contact_time;
        }

        protected long getUploaded() {
            return this.uploaded;
        }

        protected byte getNATStatus() {
            return this.nat_status;
        }
    }
}

