/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.proxy.socks.impl;

import com.aelitis.azureus.core.proxy.AEProxyConnection;
import com.aelitis.azureus.core.proxy.AEProxyConnectionListener;
import com.aelitis.azureus.core.proxy.AEProxyState;
import com.aelitis.azureus.core.proxy.socks.AESocksProxy;
import com.aelitis.azureus.core.proxy.socks.AESocksProxyConnection;
import com.aelitis.azureus.core.proxy.socks.AESocksProxyPlugableConnection;
import com.aelitis.azureus.core.proxy.socks.AESocksProxyPlugableConnectionFactory;
import com.aelitis.azureus.core.proxy.socks.impl.AESocksProxyAddressImpl;
import com.aelitis.azureus.core.proxy.socks.impl.AESocksProxyImpl;
import com.aelitis.azureus.core.proxy.socks.impl.AESocksProxyState;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.azureus2.core3.util.HostNameToIPResolverListener;

public class AESocksProxyConnectionImpl
implements AESocksProxyConnection,
AEProxyConnectionListener {
    public static final boolean TRACE = true;
    protected AESocksProxy proxy;
    protected AEProxyConnection connection;
    protected boolean disable_dns_lookups;
    protected SocketChannel source_channel;
    protected int socks_version;
    protected AESocksProxyPlugableConnection plugable_connection;

    protected AESocksProxyConnectionImpl(AESocksProxyImpl _proxy, AESocksProxyPlugableConnectionFactory _connection_factory, AEProxyConnection _connection) {
        this.proxy = _proxy;
        this.connection = _connection;
        this.connection.addListener(this);
        this.source_channel = this.connection.getSourceChannel();
        this.plugable_connection = _connection_factory.create(this);
        LGLogger.log("AESocksProxyProcessor: " + this.getName());
    }

    public AESocksProxy getProxy() {
        return this.proxy;
    }

    public void setDelegate(AESocksProxyPlugableConnection target) {
        this.plugable_connection = target;
    }

    protected String getName() {
        String name = String.valueOf(this.connection.getName()) + ", ver = " + this.socks_version;
        name = String.valueOf(name) + this.plugable_connection.getName();
        return name;
    }

    protected AEProxyState getInitialState() {
        return new proxyStateVersion();
    }

    public void connectionClosed(AEProxyConnection con) {
        try {
            this.plugable_connection.close();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public boolean isClosed() {
        return this.connection.isClosed();
    }

    public AEProxyConnection getConnection() {
        return this.connection;
    }

    public void disableDNSLookups() {
        this.disable_dns_lookups = true;
    }

    public void enableDNSLookups() {
        this.disable_dns_lookups = false;
    }

    public void close() throws IOException {
        new proxyStateClose();
    }

    public void connected() throws IOException {
        if (this.socks_version == 4) {
            new proxyStateV4Reply();
        } else {
            new proxyStateV5Reply();
        }
    }

    protected class proxyStateVersion
    extends AESocksProxyState {
        protected proxyStateVersion() {
            super(AESocksProxyConnectionImpl.this);
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(1);
        }

        protected void readSupport(SocketChannel sc) throws IOException {
            if (sc.read(this.buffer) == -1) {
                throw new IOException("read channel shutdown");
            }
            if (this.buffer.hasRemaining()) {
                return;
            }
            this.buffer.flip();
            byte version = this.buffer.get();
            if (version == 5) {
                new proxyStateV5MethodNumber();
            } else if (version == 4) {
                new proxyStateV4Request();
            } else {
                throw new IOException("Unsupported version " + version);
            }
        }
    }

    protected class proxyStateV4Request
    extends AESocksProxyState {
        boolean got_header;
        protected int port;
        protected byte[] address;

        protected proxyStateV4Request() {
            super(AESocksProxyConnectionImpl.this);
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(7);
        }

        protected void readSupport(SocketChannel sc) throws IOException {
            if (sc.read(this.buffer) == -1) {
                throw new IOException("read channel shutdown");
            }
            if (this.buffer.hasRemaining()) {
                return;
            }
            this.buffer.flip();
            if (this.got_header) {
                if (this.buffer.get() == 0) {
                    if (this.address[0] == 0 && this.address[1] == 0 && this.address[2] == 0 && this.address[3] != 0) {
                        new proxyStateV4aRequest(this.port);
                    } else {
                        AESocksProxyConnectionImpl.this.socks_version = 4;
                        AESocksProxyConnectionImpl.this.plugable_connection.connect(new AESocksProxyAddressImpl("", InetAddress.getByAddress(this.address), this.port));
                    }
                } else {
                    this.buffer.flip();
                }
            } else {
                this.got_header = true;
                byte command = this.buffer.get();
                if (command != 1) {
                    throw new IOException("SocksV4: only CONNECT supported");
                }
                this.port = ((this.buffer.get() & 0xFF) << 8) + (this.buffer.get() & 0xFF);
                this.address = new byte[4];
                int i = 0;
                while (i < this.address.length) {
                    this.address[i] = this.buffer.get();
                    ++i;
                }
                this.buffer = ByteBuffer.allocate(1);
            }
        }
    }

    protected class proxyStateV4aRequest
    extends AESocksProxyState {
        protected String dns_address;
        protected int port;

        protected proxyStateV4aRequest(int _port) {
            super(AESocksProxyConnectionImpl.this);
            this.port = _port;
            this.dns_address = "";
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(1);
        }

        protected void readSupport(SocketChannel sc) throws IOException {
            if (sc.read(this.buffer) == -1) {
                throw new IOException("read channel shutdown");
            }
            if (this.buffer.hasRemaining()) {
                return;
            }
            this.buffer.flip();
            byte data = this.buffer.get();
            if (data == 0) {
                if (AESocksProxyConnectionImpl.this.disable_dns_lookups) {
                    AESocksProxyConnectionImpl.this.socks_version = 4;
                    AESocksProxyConnectionImpl.this.plugable_connection.connect(new AESocksProxyAddressImpl(this.dns_address, null, this.port));
                } else {
                    String f_dns_address = this.dns_address;
                    AESocksProxyConnectionImpl.this.connection.cancelReadSelect(sc);
                    HostNameToIPResolver.addResolverRequest(this.dns_address, new HostNameToIPResolverListener(this, f_dns_address, sc){
                        final /* synthetic */ proxyStateV4aRequest this$1;
                        private final /* synthetic */ String val$f_dns_address;
                        private final /* synthetic */ SocketChannel val$sc;
                        {
                            this.this$1 = proxyStateV4aRequest2;
                            this.val$f_dns_address = string;
                            this.val$sc = socketChannel;
                        }

                        public void hostNameResolutionComplete(InetAddress address) {
                            try {
                                proxyStateV4aRequest.access$0((proxyStateV4aRequest)this.this$1).socks_version = 4;
                                proxyStateV4aRequest.access$0((proxyStateV4aRequest)this.this$1).plugable_connection.connect(new AESocksProxyAddressImpl(this.val$f_dns_address, address, this.this$1.port));
                                proxyStateV4aRequest.access$0((proxyStateV4aRequest)this.this$1).connection.requestReadSelect(this.val$sc);
                            }
                            catch (IOException e) {
                                proxyStateV4aRequest.access$0((proxyStateV4aRequest)this.this$1).connection.failed(e);
                            }
                        }
                    });
                }
            } else {
                this.dns_address = String.valueOf(this.dns_address) + (char)data;
                if (this.dns_address.length() > 4096) {
                    throw new IOException("DNS name too long");
                }
                this.buffer.flip();
            }
        }

        static /* synthetic */ AESocksProxyConnectionImpl access$0(proxyStateV4aRequest proxyStateV4aRequest2) {
            return proxyStateV4aRequest2.AESocksProxyConnectionImpl.this;
        }
    }

    protected class proxyStateV4Reply
    extends AESocksProxyState {
        protected proxyStateV4Reply() throws IOException {
            super(AESocksProxyConnectionImpl.this);
            AESocksProxyConnectionImpl.this.connection.setWriteState(this);
            byte[] addr = AESocksProxyConnectionImpl.this.plugable_connection.getLocalAddress().getAddress();
            int port = AESocksProxyConnectionImpl.this.plugable_connection.getLocalPort();
            byte[] byArray = new byte[8];
            byArray[1] = 90;
            byArray[2] = (byte)(port >> 8 & 0xFF);
            byArray[3] = (byte)(port & 0xFF);
            byArray[4] = addr[0];
            byArray[5] = addr[1];
            byArray[6] = addr[2];
            byArray[7] = addr[3];
            this.buffer = ByteBuffer.wrap(byArray);
            this.write(AESocksProxyConnectionImpl.this.source_channel);
        }

        protected void writeSupport(SocketChannel sc) throws IOException {
            sc.write(this.buffer);
            if (this.buffer.hasRemaining()) {
                AESocksProxyConnectionImpl.this.connection.requestWriteSelect(sc);
            } else {
                AESocksProxyConnectionImpl.this.plugable_connection.relayData();
            }
        }
    }

    protected class proxyStateV5MethodNumber
    extends AESocksProxyState {
        protected proxyStateV5MethodNumber() {
            super(AESocksProxyConnectionImpl.this);
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(1);
        }

        protected void readSupport(SocketChannel sc) throws IOException {
            if (sc.read(this.buffer) == -1) {
                throw new IOException("read channel shutdown");
            }
            if (this.buffer.hasRemaining()) {
                return;
            }
            this.buffer.flip();
            byte num_methods = this.buffer.get();
            new proxyStateV5Methods(num_methods);
        }
    }

    protected class proxyStateV5Methods
    extends AESocksProxyState {
        protected proxyStateV5Methods(int methods) {
            super(AESocksProxyConnectionImpl.this);
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(methods);
        }

        protected void readSupport(SocketChannel sc) throws IOException {
            if (sc.read(this.buffer) == -1) {
                throw new IOException("read channel shutdown");
            }
            if (this.buffer.hasRemaining()) {
                return;
            }
            new proxyStateV5MethodsReply();
        }
    }

    protected class proxyStateV5MethodsReply
    extends AESocksProxyState {
        protected proxyStateV5MethodsReply() throws IOException {
            super(AESocksProxyConnectionImpl.this);
            new proxyStateV5Request();
            AESocksProxyConnectionImpl.this.connection.setWriteState(this);
            byte[] byArray = new byte[2];
            byArray[0] = 5;
            this.buffer = ByteBuffer.wrap(byArray);
            this.write(AESocksProxyConnectionImpl.this.source_channel);
        }

        protected void writeSupport(SocketChannel sc) throws IOException {
            sc.write(this.buffer);
            if (this.buffer.hasRemaining()) {
                AESocksProxyConnectionImpl.this.connection.requestWriteSelect(sc);
            }
        }
    }

    protected class proxyStateV5Request
    extends AESocksProxyState {
        protected proxyStateV5Request() {
            super(AESocksProxyConnectionImpl.this);
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(4);
        }

        protected void readSupport(SocketChannel sc) throws IOException {
            if (sc.read(this.buffer) == -1) {
                throw new IOException("read channel shutdown");
            }
            if (this.buffer.hasRemaining()) {
                return;
            }
            this.buffer.flip();
            this.buffer.get();
            byte command = this.buffer.get();
            this.buffer.get();
            byte address_type = this.buffer.get();
            if (command != 1) {
                throw new IOException("V5: Only connect supported");
            }
            if (address_type == 1) {
                new proxyStateV5RequestIP();
            } else if (address_type == 3) {
                new proxyStateV5RequestDNS();
            } else {
                throw new IOException("V5: Unsupported address type");
            }
        }
    }

    protected class proxyStateV5RequestIP
    extends AESocksProxyState {
        protected proxyStateV5RequestIP() {
            super(AESocksProxyConnectionImpl.this);
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(4);
        }

        protected void readSupport(SocketChannel sc) throws IOException {
            if (sc.read(this.buffer) == -1) {
                throw new IOException("read channel shutdown");
            }
            if (this.buffer.hasRemaining()) {
                return;
            }
            this.buffer.flip();
            byte[] bytes = new byte[4];
            this.buffer.get(bytes);
            InetAddress inet_address = InetAddress.getByAddress(bytes);
            new proxyStateV5RequestPort("", inet_address);
        }
    }

    protected class proxyStateV5RequestDNS
    extends AESocksProxyState {
        boolean got_length;

        protected proxyStateV5RequestDNS() {
            super(AESocksProxyConnectionImpl.this);
            this.got_length = false;
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(1);
        }

        protected void readSupport(SocketChannel sc) throws IOException {
            if (sc.read(this.buffer) == -1) {
                throw new IOException("read channel shutdown");
            }
            if (this.buffer.hasRemaining()) {
                return;
            }
            this.buffer.flip();
            if (!this.got_length) {
                int length = this.buffer.get() & 0xFF;
                this.buffer = ByteBuffer.allocate(length);
                this.got_length = true;
            } else {
                String dns_address = "";
                while (this.buffer.hasRemaining()) {
                    dns_address = String.valueOf(dns_address) + (char)this.buffer.get();
                }
                if (AESocksProxyConnectionImpl.this.disable_dns_lookups) {
                    new proxyStateV5RequestPort(dns_address, null);
                } else {
                    String f_dns_address = dns_address;
                    AESocksProxyConnectionImpl.this.connection.cancelReadSelect(sc);
                    HostNameToIPResolver.addResolverRequest(dns_address, new HostNameToIPResolverListener(this, f_dns_address, sc){
                        final /* synthetic */ proxyStateV5RequestDNS this$1;
                        private final /* synthetic */ String val$f_dns_address;
                        private final /* synthetic */ SocketChannel val$sc;
                        {
                            this.this$1 = proxyStateV5RequestDNS2;
                            this.val$f_dns_address = string;
                            this.val$sc = socketChannel;
                        }

                        public void hostNameResolutionComplete(InetAddress address) {
                            proxyStateV5RequestDNS.access$0(this.this$1).new proxyStateV5RequestPort(this.val$f_dns_address, address);
                            proxyStateV5RequestDNS.access$0((proxyStateV5RequestDNS)this.this$1).connection.requestReadSelect(this.val$sc);
                        }
                    });
                }
            }
        }

        static /* synthetic */ AESocksProxyConnectionImpl access$0(proxyStateV5RequestDNS proxyStateV5RequestDNS2) {
            return proxyStateV5RequestDNS2.AESocksProxyConnectionImpl.this;
        }
    }

    protected class proxyStateV5RequestPort
    extends AESocksProxyState {
        protected String unresolved_address;
        protected InetAddress address;

        protected proxyStateV5RequestPort(String _unresolved_address, InetAddress _address) {
            super(AESocksProxyConnectionImpl.this);
            this.unresolved_address = _unresolved_address;
            this.address = _address;
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(2);
        }

        protected void readSupport(SocketChannel sc) throws IOException {
            if (sc.read(this.buffer) == -1) {
                throw new IOException("read channel shutdown");
            }
            if (this.buffer.hasRemaining()) {
                return;
            }
            this.buffer.flip();
            int port = ((this.buffer.get() & 0xFF) << 8) + (this.buffer.get() & 0xFF);
            AESocksProxyConnectionImpl.this.socks_version = 5;
            AESocksProxyConnectionImpl.this.plugable_connection.connect(new AESocksProxyAddressImpl(this.unresolved_address, this.address, port));
        }
    }

    protected class proxyStateV5Reply
    extends AESocksProxyState {
        protected proxyStateV5Reply() throws IOException {
            super(AESocksProxyConnectionImpl.this);
            AESocksProxyConnectionImpl.this.connection.setWriteState(this);
            byte[] addr = AESocksProxyConnectionImpl.this.plugable_connection.getLocalAddress().getAddress();
            int port = AESocksProxyConnectionImpl.this.plugable_connection.getLocalPort();
            byte[] byArray = new byte[10];
            byArray[0] = 5;
            byArray[3] = 1;
            byArray[4] = addr[0];
            byArray[5] = addr[1];
            byArray[6] = addr[2];
            byArray[7] = addr[3];
            byArray[8] = (byte)(port >> 8 & 0xFF);
            byArray[9] = (byte)(port & 0xFF);
            this.buffer = ByteBuffer.wrap(byArray);
            this.write(AESocksProxyConnectionImpl.this.source_channel);
        }

        protected void writeSupport(SocketChannel sc) throws IOException {
            sc.write(this.buffer);
            if (this.buffer.hasRemaining()) {
                AESocksProxyConnectionImpl.this.connection.requestWriteSelect(sc);
            } else {
                AESocksProxyConnectionImpl.this.plugable_connection.relayData();
            }
        }
    }

    protected class proxyStateClose
    extends AESocksProxyState {
        protected proxyStateClose() throws IOException {
            super(AESocksProxyConnectionImpl.this);
            AESocksProxyConnectionImpl.this.connection.close();
            AESocksProxyConnectionImpl.this.connection.setReadState(null);
            AESocksProxyConnectionImpl.this.connection.setWriteState(null);
            AESocksProxyConnectionImpl.this.connection.setConnectState(null);
        }
    }
}

