/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager;

import com.aelitis.azureus.core.networkmanager.ConnectionOwner;
import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.networkmanager.Transport;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;

public class Connection {
    private final ConnectionOwner owner;
    private final InetSocketAddress remote_address;
    private final Transport transport;
    private ConnectionListener connection_listener;
    private final OutgoingMessageQueue outgoing_message_queue = new OutgoingMessageQueue();
    private boolean is_connected;

    protected Connection(ConnectionOwner _owner, InetSocketAddress _remote_address) {
        this.owner = _owner;
        this.remote_address = _remote_address;
        this.transport = new Transport(this.owner.getTransportOwner());
        this.is_connected = false;
    }

    protected Connection(ConnectionOwner _owner, SocketChannel _remote_channel) {
        this.owner = _owner;
        this.remote_address = new InetSocketAddress(_remote_channel.socket().getInetAddress(), _remote_channel.socket().getPort());
        this.transport = new Transport(this.owner.getTransportOwner(), _remote_channel);
        this.is_connected = true;
    }

    public void connect(ConnectionListener listener) {
        this.connection_listener = listener;
        if (this.is_connected) {
            this.connection_listener.connectSuccess();
            return;
        }
        this.transport.establishOutboundConnection(this.remote_address, new Transport.ConnectListener(){

            public void connectAttemptStarted() {
                Connection.this.connection_listener.connectStarted();
            }

            public void connectSuccess() {
                Connection.this.is_connected = true;
                Connection.this.connection_listener.connectSuccess();
            }

            public void connectFailure(Throwable failure_msg) {
                Connection.this.is_connected = false;
                Connection.this.connection_listener.connectFailure(failure_msg);
            }
        });
    }

    public boolean isConnected() {
        return this.is_connected;
    }

    public void close() {
        this.outgoing_message_queue.destroy();
        this.transport.close();
        this.is_connected = false;
    }

    protected void notifyOfException(Throwable error) {
        if (this.connection_listener != null) {
            this.connection_listener.exceptionThrown(error);
        } else {
            System.out.println("connection_listener == null");
        }
    }

    public OutgoingMessageQueue getOutgoingMessageQueue() {
        return this.outgoing_message_queue;
    }

    protected Transport getTransport() {
        return this.transport;
    }

    public SocketChannel getSocketChannel() {
        return this.transport.getSocketChannel();
    }

    public interface ConnectionListener {
        public void connectStarted();

        public void connectSuccess();

        public void connectFailure(Throwable var1);

        public void exceptionThrown(Throwable var1);
    }
}

