package vars;

require 5.002;

# The following require can't be removed during maintenance
# releases, sadly, because of the risk of buggy code that does
# require Carp; Carp::croak "..."; without brackets dying
# if Carp hasn't been loaded in earlier compile time. :-(
# We'll let those bugs get found on the development track.
require Carp if $] < 5.00450;

use warnings::register;
require strict;

sub import {
    my $callpack = caller;
    my ($pack, @imports, $sym, $ch) = @_;
    foreach $sym (@imports) {
        ($ch, $sym) = unpack('a1a*', $sym);
	if ($sym =~ tr/A-Za-z_0-9//c) {
	    # time for a more-detailed check-up
	    if ($sym =~ /::/) {
		require Carp;
		Carp::croak("Can't declare another package's variables");
	    } elsif ($sym =~ /^\w+[[{].*[]}]$/) {
		require Carp;
		Carp::croak("Can't declare individual elements of hash or array");
	    } elsif (warnings::enabled() and length($sym) == 1 and $sym !~ tr/a-zA-Z//) {
		warnings::warn("No need to declare built-in vars");
            } elsif  ( $^H &= strict::bits('vars') ) {
              Carp::croak("'$ch$sym' is not a valid variable name under strict vars");
	    }
	}
        *{"${callpack}::$sym"} =
          (  $ch eq "\$" ? \$   {"${callpack}::$sym"}
           : $ch eq "\@" ? \@   {"${callpack}::$sym"}
           : $ch eq "\%" ? \%   {"${callpack}::$sym"}
           : $ch eq "\*" ? \*   {"${callpack}::$sym"}
           : $ch eq "\&" ? \&   {"${callpack}::$sym"}
           : do {
		require Carp;
		Carp::croak("'$ch$sym' is not a valid variable name");
	     });
    }
};

1;
__END__

