#include <stdlib.h>	/* for srand48() */
#include <unistd.h>	/* for "access()" */
#include <stdio.h>

#include <Xatom.h>
#include <Xos.h>
#include <Intrinsic.h>
#include <StringDefs.h>
#include <Shell.h>
#include <Xaw/Command.h>
#include <Xaw/Label.h>
#include <Xaw/Form.h>
#include <Composite.h>


#include "defs.h"
#include "externs.h"
#include "game.h"
#include "grades.h"
#include "options.h"
#include "widgets.h"

#include "icon_xbm"

Boolean useKanji[MAXKANJIALLOWED];
int lowfrequency=0,highfrequency=0;

char *usefile=NULL;	/* global pointer that indicates if usefile is
			 * AVAILABLE, not neccessarily that it is used
			 */
char usefilename[100];

Atom wm_message,delete_message;

/*
 * We  must have these resources set!!
 *
 * ( Note the similarity between this stuff and optionDescList[].
 *   coincidence? I think not :-)
 */
static char *fallback[] = {
	"KDrill.options_popupx:		0",
	"KDrill.options_popupy:		-200",
	"KDrill.search_popupx:		400", /* should really be precise,
						but... */
	"KDrill.search_popupy:		0",
	"KDrill.notallT:	0",
	"KDrill.noBell:		0",
	"KDrill*nousefile:	0",
	"KDrill*usefile:	.kanjiusefile", 
	DICTLOCATION,
	"KDrill*kanjifont:	kanji24",
	"KDrill*smallkanji:	kanji16",
	"KDrill*englishfont:	fixed",
	"KDrill*gradelevel:	0",
	"KDrill*guessmeaning:	0",
	"KDrill*showkana:	0",
	"KDrill*lowfrequency:	0",
	"KDrill*highfrequency:	0",
#ifdef OLDLOG
	"KDrill*logfile:	none",
#else
	"KDrill*logfile:	kdrill.log",
#endif
	NULL
};

/* command line arguments should set the appropriate resources.. so we can
 * pull them out when wanted
 */
static XrmOptionDescRec optionDescList[] = {
	{"-notallT",	".notallT",XrmoptionNoArg,"1"},
	{"-usefile",	".usefile",	XrmoptionSepArg,(caddr_t) NULL},
	{"-nousefile",  ".nousefile",	XrmoptionNoArg, "1"},
	{"-dictfile",	".dictfile",	XrmoptionSepArg,(caddr_t) NULL},
	{"-englishfont",".englishfont",	XrmoptionSepArg,(caddr_t) NULL},
	{"-kanjifont",	".kanjifont",	XrmoptionSepArg,(caddr_t) NULL},
	{"-smallkanji",	".smallkanji",	XrmoptionSepArg,(caddr_t) NULL},
	{"-noBell",     ".noBell",	XrmoptionNoArg, "1"},
	{"-guessmeaning",".guessmeaning",XrmoptionNoArg,"1"},
	{"-showkana",   ".showkana",    XrmoptionNoArg,"1"},
	{"-showinorder",   ".showinorder",    XrmoptionNoArg,"1"},
	{"-gradelevel", ".gradelevel",  XrmoptionSepArg,(caddr_t) NULL},
	{"-lowfrequency",	".lowfrequency",XrmoptionSepArg,(caddr_t) NULL},
	{"-highfrequency",	".highfrequency",XrmoptionSepArg,(caddr_t) NULL},
	{"-logfile",	".logfile",	XrmoptionSepArg,(caddr_t) NULL},
	
	
};



/* handle_delete
 *	Its sole purpose is to handle WM_DELETE messages
 */
void
handle_delete(Widget w,XtPointer closure,XEvent *event,Boolean *cont)
{
	XClientMessageEvent *cevent = (XClientMessageEvent *) event;

	if(cevent->type != ClientMessage) return;
	if(cevent->message_type != wm_message) return;
	if(cevent->data.l[0] != delete_message)  return;

	if(w == options_popup){
		OptionsCallback(options_popup,(XtPointer)NULL,(XtPointer)NULL);
		return;
	}
	quit();
	/* NOTREACHED */
}

/* initgc:
 *	Initialises global gc values.
 *      We don't really need this any more. But
 *	GC's are good to have, I suppose.
 */
void initgc(){

	gc =  XCreateGC(display,mainwindow,0,NULL);
	cleargc = XCreateGC(display,mainwindow,0,NULL);

	XSetForeground(display,gc,black);
	XSetBackground(display,gc,white);
	XSetForeground(display,cleargc,white);
	XSetBackground(display,cleargc,black);

}

/* getusefile:
 *	Gets a FILE * to "usefile", to abridge the full dictionary.
 *	If possible, will get it from the user's home directory,
 *	otherwise, tries current directory
 *
 *	This is NOT an exported routine: initusefile() is
 */
FILE *getusefile(){
	FILE *f;
	char *homedir;
	char fullname[100];

	GetXtString("usefile","Usefile",usefilename);
	usefile = usefilename;

#ifdef DEBUG
	puts("");
	printf("usefile from resources is \"%s\"\n",usefilename);
#endif

	if(usefile == NULL) return NULL;
	fullname[0] = '\0';
	if(strncmp(usefile,"~/",2) == 0) {
		homedir = (char *) getenv("HOME");
		if(homedir == NULL){
			perror("Cannot expand '~' char. no HOME env. varriable");
			exit(0);
		}
		sprintf(fullname,"%s%s",homedir,&usefile[1]);
	} else {
		strcpy(fullname,usefile);
	}

	if((f = fopen(fullname,"r")) == NULL){
		printf("%s does not exist. Using entire dictionary...",
		         fullname);
		usefile = NULL;
	} else {
		printf("using \"%s\" to abridge dictionary\n",fullname);
		if(!useUsefile)
			puts("(-nousefile option used. Will not abridge, unless requested.)");
	}
	return f;
}

/* inituse:
 *
 *	revamped from 2.9.3 version.
 *	We now have a dedicated useKanji[] array.
 *
 *	Either set all useKanji elements to 1, or
 *	zero out, and set to specifications of usefile contents.
 *
 *	Then call "getusefile()", and actually read in information
 *	from usefile, if available.
 *
 */

void initusefile(){
	FILE *f;
	char inbuf[100];

	f = getusefile();


#ifndef HAS_MEMSET
	if(usefile == NULL){
		usefilecallback(usefilebutton,NULL,NULL);
		i = MINKANJIALLOWED;
		while(i<MAXKANJIALLOWED){
			useKanji[i++] = 1;
		}
		return;
	} else {	/* set all to UNREADABLE, for now */
#ifdef HAS_BZERO
		bzero(useKanji,sizeof(Boolean[MAXKANJIALLOWED]));
#else
		i = MINKANJIALLOWED;
		while(i<MAXKANJIALLOWED){
			useKanji[i++] = 0;
		}
#endif /* HAS_BCOPY */
#else /*HAS_MEMSET*/

	if(usefile == NULL){
		usefilecallback(usefilebutton,NULL,NULL);
		memset(useKanji,1,sizeof(Boolean[MAXKANJIALLOWED]));
		return;
	} else {	/* set all to UNREADABLE, for now */
		memset(useKanji,0,sizeof(Boolean[MAXKANJIALLOWED]));
	}
#endif /* HAS_MEMSET */

	while(fgets(inbuf,99,f) != NULL){
		int usechar;
		usechar = xtoi(inbuf);
		if( usechar<MAXKANJIALLOWED)
			useKanji[usechar] = 1;
	}
}


/* GetOptions
 *	get resource and command line options
 */
void GetOptions(){
	char tempnumber[10];

	/* set grade bits appropriately */
	parsegrades(tempnumber);

	switchKanaEnglish = !GetXtBoolean("notallT","NotallT");
	useUsefile = !GetXtBoolean("nousefile","Nousefile");
	doBell = !GetXtBoolean("noBell","NoBell");
	showinorder = GetXtBoolean("showinorder","Showinorder");
	if(GetXtBoolean("guessmeaning","Guessmeaning"))
		Kanji2English = GUESSMEANING;

	lowfrequency = GetXtNumber("lowfrequency","Lowfrequency");
	if((lowfrequency <0) || (lowfrequency >=MAXKANJIALLOWED))
		lowfrequency = 0;
	highfrequency = GetXtNumber("highfrequency","Highfrequency");
	if((highfrequency <0) || (highfrequency >=MAXKANJIALLOWED))
		highfrequency = 0;

	GetXtString("gradelevel","Gradelevel",tempnumber);
}


/* this routine is solely for internalizing various
 *  "Atoms" neccessary to handle the stupid WM_DELETE_WINDOW
 *  message
 */
void setup_deletewindow()
{

	wm_message=XInternAtom(display,"WM_PROTOCOLS",False);
	delete_message=XInternAtom(display,"WM_DELETE_WINDOW",False);


        XtAddEventHandler(toplevel, NoEventMask, True,
			     handle_delete, (XtPointer)NULL);
        XChangeProperty(display, mainwindow,
			wm_message, XA_ATOM, 32, PropModeReplace, 
                        (unsigned char *) &delete_message, 1);

	if (wm_message == (Atom) NULL) {
		perror("unable to create wm_message property");
		exit(1);
	}
	if (delete_message == (Atom) NULL) {
		perror("unable to create delete property");
		exit(1);
	}

}

/* initstuffs:
 *	calls the various init routines to setup
 *	GCs, fonts, dictionaries, and widgets
 *	(But initializing the translations is done later)
 */

static Pixmap iconpixmap;

void initstuffs(int *argc,char *argv[])
{
	srand48 (time(NULL));

	toplevel = XtVaAppInitialize(&Context,"KDrill",
 				   optionDescList,XtNumber(optionDescList),
 				   argc,argv,fallback,
 				   NULL,NULL);

	if(*argc >1){
		usage();
	}

	display = XtDisplay(toplevel);

	if(display == NULL) perror("NULL DISPLAY");

	/* Get command line options... yeah, we should do this in a
	 *  struct, in one go... but some things need to be initalized
	 * later
	 */

	GetOptions();

	MakeWidgets();

	XtRealizeWidget(toplevel);

	mainwindow = XtWindow(toplevel);
	if(mainwindow == 0) perror("NULL WINDOW");
	
	setup_deletewindow();

	iconpixmap = XCreateBitmapFromData(display,mainwindow,
			   icon_xbm_bits,icon_xbm_width,icon_xbm_height);

	XtVaSetValues(toplevel,XtNiconName,"kdrill",
			XtNiconPixmap,iconpixmap,NULL);


	white = WhitePixel(display,0);
	black = BlackPixel(display,0);
	initgc();

}

