#ifndef __EXPLORER_WIDGETS_H__
#define __EXPLORER_WIDGETS_H__

/*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer"
 * Copyright 1996. All Rights Reserved.
 * 
 * $RCSfile: ewidgets.h,v $
 *
 * $Revision: 1.5 $
 * 
 * $Author: ruben $ 
 * 
 * $Locker: ruben $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 * 
 * $Log: ewidgets.h,v $
 * Revision 1.5  1997/07/11 11:05:54  ruben
 * moved hidden option to getopt in main()
 *
 * Revision 1.4  1997/06/09 12:59:23  ruben
 * switched rcs commands again I think...
 * compiled with -Wall -Werror, fixed bugs and potential bugs
 * fixed Mister Data bugs
 *
 * Revision 1.3  1997/05/27  09:02:10  ruben
 * Removed CopyProgressDialog pointer as it is no more needed.
 * reworked include strategy for developers ease
 *
 * Revision 1.3  1997/05/27  09:02:10  ruben
 * Removed CopyProgressDialog pointer as it is no more needed.
 * reworked include strategy for developers ease
 *
 * Revision 1.2  1997/04/06 21:34:09  ruben
 * added FileNotify dirchaned object
 *
 * Revision 1.1  1997/03/28 17:48:16  ruben
 * Initial revision
 *
 */

#define ICON_X_SIZE 23
#define ICON_Y_SIZE 22

#include <qapp.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <dirent.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/utsname.h>
#include <string.h>

#include <qgrpbox.h>
#include <qlayout.h>
#include <qmenubar.h>
#include <qpushbt.h>
#include <qfont.h>
#include <qcombo.h>

#include "data_win.h"
#include "dir_tree.h"
#include "file_list.h"

#include "expl_vfsl.h"
#include "menu.h"
#include "dialogs.h"
#include "cpdlg.h"
#include "config_expl.h"
#include "plugin_m.h"
#include "ecommand.h"

#include "vars.h"
// This class is the complete explorer with 2 view panes 

class   ExploreClass:public QWidget
{

        Q_OBJECT

   public:

	ExploreClass(QWidget *, const char *,char *);
	~ExploreClass();

   private:
   
        char tb_show;
        char sb_show;
        char fr_show;
        char pl_show;
        
        CopyProgressDlg *copy_dialog;
        
        QBoxLayout *gm;
        
        QBoxLayout *gm_00,
                   *gm_01,
                   *gm_02,
                   *gm_04, 
                   *gm_03;

	ECommandClass  *frame1;	
	DirectoryFrame *frame2;
	ObjectFrame    *frame3;
	FileFrame      *frame4;

	MountBox *dir_box;

	QPushButton *umount_button;                   
                   
        QPushButton *btn1,
                    *btn2,
                    *btn3,
                    *btn4,
                    *btn5,
                    *btn6,
                    *btn7,
                    *btn8,
                    *btn9,
                    *btn10,
                    *btn11;

	QCursor *move_file_cursor;
	QCursor *move_map_cursor;
	QCursor *move_stop_cursor;

	ExplorerMenu *expl_menu;

	DirTreeContainer  *dirview;
	FileListContainer *fileview;

        OptionsPopup   *mouse_popup;
        OperationPopup *op_popup;

	VFSL_Class     *io_tools;
	EPluginManager *pl_manager;	
	ConfigClass    *explorer_config;
	FileNotify     *dirchanged_notifier;
	
	QLabel *cursor_label;

	void setup_general(void);
	void setup_filesystem(void);
	void signals_n_slots(void);
	void create_controls(char *);
	
	bool validate_operation (FileTreeNode *,
                                 FileTreeNode *);
        
        void copy_list   (FileTreeNode *);
        void move_list   (FileTreeNode *);                
        void remove_list (FileTreeNode *);                        
                                 
        void re_layout (void);

   public  slots:

        void show_toolbar ();   
        void show_statusbar ();
        void show_framebar ();
        void show_pluginview ();
        
        void copy_failed (int);
        void copy_complete ();

	void dragging_and_dropping(bool);
	
	// well here they are the actual functions
		
	void copy_files      (bool);
	void move_files      (bool);
	void op_cancel       (bool);
	
	void delete_files    ();
	void delete_file     (char *,FileTreeNode *);
	void file_properties (const char *,const char *,FileTreeNode *);
	void link_file       (char *);
	
	void create_directory (char *,unsigned long);
	void read_directory   (FileTreeNode *,char *);
	void copy_a_file      (char *,char *);
	void remove_a_file    (char *);
	void remove_a_dir     (char *);
	
	void mouse_movement   (QPoint &);
	
   signals:	
   
   
        void dnd_change (bool);
};






// This class is the browse or file-find dialog widget, it features one 
// pane based on the FileListWidget

class   ExploreFindClass:public QDialog
{

	Q_OBJECT

	public:

	ExploreFindClass(char *, char *, QWidget *, const char *name, bool modal);
	~ExploreFindClass();

	private:

	QCursor * move_file_cursor;
	QCursor *move_map_cursor;
	QCursor *move_stop_cursor;

	ObjectFrame *frame3;
	FileFrame *frame4;

	MountBox *dir_box;

	VFSL_Class *io_tools;
	ConfigClass    *explorer_config;

	void    setup_general(void);
	void    setup_filesystem(char *, char *);
	void    signals_n_slots(void);
	void    create_controls(void);

	public  slots:

	void    dragging_and_dropping(bool);
};

#endif	 // __EXPLORER_WIDGETS_H__
