// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _Url_h_
#define _Url_h_

#include <qstring.h>

//: The Url class parses and stores a Uniform Resource Locator, as specified in RFC1738 and RFC1808.
//. This class can take a partially or fully qualified URL as a string, and parse it
//. into its component parts.  It can also resolve a partially qualified URL to
//. a fully qualified URL using a fully qualified "base" URL.
class Url {
    QString _method;
    QString _user;
    QString _password;
    QString _hostname;
    QString _path;
    QString _fragment;
    QString _query;
    QString _parameters;
    int     _port;

    //. Parse a url given as a text string into its component parts, as per the
    //. algorithm given in RFC1808.  This routine successfully parses all the
    //. test cases mentioned in RFC1808.  This algorithm works for partially
    //. and fully qualified URLs.
    void parseUrl( QString url );
public:
    //. Parse a fully qualified URL.
    Url( const QString absUrl );

    Url( const char* absUrl );

    //. Parse a partially qualified URL, and then resolve it with the given absolute URL.
    Url( const Url* absUrl, const QString relUrl );

    //. Return the fully qualified URL as a string.
    QString url() const;
    
    //. Return the URL's method.
    QString method() const { return _method; }

    //. Return the URL's user name.
    QString user() const { return _user; }

    //. Return the URL's password.
    QString password() const { return _password; }
    
    //. Return the URL's hostname.
    QString hostname() const { return _hostname; }
    
    //. Return the URL's path.
    QString path() const { return _path; }

    //. Set the URL's path.
    void setPath( QString path ) { _path = path; }

    //. Return the URL's fragment.
    QString fragment() const { return _fragment; }

    //. Return the URL's query.
    QString query() const { return _query; }

    //. Set the URL's query.
    void setQuery( QString query ) { _query = query; }

    //. Return the URL's parameters.
    QString parameters() const { return _parameters; }
    
    //. Return the URL's port.
    int port() const { return _port; }

    static void encode( QString& str );
};

#endif
