// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
extern "C" {
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h> 
#include <unistd.h>
}
#include <qdir.h>
#include <qfileinf.h>
#include <qmsgbox.h>
#include "FileConn.h"
#include "Poller.h"

extern int errno;

//=============================================================================
// Public methods.
//-----------------------------------------------------------------------------
FileConn::FileConn( const Url& url ) : Connection( url ), _firstRead( TRUE )
{
//    printf( "FileConn::FileConn()\n" );
}

bool FileConn::open()
{
    QFileInfo info( _url.path().data() );

    if ( !info.isReadable() ) {
        emit startOfData( "text", "html", -1 );
        QString error;
        error.sprintf( "<TITLE>File Not Found</TITLE><H1>File Not Found</H1>Could not open file '%s' for reading.", _url.path().data() );
        emit data( error.data(), error.length() );
        emit endOfData();
        delete this;
        return TRUE;
    } else {
        if ( info.isFile() ) {
            _size = info.size();
            _fd = ::open( _url.path(), O_RDONLY | O_NONBLOCK );
            poller->reg( this, _fd );
            return TRUE;
        } else if ( info.isDir() ) {
            QDir dir( _url.path().data() );
            QFileInfoListIterator i( *dir.entryInfoList() );

            QString tmp;
            QString path;
            emit startOfData( "text", "html", -1 );
            tmp.sprintf( "<TITLE>Directory of %s</TITLE>", _url.path().data() );
            emit data( tmp.data(), tmp.length() );
            emit data( "<TABLE>", 7 );
            emit data( "<TR><TD><B>Filename</B><TD><B>Size</B>", 39 );
            for ( i.toFirst(); i.current(); ++i ) {
                emit data( "<TR>", 4 );
                emit data( "<TD>", 4 );
                path = dir.absPath();
                if ( path.right( 1 ) != "/" ) {
                    path += "/";
                }
                path += i.current()->fileName();
                path = QDir::cleanDirPath( path );
                tmp.sprintf( "<A HREF=\"file:%s\">%s</A>", path.data(), i.current()->fileName().data() );
                emit data( tmp.data(), tmp.length() );
                emit data( "<TD>", 4 );
                tmp.sprintf( "%d", i.current()->size() );
                emit data( tmp.data(), tmp.length() );
                emit data( "</TR>", 5 );
            }
            emit data( "</TABLE>", 8 );
            emit endOfData();
            delete this;
            return TRUE;
        } else {
            emit startOfData( "text", "html", -1 );
            QString error;
            error.sprintf( "<TITLE>Unsupported File Type</TITLE><H1>Unsupported File Type</H1>'%s' is neither a file nor a directory.", _url.path().data() );
            emit data( error.data(), error.length() );
            emit endOfData();
            delete this;
            return TRUE;
        }
    }
}

//=============================================================================
// Public slots.
//-----------------------------------------------------------------------------
void FileConn::readable()
{
    int length;

    if ( _firstRead ) {
        _firstRead = FALSE;
        QString mediaType;
        QString mediaSubtype;
        guessFileType( mediaType, mediaSubtype );
        emit startOfData( mediaType, mediaSubtype, _size );
    }
    
    if ( ( length = read( _fd, _bytes, 1024 ) ) < 0 ) {
        abort();
        emit endOfData();
        delete this;
//        printf( "FileConn::readable(%d) -- read() failed, errno = %d\n", _fd, errno );
    } else {
        if ( length > 0 ) {
            emit data( _bytes, length );
        } else {
            poller->dereg( this, _fd );
            emit endOfData();
            delete this;
        }
    }
}
