// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _History_h_
#define _History_h_

#include <qobject.h>
#include <qstring.h>
#include <qlist.h>
#include "Url.h"

class QPopupMenu;

//: The History class keeps track of visited URLs for a single Browser.
class History : public QObject {
    Q_OBJECT
    QList<QString> _titles;
    QList<Url>     _urls;
    QPopupMenu*    _menu;

    //. Make the history menu reflect the current browser history.
    void updateMenu();
public:
    //. Create a new URL history.  The given popup menu is managed by the
    //. History object.
    History( QPopupMenu* menu );

    //. Destroy history.
    ~History();

    //. Return the URL of the current history item, if any.
    const Url* current();

    //. Truncate the history at the current position, then append the home URL
    //. as a new history item.
    const Url* home();

    //. Return the previous history item.
    const Url* back();

    //. Return the next history item.
    const Url* forward();

    //. Truncate the history at the current position, then append the given URL
    //. as a new history item.
    const Url* open( const Url& url );

    //. Return the URL of the history item at the given index, if any.
    const Url* go( int index );

    //. This function changes the title of the current history item.
    void setTitle( QString title );
signals:
    //. This signal tells a browser whether to enable or disable the backward
    //. button and menu entry.
    void canGoBack( bool b );

    //. This signal tells a browser whether to enable or disable the forward
    //. button and menu entry.
    void canGoForward( bool b );
};

#endif
