// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _CatalogEntry_h_
#define _CatalogEntry_h_

#include <qstring.h>

//: The CatalogEntry class encapsulates a single entry in the SgmlCatalog.
//. Each catalog entry has a type, a public identifier, and a storage object
//. identifier.  The type tells whether the entry is for a document type
//. declaration, a style sheet, or an SGML entity.  The public identifier
//. is the symbolic name, and the storage object idnentifier gives the
//. actual physical location of the data.
class CatalogEntry {
public:
    enum Type {
        Doctype,
        Entity,
        Style
    };
private:
    Type    _type;
    QString _id;
    QString _soi;
public:
    //. Create a new CatalogEntry of the given type, and with the given
    //. public identifer and storage object identifier.
    CatalogEntry( Type type, const QString id, const QString soi );

    //. Return the type of this catalog entry.  The supported types are:
    //. <DL>
    //. <DT>Doctype<DD>Document type declaration.
    //. <DT>Entity<DD>A generic SGML entity, usually included into a DTD.
    //. <DT>Style<DD>A style sheet.
    //. </DL>
    Type type() const { return _type; }

    //. Return the public identifier for the catalog entry.  Doctype and Style
    //. entries that have the same public identifier are directly associated.
    //. That means that when rendering a document of type "foo", we use the
    //. style sheet with a public identifier of "foo".
    const QString id() const { return _id; }

    //. Return the Storage Object Identifier.  This is the location of the
    //. actual data.  This will always be a URL.
    const QString soi() const { return _soi; }

    //. Set the Storage Object Identifer for the entry.
    void soi( const QString str ) { _soi = str.copy(); }
};

#endif
