// fieldsel.C
//
// This program is free software. See the file COPYING for details.
// Author: Mattias Engdegrd, 1997, 1998

#include <qpushbt.h>
#include <qlabel.h>
#include <qaccel.h>
#include "fieldsel.h"

FieldSelect::FieldSelect(Procview *pv, Proc *proc)
            : QDialog(0, "select fields"),
	      nbuttons(proc->cats.size()),
	      disp_fields(nbuttons),
	      procview(pv)
{
    const int vspace = 18;		// vertical distance between boxes
    const int dlg_middle = 380;

    updating = FALSE;
    setCaption("qps: select fields");
    buts = new CrossBox*[nbuttons];

    int half = (nbuttons + 1) / 2;
    for(int i = 0; i < nbuttons; i++) {
	CrossBox *but = new CrossBox(proc->cats[i]->name, this);
	QLabel *desc = new QLabel(proc->cats[i]->help, this);
 	but->adjustSize();
	if(i < half)
	    but->setGeometry(8, 8 + i * vspace, 80, but->height());
	else
	    but->setGeometry(dlg_middle, 8 + (i - half) * vspace,
			     80, but->height());
	desc->setGeometry(but->x() + but->width(), but->y(),
			  300, but->height());
	buts[i] = but;
	connect(but, SIGNAL(toggled(bool)), this, SLOT(field_toggled(bool)));
    }
    update_boxes();

    QPushButton *closebut = new QPushButton("Close", this);
    closebut->setDefault(TRUE);
    closebut->adjustSize();
    resize(2 * dlg_middle,
	   8 + (half + 1) * vspace + 4 + closebut->height() + 4);
    closebut->move(dlg_middle - closebut->width() / 2,
		   height() - closebut->height() - 4);

    connect(closebut, SIGNAL(clicked()), SLOT(closed()));

    QAccel *acc = new QAccel(this);
    acc->connectItem(acc->insertItem(ALT + Key_W),
		     this, SLOT(closed()));
}

// one of the fields was toggled (we don't know which one yet)
void FieldSelect::field_toggled(bool)
{
    if(updating) return;
    set_disp_fields();
    for(int i = 0; i < nbuttons; i++)
	if(buts[i]->isChecked() != disp_fields.testBit(i))
	    if(buts[i]->isChecked())
		emit added_field(i);
	    else
		emit removed_field(i);
}

void FieldSelect::closed()
{
    hide();
}

void FieldSelect::closeEvent(QCloseEvent *)
{
    closed();
}

void FieldSelect::set_disp_fields()
{
    disp_fields.fill(FALSE);
    int n = procview->cats.size();
    for(int i = 0; i < n; i++)
	disp_fields.setBit(procview->cats[i]->index);
}

void FieldSelect::update_boxes()
{
    set_disp_fields();
    updating = TRUE;
    for(int i = 0; i < nbuttons; i++)
	buts[i]->setChecked(disp_fields.testBit(i));
    updating = FALSE;
}


