// checkmenu.C
//
// This program is free software. See the file COPYING for details.
// Author: Mattias Engdegrd, 1997, 1998

// a version of QPopupMenu where checked items look better in Motif
// This doesn't look well with all fonts (designed for Helvetica Bold 12 at
// 75dpi).

// In WindowsStyle the behaviour is identical to that of QPopupMenu.

#include "checkmenu.h"
#include <qfontmet.h>

// Motif style parameters (snarfed from Qt sources)

static const int motifItemFrame		= 2;	// menu item frame width
static const int motifItemHMargin	= 3;	// menu item hor text margin
static const int motifItemVMargin	= 2;	// menu item ver text margin

CheckMenu::CheckMenu(QWidget *parent, const char *name)
          : QPopupMenu(parent, name)
{}

void CheckMenu::paintCell(QPainter *p, int row, int col)
{
    int id = idAt(row);
    // only do this if we're in Motif mode
    if(col == 0 && isItemChecked(id) && style() == MotifStyle) {
	int ch = cellHeight(row);

	int x0 = motifItemFrame + motifItemHMargin;
	int y0 = motifItemVMargin;

	QFontMetrics fm = fontMetrics();
	// let the tick be an M wide and go from baseline to ascent
	int w = fm.width('M');
	int h = fm.height();
	int a = fm.ascent() - 4;
	y0 += (ch - h) / 2 + 1;

	// this is tuned for Helvetica Bold 12, but should work otherwise too
	if(font().bold())
	    p->setPen(QPen(colorGroup().text(), 2));
	p->drawLine(x0, y0 + a * 2 / 3, x0 + w / 3, y0 + a);
	p->drawLine(x0 + w / 3, y0 + a, x0 + w, y0);
    } else
	QPopupMenu::paintCell(p, row, col);
}

