/* Output from p2c 1.21alpha-07.Dec.93, the Pascal-to-C translator */
/* From input file "mtx.pas" */


#include "cfuncs.h"


#define MTX_G
#include "mtx.h"


#ifndef GLOBALS_H
#include "globals.h"
#endif

#ifndef MTXLINE_H
#include "mtxline.h"
#endif

#ifndef STRINGS_H

#endif

#ifndef STATUS_H
#include "status.h"
#endif


#define dot             '.'
#define comma           ','
#define dotcode         'd'

#define flagged         "8136"

#define crotchet        16

#define has_duration    "abcdefgr"
#define note_names      "abcdefg"

#define rest_           'r'
#define tex_escape      '\\'
#define unspecified     '5'   /* Not a valid duration */


typedef boolean sticky['z' + 1 - 'a'];


static short count64['9' + 1 - '0'] = {
  64, 4, 32, 2, 16, 0, 1, 0, 8, 128
};

static sticky note_attrib[maxvoices], rest_attrib[maxvoices];


boolean isNoteOrRest(char *w)
{
  return (pos1(w[0], has_duration) > 0);
}


boolean isPause(char *note)
{
  return (startsWith(note, pause));
}


static short logTwo(short denom)
{
  short l = 0;

  while (denom > 1) {
    l++;
    denom /= 2;
  }
  return l;
}


static boolean dotted(short n)
{
  boolean Result;

/* p2c: mtx.pas: Note: Eliminated unused assignment statement [338] */
  if (n == 0)
    return false;
  if (n != n / 3 * 3)
    return false;
  n /= 3;
  while ((n & 1) == 0)
    n /= 2;
  return (n == 1);
}


/* RESTS should have a third parameter OFFSET.  At present we in effect
   assume OFFSET+LENGTH to be a multiple of METERDENOM. */
char *rests(char *Result, short len, short meterdenom, boolean blind)
{
  char r[256], bl[256];
  char STR1[256];

  if (blind)
    strcpy(bl, "b");
  else
    *bl = '\0';
  if (len == 0)
    return strcpy(Result, "");
  else {
    if (len == meterdenom * 128) {
      sprintf(Result, "r9%s ", bl);
      return Result;
    } else {
      if (dotted(len)) {
	rests(r, len - len / 3, meterdenom, false);
	r[2] = 'd';
	sprintf(Result, "%s%s ", r, bl);
	return Result;
      } else if (len >= 64 / meterdenom) {
	sprintf(Result, "%sr%c%s ",
		rests(STR1, len - 64 / meterdenom, meterdenom, blind),
		durations[whole + logTwo(meterdenom) - 1], bl);
	return Result;
      } else
	return (rests(Result, len, meterdenom * 2, blind));
    }
  }
}


static void extractDurationCode(char *note, char *code)
{
  short i = 2;
  short l;
  char term[256];

  *code = unspecified;
  l = strlen(note);
  strcpy(term, terminators);
  if (note[0] == 'r')
    strcat(term, "+-");
  if (l < 2 || !isNoteOrRest(note))
    return;
  while (i <= l) {
    if (pos1(note[i-1], durations) > 0) {
      *code = note[i-1];
      delete1(note, i);
      return;
    }
    if (pos1(note[i-1], term) > 0)
      return;
    i++;
  }
}


static char durationCode(char *note_)
{
  char note[256];
  char code;

  strcpy(note, note_);
  extractDurationCode(note, &code);
  return code;
}


static char half(char dur)
{
  char Result;
  short k;
  char STR1[20];
  char STR2[24];

  k = pos1(dur, durations);
  Result = dur;
  if (k == 0) {
    sprintf(STR1, "Invalid duration %c", dur);
    error(STR1, print);
    return Result;
  }
  if (k <= ndurs)
    return (durations[k]);
  sprintf(STR2, "%c is too short to halve", dur);
  error(STR2, print);
  return Result;
}


typedef enum {
  solitary, three_one, two_one
} grouptype;


/* static variables for expand: */
struct LOC_expand {
  char *note, *xnote;
  char *dur;
  char note1[256];
  grouptype group;
} ;

static void dotme(struct LOC_expand *LINK)
{
  char STR1[256];

  if (split_dots)
    *LINK->dur = half(*LINK->dur);
  if (LINK->group == two_one)
    GetNextWord(LINK->note1, LINK->note, comma, dummy);
  else
    sprintf(LINK->note1, "%s%c",
	    GetNextWord(STR1, LINK->note, dot, dummy), dotcode);
  addDuration(LINK->note1, LINK->dur);
  *LINK->dur = half(*LINK->dur);
  addDuration(LINK->note, LINK->dur);
  strcpy(LINK->xnote, LINK->note);
  strcpy(LINK->note, LINK->note1);
}


/* Expand dot groups */
static void expand(char *note_, char *xnote_, char dur1, char *dur_)
{
  struct LOC_expand V;
  short k;
  char dur2;

  V.note = note_;
  V.xnote = xnote_;
  V.dur = dur_;
  *V.xnote = '\0';
  if (*V.note == '\0' || !isNoteOrRest(V.note) || isPause(V.note))
    return;
  extractDurationCode(V.note, &dur2);
  if (dur2 == unspecified)
    *V.dur = dur1;
  else
    *V.dur = dur2;
  k = pos1(dot, V.note);
  if (k > 0)
    V.group = three_one;
  else {
    k = pos1(comma, V.note);
    if (k > 0)
      V.group = two_one;
    else
      V.group = solitary;
  }
  if (k == strlen(V.note))
    error("Note may not end in dot or comma", print);
  else if (V.group != solitary) {
    if (tonic_solfa)
      translateSolfa(&V.note[k]);
    if (pos1(V.note[k], note_names) == 0)
      error("Dot or comma must be followed by notename", print);
  }
  if (V.group == solitary)
    insertchar(*V.dur, V.note, 2);
  else
    dotme(&V);
}


static char *attribs(char *Result, char *note)
{
  char a[256];
  short i = 2;
  short l;
  char n;

  *a = '\0';
  l = strlen(note);
  while (i <= l) {
    n = note[i-1];
    if (n == 'x')
      i = l;
    else if (islower(n))
      sprintf(a + strlen(a), "%c", n);
    i++;
  }
  return strcpy(Result, a);
}


static void checkSticky(char *note, boolean *attrib)
{
  short i = 2;
  short l;
  char c;
  char a[256];

  if (*note == '\0')
    return;
  l = strlen(note);
  while (i <= l) {
    c = note[i-1];
    if (islower(c)) {
      if (i < l && note[i] == ':') {
	delete1(note, i + 1);
	l--;
	attrib[c - 'a'] = !attrib[c - 'a'];
      } else
	attrib[c - 'a'] = false;
    }
    i++;
  }
  attribs(a, note);
  for (c = 'z'; c >= 'a'; c--) {
    if (attrib[c - 'a'] && pos1(c, a) == 0)
      insertchar(c, note, 3);
  }
}


void extendRest(char *rest, short voice)
{
  SetDuration(rest, voice);
}


void checkOctave(char *note, short voice)
{
  short i;

  i = pos1('=', note);
  if (i > 0) {
    delete1(note, i);
    setOctave(voice);
  }
  if (octave(voice) == blank)
    return;
  i = 2;
  do {
    if (note[i-1] == '+' || note[i-1] == '-') {
      newOctave(voice, note[i-1]);
      delete1(note, i);
    } else if (pos1(note[i-1], terminators) > 0)
      i = strlen(note);
    i++;
  } while (i <= strlen(note));
  insertchar(octave(voice), note, 3);
  resetOctave(voice);
}


void markDebeamed(char *note, short voice)
{
  if (isVocal(voice) && afterSlur(voice) == 0 && unbeam_if_vocal &&
      pos1(duration(voice), flagged) > 0)
    insertchar('a', note, 2);
}


short l64(char *note)
{
  return (count64[durationCode(note) - '0']);
}


short noteLength(char *note, short voice)
{
  short Result = 0, i = 2;
  short l, nl, tnl;
  char dur1, dur2;
  char STR1[256];

  dur1 = duration(voice);
  if (*note == '\0')
    return Result;
  if (isPause(note))
    return full_bar;
  if (!isNoteOrRest(note))
    return Result;
  dur2 = durationCode(note);
  if (dur2 != unspecified)
    dur1 = dur2;
  nl = count64[dur1 - '0'];
  tnl = nl;
  l = strlen(note);
  while (i <= l) {
    sprintf(STR1, "%c", dotcode);
    if (pos1(note[i-1], STR1) > 0) {
      nl /= 2;
      tnl += nl;
    } else if (pos1(note[i-1], terminators) > 0)
      i = l;
    i++;
  }
  if (pos1(dot, note) > 0)
    tnl += tnl;
  else if (pos1(comma, note) > 0)
    tnl += tnl / 2;
  return tnl;
/* p2c: mtx.pas: Note: Deleting unreachable code [255] */
}


static short barLength(char *meter)
{
  short n1, n2, pn1, pn2;

  readMeter(meter, &n1, &n2, &pn1, &pn2);
  return (n1 * (64 / n2));
}


static void checkMultiBarRest(char *rest)
{
  if (strlen(rest) < 3)
    return;
  if (rest[1] != 'm')
    return;
  if (multi_bar_rest)
    error("Only one multibar rest allowed per line", print);
  multi_bar_rest = true;
}


/* static variables for scanMusic: */
struct LOC_scanMusic {
  short voice;
  char note[256];
  boolean beam_next;
  short bar, bar_length, dotme, i, l, nl, ngrace, nmulti;
  char dur1, dur2;
} ;

/* static variables for countIt: */
struct LOC_countIt {
  struct LOC_scanMusic *LINK;
} ;

static void incbar(short nl, struct LOC_countIt *LINK)
{
  LINK->LINK->bar_length += nl;
  if (LINK->LINK->bar_length > LINK->LINK->bar && meternum > 0)
    error3(LINK->LINK->voice, "Bar end occurs in mid-note");
}

static void countIt(struct LOC_scanMusic *LINK)
{
  struct LOC_countIt V;
  boolean dotadd;
  char STR1[256];

  V.LINK = LINK;
  if (LINK->ngrace > 0) {
    LINK->ngrace--;
    return;
  }
  if (LINK->nmulti > 0) {
    LINK->nmulti--;
    return;
  }
  LINK->dur2 = durationCode(LINK->note);
  if (LINK->dur2 != unspecified)
    LINK->dur1 = LINK->dur2;
  LINK->nl = count64[LINK->dur1 - '0'];
  incbar(LINK->nl, &V);
  if (pos1(comma, LINK->note) > 0)
    incbar(LINK->nl / 2, &V);
  else {
    if (pos1(dot, LINK->note) > 0)
      LINK->dotme = 2;
    else
      LINK->dotme = 1;
    if (!split_dots && LINK->dotme == 2) {
      LINK->dotme = 1;
      incbar(LINK->nl, &V);
    }
    LINK->l = strlen(LINK->note);
    LINK->i = 2;
    dotadd = false;
    while (LINK->i <= LINK->l) {
      sprintf(STR1, "%c", dotcode);
      if (pos1(LINK->note[LINK->i-1], STR1) > 0) {
	LINK->nl /= 2;
	incbar(LINK->nl, &V);
	dotadd = true;
      } else if (pos1(LINK->note[LINK->i-1], terminators) > 0)
	LINK->i = LINK->l;
      LINK->i++;
    }
  }
  if (!dotadd &&
      (LINK->note[0] != rest_ && note_attrib[LINK->voice-1]['d' - 'a'] ||
       LINK->note[0] == rest_ && rest_attrib[LINK->voice-1]['d' - 'a'])) {
    LINK->nl /= 2;
    incbar(LINK->nl, &V);
  }
  /* ------------ did you forget duration under beam? ------------ */
  if (LINK->beam_next && LINK->nl / LINK->dotme >= crotchet)
    warning("Note under beam has length 1/4 or more", print);
  LINK->beam_next = false;
  /* ------------------------------------------------------------- */
  LINK->l = pos1(multi_group, LINK->note);
  if (LINK->l <= 0)
    return;
  predelete(LINK->note, LINK->l);
  getNum(LINK->note, &LINK->nmulti);
  LINK->nmulti--;
}

static void maybeGroup(struct LOC_scanMusic *LINK)
{
  switch (LINK->note[0]) {

  case start_beam:
    LINK->beam_next = true;
    break;

  case grace_group:
    if (strlen(LINK->note) == 1)
      LINK->ngrace = 1;
    else
      LINK->ngrace = pos1(LINK->note[1], digits);
    /* bug if ngrace>9 */
    if (LINK->ngrace > 0)
      LINK->ngrace--;
    break;
  }
}


void scanMusic(short voice_, short *l1)
{
  struct LOC_scanMusic V;
  char buf[256], enote[256], xnote[256];
  boolean has_next = false, done = false;
  char lastdur;
  music_word nscan;
  char STR1[256];

  V.voice = voice_;
  if (extended_dots)
    strcpy(terminators, "d.x");
  resetInfo(V.voice, buf);
  *l1 = 0;
  V.bar = full_bar;
  V.bar_length = 0;
  V.ngrace = 0;
  V.nmulti = 0;
  if (meternum == 0)
    V.bar = 32000;
  V.dur1 = duration(V.voice);
  lastdur = V.dur1;
  V.beam_next = false;
  do {
    getNextMusWord(buf, V.note, &nscan);
    if (nscan == mword) {
      if (V.bar_length > 0)
	error3(V.voice, "Meter change only allowed at start of bar");
      else
	V.bar = barLength(V.note);
    }
    if (nscan == rword) {
      checkMultiBarRest(V.note);
      if (!(isPause(V.note) || multi_bar_rest)) {
	expand(V.note, xnote, V.dur1, &lastdur);
	checkSticky(V.note, rest_attrib[V.voice-1]);
      }
    }
    if (*V.note != '\0')
      appendNote(V.voice, nscan);
    strcpy(enote, V.note);
    if (nscan == abcdefg) {
      if (!multi_bar_rest && V.ngrace + V.nmulti == 0) {
	expand(enote, xnote, V.dur1, &lastdur);
	if (*xnote != '\0') {
	  checkSticky(enote, note_attrib[V.voice-1]);
	  appendToLine(V.voice, enote);
	  appendNote(V.voice, nscan);
	  strcpy(enote, xnote);
	}
	checkSticky(enote, note_attrib[V.voice-1]);
      }
    }
    appendToLine(V.voice, enote);
    if (*V.note == '\0')   /* !!! else word_bound[here]:=length(line); */
      done = true;
    sprintf(STR1, "%c", barsym);
    if (!strcmp(V.note, STR1)) {
      if (meternum == 0)
	error3(V.voice, "You may not use bar lines in barless music");
      else if (V.bar_length == 0)
	markBar(V.voice);
      else if (numberOfBars(V.voice) == 0 && V.bar_length < V.bar) {
	if (has_next)
	  has_next = false;   /*Should check whether pickups are equal*/
	else if (*l1 > 0)
	  error3(V.voice, "Bar is too short");
	*l1 = V.bar_length;
	V.bar_length = 0;
      }
    }
    if (nscan == nextvoice) {
      if (V.bar_length > 0)
	error3(V.voice, "Next voice before bar is full");
      else
	barForward(V.voice, -1);
      has_next = true;
    } else if (isPause(V.note))
      V.bar_length += V.bar;
    else if (!multi_bar_rest) {   /*do nothing*/
      if (!done && isNoteOrRest(V.note))
	countIt(&V);
      else
	maybeGroup(&V);
    }
    if (V.bar_length >= V.bar && V.ngrace + V.nmulti == 0) {
      barForward(V.voice, V.bar_length / V.bar);
      V.bar_length %= V.bar;
/* p2c: mtx.pas, line 351:
 * Note: Using % for possibly-negative arguments [317] */
    }
  } while (!done);
  setExtraLength(V.voice, V.bar_length);
  if (V.dur1 != lastdur)
    warning("Explicit duration probably needed in next paragraph", print);
  regroup(V.voice);
}


void initMTX(void)
{
  short i;
  char j;

  for (i = 0; i <= maxvoices - 1; i++) {
    for (j = 'a'; j <= 'z'; j++)
      note_attrib[i][j - 'a'] = false;
  }
  memcpy(rest_attrib, note_attrib, maxvoices * sizeof(sticky));
}




/* End. */
