#ifndef FilterDialog_h
#define FilterDialog_h

#include <math.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <sidplay/emucfg.h>

#include "FilterDialogData.h"
#include "GlobalIcon.h"

class FilterDialog : public FilterDialogData
{
    Q_OBJECT

public:

    FilterDialog(QWidget* parent = NULL, const char* name = NULL);

    void setConfig(const emuConfig&);
    void setConfigDefault(const emuConfig&);
    
    void paintFilterFunc();
	
 public slots:

    void receiveConfig(const emuConfig&);

 protected:

    emuConfig config;
    emuConfig configDefault;

    void paintEvent(QPaintEvent *);

 private:
    
    void setButtons();
    void setSliderValues();

    bool changedSignalEnabled;
    void enableChangedSignal(bool);
    void emitChangedIfEnabled();

 protected slots:

    void updatePara1(int);
    void updatePara2(int);
    void updatePara3(int);
    void setFilterFlag(bool);
    void setDefaults();
 
 signals:

    void changed(const emuConfig&);
		
};

#endif  // FilterDialog_h
