#include "FilterDialog.h"
#include "images/filticon.xpm"

#define Inherited FilterDialogData

FilterDialog::FilterDialog(QWidget* parent, const char* name) : Inherited(parent,name)
{
    setCaption("Filter Adjustment");
    setFixedSize(width(),height());
    setIcon(*myMainIcon);

    enableChangedSignal(true);
    setButtons();
    paintFilterFunc();
}

void FilterDialog::enableChangedSignal(bool val)
{
    changedSignalEnabled = val;
}

void FilterDialog::emitChangedIfEnabled()
{
    if (changedSignalEnabled)
    {
        emit changed(config);
    }
}

void FilterDialog::setConfig(const emuConfig& inConfig)
{
    enableChangedSignal(false);
    config = inConfig;
    setButtons();
    enableChangedSignal(true);
}

void FilterDialog::setConfigDefault(const emuConfig& inConfig)
{
    configDefault = inConfig;
}

void FilterDialog::receiveConfig(const emuConfig& inConfig)
{
    // Check flags that can be set from other dialogs.
    if (config.emulateFilter != inConfig.emulateFilter)
    {
        config = inConfig;
        // Make sure we do not send values because we are the receiver.
        enableChangedSignal(false);
        isEnabled->setChecked(inConfig.emulateFilter);
        isEnabled->repaint(false);
        enableChangedSignal(true);
    }
}

void FilterDialog::setButtons()
{
    isEnabled->setChecked(config.emulateFilter);
    setSliderValues();
}

void FilterDialog::setSliderValues()
{
    para1Sld->setValue((int)((config.filterFs/6.0-1.0)));
    para2Sld->setValue((int)(config.filterFm-1.0));
    para3Sld->setValue((int)(config.filterFt*100.0));
}

void FilterDialog::updatePara1(int index)
{
    config.filterFs = 1.0+index*6.0;
    emitChangedIfEnabled();
}

void FilterDialog::updatePara2(int index)
{
    config.filterFm = 1.0+index;
    emitChangedIfEnabled();
}

void FilterDialog::updatePara3( int index )
{
    config.filterFt = index/100.0;
    emitChangedIfEnabled();
}

void FilterDialog::setDefaults()
{
    // Don't copy the full emuConfig because the rest of the default
    // doesn't get updated.
    config.emulateFilter = configDefault.emulateFilter;
    config.filterFs = configDefault.filterFs;
    config.filterFm = configDefault.filterFm;
    config.filterFt = configDefault.filterFt;

    setSliderValues();
    emitChangedIfEnabled();
}

void FilterDialog::setFilterFlag(bool val)
{
    if (val != config.emulateFilter)
    {
        config.emulateFilter = val;
        emitChangedIfEnabled();
    }
}

void FilterDialog::paintFilterFunc()
{
    QPixmap myFiltPic(filticon);
    QPainter paintBuf;
    paintBuf.begin(&myFiltPic);
    QColor myPenColor(0,0,255);  // rgb
    paintBuf.setPen(myPenColor);
    extern float filterTable[0x800];  // the only way
    for (int i=0; i<0x800; i++)
    {
        paintBuf.drawPoint((int)(i/15.75),(int)(filterTable[i]*100.0));
    }
    paintBuf.end();

    QPainter paint(this);
    paint.drawPixmap(220,0,myFiltPic);
}

void FilterDialog::paintEvent(QPaintEvent *)
{
    paintFilterFunc();
}
