#include "EmuDialog.h"
#define Inherited EmuDialogData

EmuDialog::EmuDialog(QWidget* parent, const char* name)	: Inherited(parent,name)
{
    setCaption( "Emulation" );
    setFixedSize(width(),height());
    setIcon(*myMainIcon);

    enableChangedSignal(true);
    setButtons();
}

void EmuDialog::enableChangedSignal(bool val)
{
    changedSignalEnabled = val;
}

void EmuDialog::emitChangedIfEnabled()
{
    if (changedSignalEnabled)
        emit changed(config);
}

void EmuDialog::setConfig(const emuConfig& inConfig)
{
    // Copy without verification.
    config = inConfig;
    // Make sure we do not send values because we are the receiver.
    enableChangedSignal(false);
    setButtons();
    enableChangedSignal(true);
}

void EmuDialog::receiveConfig(const emuConfig& inConfig)
{
    // Check flags that can be set from other dialogs.
    if (config.emulateFilter != inConfig.emulateFilter)
    {
        config = inConfig;
        // Make sure we do not send values because we are the receiver.
        enableChangedSignal(false);
        SIDfilter->setChecked(inConfig.emulateFilter);
        SIDfilter->repaint();
        enableChangedSignal(true);
    }
}

const emuConfig& EmuDialog::getConfig() const
{
    return config;
}

void EmuDialog::setButtons()
{
    SIDfilter->setChecked(config.emulateFilter);
    measVol->setChecked(config.measuredVolume);
    mos8580->setChecked(config.mos8580);
    forceSS->setChecked(config.forceSongSpeed);
	
    fullBS->setChecked(config.memoryMode==MPU_BANK_SWITCHING);
    transROM->setChecked(config.memoryMode==MPU_TRANSPARENT_ROM);
    psidEnv->setChecked(config.memoryMode==MPU_PLAYSID_ENVIRONMENT);

    clockPAL->setChecked(config.clockSpeed==SIDTUNE_CLOCK_PAL);
    clockNTSC->setChecked(config.clockSpeed==SIDTUNE_CLOCK_NTSC);
}

void EmuDialog::newEMUsetting(int)
{
    config.emulateFilter = SIDfilter->isChecked();
    config.mos8580 = mos8580->isChecked();
    config.measuredVolume = measVol->isChecked();
    config.forceSongSpeed = forceSS->isChecked();
    emitChangedIfEnabled();
}

void EmuDialog::newMPUsetting(int)
{
    if (fullBS->isChecked())
        config.memoryMode = MPU_BANK_SWITCHING;
    else if (transROM->isChecked())
        config.memoryMode = MPU_TRANSPARENT_ROM;
    else  // if (psidEnv->isChecked())
        config.memoryMode = MPU_PLAYSID_ENVIRONMENT;
    emitChangedIfEnabled();
}

void EmuDialog::newCLKsetting(int)
{
    if (clockPAL->isChecked())
        config.clockSpeed = SIDTUNE_CLOCK_PAL;
    else  // if (clockNTSC->isChecked())
        config.clockSpeed = SIDTUNE_CLOCK_NTSC;
    emitChangedIfEnabled();
}
