/***************************************************************************
**    xIrc.cpp  $Revision: 1.26 $ - $Name: V2-0 $ 
**    IRC Client Main Line code
**
** Copyright (C) 1995, 1996  Joseph Croft <jcroft@unicomp.net>  
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
 ***************************************************************************/
#include <qapp.h>

#include <xFileDialog.h>

#include <qpainter.h>
#include <qwindefs.h>
#include <qfontinf.h>
#include <qpixmap.h>
#include <qbuffer.h>
#include <qimage.h>
#include <qstring.h>
#include <qobject.h>
#include <qevent.h>
#include <qtimer.h>
#include <qkeycode.h>

#include <qlined.h>
#include <qlabel.h>
#include <qdialog.h>

#include <stdlib.h>
#include <stdio.h>
#include <xMessageBox.h>
#include <xGauge.h>

#include "xIrcConnect.h"
#include "xIrcMsgDispatch.h"
#include "xIrcNickQuery.h"
#include "xIrcNickCombo.h"
#include "xLineEditQuery.h"
#include "xIrcServerQuery.h"
#include "xIrcChannelQuery.h"
#include <xApp.h>
#include <xResources.h>
#include <xDefaults.h>
#include <xMisc.h>

static int dbg = 0;

xIrcConnect *pTWindow = NULL;
xChannelQuery *ChanQuery = NULL;
xIrcNickQuery *NickQuery = NULL;
xLineEditQuery *KickQuery = NULL;
xLineEditQuery *QuitQuery = NULL;
xServerQuery *ServQuery = NULL;
xWidgetResInfo appRes(NULL, QString("xirc"), QString("XIRC"));
QPixmap *AppPixMap;

xIrcMsgDispatch Dispatcher;

xDefaults Defaults;
xApplication *pApp = NULL;
QEvent qEvt(-1);

static const char *pInitialResources[] =
{
   "XIRC*PixMap: xIrc.ppm",
   "XIRC*PixMapPath: ./;~/;/usr/local/lib;",
   "XIRC*Font.Family: Helvetica",
   "XIRC*Font.Size: 12",
   "XIRC*Font.Weight: normal",
   "XIRC*Menu.Font.Weight: Bold",
   "XIRC*Popup.Font.Weight: Bold",
   "XIRC*PushBtn.Font.Weight: Bold",
   "XIRC*PushBtn.Background: #bfafaf",
   "XIRC*Background: 0xc3c3c3",
   "XIRC*Forground: black",
   "XIRC*BaseColor: white",
   "XIRC*TextColor: black",
   "XIRC*AutoFocus: false",
   "XIRC*ListBox.BaseColor: #af9f9f",
   "XIRC*ListBox.Background: #af9f9f",
   "XIRC*MessageDialog.Background: #bfafaf",
   "XIRC*MessageDialog.PushBtn.Background: #af9f9f",
   "XIRC*MessageDialog.MultiLineEdit.Font.Family: Fixed",
   "XIRC*MessageDialog.MultiLineEdit.BaseColor: #af9f9f",
   "XIRC*MessageDialog.MultiLineEdit.TextColor: Navy Blue",
   "XIRC*DccChat.Input.Font.Family: Fixed",
   "XIRC*MsgChat.Input.Font.Family: Fixed",
   "XIRC*ServerDialog.Font.Family: Fixed",
   "XIRC*ServerDialog.ImportFile: servers.ini",
   "XIRC*ServerDialog.ImportPath: ./",
   "XIRC*ServerDialog.ImportFilter: *.ini",
   "XIRC*ServerDialog.File: .servers",
   "XIRC*ServerDialog.Path: /usr/local/lib/xIrc",
   "XIRC*ServerDialog.Filter: .*",
   NULL
};

char *version = "$Name: V2-0 $";
static XrmOptionDescList opts = NULL;

static char *defaultSpecHandler(QString strSeq)
{
   char *rv;

   if (strcmp(strSeq, "\\u") == 0)
      rv = "\x1f";
   else if (strcmp(strSeq, "\\b") == 0) 
      rv = "\x02";
   else
      rv = "";
   return(rv);
}

class MyApp : public xApplication
{
public:
   MyApp(int argc, char **argv);
   bool notify(QObject *pRcvr, QEvent *pEvt);
};

MyApp::MyApp(int argc, char **argv) :
         xApplication(argc, argv)
{
   if (dbg) fprintf(stdout, "MyApp::MyApp()!!!\n");
   if (dbg) fflush(stdout);
}

bool MyApp::notify(QObject *pRcvr, QEvent *pEvt)
{
   return(xApplication::notify(pRcvr, pEvt));
}

int main(int argc, char **argv)
{
   QColor fg, bg, baseColor, textColor;
   QFont defFont;

   FILE *pfd;
   char *cp, fontWeight[80], fontSize[80], tmpBuf[512], pmBuf[256];
   const char *ccp1, *ccp2, *ccp3;

   if (dbg) fprintf(stdout, "main():Enter\n");   
   if (dbg) fflush(stdout);
   ccp1 = NULL;
   Resources = new xResources(&ccp1, &opts, 0, &argc, argv);
   Resources->setWidgetInit(pInitialResources);
   MyApp a( argc, argv );
   pApp = &a;

   if (dbg) fprintf(stdout, "main():Opening defaults\n");   
   if (dbg) fflush(stdout);
   if ((pfd = fopen("xIrc.defaults", "r")) == NULL)
   {
      char dnam[128];
      const char *cp;
      
      if ((cp = getenv("HOME")) != NULL)
      {
         strcpy(dnam, cp);
         strcat(dnam, "/.xIrc");
         if (dbg) fprintf(stdout, "main():Trying defaults file |%s|\n", dnam);   
         if (dbg) fflush(stdout);
         pfd = fopen(dnam, "r");
//         if (dbg) fprintf(stdout, "main():Defaults file pointer = |0x%x|\n", pfd);   
//         if (dbg) fflush(stdout);
      }
   }
   Defaults.setCallBack(defaultSpecHandler);
//   Defaults.setEscapes(defEscapes);
   Defaults.load(pfd, NULL);
//   if (dbg) Defaults.show();
   
   if (dbg) fprintf(stdout, "main():Setting Colors and Pallete\n");   
   if (dbg) fflush(stdout);

   if ((ccp1 = Resources->get(&appRes, "background", "Background")) == NULL)
      ccp1 = "0xc3c3c3";
   setStrColor(bg, ccp1);

   if ((ccp1 = Resources->get(&appRes, "foreground", "Foreground")) == NULL)
      ccp1 = "black";
   setStrColor(fg, ccp1);

   if ((ccp1 = Resources->get(&appRes, "basecolor", "BaseColor")) != NULL)
      setStrColor(baseColor, ccp1);
   else
      baseColor = bg;

   if ((ccp1 = Resources->get(&appRes, "textcolor", "TextColor")) != NULL)
      setStrColor(textColor, ccp1);
   else
      textColor = fg;

   QColorGroup g(fg, bg, bg.light(), bg.dark(), bg.dark(120), fg, bg);
   QPalette p( g, g, g );
   a.setPalette(p);

   ccp1 = Resources->get(&appRes, "font.family", "Font.Family");
   ccp2 = Resources->get(&appRes, "font.weight", "Font.Weight");
   ccp3 = Resources->get(&appRes, "font.size", "Font.Size");

   if (ccp1 == NULL)
      ccp1 = a.font()->family();
   if (ccp2 == NULL)
   {
      sprintf(fontWeight, "%d", a.font()->weight());
      ccp2 = fontWeight;
   }
   if (ccp3 == NULL)
   {
      sprintf(fontSize, "%d", a.font()->pointSize());
      ccp2 = fontSize;
   }
   a.setFont(setStrFont(ccp1, ccp2, ccp3));

   if (dbg) fprintf(stdout, "main():Getting Pixmap file name\n");   
   AppPixMap = NULL;
   if ((ccp1 = Resources->get(&appRes, "pixmap", "PixMap")) != NULL)
   {
      if ((ccp2 = Resources->get(&appRes, "pixmappath", "PixMapPath")) != NULL)
      {
         strcpy(tmpBuf, ccp2);
         for (cp = tmpBuf; *cp; cp++)
            if (*cp == ';')
               *cp = '\0';
         *(cp + 1) = '\0';
         for (cp = tmpBuf; *cp; cp++)
         {
            if (dbg) fprintf(stdout, "main():Pixmap Path: |%s|\n", cp);
            AppPixMap = new QPixmap;
            strcpy(pmBuf, cp);
            if (pmBuf[strlen(cp) - 1] != '/')
               strcat(pmBuf, "/");
            strcat(pmBuf,ccp1);
            if (dbg) fprintf(stdout, "main():Attempting to open Pixmap: |%s|\n", pmBuf);
            if (!AppPixMap->load(pmBuf))
            {
               if (dbg) fprintf(stdout, "main():Error opening Pixmap: |%s|\n", pmBuf);   
               delete AppPixMap;
               AppPixMap = NULL;
            }
            else
               break;
            while (*cp) cp++;
         }
      }
      else
      {
         delete AppPixMap;
         AppPixMap = NULL;
      }
   }
   else
   {
      delete AppPixMap;
      AppPixMap = NULL;
   }
   if (dbg) fprintf(stdout, "main():ServQuery\n");   
   if (dbg) fflush(stdout);
   ServQuery = new xServerQuery(&appRes, NULL, "Server Selection");

   if (dbg) fprintf(stdout, "main():Opening channel Query\n");   
   if (dbg) fflush(stdout);
   ChanQuery = new xChannelQuery(&appRes, NULL, "Channels & People");

   if (dbg) fprintf(stdout, "main():NickQuery\n");   
   if (dbg) fflush(stdout);
   NickQuery = new xIrcNickQuery(&appRes, NULL, "Nickname");

   if (dbg) fprintf(stdout, "main():KickQuery\n");   
   if (dbg) fflush(stdout);
   KickQuery = new xLineEditQuery(&appRes, "Enter Kick Message", "", NULL,
                                  "Kick Message", "KICKMESSAGE", &Defaults);

   if (dbg) fprintf(stdout, "main():QuitQuery\n");   
   if (dbg) fflush(stdout);
   QuitQuery = new xLineEditQuery(&appRes, "Enter Quit Message", "", NULL,
                                  "Quit Message", "QUITMESSAGE", &Defaults);
   if (dbg) fprintf(stdout, "main():xIrcConnect\n");   
   if (dbg) fflush(stdout);
//   xIrcServerTable *pTWindow = new xIrcServerTable(&appRes, NULL, "Server Selection Table");
   pTWindow = new xIrcConnect(&appRes);
   
   if (dbg) fprintf(stdout, "main():Showing/Setting/executing app\n");
   if (dbg) fflush(stdout);
   a.setMainWidget( pTWindow );
   pTWindow->show();
   for (;;)
   {
      if (NickQuery->exec() == QDialog::Rejected)
         xMessageBox::message("Error", "You must choose a NickName");
      else
         break;
   }
   pTWindow->show();
   pTWindow->newServer();
/*
*/
   a.exec();
   if (pTWindow)
   {
      if (dbg) fprintf(stdout, "main():Deleting pTWindow\n");
      if (dbg) fflush(stdout);
      delete pTWindow;
   }
   if (ChanQuery)
   {
      if (dbg) fprintf(stdout, "main():Deleting ChanQuery\n");
      if (dbg) fflush(stdout);
      delete ChanQuery;
   }
   if (NickQuery)
   {
      if (dbg) fprintf(stdout, "main():Deleting NickQuery\n");
      if (dbg) fflush(stdout);
      delete NickQuery;
   }
   if (KickQuery)
   {
      if (dbg) fprintf(stdout, "main():Deleting KickQuery\n");
      if (dbg) fflush(stdout);
      delete KickQuery;
   }
   if (QuitQuery)
   {
      if (dbg) fprintf(stdout, "main():Deleting QuitQuery\n");
      if (dbg) fflush(stdout);
      delete QuitQuery;
   }
   if (ServQuery)
   {
      if (dbg) fprintf(stdout, "main():Deleting ServQuery\n");
      if (dbg) fflush(stdout);
      delete ServQuery;
   }
   if (dbg) fprintf(stdout, "main():Exiting!\n");
   if (dbg) fflush(stdout);
}

/*
      fg.setNamedColor("black");
   else
   {
      if (dbg) fprintf(stdout, "main():Found Foreground color! |%s|\n", cp2);   
      rgbColor = strtol(cp2, &cp1, 0);
      if (cp2 != cp1)
      {
         if (dbg) fprintf(stdout, "main():Is Value\n");   
         fg.setRgb(rgbColor);
      }
      else
      {
         if (dbg) fprintf(stdout, "main():Is Named\n");   
         fg.setNamedColor(cp2);
      }
   }
*/
/*
   if ((cp = (char *)Defaults.get("FRAME_BG_COLOR_RGB")) == NULL)
   {
      if ((cp = (char *)Defaults.get("FRAME_BG_COLOR_NAME")) == NULL)
         bg.setRgb(0xc3c3c3);	// Motif gray
      else
         bg.setNamedColor(cp);
   }
   else
   {
      rgbColor = strtol(cp, &cp1, 0);
      if (cp != cp1)
         bg.setRgb(rgbColor);
      else
         bg.setRgb(0xc3c3c3);	// Motif gray 
   }
   if ((cp = (char *)Defaults.get("FRAME_FG_COLOR_RGB")) == NULL)
   {
      if ((cp = (char *)Defaults.get("FRAME_FG_COLOR")) == NULL)
         cp = "black";
      fg.setNamedColor(cp);
   }
   else
   {
      rgbColor = strtol(cp, &cp1, 0);
      if (cp != cp1)
         fg.setRgb(rgbColor);
      else
         fg.setNamedColor("black");	// kind of blue
   }
*/
   /*
   QMenuBar *pMenu = new QMenuBar(pTWindow);
   pMenu->insertItem("Server", pTWindow, SLOT(connectSocket()), CTRL+ALT+Key_C);
   pMenu->insertItem("Channel", 1, 1);
   pMenu->insertItem("Menu3", 2, 2);
   
   pTWindow->attachMenu(pMenu);
   pMenu->show();
   
   while (ServQuery->exec() == QDialog::Rejected);
   fprintf(stderr, "Selected Server = |%s|\n\r", ServQuery->server());
   if (dbg) fflush(stdout);
   fprintf(stderr, "Selected Port = |%s|\n\r", ServQuery->port());
   if (dbg) fflush(stdout);
   
   while (NickQuery->exec() == QDialog::Rejected);
   fprintf(stderr, "Selected Nick = |%s|\n\r", NickQuery->editText());
   if (dbg) fflush(stdout);
   */   
   

