#ifndef OPTIONSDLG_H
#define OPTIONSDLG_H

#include <qlabel.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qtabdialog.h>
#include <qgroupbox.h>
#include <qcheckbox.h>
#include <qspinbox.h>

class OptionsDlg : public QTabDialog
{
   Q_OBJECT
friend class LicqGUI;
public:
   OptionsDlg (QWidget *parent = NULL, char *name = NULL);

protected:
   QWidget *tab[4];

   // network options tab
   QLabel *lblServers, *lblDefServerPort, *lblTcpServerPort, 
          *lblAutoAway, *lblAutoNa, *lblAutoLogon;
   QComboBox *cmbServers, *cmbAutoLogon;
   QSpinBox *spnDefServerPort, *spnTcpServerPort, *spnAutoAway, *spnAutoNa;
   QPushButton *btnAddServer;
   
   // appearance tab
   QGroupBox *boxFont;
   QLabel *lblFontFamily, *lblFontSize, *lblFontCharSet;
   QLineEdit *edtFontFamily;
   QSpinBox *spnFontSize;
   QComboBox *cmbFontCharSet;
   
   QGroupBox *boxColor;
   QLabel *lblColorOnline, *lblColorAway, *lblColorOffline, *lblColorNew,
          *lblColorBackground;
   QLineEdit *edtColorOnline, *edtColorAway, *edtColorOffline, *edtColorNew,
             *edtColorBackground;
   
   QCheckBox *chkGridLines, *chkHeader, *chkAutoClose;

   // columns tab
   QLabel *lblColWidth, *lblColAlign, *lblColInfo;
   QCheckBox *chkColEnabled[4];
   QSpinBox *spnColWidth[4];
   QComboBox *cmbColAlign[4], *cmbColInfo[4];

   // sounds tab
   QLabel *lblSndType, *lblSndPlayer, *lblSndMsg, *lblSndChat,
          *lblSndUrl, *lblSndFile, *lblSndNotify;
   QComboBox *cmbSndType;
   QLineEdit *edtSndPlayer, *edtSndMsg, *edtSndChat, *edtSndUrl,
             *edtSndFile, *edtSndNotify;
   QGroupBox *boxSndEvents;
   
protected slots:
   void colEnable(bool);
};



#endif
