/*      -------------------------------------------------------------------
	xldlas -- A Stastics Package
	Copyright (C) 1996 Thor Sigvaldason

	Popup help balloons based on the tooltips library
	Copyright (C) 1996 by Michael Chu


	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

        -------------------------------------------------------------------

	Code written to compile and run under the GNU C complier
	and the Linux operating system. Should also compile on any
	vaguely POSIX-compatible system that has xforms installed.
	
	Kudos to the Free Software Foundation, Linus Torvalds, and
	the developpers of xforms.
	
        -------------------------------------------------------------------*/

#include "xldlas.h"


extern void create_frontend();
extern int startup();
extern void opening_quote();
extern void set_possible_choices();
extern void say_status(char the_status[256]);
extern void simple_line_output(char which_routine[XLDLASMAX_INPUT], char the_output[XLDLASMAX_INPUT]);
extern void handle_cloptions(int numb_arguments, char *arguments[]);
extern void tooltips_initialize();
extern TOOLTIPS_ERROR tooltips_suspend();
extern void set_font_preference(FL_OBJECT *obj, long arg);
extern int check_for_command_line_help(int numb_arguments, char *arguments[]);

void quit_xldlas(FL_OBJECT *ob, long user_data)
{
	fl_finish();
	exit(0);
}

void user_quit_xldlas()
{
	fl_finish();
	exit(0);
}



void nothing(FL_OBJECT *ob, long user_data)
{
	fl_addto_browser(main_browser,"Sorry, that function is not yet implemented");
}




int main(int argc, char *argv[])
{
	int start_status;
	char string_one[256];
	char string_two[256];
	if(check_for_command_line_help(argc, argv) == FALSE)
	{
		fl_initialize(&argc, argv,"xldlas", 0, 0);
		tooltips_initialize();
		fl_set_app_nomainform(TRUE);
	
		create_frontend();
	
		strcpy(string_one,"xldlas v");
		sprintf(string_two,"%d",XLDLAS_MAJOR);
		strcat(string_one,string_two);
		strcat(string_one,".");
		sprintf(string_two,"%d",XLDLAS_MINOR);
		strcat(string_one,string_two);
		start_status = startup();
		set_possible_choices();
		if(main_font == 2 || main_font < 0 || main_font > 3)
		{
			set_font_preference(prefs_font_normal_button, 2);
		}
		if(main_font == 1)
		{
			set_font_preference(prefs_font_small_button, 1);
		}
		if(main_font == 3)
		{
			set_font_preference(prefs_font_large_button, 3);
		}
		        fl_show_form(frontend,FL_PLACE_FREE,FL_FULLBORDER,string_one);
		if(start_status == 0)
		{
			opening_quote();
			simple_line_output("start","xldlas started (Preferences read from ~/.xldlasrc)");
		}
		if(start_status == - 2)
		{
			say_status("Wierdness");
			fl_show_alert("Could not open ~/.xldlasrc!", "This is very strange ?!?", "Do you have a HOME environment variable?",TRUE);
		}
		if(start_status == 1)
		{
			say_status("Welcome");	
			fl_show_message("Welcome New User!","","Default configuration created in HOME/.xldlasrc");
		}
		handle_cloptions(argc, argv);
		say_status("Ready");
		if(balloon_help == FALSE)
		{
			tooltips_suspend();
		}
	        fl_do_forms();
		return(0);
	}
	else
	{
		return(0);
	}
}
