// test application for TYA
// (c) Mon Sep 22 20:02:41 1997 Albrecht Kleine
//
//
import java.awt.*;
import java.awt.image.*;

public class Iview extends Frame 
{
    Image image,image0;
    IviewCanvas ic;
    Label ilab;
    String xfilename;
    static public void main(String[] args) 
    {
       if (args.length > 0)
	 new Iview(args[0]);
       else
	 System.out.println("Usage: Iview filename");
    }

    // constructor
    Iview(String filename)
    {
        super("IView");
        xfilename=filename;
        ic = new IviewCanvas();
        ilab=new Label();
        add("Center",ic);
        add("North", ilab);
        MenuBar menubar = new MenuBar();
        Menu file = new Menu("File");
        Menu filter = new Menu("Filter");
        menubar.add(file);
        menubar.add(filter);
        file.add("Quit");
        filter.add("Filter red");
        filter.add("Filter green");
        filter.add("Filter blue");
        filter.add("No filter");
        setMenuBar(menubar);
	image0=image=CreateImageDecoder();
	ic.setImage(image);
	ilab.setText(filename);
        pack();
        show();
    }

   private Image CreateImageDecoder()
   {
        Image iimage;
        try
	{
         iimage = Toolkit.getDefaultToolkit().getImage(xfilename);  // jpg,gif
	}
        catch (Exception ex)
	{
           ex.printStackTrace();
	   return null;
	}
        return iimage;
   }

   public boolean action(Event e, Object arg)
    {
        if (e.target instanceof MenuItem) 
        {
            String label = (String) arg;
            if (label.equals("Quit")) 
		System.exit(0);
	    else
	        if (label.equals("Filter red"))
                  ColorFilter(30);
	    else
	        if (label.equals("Filter green"))
                  ColorFilter(31);
	    else
	        if (label.equals("Filter blue"))
                  ColorFilter(32);
	    else
	        if (label.equals("No filter"))
                  ColorFilter(0);
        }
	return false;
    }


   void ColorFilter(int filternr)
   {
      if (filternr!=0)
      {
       Image ii=CreateImageDecoder();
       ImageProducer ipro;
       ipro  = ii.getSource();
       IviewColorFilter gf=new IviewColorFilter(filternr);  
       ipro=new FilteredImageSource(ipro,gf);
       image= this.createImage(ipro);
      }
      else
       image=image0;
      ic.setImage(image);
      ic.repaint();
   }
}



// ----simple mini control for an image display------------------------------
//
class IviewCanvas extends Canvas 
{
    private Image image;
    IviewCanvas() 
    {
        this.image = null;
    }

    public Dimension preferredSize()
    {
      int w,h;
      if (image!=null)
	 {
	    w = image.getWidth(this);
	    h = image.getHeight(this);
         }
      else
	 {
	    w=250;		// for writing an error message
	    h=100;
	 }
       
     return new Dimension(w,h);
    }

    public Image getImage()
    {
     return image;
    }
    

   
    public void setImage(Image image)
    {
      if (image!=null)
      {
        int i;
        long startTime;
        MediaTracker tracker;
        System.out.println("waiting for MediaTracker...");
        startTime=System.currentTimeMillis();
        tracker = new MediaTracker (this);
        tracker.addImage(image,0);
        try 
	{ 
	   tracker.waitForID(0); 
	} 
        catch (Exception ex)
	{
	   System.out.println("error Exception:");
           ex.printStackTrace();
	   return;
	}
        switch (i=tracker.statusID(0,false))
	 {
	  case MediaTracker.COMPLETE:
	    long readyTime=System.currentTimeMillis();
	    System.out.println("MediaTracker OK. ");
	    System.out.println(IviewColorFilter.cnt+" filter calls, Time="+
	       ( readyTime - startTime)+ " msec");
	    break;
	  default:
	    System.out.println("MediaTracker status = "+i);
	    image=null;
	    break;
	 }
      }
      this.image=image;
    }

    public void paint(Graphics g) 
    {
      if (image!=null)
	 g.drawImage(image, 0, 0, this);
      else
	 {
	    Font f=new Font("Courier",Font.BOLD,18);
	    g.setFont(f);
	    g.drawString("NO IMAGE LOADED",30,30);
	 }
    } 
}

//--------------------------------------------------------------------------
// Filter

class IviewColorFilter extends RGBImageFilter 
{
  int nummer;
  static int cnt;
  
  public IviewColorFilter(int filternummer) 
  {
   canFilterIndexColorModel = false;
   nummer=filternummer;
   cnt=0;
  }
   
  public int filterRGB(int x, int y, int rgb)
  {
      int a,r,g,b;
      cnt++;
      // for speed testing 
      r = (rgb & 0x00ff0000);
      g = (rgb & 0x0000ff00);
      b =  rgb & 0x000000ff ;
      a = 0xff<<24;
      switch (nummer)
      {
       case 30: g=0;		// Rotfilter
		b=0;
		return a|r|g|b;
       case 31:	r=0;		// Grnfilter
		b=0;
		return a|r|g|b;
       case 32: r=0;		// Blaufilter
		g=0;
		return a|r|g|b;
      }
     return rgb; 		// default: do nothing
  }
}

