/* IluIOFunctions.java */
/* Chris Jacobi, August 14, 1997 10:35 pm PDT */

/*
 * Copyright (c) 1996 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* 
 * $Id: IluIOFunctions.java,v 1.5 1997/08/15 06:23:04 jacobi Exp $ 
 */
 
package xerox.ilu;

/**
 * Generic io functions.<p>
 *
 * Not for applications. <p>
 *
 * TypeCode argument may or may not be required or ignored. <br>
 * For the IO functions the Object x must be of the appropriate 
 * type or an exception may be raised.<br>
 * The isAFunc is primarily internally used; for client taste
 * it is probably too leniant. <p>
 *
 * @see IluPickle
 */
public interface IluIOFunctions {
    public int szFunc(
        xerox.ilu.IluCall _call, java.lang.Object _x, IluTypeCode _tc) 
        throws IluSystemException;
    public void outFunc(
        xerox.ilu.IluCall _call, java.lang.Object _x, IluTypeCode _tc) 
        throws IluSystemException;
    public java.lang.Object inFunc(
        xerox.ilu.IluCall _call, IluTypeCode _tc) 
        throws IluSystemException;
    public boolean isAFunc(
        java.lang.Object _x, IluTypeCode _tc) 
        throws IluSystemException;
} //IluIOFunctions

