#!/usr/local/bin/perl
#  wrapper.pl - a command parsing wrapper for the CBB 'engine'.
#
#  Written by Curtis Olson.  Started August 22, 1994.
#
#  Copyright (C) 1994 - 1997  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: wrapper.pl,v 2.10 1997/05/06 01:00:29 curt Exp $
# (Log is kept at end of this file)


package CBB;

use strict;    # don't take no guff


# specify the installed location of the necessary pieces.
$CBB::cbb_incl_dir = ".";
unshift(@INC, $CBB::cbb_incl_dir);

require "engine.pl";
require "categories.pl";
require "file.pl";
require "memorized.pl";
require "import.pl";
require "export.pl";


sub BEGIN {
    $CBB::logging = 1;		# 0 = off,  1 = on
    $CBB::debug = 0;		# 0 = off,  1 = on

    # get user name
    @CBB::pw = getpwuid($<);

    $CBB::user_name = $CBB::pw[0]
	|| $ENV{LOGNAME} || die "No user name!";

    $CBB::current_file = "";

    $CBB::encrypt = "";
    $CBB::decrypt = "";

    # set umask to 066 (only owner should be able to read this)
    umask(066);
}


&main_loop();


# main command parsing loop
sub main_loop {
    my($arg, $command);

    while (<>) {
	chop;

	print DEBUG "Command string:  '$_'\n" if $CBB::debug;

	if ( m/ / ) {
	    ($command, $arg) = split(/ /, $_, 2);
	} else {
	    ($command, $arg) = ($_, "");
	}

	if ($command eq "create_trans") {
	    print DEBUG "calling create_trans($arg)\n" if $CBB::debug;
	    print &create_trans($arg)."\n";
	    &log_txn($_) if $CBB::logging;
	} elsif ($command eq "create_xfer") {
	    print DEBUG "calling create_xfer($arg)\n" if $CBB::debug;
	    print &create_xfer($arg)."\n";
	    &log_txn($_) if $CBB::logging;
	} elsif ($command eq "update_trans") {
	    print DEBUG "calling update_trans($arg)\n" if $CBB::debug;
	    print &update_trans($arg)."\n";
	    &log_txn($_) if $CBB::logging;
	} elsif ($command eq "update_xfer") {
	    print DEBUG "calling update_xfer($arg)\n" if $CBB::debug;
	    print &update_xfer($arg)."\n";
	    &log_txn($_) if $CBB::logging;
	} elsif ($command eq "delete_trans") {
	    print DEBUG "calling delete_trans($arg)\n" if $CBB::debug;
	    print &delete_trans($arg)."\n";
	    &log_txn($_) if $CBB::logging;
	} elsif ($command eq "delete_xfer") {
	    print DEBUG "calling delete_xfer($arg)\n" if $CBB::debug;
	    print &delete_xfer($arg)."\n";
	    &log_txn($_) if $CBB::logging;
	} elsif ($command eq "next_trans") {
	    print DEBUG "next_trans()\n" if $CBB::debug;
	    print &next_trans()."\n";
	} elsif ($command eq "prev_trans") {
	    print "prev_trans()\n";
	} elsif ($command eq "find_trans") {
	    print DEBUG "find_trans($arg)\n" if $CBB::debug;
	    print &find_trans($arg)."\n";
	} elsif ($command eq "get_current_index") {
	    print DEBUG "get_current_index()\n" if $CBB::debug;
	    print &get_current_index()."\n";
	} elsif ($command eq "first_trans") {
	    print DEBUG "first_trans()\n" if $CBB::debug;
	    print &first_trans()."\n";
	} elsif ($command eq "all_trans") {
	    print DEBUG "all_trans($arg)\n" if $CBB::debug;
	    print &all_trans($arg)."\n";
	} elsif ($command eq "part_trans") {
	    print DEBUG "part_trans($arg)\n" if $CBB::debug;
	    print &part_trans($arg)."\n";
	} elsif ($command eq "last_trans") {
	    print "last_trans()\n";
	} elsif ($command eq "first_uncleared_trans") {
	    print DEBUG "first_uncleared_trans()\n" if $CBB::debug;
	    print &first_uncleared_trans()."\n";
	} elsif ($command eq "last_uncleared_trans") {
	    print "last_uncleared_trans()\n";
	} elsif ($command eq "next_uncleared_trans") {
	    print DEBUG "next_uncleared_trans()\n" if $CBB::debug;
	    print &next_uncleared_trans()."\n";
	} elsif ($command eq "prev_uncleared_trans") {
	    print "prev_uncleared_trans()\n";
	} elsif ($command eq "select_trans") {
	    print DEBUG "select_trans()\n" if $CBB::debug;
	    print &select_trans($arg)."\n";
	    &log_txn($_) if $CBB::logging;
	} elsif ($command eq "unselect_trans") {
	    print DEBUG "unselect_trans()\n" if $CBB::debug;
	    print &unselect_trans($arg)."\n";
	    &log_txn($_) if $CBB::logging;
	} elsif ($command eq "clear_trans") {
	    print DEBUG "clear_trans()\n" if $CBB::debug;
	    print &clear_trans()."\n";
	    &log_txn($_) if $CBB::logging;
	} elsif ($command eq "get_cleared_bal") {
	    print DEBUG "get_cleared_bal()\n" if $CBB::debug;
	    print &get_cleared_bal()."\n";
	} elsif ($command eq "sort_trans") {
	    print "sort_trans()\n";
	} elsif ($command eq "init_trans") {
	    print DEBUG "calling init_trans()\n" if $CBB::debug;
	    print &init_trans()."\n";
	} elsif ($command eq "make_acct") {
	    print DEBUG "calling make_acct($arg)\n" if $CBB::debug;
	    print &make_acct($arg)."\n";
	    &log_txn($_) if $CBB::logging;
	} elsif ($command eq "load_trans") {
	    print DEBUG "calling load_trans($arg)\n" if $CBB::debug;
	    print &load_trans($arg)."\n";
	    &log_txn($_) if $CBB::logging;
	} elsif ($command eq "load_cbb") {
	    print DEBUG "calling load_cbb($arg)\n" if $CBB::debug;
	    print &load_cbb($arg)."\n";
	    &log_txn($_) if $CBB::logging;
	} elsif ($command eq "import_qif") {
	    print DEBUG "calling import_qif($arg)\n" if $CBB::debug;
	    print &import_qif($arg)."\n";
	    &log_txn($_) if $CBB::logging;
	} elsif ($command eq "save_cbb") {
	    print DEBUG "calling save_cbb($arg)\n" if $CBB::debug;
	    print &save_cbb($arg)."\n";
	    &log_txn($_) if $CBB::logging;
	} elsif ($command eq "export_qif") {
	    print DEBUG "calling export_qif($arg)\n" if $CBB::debug;
	    print &export_qif($arg)."\n";
	    &log_txn($_) if $CBB::logging;
	} elsif ($command eq "save_trans") {
	    print DEBUG "calling save_trans($arg)\n" if $CBB::debug;
	    print &save_trans($arg)."\n";
	    &log_txn($_) if $CBB::logging;
	} elsif ($command eq "auto_save_trans") {
	    print DEBUG "calling auto_save_trans($arg)\n" if $CBB::debug;
	    &save_trans($arg);
	} elsif ($command eq "rehash_mems") {
	    print DEBUG "calling rehash_mems()\n" if $CBB::debug;
	    print &rehash_mems()."\n";
	} elsif ($command eq "find_mem") {
	    print DEBUG "calling find_mem($arg)\n" if $CBB::debug;
	    print &find_mem($arg)."\n";
	} elsif ($command eq "init_cats") {
	    print DEBUG "calling init_cats()\n" if $CBB::debug;
	    print &init_cats()."\n";
	} elsif ($command eq "edit_cat") {
	    print DEBUG "calling edit_cat($arg)\n" if $CBB::debug;
	    print &edit_cat($arg)."\n";
	    &log_txn($_) if $CBB::logging;
	} elsif ($command eq "insert_cat") {
	    print DEBUG "calling insert_cat($arg)\n" if $CBB::debug;
	    print &insert_cat($arg)."\n";
	    &log_txn($_) if $CBB::logging;
	} elsif ($command eq "delete_cat") {
	    print DEBUG "calling delete_cat($arg)\n" if $CBB::debug;
	    print &delete_cat($arg)."\n";
	    &log_txn($_) if $CBB::logging;
	} elsif ($command eq "all_cats") {
	    print DEBUG "calling all_cats()\n";
	    print &all_cats()."\n";
	} elsif ($command eq "find_cat") {
	    print DEBUG "calling find_cat($arg)\n";
	    print &find_cat($arg)."\n";
	} elsif ($command eq "get_cat_info") {
	    print DEBUG "calling get_cat_info($arg)\n";
	    print &get_cat_info($arg)."\n";
	} elsif ($command eq "load_cats") {
	    print DEBUG "calling load_cats($arg)\n" if $CBB::debug;
	    print &load_cats($arg)."\n";
	} elsif ($command eq "load_dbm_cats") {
	    print DEBUG "calling load_dbm_cats($arg)\n" if $CBB::debug;
	    print &load_dbm_cats($arg)."\n";
	} elsif ($command eq "save_cats") {
	    print DEBUG "calling save_cats($arg)\n" if $CBB::debug;
	    print &save_cats($arg)."\n";
	} elsif ($command eq "rep_txn_list") {
	    print DEBUG "calling rep_txn_list($arg)\n" if $CBB::debug;
	    print &rep_txn_list($arg)."\n";
	} elsif ($command eq "rep_txn_by_cat") {
	    print DEBUG "calling rep_txn_by_cat($arg)\n" if $CBB::debug;
	    print &rep_txn_by_cat($arg)."\n";
	} elsif ($command eq "rep_txn_by_cat_short") {
	    print DEBUG "calling rep_txn_by_cat_short($arg)\n" if $CBB::debug;
	    print &rep_txn_by_cat_short($arg)."\n";
	} elsif ($command eq "nice_date") {
	    print DEBUG "calling nice_date($arg)\n" if $CBB::debug;
	    print &nice_date($arg)."\n";
	} elsif ($command eq "raw_date") {
	    print DEBUG "calling raw_date()\n" if $CBB::debug;
	    print &raw_date()."\n";
	} elsif ($command eq "start_date") {
	    print DEBUG "calling start_date()\n" if $CBB::debug;
	    print &start_date($arg)."\n";
	} elsif ($command eq "century") {
	    print DEBUG "calling century()\n" if $CBB::debug;
	    print &century()."\n";
	} elsif ($command eq "get_files") {
	    print DEBUG "get_files($arg)\n" if $CBB::debug;
	    print &get_files($arg)."\n";
	} elsif ($command eq "debug") {
	    print DEBUG "debug($arg)\n" if $CBB::debug;
	    print &debug($arg)."\n";
	} elsif ($command eq "cache") {
	    print DEBUG "cache($arg)\n" if $CBB::debug;
	    $CBB::cache = int($arg);
	    print $CBB::cache . "\n";
	} elsif ($command eq "encrypt") {
	    print DEBUG "encrypt($arg)\n" if $CBB::debug;
	    $CBB::encrypt = $arg;
	    print $CBB::encrypt . "\n";
	} elsif ($command eq "decrypt") {
	    print DEBUG "decrypt($arg)\n" if $CBB::debug;
	    $CBB::decrypt = $arg;
	    print $CBB::decrypt . "\n";
	} elsif ($command eq "logging") {
	    print DEBUG "logging($arg)\n" if $CBB::debug;
	    $CBB::logging = int($arg);
	    print $CBB::logging . "\n";
	} elsif ($command eq "quit") {
	    print DEBUG "exiting\n" if $CBB::debug;
	    exit(0);
	} else {
	    # unknown command ... return error
	    print DEBUG "unknown command\n" if $CBB::debug;
	    print "error\n";
	}
    }
}


1;				# need to return a true value


# ----------------------------------------------------------------------------
# $Log: wrapper.pl,v $
# Revision 2.10  1997/05/06 01:00:29  curt
# Added patches contributed by Martin Schenk <schenkm@ping.at>
# - Default to umask of 066 so .CBB files get created rw by owner only
# - Added support for pgp encrypting data files
# - Added support for displaying only recent parts of files (avoids
#   waiting to load in lots of old txns you don't currently need.)
# - Added a feature to "cache" whole accounts in the perl engine so
#   that switching between accounts can be faster.
# - The above options can be turned on/off via the preferrences menu.
#
# Revision 2.9  1997/01/18 03:28:46  curt
# Added "use strict" pragma to enforce good scoping habits.
#
# Revision 2.8  1997/01/10 22:03:33  curt
# Transfer fixups and a few other misc. fixes contributed by
#   Lionel Mallet <Lionel.Mallet@sophia.inria.fr>
#
# Revision 2.7  1996/12/17 14:54:04  curt
# Updated copyright date.
#
# Revision 2.6  1996/10/03 04:49:01  curt
# Fixed an inconsistency in &raw_date() in common.pl (with how it was
# called.)
#
# Version now is 0.67-beta-x
#
# Revision 2.5  1996/10/03 03:52:59  curt
# CBB now determines the current century automatically ... no need for it
# to be hard coded.  Removed all hardcoded instances of the century (especially
# in reports.pl and recur.pl)
#
# Added an optional --debug flag to the invocation of CBB.
#
# Revision 2.4  1996/10/02 19:37:20  curt
# Replaced instances of hardcoded century (19) with a variable.  We need to
# know the current century in cases where it is not provided and it is
# assumed to be the current century.  Someday I need to figure out how
# to determine the current century, but I have a couple of years to do it. :-)
#
# I still need to fix conf-reports and reports.pl
#
# Revision 2.3  1996/07/13 02:57:53  curt
# Version 0.65
# Packing Changes
# Documenation changes
# Changes to handle a value in both debit and credit fields.
#
# Revision 2.2  1996/03/03  00:16:11  curt
# Modified Files:  cbb categories.pl wrapper.pl file.tk main.tk menu.tk
#   Added an account list at the bottom of the screen.  Thanks to:
#   Cengiz Alaettinoglu <cengiz@ISI.EDU> for this great addition.
#
# Revision 2.1  1996/02/27  05:35:52  curt
# Just stumbling around a bit with cvs ... :-(
#
# Revision 2.0  1996/02/27  04:43:06  curt
# Initial 2.0 revision.  (See "Log" files for old history.)
