// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  TmplEColored.C

  Stephane Rehel

  October 19 1997
*/

#include "tools/file/MLWFileBlock.h"
#include "tools/file/MLRFileBlock.h"

#include "graphics/mlgl.h"
#include "graphics/MLEvent.h"
#include "graphics/SystemWindow.h"

#include "interface/MLXORRectAction.h"
#include "interface/MLMotionAction.h"
#include "interface/MLClickedMotionAction.h"
#include "interface/MLMode.h"
#include "interface/MLCanvasPopup.h"
#include "interface/MLPopup.h"
#include "interface/MLCanvasButton.h"
#include "interface/MLCanvasActionsPool.h"

#include "TmplEColored.h"

#include "tmpl/TmplModule.h"
#include "tmpl/TmplModes.h"

#include "tmpl/modes/TmplMSelect.h"
#include "tmpl/modes/TmplMDrag.h"

/////////////////////////////////////////////////////////////////////////////

TmplEColored::TmplEColored( TmplCanvas* _canvas,
                        double _r, /* = .3 */
                        double _g, /* = .3 */
                        double _b  /* = .3 */ ):
  TmplEngine(_canvas)
{
  r= _r;
  g= _g;
  b= _b;

  name= "Colored";

  displayTypeButton= new MLCanvasButton(canvas);
  displayTypeButton->create("Preview");
  TmplEngine::actions->addRightAction(displayTypeButton);

  optionsPopup= new MLCanvasPopup(canvas);
  optionsPopup->create("Options");
  MLPopup* p= optionsPopup->getPopup();
  options_popup_wire_front= p->addCheck("Wire front");
  TmplEngine::actions->addRightAction(optionsPopup);
}

/////////////////////////////////////////////////////////////////////////////

TmplEColored::~TmplEColored()
{
}

/////////////////////////////////////////////////////////////////////////////

// protected
// return IFALSE if window is unmapped, etc.
IBOOL TmplEColored::_back_draw()
{
  if( ! MLEngine::mapped() || tmplModule->isIconic() )
    return IFALSE;

  SystemWindow* window= MLEngine::getGfxWindow();
  if( window == 0 )
    return IFALSE;

  window->current();
  mlBack();

  glClearColor( r, g, b, 0. );
  glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );

  return ITRUE;
}

/////////////////////////////////////////////////////////////////////////////

void TmplEColored::draw()
{
  if( ! _back_draw() )
    return;

  SystemWindow* window= MLEngine::getGfxWindow();

  if( window != 0 )
    window->swapBuffers();
}

/////////////////////////////////////////////////////////////////////////////

IBOOL TmplEColored::handleAction( MLAction* action )
{
  if( action == displayTypeButton )
    {
    /* ... */

    updatePopupsFlags();

    return ITRUE;
    }

  if( action == optionsPopup )
    {
    int label= optionsPopup->getLabel();

    if( label == options_popup_wire_front )
      {
      /* ... */

      updatePopupsFlags();

      return ITRUE;
      }
    }

  if( ! MLEngine::validPointerAction(action) )
    return TmplEngine::handleAction(action);

  switch( MLEngine::getMode()->getID() )
    {
    case TmplModes::SELECT:
      {
      TmplMSelect* s= (TmplMSelect*) getMode();

      MLXORRectAction* a= (MLXORRectAction*) action;

      /* ... */
      s->button= a->button;

      tmplModule->validateFunction();

      return ITRUE;
      }

    case TmplModes::DRAG:
      {
      TmplMDrag* d= (TmplMDrag*) getMode();

      MLMotionAction* a= (MLMotionAction*) action;
      if( a->type != MLMotionAction::MOVING )
        return ITRUE;

      d->button= a->button;
      d->screenVector= Vector2( a->delta_size.x(),
                                a->delta_size.y() );

      tmplModule->validateFunction();

      return ITRUE;
      }

    default:
      break;
    }

  return TmplEngine::handleAction(action);
}

/////////////////////////////////////////////////////////////////////////////

void TmplEColored::refreshScreen( unsigned what )
{
  if( (what & TmplModule::REFRESH_COLOR) != 0 )
    MLEngine::postRefresh();
}

/////////////////////////////////////////////////////////////////////////////

void TmplEColored::leaveMode( MLMode* mm )
{
  if( mm != 0 && tmplModule != 0 )
    tmplModule->postCmdStop(); // close the undo list for non-lonely commands

  TmplEngine::leaveMode(mm);
}

/////////////////////////////////////////////////////////////////////////////

void TmplEColored::write( MLWFileBlock& block )
{
  TmplEngine::write(block);

  block << double(r) << double(g) << double(b);

  block << int(0);
}

/////////////////////////////////////////////////////////////////////////////

void TmplEColored::read( MLRFileBlock& block )
{
  TmplEngine::read(block);

  r= block.getDouble();
  g= block.getDouble();
  b= block.getDouble();

  if( block.getInteger() == 0 )
    goto end;

end:
  updatePopupsFlags();
}

/////////////////////////////////////////////////////////////////////////////

void TmplEColored::resetAll()
{
  r= g= b= 0.3;

  TmplEngine::resetAll();

  optionsPopup->setChecked(options_popup_wire_front,IFALSE);

  updatePopupsFlags();
}

/////////////////////////////////////////////////////////////////////////////

void TmplEColored::updatePopupsFlags()
{
  if( optionsPopup == 0 )
    return;

  optionsPopup->setAvailable(options_popup_wire_front,IFALSE);

  displayTypeButton->setTitle(" Wire  ");
}

/////////////////////////////////////////////////////////////////////////////
