// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  MLAllocator.h

  Stephane Rehel

  November 28 1996
*/

#ifndef __MLAllocator_h
#define __MLAllocator_h

class MLModule;
class MLCanvas;
class MLEngine;
class MLScrollingDialog;

/////////////////////////////////////////////////////////////////////////////

class MLAllocator
{
  friend class MLModule;
  friend class MLCanvas;
  friend class MLEngine;
  friend class MLScrollingDialog;

public:
  MLAllocator();
  ~MLAllocator();

  static void init();

  static int allocModule( MLModule* m );
  static int allocCanvas( MLCanvas* c );
  static int allocEngine( MLEngine* e );
  static int allocScrollingDialog( MLScrollingDialog* sd );

  static MLModule* getModule( int id );
  static MLCanvas* getCanvas( int id );
  static MLEngine* getEngine( int id );
  static MLScrollingDialog* getScrollingDialog( int id );

  static void freeModule( int id );
  static void freeCanvas( int id );
  static void freeEngine( int id );
  static void freeScrollingDialog( int id );

private:
  static void freeModule( MLModule* m ); // called by ~MLModule
  static void freeCanvas( MLCanvas* c ); // called by ~MLCanvas
  static void freeEngine( MLEngine* e ); // called by ~MLEngine
  static void freeScrollingDialog( MLScrollingDialog* sd );
                                   // called by ~MLScrollingDialog

  static int findModule( MLModule* m );
  static int findCanvas( MLCanvas* c );
  static int findEngine( MLEngine* e );
  static int findScrollingDialog( MLScrollingDialog* sd );
};

/////////////////////////////////////////////////////////////////////////////

#endif // ifndef __MLAllocator_h
