#!/usr/local/bin/perl

$font = "";
$ptsize = 12;

# Print header.

print <<"EOF";
%!

/paperw 595 def
/paperh 839 def

/grid 30 def
/ptsize $ptsize def

/xofs paperw grid 16 mul sub 2 div def
/yofs paperh grid 16 mul sub 2 div def

/DoChar { % col row str -> -
  /str exch def
  /row exch def
  /col exch def
  col grid mul xofs add
  row grid mul yofs add moveto 
  grid str stringwidth pop sub 2 div 
  grid ptsize sub 2 div 
  rmoveto 
  str show
} def

% Print grids.

% vertical
0 1 16 {
  grid mul xofs add yofs moveto
  0 grid 16 mul rlineto stroke
} for

% horizontal
0 1 16 {
  grid mul yofs add xofs exch moveto
  grid 16 mul 0 rlineto stroke
} for

% Print numbers

/bodyfont /Helvetica-Bold findfont 10 scalefont def
bodyfont setfont

% vertical
0 1 15 {
  /num exch def
  /str num 16 mul 10 string cvs def
  num grid mul xofs add 
  grid str stringwidth pop sub 2 div add
  yofs grid 16 mul 10 add add moveto
  str show
} for 

% horizontal
0 1 15 {
  /num exch def
  /str num 10 string cvs def
  xofs grid sub grid str stringwidth pop sub 2 div add
  grid 16 mul 
    num grid mul grid ptsize sub 2 div sub sub 
    grid sub
    yofs add
  moveto
  str show
} for 
EOF



# Print characters.
while (<>) {
    @fields = split;
    $num = @fields[1];
    $fname = @fields[2];
    if (!($font EQ $fname)) {
	print "/$fname findfont $ptsize scalefont setfont\n";
	$font = $fname;
    }
    if ($num >= 0) {
	$col = $num / 16;
	$row = $num % 16;
	printf("%d %d (\\%o) DoChar\n", $col, $row, $num);
    }
}

# Print trailer

print <<"EOF";
bodyfont setfont
($fname) dup stringwidth pop paperw exch sub 2 div paperh 100 sub moveto show
EOF
print "showpage\n%%EOF\n";
