// -*- C++ -*-
#ifndef _TEX_DEFS_H
#define _TEX_DEFS_H

#include "keybind.h"

// see alos in definitions.h

static
char *tex_babel[] = {"default","american","austrian","bahasa","brazil",
		     "catalan","croatian","czech","danish","dutch",
		     "english","esperanto","finnish","francais","french",
		     "galician","german","hungarian","italian","magyar",
		     "norsk","polish","portuges","romanian","russian",
		     "spanish","slovak","slovene","swedish","turkish",
		     "last_item"};


static
char *tex_epsfig[] = {"none", "dvips", "dvitops", "emtex",
		      "ln", "oztex", "textures", "last_item"};

static
char *tex_fonts[] = {"default", "times", "palatino", "helvet", "avant",
		     "newcent", "bookman", "last_item"};


/* the names used by TeX and XWindows for deadkeys/accents are not the same
   so here follows a table to clearify the differences. Please correct this
   if I got it wrong

   |------------------|------------------|-----------------|--------------|
   |      TeX         |     XWindows     |   \bind/LFUN     | used by intl |
   |------------------|------------------|------------------|--------------|
   |    grave         |    grave         |LFUN_GRAVE        | grave
   |    acute         |    acute         |LFUN_ACUTE        | acute
   |    circumflex    |    circumflex    |LFUN_CIRCUMFLEX   | circumflex
   | umlaut/dieresis  |    diaeresis     |LFUN_UMLAUT       | umlaut
   |    tilde         |    tilde         |LFUN_TILDE        | tilde
   |    macron        |    maron         |LFUN_MACRON       | macron
   |    dot           |    abovedot      |LFUN_DOT          | dot
   |    cedilla       |    cedilla       |LFUN_CEDILLA      | cedilla
   |    underdot      |                  |LFUN_UNDERDOT     | underdot
   |    underbar      |                  |LFUN_UNDERBAR     | underbar
   |    hcek         |    caron         |LFUN_CARON        | caron
   |    breve         |    breve         |LFUN_BREVE        | breve
   |    tie           |                  |LFUN_TIE          | tie
   | Hungarian umlaut |    doubleacute   |LFUN_HUNG_UMLAUT  | hungarian umlaut
   |    circle        |    abovering     |LFUN_CIRCLE       | circle
   |                  |    ogonek        |                  |
   |                  |    iota          |                  |
   |                  |    voiced_sound  |                  |
   |                  | semivoiced_sound |                  |
   |                  |                  |LFUN_SPECIAL_CARON| special caron
   */
// I am not sure how some of the XWindows names coresponds to the TeX ones.

enum tex_accent {
  TEX_NOACCENT = 0,
  TEX_ACUTE,
  TEX_GRAVE,
  TEX_MACRON,
  TEX_TILDE,
  TEX_UNDERBAR,
  TEX_CEDILLA,
  TEX_UNDERDOT,
  TEX_CIRCUMFLEX,
  TEX_CIRCLE,
  TEX_TIE,
  TEX_BREVE,
  TEX_CARON,
//  TEX_SPECIAL_CARON,
  TEX_HUNGUML,
  TEX_UMLAUT,
  TEX_DOT,
  TEX_MAX_ACCENT=TEX_DOT
};

// the native is so we know what characters TeX can write in a decent way
// it should be up to the user if _all_ characters should be allowed to
// be accented. Lgb.
struct tex_accent_struct {
  tex_accent accent;
  char *cmd;
  char *native;
  char *name;
  kb_action action;
};


static
tex_accent_struct lyx_accent_table[] = {
  {TEX_ACUTE,      "\\'",  " AEIOUYaeiouySZszRLCNrlcn","acu",   LFUN_ACUTE},
  {TEX_GRAVE,      "\\`",  " aeiouAEIOU",           "gra",    LFUN_GRAVE},
  {TEX_MACRON,     "\\=",  " EeAIOUaiou",           "mac",    LFUN_MACRON},
  {TEX_TILDE,      "\\~",  " ANOanoIiUu",           "til",    LFUN_TILDE},
  {TEX_UNDERBAR,   "\\b ", " ",                     "underb", LFUN_UNDERBAR},
  {TEX_CEDILLA,    "\\c ", " CcSsTtRLGrlgNKnk",     "ced",    LFUN_CEDILLA},
  {TEX_UNDERDOT,   "\\d ", " ",                     "underd", LFUN_UNDERDOT},
  {TEX_CIRCUMFLEX, "\\^",  " AEIOUaeiouHJhjCGScgs", "circu",  LFUN_CIRCUMFLEX},
  {TEX_CIRCLE,     "\\r ", " AaUu",                 "circl",  LFUN_CIRCLE},
  {TEX_TIE,        "\\t ", " ",                     "tie",    LFUN_TIE},
  {TEX_BREVE,      "\\u ", " AaGgUu",               "bre",    LFUN_BREVE},
  {TEX_CARON,      "\\v ", " LSTZlstzCEDNRcednr",   "car",    LFUN_CARON},
//  {TEX_SPECIAL_CARON, "\\q ", "","ooo",  LFUN_SPECIAL_CARON},
  {TEX_HUNGUML,    "\\H ", " OUou",                 "hug",    LFUN_HUNG_UMLAUT},
  {TEX_UMLAUT,     "\\\"", " AEIOUaeiouy",          "uml",    LFUN_UMLAUT},
  {TEX_DOT,        "\\.",  " ZzICGicgEe",           "dot",    LFUN_DOT},
  { (tex_accent)0, NULL, NULL, NULL,(kb_action)0}};
  
#endif
