dnl### Useful functions.
dnl Usage: LYX_ERROR(file,library)  Displays an error message indication that
dnl  'file' cannot be found because 'lib' may be uncorrectly installed.
AC_DEFUN(LYX_ERROR,[AC_WARN([Can't find $1. Please check that the $2 library
is correctly installed on your system.
(see the section 'Problems' in the INSTALL file)])
lyx_error=yes])
dnl
dnl
dnl Usage: LYX_CHECK_ERRORS  Displays a warning message if a LYX_ERROR
dnl   has occured previously. 
AC_DEFUN(LYX_CHECK_ERRORS,[
test x$lyx_error = xyes && AC_WARN([
*** Some important files or library have been flagged as missing
*** by configure. Please check the warning messages before running 'make'.
*** If you correct your configuration or use new options for configure, 
*** remember to issue a 'make clean' before re-running configure.])])
dnl
dnl
dnl Usage: LYX_WITH_DIR(dir-name,desc,dir-var-name,default-value)  Adds a
dnl  --with-'dir-name' option (described by 'desc') and puts the resulting
dnl  directory name in 'dir-var-name'.
AC_DEFUN(LYX_WITH_DIR,[
  AC_ARG_WITH($1,[  --with-$1        specify $2])
  AC_MSG_CHECKING([for $2])
  if test -z "$with_$3"; then
     AC_CACHE_VAL(lyx_cv_$3, lyx_cv_$3=$4)
  else
    for dir in $with_$3 ; do
      test ! -d "$dir" && AC_ERROR([\`$dir' is not a directory])
    done
    lyx_cv_$3=$with_$3
  fi
  AC_MSG_RESULT($lyx_cv_$3)])
dnl
dnl
dnl
dnl Usage LYX_PATH_TEX  Searches for TeX root and puts the result in variable 
dnl  TEXMF. NOT USED ANYMORE
dnl AC_DEFUN(LYX_PATH_TEX,[
dnl   AC_ARG_WITH(texmf,[  --with-texmf            specify TeX root directory])
dnl   AC_MSG_CHECKING([for TeX])
dnl   if test -z "$with_texmf"; then
dnl      AC_CACHE_VAL(lyx_cv_texmf,[
dnl       for lyx_dir in \
dnl          ${prefix}/lib \
dnl          /usr/lib \
dnl          /usr/local \
dnl          /usr/local/lib \
dnl          /usr/local/share \
dnl          /opt ; do
dnl         test -d $lyx_dir/texmf && lyx_cv_texmf=$lyx_dir/texmf;
dnl       done])
dnl   else
dnl     test ! -d "$with_texmf" && AC_ERROR(proper usage is --with-texmf=DIRECTORY)
dnl     lyx_cv_texmf=$with_texmf
dnl   fi
dnl   TEXMF=$lyx_cv_texmf
dnl   if test "x$TEXMF" = x ; then
dnl     AC_MSG_RESULT(no)
dnl     TEXMF=NONE
dnl     AC_WARN([Unable to find TeX. Please use the --with-texsty-dir flag.])
dnl   else
dnl     AC_MSG_RESULT($TEXMF)
dnl   fi])
dnl
dnl
dnl
AC_DEFUN(LYX_HPUX,
[AC_CACHE_CHECK(for HP-UX,ac_cv_hpux,[
os=`uname -s | tr '[A-Z]' '[a-z]'`
ac_cv_hpux=no
test "$os" = hp-ux && ac_cv_hpux=yes])
if test "$ac_cv_hpux" = yes; then
 test "x$GXX" = xyes && CXXFLAGS="$CXXFLAGS -fpcc-struct-return"
fi])
dnl
dnl
dnl
AC_DEFUN(LYX_SUNOS4,
[AC_CACHE_CHECK(for SunOS 4.x,ac_cv_sunos4,[
changequote(, )
os=`uname -a | tr '[A-Z]' '[a-z]'|sed -e 's/^\([^ ]*\) [^ ]* \([0-9]\)\..*/\1\2/'`
changequote([, ])
ac_cv_sunos4=no
test "$os" = sunos4 && ac_cv_sunos4=yes])
if test "$ac_cv_sunos4" = yes; then
 test "x$GXX" = xyes && lyx_sun_headers=yes
fi])
dnl
dnl
dnl
dnl Usage LYX_VERSION   Sets `lyx_version' to the version of LyX being built,
dnl   displays it and sets variable `lyx_devel' to yes or no depending whether
dnl   the version is a development release or not. 
AC_DEFUN(LYX_VERSION,[
changequote(, )
lyx_version=`grep '#define *VERSION' version.h | 
             sed -e 's/^.*"\([0-9.]*\)[^0-9.].*$/\1/' 2>/dev/null`
echo "Configuring LyX version $lyx_version"
if echo "$lyx_version" | grep '[0-9]*\.[0-9]*[13579]\.[0-9]*' >/dev/null ; then
  lyx_devel_version=yes
  echo "WARNING: This is a development version. Expect bugs."
else
  lyx_devel_version=no
fi
changequote([, ])
test $lyx_devel_version = yes && AC_DEFINE(DEVEL_VERSION)])

