/* This software is Copyright 1995 by Karl-Johan Johnsson
 *
 * Permission is hereby granted to copy, reproduce, redistribute or otherwise
 * use this software as long as: there is no monetary profit gained
 * specifically from the use or reproduction of this software, it is not
 * sold, rented, traded or otherwise marketed, and this copyright notice is
 * included prominently in any copy made. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. ANY USE OF THIS
 * SOFTWARE IS AT THE USER'S OWN RISK.
 */
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include "Compat.h"
#include "Knapp.h"
#include "Layout.h"
#include "Message.h"
#include "TextField.h"
#include "DialogueP.h"
#include "Util.h"

static XtResource resources[] = {
    {XtNinput, XtCInput, XtRBool, sizeof(Bool),
     XtOffsetOf(DialogueRec, wm.wm_hints.input),
     XtRImmediate, (XtPointer)True},
    {XtNallowShellResize, XtCAllowShellResize, XtRBoolean, sizeof(Boolean),
     XtOffsetOf(DialogueRec, shell.allow_shell_resize),
     XtRImmediate, (XtPointer)True},
#define offset(field) XtOffsetOf(DialogueRec, dialogue.field)
    {XtNcallback, XtCCallback, XtRCallback, sizeof(XtCallbackList),
     offset(callback), XtRCallback, (XtPointer)NULL},
    {XtNcursor, XtCCursor, XtRCursor, sizeof(Cursor),
     offset(cursor), XtRString, (XtPointer)"top_left_arrow"},
    {XtNmessage, XtCMessage, XtRString, sizeof(String),
     offset(message), XtRImmediate, (XtPointer)NULL},
    {XtNbuffer, XtCBuffer, XtRString, sizeof(String),
     offset(buffer), XtRImmediate, (XtPointer)NULL},
    {XtNleftLabel, XtCLabel, XtRBoolean, sizeof(String),
     offset(left_label), XtRImmediate, (XtPointer)NULL},
    {XtNmiddleLabel, XtCLabel, XtRBoolean, sizeof(String),
     offset(middle_label), XtRImmediate, (XtPointer)NULL},
    {XtNrightLabel, XtCLabel, XtRBoolean, sizeof(String),
     offset(right_label), XtRImmediate, (XtPointer)NULL},
#undef offset
};

static void Initialize(Widget, Widget, ArgList, Cardinal*);
static void Realize(Widget, XtValueMask*, XSetWindowAttributes*);
static Boolean SetValues(Widget, Widget, Widget, ArgList, Cardinal*);
static void GetValuesHook(Widget, ArgList, Cardinal*);

static void close_dialogue(Widget, XEvent*, String*, Cardinal*);

static XtActionsRec actions[] = {
    {"close-dialogue",	close_dialogue},
};

static char translations[] =
"<Message>WM_PROTOCOLS:	close-dialogue() \n";

DialogueClassRec dialogueClassRec = {
    {                                   /* core fields                  */
        (WidgetClass) &transientShellClassRec, /* superclass            */
        "Dialogue",                     /* class_name                   */
        sizeof(DialogueRec),	        /* widget_size                  */
        NULL,                           /* class_initialize             */
        NULL,                           /* class_part_initialize        */
        FALSE,                          /* class_inited                 */
        Initialize,                     /* initialize                   */
        NULL,                           /* initialize_hook              */
        Realize,                        /* realize                      */
        actions,                        /* actions                      */
        XtNumber(actions),              /* num_actions                  */
        resources,                      /* resources                    */
        XtNumber(resources),            /* num_resources                */
        NULLQUARK,                      /* xrm_class                    */
        TRUE,                           /* compress_motion              */
	FALSE,				/* compress_exposure		*/
        TRUE,                           /* compress_enterleave          */
        FALSE,                          /* visible_interest             */
        NULL,                           /* destroy                      */
        XtInheritResize,                /* resize                       */
        NULL,	                        /* expose                       */
        SetValues,                      /* set_values                   */
        NULL,                           /* set_values_hook              */
        XtInheritSetValuesAlmost,       /* set_values_almost            */
        GetValuesHook,                  /* get_values_hook              */
        NULL,                           /* accept_focus                 */
        XtVersion,                      /* version                      */
        NULL,                           /* callback_private             */
        translations,                   /* tm_table                     */
        NULL,                           /* query_geometry               */
        XtInheritDisplayAccelerator,    /* display_accelerator          */
        NULL                            /* extension                    */
    },
    {					/* composite fields		*/
	XtInheritGeometryManager,	/* geometry_manager		*/
	XtInheritChangeManaged,		/* change_managed		*/
	XtInheritInsertChild,		/* insert_child			*/
	XtInheritDeleteChild,		/* delete_child			*/
	NULL,				/* extension			*/
    },
    {					/* shell fields			*/
	NULL,				/* extension			*/
    },
    {					/* wm shell fields		*/
	NULL,				/* extension			*/
    },
    {					/* vendor shell fields		*/
	NULL,				/* extension			*/
    },
    {					/* transient shell fields	*/
	NULL,				/* extension			*/
    },
    {					/* dialogue fields		*/
	NULL,				/* extension			*/
    }
};

WidgetClass dialogueWidgetClass = (WidgetClass)&dialogueClassRec;

/*************************************************************************/

static char *layout_string[] = {
"vertical { "
"	message "
"} ",
"vertical { "
"	height knapp1 <+inf-100%> "
"	horizontal { "
"		height knapp1 <+inf-100%> "
"		message "
"		height knapp1 <+inf-100%> "
"	} "
"	height knapp1 <+inf-100%> "
"	horizontal { "
"		height knapp1 <+inf-100%> "
"		knapp1 "
"		height knapp1 <+inf-100%> "
"	} "
"	height knapp1 <+inf-100%> "
"} ",
"vertical { "
"	height knapp1 <+inf-100%> "
"	horizontal { "
"		height knapp1 <+inf-100%> "
"		message "
"		height knapp1 <+inf-100%> "
"	} "
"	height knapp1 <+inf-100%> "
"	horizontal { "
"		height knapp1 <+inf-100%> "
"		textfield "
"		height knapp1 <+inf-100%> "
"	} "
"	height knapp1 <+inf-100%> "
"	horizontal { "
"		height knapp1 <+inf-100%> "
"		knapp1 "
"		height knapp1 <+3inf-100%> "
"		knapp2 "
"		height knapp1 <+inf-100%> "
"	} "
"	height knapp1 <+inf-100%> "
"}",
"vertical { "
"	height knapp1 <+inf-100%> "
"	horizontal { "
"		height knapp1 <+inf-100%> "
"		message "
"		height knapp1 <+inf-100%> "
"	} "
"	height knapp1 <+inf-100%> "
"	horizontal { "
"		height knapp1 <+inf-100%> "
"		textfield "
"		height knapp1 <+inf-100%> "
"	} "
"	height knapp1 <+inf-100%> "
"	horizontal { "
"		height knapp1 <+inf-100%> "
"		knapp1 "
"		height knapp1 <+3inf-100%> "
"		knapp2 "
"		height knapp1 <+3inf-100%> "
"		knapp3 "
"		height knapp1 <+inf-100%> "
"	} "
"	height knapp1 <+inf-100%> "
"} "};

static void call_callbacks(DialogueWidget w, DialogueReply reply)
{
    XtCallbackList	c_list = w->dialogue.callback;

    if (c_list) {
	DialogueReport	report;
	Arg		arg;

	report.reply = reply;
	XtSetArg(arg, XtNbuffer, &report.buffer);
	XtGetValues(w->dialogue.text_field, &arg, 1);
	XtCallCallbackList((Widget)w, c_list, (XtPointer)&report);
    }
}

static void close_dialogue(Widget w, XEvent *event,
			   String *params, Cardinal *no_params)
{
    if (event->type == ClientMessage) {
	Display		*disp = XtDisplay(w);
	Atom		wm_delete_window =
	    XInternAtom(disp, "WM_DELETE_WINDOW", True);
	Atom		wm_protocols =
	    XInternAtom(disp, "WM_PROTOCOLS", True);

	if (event->xclient.message_type == wm_protocols &&
	    event->xclient.data.l[0] == wm_delete_window)
	    call_callbacks((DialogueWidget)w, DialogueReplyClose);
    }
}

static void knapp_callback(Widget knapp,
			   XtPointer client_data,
			   XtPointer call_data)
{
    DialogueWidget	w = (DialogueWidget)client_data;

    if (knapp == w->dialogue.left_knapp)
	call_callbacks(w, DialogueReplyLeft);
    else if (knapp == w->dialogue.middle_knapp)
	call_callbacks(w, DialogueReplyMiddle);
    else if (knapp == w->dialogue.right_knapp)
	call_callbacks(w, DialogueReplyRight);
}

static void enter_callback(Widget gw,
			   XtPointer client_data,
			   XtPointer call_data)
{
    DialogueWidget	w = (DialogueWidget)client_data;
    XtCallbackList	c_list = w->dialogue.callback;
    DialogueReport	report;

    report.reply = DialogueReplyEnter;
    report.buffer = (String)call_data;

    if (c_list)
	XtCallCallbackList((Widget)w, c_list, (XtPointer)&report);
}

static void tab_callback(Widget gw,
			 XtPointer client_data,
			 XtPointer call_data)
{
    DialogueWidget	w = (DialogueWidget)client_data;
    XtCallbackList	c_list = w->dialogue.callback;
    DialogueReport	report;

    report.reply = DialogueReplyTab;
    report.buffer = (String)call_data;

    if (c_list)
	XtCallCallbackList((Widget)w, c_list, (XtPointer)&report);
}

/*************************************************************************/

static void Initialize(Widget grequest, Widget gnew,
		       ArgList gargs, Cardinal *no_args)
{
    static char *name[] = {"knapp1", "knapp2", "knapp3"};
    DialogueWidget	new = (DialogueWidget)gnew;
    XrmValue		to_val, from_val;
    XtPointer		layout;
    Arg			args[2];
    int			n;

    new->dialogue.layout =
	XtCreateManagedWidget("layout", layoutWidgetClass,
			      (Widget)new, NULL, 0);
    n = 0;
    if (new->dialogue.left_label)
	n++;
    if (new->dialogue.middle_label)
	n++;
    if (new->dialogue.right_label)
	n++;
    from_val.size = sizeof(String);
    from_val.addr = layout_string[n];
    to_val.size = sizeof(XtPointer);
    to_val.addr = (XPointer)&layout;
    if (XtConvertAndStore(new->dialogue.layout, XtRString, &from_val,
			  XtRLayout, &to_val)) {
	args[0].name = XtNlayout;
	args[0].value = (XtArgVal)layout;
	XtSetValues(new->dialogue.layout, args, 1);
    }

    n = 0;
    if (new->dialogue.left_label) {
	args[0].name = XtNlabel;
	args[0].value = (XtArgVal)new->dialogue.left_label;
	new->dialogue.left_knapp =
	    XtCreateManagedWidget(name[n], knappWidgetClass,
				  new->dialogue.layout, args, 1);
	XtAddCallback(new->dialogue.left_knapp, XtNcallback,
		      knapp_callback, (XtPointer)new);
	n++;
    } else {
	new->dialogue.left_knapp = NULL;
    }

    if (new->dialogue.middle_label) {
	args[0].name = XtNlabel;
	args[0].value = (XtArgVal)new->dialogue.middle_label;
	new->dialogue.middle_knapp =
	    XtCreateManagedWidget(name[n], knappWidgetClass,
				  new->dialogue.layout, args, 1);
	XtAddCallback(new->dialogue.middle_knapp, XtNcallback,
		      knapp_callback, (XtPointer)new);
	n++;
    } else {
	new->dialogue.middle_knapp = NULL;
    }

    if (new->dialogue.right_label) {
	args[0].name = XtNlabel;
	args[0].value = (XtArgVal)new->dialogue.right_label;
	new->dialogue.right_knapp =
	    XtCreateManagedWidget(name[n], knappWidgetClass,
				  new->dialogue.layout, args, 1);
	XtAddCallback(new->dialogue.right_knapp, XtNcallback,
		      knapp_callback, (XtPointer)new);
	n++;
    } else {
	new->dialogue.right_knapp = NULL;
    }

    XtSetArg(args[0], XtNbuffer, new->dialogue.buffer);
    new->dialogue.text_field =
	XtCreateManagedWidget("textfield", textFieldWidgetClass,
			      new->dialogue.layout, args, 1);
    XtAddCallback(new->dialogue.text_field, XtNcallback,
		  enter_callback, (XtPointer)new);
    XtAddCallback(new->dialogue.text_field, XtNtabCallback,
		  tab_callback, (XtPointer)new);

    XtSetArg(args[0], XtNbuffer, new->dialogue.message);
    XtSetArg(args[1], XtNborderWidth, 0);
    new->dialogue.message_widget =
	XtCreateManagedWidget("message", messageWidgetClass,
			      new->dialogue.layout, args, 2);
    new->dialogue.message = NULL;

    XtSetKeyboardFocus((Widget)new, new->dialogue.text_field);
}

static void Realize(Widget gw, XtValueMask *mask,
		    XSetWindowAttributes *attributes)
{
    DialogueWidget	w = (DialogueWidget)gw;
    Display		*disp = XtDisplay(w);
    Atom		wm_delete_window;

    if (w->dialogue.cursor != None) {
	*mask |= CWCursor;
	attributes->cursor = w->dialogue.cursor;
    }

    transientShellWidgetClass->core_class.realize((Widget)w, mask, attributes);

    wm_delete_window = XInternAtom(disp, "WM_DELETE_WINDOW", False);
    XSetWMProtocols(disp, XtWindow(w), &wm_delete_window, 1);
}

static Boolean SetValues(Widget gcurrent,
			 Widget grequest,
			 Widget gnew,
			 ArgList args,
			 Cardinal *num_args)
{
    Boolean		redisplay = False;
    DialogueWidget	new = (DialogueWidget)gnew;
    DialogueWidget	current = (DialogueWidget)gcurrent;

    if (new->dialogue.message != current->dialogue.message) {
	Arg	arg;

	XtSetArg(arg, XtNbuffer, new->dialogue.message);
	new->dialogue.message = NULL;
	XtSetValues(new->dialogue.message_widget, &arg, 1);
    }

    if (new->dialogue.buffer != current->dialogue.buffer) {
	Arg	arg;

	XtSetArg(arg, XtNbuffer, new->dialogue.buffer);
	new->dialogue.buffer = NULL;
	XtSetValues(new->dialogue.text_field, &arg, 1);
    }

    return redisplay;
}

static void GetValuesHook(Widget gw, ArgList args, Cardinal *no_args)
{
    DialogueWidget	w = (DialogueWidget)gw;
    int			i;

    for (i = 0 ; i < *no_args ; i++) {
	if (strcmp(args[i].name, XtNbuffer) == 0) {
	    Arg	arg;

	    XtSetArg(arg, XtNbuffer, args[i].value);
	    XtGetValues(w->dialogue.text_field, &arg, 1);
	}
    }
}
