#
# $Source: /home/nlfm/Working/Zircon/Development/lib/RCS/Utilities.tcl,v $
# $Date: 1996/04/03 13:02:54 $
# $Revision: 1.16.1.22 $
#
proc makeArray {args} {
    foreach x $args { global $x ; set ${x}(1) 1 ; unset ${x}(1) }
}
#
proc channel {w} {
    global Name
    if {![catch {set win [winfo toplevel $w]}]  && [info exists Name($win)]} {
	return $Name($win)
    }
    return nil
}
#
proc window {chan} { return [[find $chan] window] }
#
proc normal {w} {return [string match {normal} [$w cget -state]]}
#
proc capitalise {str} {return [string toupper [string index $str 0]][string range $str 1 end]}
#
proc getOption {var dflt} {
    global $var
    if [string match {} [set $var [option get . $var [capitalise $var]]]] {
	set $var $dflt
    }
}
#
# List utilities
#
proc listmatch {list val} {
    set i 0
    foreach item $list { if {[lindex $item 0] == $val} { return $i } ; incr i}
    return -1
}
#
proc listdel {v item} {
    set cmd \
      "if {\[llength \$$v\] > $item} { set $v \[lreplace \$$v $item $item\] }"
    uplevel 1 $cmd
}
#
proc listupdate {list item val} {
    uplevel 1 "while { \[llength \$${list}\] <= $item} {lappend ${list} {} }"
    uplevel 1 "set $list \[lreplace \$$list $item $item {$val} \]"
}
#
proc listmove {list from to val} {
    set cmd "set $list \[linsert \[lreplace \$$list $from $from\] $to $val \]"
    uplevel 1 $cmd
}
#
# Procedure used to shorten menu labels to 10 characters. Used
# when adding user provided items to menus
#
proc prune {name lng} {
    regsub -all "\[\002\017\026\037\]" $name {} name
    return [expr {[string length $name] > $lng ? \
      "[string range $name 0 [expr {$lng - 3}]]..." : $name}]
}
#
proc killWindow {win} {
    global Icon IconBM
    catch "unset Icon($win)"
    catch "unset IconBM($win)"
    catch "destroy $win"
}
#
#	proc me : Returns true if nk is this user
#		  Assumes that nk is in lower case!!!
#
proc me {nk} {global myid ; return [expr {[string tolower $nk] == [$myid lname]}]}
#
set ctcpCmds  {Clientinfo Echo Errmsg Finger Pid Ping Source Time
Version Userinfo Other}
set specialCmds {Zircon}
#
proc addCTCPMenu {net name usr} {
    global ctcpCmds DEBUG specialCmds ztrans

    $name add cascade -label $ztrans(ctcp) -menu $name.ctcp
    menu $name.ctcp -tearoff 0
    foreach cmd [expr {$DEBUG ? [concat $ctcpCmds $specialCmds] : $ctcpCmds}] {
	if {$usr == {{}}} {
	    set prc "usersCTCP $net [string toupper $cmd]"
	} {
	    set prc "doCtcp $net [string toupper $cmd] \[$usr name \]"
	}
	$name.ctcp add command -label [trans $cmd] -command $prc
    }
}
#
proc addChanCTCPMenu {name ctl} {
    global ctcpCmds DEBUG specialCmds ztrans
    $name add cascade -label $ztrans(ctcp) -menu $name.ctcp
    menu $name.ctcp -tearoff 0
    foreach cmd [expr {$DEBUG ? [concat $ctcpCmds $specialCmds] : $ctcpCmds}] {
	$name.ctcp add command -label [trans $cmd] \
	  -command "chanCTCP [string toupper $cmd] $ctl"
    }
}
#
proc addDCCMenu {name usr} {
    global ztrans
    $name add cascade -label $ztrans(dcc) -menu $name.dcc
    menu $name.dcc -tearoff 0
    foreach cmd {Send Chat} { $name.dcc add command -label [trans $cmd] \
      -command "doDCC [string toupper $cmd] \[$usr name\]" }
}
#
proc makeUserMenu {chid win usr} {
    if [winfo exists $win] {
	return $win
    } {
	return [menu $win -postcommand "postUM $chid $win $usr"]
    }
}
#
#
proc postUM {chid win usr} {
    global zircon ztrans ucmds Ops
    set w [winfo parent $win]
    set net [$usr net]
    array set ucmds "
	Whois	{$net WHOIS \[$usr lname\]}
	Message	{Message :: make \[$usr name\]}
	Notice	{channelNotice $net \[$usr lname\]}
	Time	{$net TIME \[$usr name\]}
	CTCP	{}
	DCC	{}
	Notify	{}
	Ignore	{}
	Finger	{}
	Speak	{}
	ChanOp	{}
	Kick	{$chid kick $usr}
	BanKick {$chid banKick $usr}
	Kill	{}
    "
    foreach cmd $Ops(userMenu) {
	switch $cmd {
	CTCP { addCTCPMenu $net $win $usr }
	DCC { addDCCMenu $win $usr }
	Notify {
		$win add checkbutton -label $ztrans(notify) \
		  -variable Unotify($usr) -command "$usr doNotify"
	    }
	Whois -
	Message -
	Notice -
	Time { $win add command -label [trans $cmd] -command $ucmds($cmd) }
	Ignore { if [string compare nil $chid] { addIgnoreMenu $win $usr } }
	Finger {
		if [string compare nil $chid] {
		    $win add command -label $ztrans(finger) \
		      -command "$usr finger"
		}
	   }
	}
    }
    set st [expr {[$chid operator] ? "normal" : "disabled"}]
    foreach cmd $Ops(chanop) {
	switch $cmd {
	Speak {
		$win add checkbutton -label $ztrans(speak) \
		  -variable ${chid}(Spk,$usr) \
		  -command "$chid userMode $usr v" -state $st
	    }
	ChanOp {
		$win add checkbutton -label $ztrans(chanop) \
		  -variable ${chid}(Op,$usr) \
		  -command "$chid userMode $usr o" -state $st
	    }
	Kick -
	BanKick {
		$win add command -label [trans $cmd] \
		  -command $ucmds($cmd)  -state $st
	    }
	}
    }
    foreach cmd $Ops(ircop) {
	switch $cmd {
	Kill {
		$win add command -label $ztrans(kill) -command "$usr kill" \
		  -state [expr {[$net ircop] ? {normal} : {disabled}}] \
		  -foreground red
	    }
	}
    }
    $win configure -postcommand {}
}
#
proc invert {button} {
    set fg [$button cget -foreground]
    set bg [$button cget -background]
    $button conf -foreground $bg -background $fg \
      -activeforeground $fg -activebackground $bg
}
#
proc makeLB {win args} {
    frame $win -relief raised
    frame $win.vs -borderwidth 0
    frame $win.hs -borderwidth 0
    scrollbar $win.vs.vscroller -command "$win.l yview"
    scrollbar $win.hs.hscroller -command "$win.l xview" -orient horizontal
    eval listbox $win.l -xscrollcommand "{hsSet $win}" \
      -yscrollcommand "{bsSet $win.vs.vscroller}" $args
    pack $win.l -side left -expand 1 -fill both -in $win.vs
    frame $win.hs.pd
    pack $win.vs -expand 1 -fill both -side top
    return $win
}
#
proc utest {win x y cmd} {
    set name [lindex [$win tag names @$x,$y] 0]
    if [string match user* $name] { Message :: make [$name lname] }
    notIdle $win
}
#
proc who2 {net name} {$net WHOIS $name $name}
#
proc rebind {txt net} {
    $txt configure -state disabled -takefocus 0
    bind $txt <Any-KeyPress> {notIdle %W ; break}
    bind $txt <Double-Button-2> {utest %W %x %y {Message :: make}}
    bind $txt <Shift-Double-Button-2> "utest %W %x %y {who2 $net}"
    bind $txt <Control-Double-Button-2> "utest %W %x %y {finger $net}"
    bind $txt <Double-3> "findURL %W %x %y $net"
}
