/*  LAST EDIT: Sat Mar 16 15:07:27 1996 by Thorsten Kukuk (kukuk)  */
/*
** This file is part of the NYS YP Server.
**
** The NYS YP Server is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
** The NYS YP Server is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** General Public License for more details.
** 
** You should have received a copy of the GNU General Public
** License along with the NYS YP Server; see the file COPYING.  If
** not, write to the Free Software Foundation, Inc., 675 Mass Ave,
** Cambridge, MA 02139, USA.
**
** Autor: Thorsten Kukuk <kukuk@uni-paderborn.de>
*/

static char rcsid[] = "$Id: rev_liste.c,v 1.1 1996/03/16 14:35:38 kukuk Exp $";

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <string.h>
#include <malloc.h>
#include "rev_liste.h"

int insert_netgroup (netgroup_liste_t **liste, const char *key, const char *val)
{
  netgroup_liste_t *work;

  work = *liste;

  if(work == NULL)
    {
      work = malloc(sizeof(netgroup_liste_t));
      *liste = work;
    }
  else
    {
      while(work->next != NULL) work = work->next;
      work->next = malloc(sizeof(netgroup_liste_t));
      work = work->next;
    }
  work->next = NULL;
  work->key = malloc(strlen(key)+1);
  work->val = malloc(strlen(val)+1);
  strcpy(work->key,key);
  strcpy(work->val,val);
 
  return 0;
}

int remove_netgroup (netgroup_liste_t **liste)
{
  netgroup_liste_t *work;

  while(*liste != NULL)
    {
      work = *liste;
      *liste = (*liste)->next;
      free(work->key);
      free(work->val);
      free(work);
    }

  return 0;
}

char *search_netgroup (netgroup_liste_t **liste, const char *key)
{
  netgroup_liste_t *work;

  work = *liste;

  while((work != NULL) && (0 != strcmp(work->key,key)))
    work = work->next;
    
  if(work != NULL)
    return work->val;
  else
    return NULL;
}

int delkey_netgroup (netgroup_liste_t **liste, const char *key)
{
  netgroup_liste_t *work, *prev;
  
  if(*liste != NULL && (0 == strcmp((*liste)->key,key)))
    {
      work=*liste;
      *liste = (*liste)->next;
      free(work->key);
      free(work->val);
      free(work);
      return 0;
    }

  work = *liste;
  prev = NULL;
  
  while((work != NULL) && (0 != strcmp(work->key,key)))
    {
      prev = work;
      work = work->next;
    }
  
  if(work != NULL)
    {
      prev->next = work->next;
      free(work->key);
      free(work->val);
      free(work);
      return 0;
    }
   else
     return 1;
}
