
#include <sys/time.h>

/* Delay -- delay given in 1/60th of a second */
static inline Delay(int sixty_th)
{
	struct timeval tv;

	/* Take this opportunity to seed the random number generator */
	srand((rand()/2+(time(NULL)%360)));

	/* select() is a fairly accurate delay? */
	tv.tv_sec = (sixty_th/60);
	tv.tv_usec = ((sixty_th%60)*(1000/60));
	(void) select(64, NULL, NULL, NULL, &tv);
}
/* Return current time (in 1/60'th of a second) */
static inline unsigned long Ticks(void)
{
	struct timeval tv;

	gettimeofday(&tv, NULL);
#ifdef FAITHFUL_SPECS
	return(tv.tv_sec*60 + (tv.tv_usec*60)/1000000);
#else  /* FAST PERFORMANCE */
	//return(tv.tv_sec*50 + (tv.tv_usec*50)/1000000);
	return(tv.tv_sec*60 + (tv.tv_usec*60)/1000000);
#endif
}

/* Quickly return a random value */
#define FastRandom(range)	(rand()%(range))
