/* s__solve.cc
 *$Header: /al/acs/src/RCS/s__solve.cc,v 9.26 95/10/31 16:12:35 al Exp $
 * solve one step or a transient analysis
 */
#include "m_matrix.h"
#include "error.h"
#include "io.h"
#include "e_node.h"
#include "u_opt.h"
#include "u_status.h"
#include "e_card.h"
#include "s__.h"
#include "declare.h"	/* solve */
/*--------------------------------------------------------------------------*/
//	int	SIM::solve(int,int);
//	void	SIM::advance_time(void);
//	void	SIM::clear_arrays(void);
/*--------------------------------------------------------------------------*/
int SIM::solve(int itl, int trace)	/* solve one time step		    */
{
  int converged = FALSE;
  
  STATUS::iter[iSTEP] = 0;
  advance_time();
  
  inc_mode = (inc_mode == FALSE) ? BAD : inc_mode;
  damp = OPT::dampmax;
  
  do {
    inc_mode = (inc_mode == BAD || STATUS::iter[iSTEP] == OPT::itl[OPT::TRLOW])
             ? FALSE
             : OPT::incmode;
    if (trace >= tITERATION)
      print((double)-STATUS::iter[iSTEP]);
    ++STATUS::iter[iPRINTSTEP];
    ++STATUS::iter[iSTEP];
    ++STATUS::iter[mode];
    ++STATUS::iter[iTOTAL];
  
    fulldamp = (STATUS::iter[iSTEP] == 2  &&  OPT::dampstrategy & dsINIT)
             ? TRUE
             : FALSE;
      
    clear_arrays();
    STATUS::evaluate.start();
    converged = CARD::dotr_all();
    STATUS::evaluate.stop();
    
    if (STATUS::iter[iSTEP] == 1  ||  converged){
      damp = 1.0;
    }else if (fulldamp){
      damp = OPT::dampmin;
    }else{
      damp = (damp + OPT::dampmax)/2;
    }
    error(bTRACE, "damp=%f\n", damp);

    STATUS::load.start();
    CARD::trload_all();
    STATUS::load.stop();

    double *vnew;
    vnew = vi1;		/* save last iter voltages by swapping arrays */
    vi1 = v0;    
    v0 = NULL;
    ::solve();
    lu.fbsub(vnew, i, fw);
    v0 = vnew;

    if (STATUS::iter[iSTEP] >= OPT::itl[OPT::TRACE])
      IO::suppresserrors = FALSE;
    bypass_ok = OPT::bypass;
  } while (STATUS::iter[iSTEP]<3 || !converged && STATUS::iter[iSTEP]<=itl);
  return converged;
}
/*--------------------------------------------------------------------------*/
void SIM::advance_time(void)
{
  if (SIM::mode == sTRAN){
    static double last_iter_time;	
    if (SIM::time0 > last_iter_time){	/* moving forward */
      int ii;
      for (ii = 1;  ii <= STATUS::total_nodes;  ii++){
	SIM::vt1[ii] = SIM::v0[ii];
      }
    }else{				/* moving backward or DC */
      /* don't save voltages.  They're wrong !*/
    }
    last_iter_time = SIM::time0;
  }
}
/* last_iter_time is initially 0 by C definition.
 * On subsequent runs it will start with an arbitrary positive value.
 * SIM::time0 starts at either 0 or the ending time of the last run.
 * In either case, (time0 > last_iter_time) is false on the first step.
 * This correctly results in "don't save voltages..."
 */
/*--------------------------------------------------------------------------*/
void SIM::clear_arrays(void)
{
  if (!SIM::inc_mode){			/* Clear working array */
    SIM::aa.zero();
    SIM::aa.dezero(OPT::gmin);		/* gmin fudge */
    int ii;
    for (ii = 1;  ii <= SIM::aa.size();  ii++){
      SIM::i[ii] = 0.;			/* Clear new right side */
    }
  }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
