;;- Machine description for Hitachi H8/500 GNU C compiler
;;    Copyright (C) 1993, 1995 Free Software Foundation, Inc.
;;
;;    contributed by Steve Chamberlain (sac@cygnus.com)
;;               and Jim Wilson        (wilson@cygnus.com)

;; This file is part of GNU CC.

;; GNU CC is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU CC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU CC; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.


;; The original PO technology requires these to be ordered by speed,
;; so that assigner will pick the fastest.

;; See file "rtl.def" for documentation on define_insn, match_*, et. al.

;; CC attribute information used in aux-output.c to optimize
;; compares on output.


;; NONE    - insn doesn't set the condition code at all
;; SET     - insn sets the condition code to reflect contents of operand[0]
;;		overflow is zeroed, carry is untouched
;; COMPARE - insn sets the condition code as if a compare had occurred
;; TEST    - insn is a compare against 0
;; CLOBBER - insn clobbers the flags in a strange way
;; WHOOPS  - insn hasn't been done yet
;; ARITH   - insn which doesn't set the overflow right
;;		

(define_attr "cc" "none,set,compare,clobber,whoops,arith,test"
  (const_string "whoops"))

;; ----------------------------------------------------------------------
;;
;; Move instructions
;;
;; ----------------------------------------------------------------------


(define_insn "set_hi"
  [(set (subreg:HI (match_operand:PSI 0 "register_operand" "=r") 0)
	(match_operand:HI 1 "general_operand" "g"))]
  ""
  "%D0	%1,%S0"
  [(set_attr "cc" "clobber")])

(define_insn "set_low"
  [(set (subreg:HI (match_operand:PSI 0 "register_operand" "=r") 1)
	(match_operand:HI 1 "general_operand" "g"))]
  ""
  "mov.w	%1,%O0 !m1"
  [(set_attr "cc" "clobber")])

(define_insn "get_hi"
  [(set (match_operand:HI 0 "general_operand" "=g,b,g,r")
	(subreg:HI (match_operand:PSI 1 "general_operand" "b,g,r,g") 0))]
  ""
  "@
	stc	%S1,%0 ! hi1
	ldc	%S1,%0 ! hi2
	mov.w	%1,%0  ! hi3
	mov.w	%1,%0  ! hi4"
  [(set_attr "cc" "none,none,set,set")])


(define_insn "get_low"
  [(set (match_operand:HI 0 "general_operand" "=g")
	(subreg:HI (match_operand:PSI 1 "register_operand" "r") 1))]
  ""
  "mov.w	%O1,%0 !m2"
  [(set_attr "cc" "set")])

(define_insn ""
  [(set (match_operand:HI 0 "general_operand" "=g,g,r")
	(match_operand:HI 1 "general_operand" "J,rn,g"))]
  ""
  "@
	clr.w	%0
	mov.w	%1,%0 !m3
	mov.w	%1,%0 !m4"
  [(set_attr "cc" "set,set,set")])

(define_insn ""
  [(set (match_operand:QI 0 "general_operand" "=r,g")
	(match_operand:QI 1 "general_operand" "g,nr"))]
  ""
  "mov.%B0	%1,%0"
  [(set_attr "cc" "set")])

(define_insn ""
  [(set (match_operand:SI 0 "push_operand" "=<")
	(match_operand:SI 1 "register_operand" "r"))]
   ""
   "mov.w	%N1,@-sp\;mov.w	%M1,@-sp"
  [(set_attr "cc" "clobber")])

(define_insn ""
  [(set (match_operand:SF 0 "push_operand" "=<")
	(match_operand:SF 1 "register_operand" "r"))]
   ""
   "mov.w	%N1,@-sp\;mov.w	%M1,@-sp"
  [(set_attr "cc" "clobber")])
  
(define_insn "movsiinsn"
  [(set (match_operand:SI 0 "general_operand" "=&r,&r,&r,>,<,&g")
	(match_operand:SI 1 "general_operand" ">,<,g,nr,nr,nr"))]
  ""
  "* return move_two_words(operands);"					
  [(set_attr "cc" "clobber")])

(define_insn "movsfinsn"
  [(set (match_operand:SF 0 "general_operand" "=&r,&r,r,>,<,&g")
	(match_operand:SF 1 "general_operand" ">,<,g,nr,nr,nr"))]
 ""
 "* return move_two_words(operands);"					
  [(set_attr "cc" "clobber")])

(define_expand "movhi"
  [(set (match_operand:HI 0 "general_operand" "")
	(match_operand:HI 1 "general_operand" ""))]
  ""
  "{ prep_move_operands(operands,HImode);}")

(define_expand "movqi"
  [(set (match_operand:QI 0 "general_operand" "")
	(match_operand:QI 1 "general_operand" ""))]
  ""
  "{ prep_move_operands(operands, QImode);}")

(define_expand "movsi"
  [(set (match_operand:SI 0 "general_operand" "")
	(match_operand:SI 1 "general_operand" ""))]
  ""					
  "{ prep_move_operands(operands, SImode);}")

(define_expand "movsf"
  [(set (match_operand:SF 0 "general_operand" "")
	(match_operand:SF 1 "general_operand" ""))]
  ""					
  "{ prep_move_operands(operands, SFmode);}")

;; ----------------------------------------------------------------------
;;
;; Test instructions
;;
;; ----------------------------------------------------------------------

(define_insn "tstqi"
  [(set (cc0)
	(match_operand:QI 0 "nonimmediate_operand" "rm"))]
  ""
  "tst.b	%0"
  [(set_attr "cc" "test")])

(define_insn "tsthi"
  [(set (cc0)
	(match_operand:HI 0 "nonimmediate_operand" "rm"))]
  ""
  "tst.w	%0"
  [(set_attr "cc" "test")])

;; ----------------------------------------------------------------------
;;
;; Compare instructions
;;
;; ----------------------------------------------------------------------

(define_insn "cmphi"
  [(set (cc0)
	(compare:HI (match_operand:HI 0 "nonimmediate_operand" "rm,r")
		    (match_operand:HI 1 "general_operand" "i,g")))]
  ""
  "cmp.w	%1,%0"
  [(set_attr "cc" "compare")])

(define_insn "cmpqi"
  [(set (cc0)
	(compare:QI (match_operand:QI 0 "nonimmediate_operand" "rm,r")
		    (match_operand:QI 1 "general_operand" "i,g")))]
  ""
  "cmp.b	%1,%0"
  [(set_attr "cc" "compare")])

(define_insn "cmppsi"
  [(set (cc0)
	(compare:PSI (match_operand:PSI 0 "register_operand" "g,r")
		     (match_operand:PSI 1 "general_operand" "n,g")))]
  ""
  "cmp.w	%O1,%O0"
  [(set_attr "cc" "compare")])

;; ----------------------------------------------------------------------
;;
;; Add instructions
;;
;; ----------------------------------------------------------------------
	
(define_insn "addhi3"
  [(set (match_operand:HI 0 "general_operand" "=g,r")
	(plus:HI (match_operand:HI 1 "general_operand" "%0,0")
		 (match_operand:HI 2 "general_operand" "I,g")))]
  ""
  "@
	add:q.w	%2,%0
	add.w	%2,%0"
  [(set_attr "cc" "arith")])

(define_insn "addqi3"
  [(set (match_operand:QI 0 "general_operand" "=g,r")
	(plus:QI (match_operand:QI 1 "general_operand" "%0,0")
		 (match_operand:QI 2 "general_operand" "I,g")))]
  ""
  "@
	add:q.b	%2,%0
	add.b	%2,%0"
  [(set_attr "cc" "arith")])

(define_insn "addsi3"
  [(set (match_operand:SI 0 "general_operand" "=r")
	(plus:SI (match_operand:SI 1 "register_operand" "%0")
		 (match_operand:SI 2 "general_operand" "g")))
  ]
 ""
 "*
{	
  /* If we're adding an SI to the stack pointer, then
     we only add to the low part */
  if (GET_CODE (operands[0]) == REG &&
      REGNO (operands[0]) == 7) 
    {
      return 	\"add.w	%N2,%0 ! addsi31\";
    }
  return \"add.w	%N2,%N0\;addx.w	%M2,%M0 ! addsi3\";
}"
  [(set_attr "cc" "clobber")])

;; ----------------------------------------------------------------------
;;
;; Subtract instructions
;;
;; ----------------------------------------------------------------------

(define_insn "subhi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	(minus:HI (match_operand:HI 1 "register_operand" "0")
		  (match_operand:HI 2 "general_operand" "g")))]
  ""
  "sub.w	%2,%0"
  [(set_attr "cc" "arith")])

(define_insn "subqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	(minus:QI (match_operand:QI 1 "register_operand" "0")
		  (match_operand:QI 2 "general_operand" "g")))]
  ""
  "sub.b	%2,%0"
  [(set_attr "cc" "arith")])

(define_insn "subsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(minus:SI (match_operand:SI 1 "register_operand" "0")
		  (match_operand:SI 2 "general_operand" "g")))]
  ""
 "*
{
  /* Subtract from the stack pointer only changes low part */
  if (GET_CODE (operands[0]) == REG &&
      REGNO (operands[0]) == 7) 
    {
      return 	\"sub.w	%N2,%0 ! addsi31\";
    }
  return \"sub.w	%N2,%N0\;subx.w	%M2,%M0 ! addsi3\";
}"
  [(set_attr "cc" "clobber")])

;; ----------------------------------------------------------------------
;;
;; Multiply instructions
;;
;; ----------------------------------------------------------------------

(define_insn "umulqihi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	(mult:HI (match_operand:QI 1 "register_operand" "%0")
		 (match_operand:QI 2 "general_operand" "g")))]
  ""
  "mulxu.b	%2,%0"
  [(set_attr "cc" "clobber")])

(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "=&r")
	(unspec:SI [(match_operand:HI 1 "register_operand" "g")
		    (match_operand:HI 2 "general_operand" "g")] 123))]
  ""
  "mov.w	%1,%M0\;mulxu.w	%2,%M0"
  [(set_attr "cc" "clobber")])

(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "=&r")
	(unspec:SI [(match_operand:HI 1 "register_operand" "g")
		    (match_operand:HI 2 "general_operand" "g")] 124))]
  ""
  "mov.w	%1,%M0\;mulxu.w	%2,%M0"
  [(set_attr "cc" "clobber")])

(define_expand "mulhi3"
  [(set (match_dup 3) 
	(unspec:SI [(match_operand:HI 1 "register_operand" "g")
		    (match_operand:HI 2 "general_operand" "g")] 123))
   (set (match_operand:HI 0 "register_operand" "") (subreg:HI (match_dup 3) 1))]
  ""
  "operands[3] = gen_reg_rtx(SImode);")

(define_expand "umulhisi3"
  [(set (match_dup 3) 
	(unspec:SI [(match_operand:HI 1 "register_operand" "g")
		    (match_operand:HI 2 "general_operand" "g")] 124))
   (set (match_operand:SI 0 "general_operand" "") (match_dup 3))]  
  ""
  "{ operands[3] = gen_reg_rtx (SImode);}")

;; ----------------------------------------------------------------------
;;
;; Divide instructions
;;
;; ----------------------------------------------------------------------

(define_insn ""
  [(set (reg:HI 1) (div:HI (reg:HI 1) (reg:HI 4)))
   (set (reg:HI 0) (mod:HI (reg:HI 1) (reg:HI 4)))]
  ""
  "%P0jsr	@__divmodhi4"
  [  (set_attr "cc" "clobber")])

(define_expand "divmodhi4"
  [(set (reg:HI 1) (match_operand:HI 1 "general_operand" "g"))
   (set (reg:HI 4) (match_operand:HI 2 "general_operand" "g"))
   (parallel[
	     (set (reg:HI 1) 
		  (div:HI (reg:HI 1) (reg:HI 4)))
	     (set (reg:HI 0)
		  (mod:HI (reg:HI 1) (reg:HI 4)))])
   (set (match_operand:HI  0 "general_operand" "g") (reg:HI 1))
   (set (match_operand:HI  3 "general_operand" "g") (reg:HI 0))]
  ""
  "")

(define_insn ""
  [(set (reg:HI 1) (udiv:HI (reg:HI 1)  (match_operand:HI 1 "general_operand" "g")))
   (set (reg:HI 0) (umod:HI (reg:HI 1)  (match_dup 1)))]
  ""
  "clr.w	r0\;divxu.w	%1,r0"
  [(set_attr "cc" "clobber")])
 
(define_expand "udivmodhi4"
  [(set (reg:HI 1) (match_operand:HI 1 "register_operand" "r"))
   (parallel[
 	     (set (reg:HI 1)
 		  (udiv:HI (reg:HI 1) (match_operand:HI 2 "general_operand" "g")))
 	     (set (reg:HI 0) 
 		  (umod:HI (reg:HI 1) (match_dup 2)))])
   (set (match_operand:HI  0 "general_operand" "g") (reg:HI 1))
   (set (match_operand:HI  3 "general_operand" "g") (reg:HI 0))]
  ""
  "")
 
;; ----------------------------------------------------------------------
;;
;; And instructions
;;
;; ----------------------------------------------------------------------

(define_insn "andqi3"
  [(set (match_operand:QI 0 "general_operand" "=g,r")
	(and:QI (match_operand:QI 1 "general_operand" "%0,0")
		(match_operand:QI 2 "general_operand" "O,g")))]
  ""
  "@
	bclr.b	%W2,%0
	and.b	%2,%0"
  [(set_attr "cc" "clobber,arith")])

(define_insn "andhi3"
  [(set (match_operand:HI 0 "general_operand" "=g,r")
	(and:HI (match_operand:HI 1 "general_operand" "%0,0")
		(match_operand:HI 2 "general_operand" "O,g")))]
  ""
  "@
	bclr.w	%W2,%0
	and.w	%2,%0"
  [(set_attr "cc" "clobber,arith")])

;; ----------------------------------------------------------------------
;;
;; Or instructions
;;
;; ----------------------------------------------------------------------

(define_insn "iorqi3"
  [(set (match_operand:QI 0 "general_operand" "=g,r")
	(ior:QI (match_operand:QI 1 "general_operand" "%0,0")
		(match_operand:QI 2 "general_operand" "P,g")))]
  ""
  "@
	bset.b	%V2,%0
	or.b	%2,%0"
  [(set_attr "cc" "clobber,arith")])

(define_insn "iorhi3"
  [(set (match_operand:HI 0 "general_operand" "=g,r")
	(ior:HI (match_operand:HI 1 "general_operand" "%0,0")
		(match_operand:HI 2 "general_operand" "P,g")))]
  ""
  "@
	bset.w	%V2,%0
	or.w	%2,%0"
  [(set_attr "cc" "clobber,arith")])

;; ----------------------------------------------------------------------
;;
;; Xor instructions
;;
;; ----------------------------------------------------------------------

(define_insn "xorqi3"
  [(set (match_operand:QI 0 "general_operand" "=g,r")
	(xor:QI (match_operand:QI 1 "general_operand" "%0,0")
		(match_operand:QI 2 "general_operand" "P,g")))]
  ""
  "@
	bnot.b	%V2,%0
	xor.b	%2,%0"
  [(set_attr "cc" "clobber,arith")])

(define_insn "xorhi3"
  [(set (match_operand:HI 0 "general_operand" "=g,r")
	(xor:HI (match_operand:HI 1 "general_operand" "%0,0")
		(match_operand:HI 2 "general_operand" "P,g")))]
  ""
  "@
	bnot.w	%V2,%0
	xor.w	%2,%0"
  [(set_attr "cc" "clobber,arith")])

;; ----------------------------------------------------------------------
;;
;; NEGATION INSTRUCTIONS
;;
;; ----------------------------------------------------------------------

(define_insn "negqi2"
  [(set (match_operand:QI 0 "general_operand" "=g")
	(neg:QI (match_operand:QI 1 "general_operand" "0")))]
  ""
  "neg.w	%0"
  [(set_attr "cc" "arith")])

(define_insn "neghi2"
  [(set (match_operand:HI 0 "general_operand" "=g")
	(neg:HI (match_operand:HI 1 "general_operand" "0")))]
  ""
  "neg.w	%0"
  [(set_attr "cc" "arith")])

(define_insn "negsi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(neg:SI (match_operand:SI 1 "register_operand" "0")))]
  ""
  "not.w	%N0\;not.w	%M0\;add	#1,%N0\;addx	#0,%M0"
  [(set_attr "cc" "clobber")])

;; ----------------------------------------------------------------------
;;
;; Not instructions
;;
;; ----------------------------------------------------------------------

(define_insn "one_cmplqi2"
  [(set (match_operand:QI 0 "general_operand" "=g")
	(not:QI (match_operand:QI 1 "general_operand" "0")))]
  ""
  "not.b	%0"
  [(set_attr "cc" "arith")])

(define_insn "one_cmplhi2"
  [(set (match_operand:HI 0 "general_operand" "=g")
	(not:HI (match_operand:HI 1 "general_operand" "0")))]
  ""
  "not.w	%0"
  [(set_attr "cc" "arith")])

;; ----------------------------------------------------------------------
;;
;; Conditional jumps
;;
;; ----------------------------------------------------------------------

(define_expand "ble"
  [(set (pc)
	(if_then_else (le (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")

(define_expand "bleu"
  [(set (pc)
	(if_then_else (leu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")

(define_expand "bge"
  [(set (pc)
	(if_then_else (ge (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")

(define_expand "bgeu"
  [(set (pc)
	(if_then_else (geu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")

(define_expand "blt"
  [(set (pc)
	(if_then_else (lt (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")

(define_expand "bltu"
  [(set (pc)
	(if_then_else (ltu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")

(define_expand "bgt"
  [(set (pc)
	(if_then_else (gt (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")

(define_expand "bgtu"
  [(set (pc)
	(if_then_else (gtu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")

(define_expand "beq"
  [(set (pc)
	(if_then_else (eq (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")

(define_expand "bne"
  [(set (pc)
	(if_then_else (ne (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")

(define_insn ""
  [(set (pc)
	(if_then_else (match_operator 1 "comparison_operator"
				      [(cc0) (const_int 0)])
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "b%j1	%l0"
 [(set_attr "cc" "none")])

(define_insn ""
  [(set (pc)
	(if_then_else (match_operator 1 "comparison_operator"
				      [(cc0) (const_int 0)])
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "b%k1	%l0"
  [   (set_attr "cc" "none")])

;; ----------------------------------------------------------------------
;;
;; Unconditional and other jump instructions
;;
;; ----------------------------------------------------------------------

(define_insn "jump"
  [(set (pc)
	(label_ref (match_operand 0 "" "")))]
  ""
  "bra	%l0"
  [(set_attr "cc" "none")])

;; ??? It's not clear whether jmp should be %P0jmp, but I don't think so.

(define_insn "tablejump"
  [(set (pc) (match_operand:HI 0 "register_operand" "r"))
   (use (label_ref (match_operand 1 "" "")))]
  ""
  "jmp	@%0"
  [(set_attr "cc" "none")])


;; Call subroutine with no return value.
;; These call patterns use SI instead of PSI because we don't want the
;; address to go into a segmentation register.
;; ??? TARGET_CODE32?

(define_insn "call_code32"
  [(call (mem:QI (match_operand:SI 0 "call_operand" "Sr"))
	 (match_operand:HI 1 "general_operand" "g"))]
  ""
  "%P0jsr	%L0"
  [(set_attr "cc" "clobber")])

;; Call subroutine, returning value in operand 0
;; (which must be a hard register).
;; ??? TARGET_CODE32?

(define_insn "call_value_code32"
  [(set (match_operand 0 "register_operand" "=rf,rf")
	(call (mem:QI (match_operand:SI 1 "call_operand" "S,r"))
	      (match_operand:HI 2 "general_operand" "g,g")))]
  ""
  "@
	%P0jsr	%L1
	%P0jsr	%L1"
  [(set_attr "cc" "clobber")])

;; Call subroutine with no return value.
;; for 16 bit calls
;; ??? !TARGET_CODE32?

(define_insn "call_code16"
  [(call (mem:QI (match_operand:HI 0 "call_operand" "Sr"))
	 (match_operand:HI 1 "general_operand" "g"))]
  ""
  "%P0jsr	%L0"
  [(set_attr "cc" "clobber")])

(define_insn "call_value_code16"
  [(set (match_operand 0 "register_operand" "=r")
	(call (mem:QI (match_operand:HI 1 "call_operand" "Sr"))
	      (match_operand:HI 2 "general_operand" "g")))]
  ""
  "%P0jsr	%L1"
  [(set_attr "cc" "clobber")])

;; Call subroutine with no return value.

;; ??? Instead of convert_to_mode, must call a special PSI->SI mode
;; internal pattern to correctly copy this value.

(define_expand "call"
  [(call (match_operand 0 "" "")
	 (match_operand:HI 1 "" ""))]
  ""
  "
{
  rtx addr;

  if (GET_CODE (operands[0]) != MEM)
    abort ();
  if (GET_CODE (XEXP (operands[0], 0)) == REG)
    {
      addr = convert_to_mode (TARGET_CODE32 ? SImode : HImode, XEXP (operands[0], 0), 0);
    }
  else 
    {
      addr = XEXP(operands[0],0);
    }

  if (TARGET_CODE32) 
    {
      emit_call_insn (gen_call_code32 (addr, operands[1]));
    }
  else 
    {
      emit_call_insn (gen_call_code16 (addr, operands[1]));
    }
  DONE;
}")

;; Call subroutine, returning value in operand 0
;; (which must be a hard register).

(define_expand "call_value"
  [(set (match_operand 0 "register_operand" "=rf")
	(call (match_operand:PSI 1 "" "")
	      (match_operand:HI 2 "" "")))]
  ""
  "
{
  rtx addr;

  if (GET_CODE (operands[1]) != MEM)
    abort ();

  if (GET_CODE (XEXP (operands[1], 0)) == REG)
    {
      addr = convert_to_mode (TARGET_CODE32 ? SImode: HImode, XEXP (operands[1], 0), 0);
    }
  else 
    {
      addr = XEXP(operands[1],0);
    }

  if (TARGET_CODE32) 
    {
      emit_call_insn (gen_call_value_code32  (operands[0], addr, operands[2]));
    }
  else 
    {
      emit_call_insn (gen_call_value_code16 (operands[0], addr, operands[2]));
    }

  DONE;
}
")

(define_insn "nop"
  [(const_int 0)]
  ""
  "nop"
  [(set_attr "cc" "none")])

(define_insn "indirect_jump"
  [(set (pc) (match_operand 0 "register_operand" "r"))]
  ""
  "%P0jmp	%L0"
  [(set_attr "cc" "none")])


;; ----------------------------------------------------------------------
;;
;; Convertions
;; ----------------------------------------------------------------------

(define_insn "zero_extendqihi2"
  [(set (match_operand:HI 0 "register_operand" "=r")
	(zero_extend:HI
	 (match_operand:QI 1 "register_operand" "0")))]
  ""
  "extu	%0"
  [(set_attr "cc" "arith")])

(define_insn "extendqihi2"
  [(set (match_operand:HI 0 "general_operand" "=r")
	(sign_extend:HI
	 (match_operand:QI 1 "general_operand" "0")))]
  ""
  "exts %0"
  [(set_attr "cc" "arith")])

(define_insn "extendhisi2_insn"
  [(set (match_operand:SI 0 "register_operand" "=&r")
	(sign_extend:SI
	 (match_operand:HI 1 "register_operand" "r")))]
  ""
  "mov.w	%1,%N0\;shal.w	%N0\;mov.w	%1,%N0\;subx.w	%M0,%M0"
  [(set_attr "cc" "clobber")])

(define_expand "extendhisi2"
  [(set (match_operand:SI 0 "register_operand" "")
	(sign_extend:SI
	 (match_operand:HI 1 "register_operand" "")))]
  ""
  "")

(define_insn "zero_extendhisi2"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	(zero_extend:SI
	 (match_operand:HI 1 "general_operand" "0,rm")))]
  ""
  "@
  	clr.w	%0
	mov.w	%1,%N0\;clr.w	%M0"
  [(set_attr "cc" "clobber")])

(define_insn "extendpsisi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(zero_extend:SI
	 (match_operand:PSI 1 "register_operand" "r")))]
  ""
  "mov.w 	%O1,%N0\;%E1	%S1,%M0"
[(set_attr "cc" "clobber")])

(define_insn "extendhipsi2"
  [(set (match_operand:PSI 0 "register_operand" "=r")
	(zero_extend:PSI
	 (match_operand:HI 1 "register_operand" "r")))]
  ""
  "mov.w	%1,%O0\;%D0	#0,%S0 ! 8"
  [(set_attr "cc" "clobber")])

;; ----------------------------------------------------------------------
;;
;; SHIFTS
;;
;; ----------------------------------------------------------------------
;;
;; We make some attempt to provide real efficient shifting.  One example is
;; doing and 8 bit shift by moving a byte reg into the other reg and moving 0
;; into the former reg.
;;
;; We also try to achieve this in a uniform way.  IE: We don't try to achieve
;; this in both rtl and at insn emit time.  Ideally, we'd use rtl as that would
;; give the optimizer more cracks at the code.  However, we wish to do things
;; like optimizing shifting the sign bit to bit 0 by rotating the other way.
;; There is rtl to handle this (rotate + and), but the h8/300 doesn't handle
;; 16 bit rotates.  Also, if we emit complicated rtl, combine may not be able
;; to detect cases it can optimize.
;;
;; For these and other fuzzy reasons, I've decided to go the less pretty but
;; easier "do it at insn emit time" route.

;; QI BIT SHIFTS

(define_expand "ashlqi3"
  [(set (match_operand:QI 0 "register_operand" "")
	(ashift:QI (match_operand:QI 1 "register_operand" "")
		   (match_operand:HI 2 "nonmemory_operand" "")))]
  ""
  "if (expand_a_shift (QImode, ASHIFT, operands)) DONE;else FAIL;")

(define_expand "ashrqi3"
  [(set (match_operand:QI 0 "register_operand" "")
	(ashiftrt:QI (match_operand:QI 1 "register_operand" "")
		     (match_operand:HI 2 "nonmemory_operand" "")))]
  ""
  "if (expand_a_shift (QImode, ASHIFTRT, operands)) DONE;else FAIL;")

(define_expand "lshrqi3"
  [(set (match_operand:QI 0 "register_operand" "")
	(lshiftrt:QI (match_operand:QI 1 "register_operand" "")
		     (match_operand:HI 2 "nonmemory_operand" "")))]
  ""
  "if (expand_a_shift (QImode, LSHIFTRT, operands)) DONE;else FAIL;")

;; WARNING: The constraints on the scratch register say one is not needed
;; for constant shifts of 1,2,3,4.  Emit_a_shift() must know this.

(define_insn "shiftbyn_QI"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	(match_operator:QI 3 "nshift_operator" 
			[ (match_operand:QI 1 "register_operand" "0,0")
			  (match_operand:HI 2 "nonmemory_operand" "IKM,rn")]))
   (clobber (match_scratch:HI 4 "=X,&r"))]
  ""
  "* return emit_a_shift (insn, operands);"
  [ (set_attr "cc" "clobber")])

;; ----------------------------------------------------------------------
;;
;; HI BIT SHIFTS
;;
;; ----------------------------------------------------------------------

(define_expand "ashlhi3"
  [(set (match_operand:HI 0 "register_operand" "")
	(ashift:HI (match_operand:HI 1 "nonmemory_operand" "")
		   (match_operand:HI 2 "nonmemory_operand" "")))]
  ""
  "if (expand_a_shift (HImode, ASHIFT, operands)) DONE;else FAIL;")

(define_expand "lshrhi3"
  [(set (match_operand:HI 0 "register_operand" "")
	(lshiftrt:HI (match_operand:HI 1 "general_operand" "")
		     (match_operand:HI 2 "nonmemory_operand" "")))]
  ""
  "if (expand_a_shift (HImode, LSHIFTRT, operands)) DONE;else FAIL;")

(define_expand "ashrhi3"
  [(set (match_operand:HI 0 "register_operand" "")
	(ashiftrt:HI (match_operand:HI 1 "register_operand" "")
		     (match_operand:HI 2 "nonmemory_operand" "")))]
  ""
  "if (expand_a_shift (HImode, ASHIFTRT, operands)) DONE;else FAIL;")

;; WARNING: The constraints on the scratch register say one is not needed
;; for constant shifts of 1,2,3,4.  Emit_a_shift() must know this.

(define_insn "shiftbyn_HI"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	(match_operator:HI 3 "nshift_operator" 
			[ (match_operand:HI 1 "register_operand" "0,0")
			  (match_operand:HI 2 "nonmemory_operand" "IKM,rn")]))
   (clobber (match_scratch:HI 4 "=X,&r"))]
  ""
  "* return emit_a_shift (insn, operands);"
  [
   (set_attr "cc" "clobber")])

;; ----------------------------------------------------------------------
;;
;;  SI BIT SHIFTS
;;
;; ----------------------------------------------------------------------

(define_expand "ashlsi3"
  [(set (match_operand:SI 0 "register_operand" "")
	(ashift:SI
	 (match_operand:SI 1 "general_operand" "")
	 (match_operand:HI 2 "nonmemory_operand" "")))]
  ""
  "if (expand_a_shift (SImode, ASHIFT, operands)) DONE;else FAIL;")

(define_expand "lshrsi3"
  [(set (match_operand:SI 0 "register_operand" "")
	(lshiftrt:SI
	 (match_operand:SI 1 "general_operand" "")
	 (match_operand:HI 2 "nonmemory_operand" "")))]
  ""
  "if (expand_a_shift (SImode, LSHIFTRT, operands)) DONE;else FAIL;")

(define_expand "ashrsi3"
  [(set (match_operand:SI 0 "register_operand" "")
	(ashiftrt:SI
	 (match_operand:SI 1 "general_operand" "")
	 (match_operand:HI 2 "nonmemory_operand" "")))]
  ""
  "if (expand_a_shift (SImode, ASHIFTRT, operands)) DONE;else FAIL;")

;; WARNING: The constraints on the scratch register say one is not needed
;; for constant shifts of 1,2.  Emit_a_shift() must know this.

(define_insn "shiftbyn_SI"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	(match_operator:SI 3 "nshift_operator" 
			[ (match_operand:SI 1 "register_operand" "0,0")
			  (match_operand:HI 2 "nonmemory_operand" "IK,rn")]))
   (clobber (match_scratch:HI 4 "=X,&r"))]
  ""
  "* return emit_a_shift (insn, operands);"
  [
   (set_attr "cc" "arith")])


; PSIs oneday ?

(define_insn "shiftbyn_PSI"
  [(set (match_operand:PSI 0 "register_operand" "=r,r")
	(match_operator:PSI 3 "nshift_operator" 
			    [ (match_operand:PSI 1 "register_operand" "0,0")
			      (match_operand:HI 2 "nonmemory_operand" "IK,rn")]))
   (clobber (match_scratch:HI 4 "=X,&r"))]
  ""
  "* return emit_a_shift (insn, operands);"
  [(set_attr "cc" "clobber")])

(define_expand "ashlpsi3"
   [(set (match_operand:PSI 0 "general_operand" "")
	 (ashift:PSI (match_operand:PSI 1 "general_operand" "")
		     (match_operand:HI 2 "nonmemory_operand" "")))]
   ""
   "{ if (expand_a_shift(PSImode,ASHIFT, operands)) DONE; else FAIL; }")

;; This is reached via the expand_divmod in round_push.

(define_insn "lshrpsi3"
   [(set (match_operand:PSI 0 "register_operand" "=ar")
	 (lshiftrt:PSI (match_operand:PSI 1 "register_operand" "%0")
		       (match_operand:HI 2 "nonmemory_operand" "arin")))]
   ""
   "shlr.w	%0 ; %2 lshrpsi3"
  [(set_attr "cc" "clobber")])

;; ----------------------------------------------------------------------
;;
;; Misc
;;
;; ----------------------------------------------------------------------

(define_insn "movstricthi"
  [(set (strict_low_part (match_operand:HI 0 "general_operand" "=r,g"))
	(match_operand:HI 1 "general_operand" "g,r"))]
  ""
  "mov.w	%1,%0"
   [(set_attr "cc" "set")])

(define_insn "movstrictqi"
  [(set (strict_low_part (match_operand:QI 0 "general_operand" "=r,g"))
	(match_operand:QI 1 "general_operand" "g,r"))]
  ""
  "mov.b	%1,%0"
   [(set_attr "cc" "set")])


;;; 'a' is listed separately before 'r', so that it will be chosen
;;; when a reload is needed.  This reduces the number of groups needed.

;;; To reduce the amount of work reload needs to do, we explicitly
;;; don't allow insns that would obviously require reloading, by rejecting
;;; them via the condition.

;;; ??? The push_operand call isn't quite right, it should be a call to
;;; a new *_operand function that only accepts valid PRE_DEC and POST_INC
;;; memory operands.

;;; ??? This probably should use secondary reloads so that it will
;;; accept any reasonable operands without using 'o' and '&'.

;;; We need a 'm'/'r' case, because otherwise a pattern like this
;;; (set (mem (plus (pseudo-reg) (constant))) (pseudo-reg))
;;; needs three ADDR_REG_CLASS reloads, one for each pseuedo-reg, and
;;; one to make the address offsettable.  Unfortunately, the class
;;; only has two registers in it.

(define_insn "movpsi_with_tmp"
  [(set (match_operand:PSI 0 "general_operand" "=<,ra,ra,g")
	(match_operand:PSI 1 "general_operand" "ar,rai,g,rai"))
   (clobber (match_scratch:HI 2 "=X,X,&r,X"))]
  "register_operand (operands[0], PSImode)
   || register_operand (operands[1], PSImode)
   || immediate_operand (operands[1], VOIDmode)"
  "* return movpsi(operands, 1);"
  [(set_attr "cc" "clobber")])

(define_insn ""
  [(set (match_operand:PSI 0 "general_operand" "=a,r,m,o,&a,&r,<>,r")
	(match_operand:PSI 1 "general_operand" "r,r,ri,ri,i,i,ri,<>"))]
  "register_operand (operands[0], PSImode)
   || register_operand (operands[1], PSImode)
   || immediate_operand (operands[1], VOIDmode)"
  "* return movpsi(operands , 0); "
  [(set_attr "cc" "clobber")])

(define_expand "movpsi"
  [(set (match_operand:PSI 0 "general_operand" "")
	(match_operand:PSI 1 "general_operand" ""))]
  ""
  "{ if (prep_move_operands(operands, PSImode)) DONE ; }")

(define_expand "reload_inpsi"
  [(parallel [(set (match_operand:PSI 0 "register_operand" "=r")
		   (match_operand:PSI 1 "memory_operand" "m"))
	      (clobber (match_operand:HI 2 "register_operand" "=&r"))])]
  ""
  "")

;; The g constraint and a register_operand used together are a bit
;; strange, but it does work.  This only means that we will let reload
;; accept a pseudo-reg replaced with a stack address here.
;; we only add/sub to the offset of a segment value

(define_insn "addpsi3_code_short"
  [(set (match_operand:PSI 0 "general_operand" "=r,g,r")
	(plus:PSI (match_dup 0)
		  (match_operand:PSI 1 "immediate_operand" "n,n,i")))
   (clobber (match_scratch:HI 2 "=X,&r,X"))
  ]
  ""
  "@
	add.w	%1,%O0 !a1
	mov.w	%O0,%2\;add.w	%1,%2\;mov.w	%2,%O0 !a2
	mov.w	%S1,%S0\;add.w	%O1,%O0 !a3"
  [(set_attr "cc" "clobber")])
	

(define_insn "addpsi3_medium_code"
   [(set (match_operand:PSI 0 "register_operand" "=r,r,r,o,r")
	 (plus:PSI (match_operand:PSI 1 "register_operand" "%0,0,0,0,0")
		   (match_operand:PSI 2 "nonmemory_operand" "c,r,n,I,g")))]
   "code_size==32 && data_size==16"
  "@
	add.w	%O2,%N0\;stc	%S2,%M0 !mc3
	add.w	%N2,%N0\;addx.w	%M2,%M0 !mc1
	add.w	%2,%O0 ! danger
	add:q.w	%2,%O0 !a5
	add.w	%N2,%N0\;addx.w	%M2,%M0 !mc2"
  [(set_attr "cc" "clobber")])

(define_insn "addpsi3_code"
   [(set (match_operand:PSI 0 "register_operand" "=&r,&r,o,a,r")
	 (plus:PSI (match_operand:PSI 1 "register_operand" "%0,0,0,0,0")
		   (match_operand:PSI 2 "nonmemory_operand" "r,n,I,i,i")))]
   ""
  "@
	%P0jsr	@__addpsi%2%0 !a4
	add.w	%2,%O0 ! danger
	add:q.w	%2,%O0 !a5
	ldc	%S2,%S0\;add.w	%O2,%O0 ! addpsiq
	mov.w	%S2,%S0\;add.w	%O2,%O0 ! addpsiq"
  [(set_attr "cc" "clobber")])

(define_expand "addpsi3"
  [(set (match_operand:PSI 0 "register_operand" "")
	(plus:PSI (match_operand:PSI 1 "register_operand" "")
		  (match_operand:PSI 2 "nonmemory_operand" "")))]
  ""
  "")
	
 (define_insn "subpsi3"
   [(set (match_operand:PSI 0 "register_operand" "=ar")
	 (minus:PSI (match_operand:PSI 1 "register_operand" "%0")
		    (match_operand:PSI 2 "nonmemory_operand" "arin")))]
   ""
   "sub.w	%O2,%O0 ! subpsi3"
  [(set_attr "cc" "clobber")])
	

 (define_insn "mulpsi3"
   [(set (match_operand:PSI 0 "register_operand" "=ar")
	 (mult:PSI (match_operand:PSI 1 "register_operand" "r")
		   (match_operand:PSI 2 "nonmemory_operand" "arin")))]
   ""
   "to be defined later: mulpsi3"
  [(set_attr "cc" "clobber")])


;;; 'a' is listed separately before 'r', so that it will be chosen
;;; when a reload is needed.  This reduces the number of groups needed.

;;; This is a special operation, which does not do what the RTL implies
;;; because of the hidden segmentation registers.  To defeat invalid
;;; optimizations, we use an UNSPEC operator.

(define_insn "truncsipsi2"
   [(set (match_operand:PSI 0 "register_operand" "=a,r")
	 (truncate:PSI (match_operand:SI 1 "register_operand" "r,r")))]
   ""
   "* return truncsipsi(operands);"
  [(set_attr "cc" "clobber")])

;; sign extend followed by shift followed by truncate can just be a
;; shift.

 (define_insn "combine1"
   [(set (match_operand:SI 0 "register_operand" "=r")
	 (sign_extend:SI (match_operand:HI 1 "register_operand" "r")))
    (set (match_dup 0) (ashift:SI (match_dup 0) (const_int 1)))
    (set (match_operand:PSI 2 "register_operand" "=r")
	 (truncate:PSI (match_dup 0)))]
   ""
   "mov.w	%1,%2\;add.w	%1,%2"
  [(set_attr "cc" "clobber")])


;; (define_insn ""
;;   [(set (match_operand:HI 0 "general_operand" "=a,r,g")
;;	 (subreg:HI (match_operand:PSI 1 "general_operand" "g,g,nar") 0))]
;;   ""
;;   "@
;;	ldc	%S1,%S0;p11
;;	mov.w	%S1,%S0;p12
;;	mov.w	%S1,%S0;p13")
;;
;; (define_insn ""
;;   [(set (match_operand:HI 0 "general_operand" "=ra,g")
;;	 (subreg:HI (match_operand:PSI 1 "general_operand" "g,nar") 1))]
;;   ""
;;   "mov.w	%O1,%O0 ! p2")
;;
;; (define_insn ""
;;   [(set (strict_low_part (subreg:HI (match_operand:PSI 0 "general_operand" "=ra,g") 1))
;;	 (subreg:HI (match_operand:PSI 1 "general_operand" "g,nar") 1))]
;;   ""
;;   "mov.w	%O1,%O0 ! p3")
;;
;; (define_insn ""
;;   [(set (subreg:HI (match_operand:PSI  0 "register_operand" "=ra") 0)
;;	 (subreg:HI (plus:PSI (match_operand:PSI 1 "" "")
;;			      (match_operand 2 "" "" )) 0))]
;;   ""
;;   "mov.w	#%%page(%I1+%I2),%0 ! b1 ")
;;
;; (define_insn ""
;;   [(set (subreg:HI (match_operand:PSI  0 "register_operand" "=ra") 1)
;;	 (subreg:HI (plus:PSI (match_operand:PSI 1 "" "")
;;			      (match_operand 2 "" "" )) 1))]
;;   ""
;;   "mov.w	#%%off(%I1+%I2),%0 ! b2")



;; PSI support

 (define_insn "andpsi3"
   [(set (match_operand:PSI 0 "register_operand" "=r")
	 (and:PSI (match_operand:PSI 1 "register_operand" "%0")
		   (match_operand:PSI 2 "nonmemory_operand" "ro")))]
   ""
   "and	%N2,%N0\;and	%M2,%M0"
   [(set_attr "cc" "clobber")])

(define_insn ""
  [(call (mem:QI (match_operand:PSI 0 "call_operand" "Sr"))
	 (match_operand:HI 1 "general_operand" "g"))]
  ""
  "%P0jsr	%L0"
  [(set_attr "cc" "clobber")])


(define_insn "combine2"
  [(set (match_operand:PSI 0 "register_operand" "=r")
	(plus:PSI (zero_extend:PSI (match_operand:HI 1 "general_operand" "g"))
		  (match_operand:PSI 2 "general_operand" "0")))]
  ""
  "add.w	%1,%O0"
  [(set_attr "cc" "clobber")])


;;(define_insn "combine3"
;;  [(set (match_operand:PSI 0 "register_operand" "=r")
;;	(minus:PSI (match_operand:PSI 1 "general_operand" "0")
;;		   (zero_extend:PSI (match_operand:HI 2 "general_operand" "g"))))]
;;  "0"
;;  "sub.w	%2,%O0")

(define_insn "combine4"
  [(set (match_operand:HI 0 "register_operand" "=r")
	(minus:PSI (subreg:HI (match_operand:PSI 1 "general_operand" "g") 1)
		   (subreg:HI (match_operand:PSI 2 "general_operand" "g") 2)))]
  "0"
  "mov.w	%O1,%0\;sub.w	%O2,%0"
  [(set_attr "cc" "clobber")])

(define_insn "combine5"
  [(set (match_operand:PSI 0 "register_operand" "=r")
	(plus:PSI (truncate:PSI (sign_extend:SI (match_operand:HI 1 "general_operand" "g")))
		  (match_operand:PSI 2 "general_operand" "0")))]
  ""
  "add.w	%1,%O0"
  [(set_attr "cc" "clobber")])


;; fancy bit ops borrowed from H8/300
(define_insn "fancybset1"
  [(set (match_operand:QI 0 "never" "=g")
	(ior:QI (subreg:QI 
		 (ashift:HI (const_int 1)
			    (subreg:QI (match_operand:HI 1 "nonmemory_operand" "rn") 0)) 0)
		(match_dup 0)))]
  ""
  "bset.b	%1,%0 ! bs1"
  [(set_attr "cc" "clobber")])

(define_insn "fancybset"
  [(set (match_operand:QI 0 "general_operand" "=g")
	(ior:QI (subreg:QI 
		 (ashift:HI (const_int 1)
			    (match_operand:HI 1 "nonmemory_operand" "rn") ) 0)
		(match_operand:QI 2 "general_operand" "0")))]
  ""
  "bset.b	%1,%0 ! bs2"
  [(set_attr "cc" "clobber")])

(define_insn "fancybclr4"
  [(set (match_operand:QI 0 "general_operand" "=g")
	(and:QI 
	 (subreg:QI 
	  (rotate:HI (const_int -2)
		     (match_operand:HI 2 "nonmemory_operand" "rn") ) 0)
	 (match_operand:QI 1 "general_operand" "0")))]

  ""
  "bclr.b	%2,%0"
  [(set_attr "cc" "clobber")])

(define_insn "fancybclr5"
  [(set (match_operand:QI 0 "general_operand" "=g")
	(and:QI 
	 (subreg:QI 
	  (rotate:HI (const_int -2)
		     (match_operand:QI 2 "nonmemory_operand" "rn")) 0)
	 (match_operand:QI 1 "general_operand" "0")))]
  ""
  "bclr.b	%2,%0 ! l1"
  [(set_attr "cc" "clobber")])

(define_insn "fancybclr2"
  [(set (match_operand:QI 0 "general_operand" "=g")
	(and:QI 
	 (subreg:QI 
	  (rotate:HI (const_int -2)
		     (match_operand:HI 2 "nonmemory_operand" "rn") ) 0)
	 (match_operand:QI 1 "general_operand" "0")))]
  ""
  "bclr.b	%2,%0"
  [(set_attr "cc" "clobber")])


(define_insn "fancybclr3"
  [(set (match_operand:QI 0 "general_operand" "=g")
	(and:QI 
	 (subreg:QI 
	  (rotate:HI (const_int -2)
		     (match_operand:QI 2 "nonmemory_operand" "rn")) 0)
	 (match_operand:QI 1 "general_operand" "0")))]
  ""
  "bclr.b	%2,%0"
  [(set_attr "cc" "clobber")])

(define_insn "fancybclr"
  [(set (match_operand:QI 0 "general_operand" "=r")
	(and:QI (not:QI (match_operand:QI 1 "general_operand" "0"))
		(match_operand:QI 2 "general_operand" "r")))]
  ""
  "not.b	%0\;and.b	%2,%0"
  [(set_attr "cc" "arith")])

(define_insn "fancybsetp3"
  [(set (match_operand:QI 0 "general_operand" "=g")
	(ior:QI (subreg:QI (ashift:HI (const_int 1)
				      (match_operand:QI 1 "register_operand" "r")) 0)
		(match_operand:QI 2 "general_operand" "0")))]
  ""
  "bset.b	%1,%0 !bs3"
  [(set_attr "cc" "clobber")])

;(define_insn "fancybsetp2"
;  [(set (match_operand:QI 0 "general_operand" "=g,r")
;	(ior:QI (subreg:QI (ashift:HI (const_int 1)
;				      (match_operand:QI 1 "register_operand" "r,r")) 0)
;		(match_operand:QI 2 "general_operand" "r,g")))]
;  ""
;  "mov.b	%2,%0\;bset	%1,%0")
	
(define_insn "fancybnot"
  [(set (match_operand:QI 0 "general_operand" "=g")
	(xor:QI (subreg:QI (ashift:HI (const_int 1)
				      (match_operand:HI 1 "register_operand" "r")) 0)
		(match_operand:QI 2 "general_operand" "0")))]
  ""
  "bnot.b	%1,%0"
  [(set_attr "cc" "clobber")])

(define_insn "fancy_btst"
  [(set (pc)
	(if_then_else (eq (zero_extract:HI (zero_extend:HI (match_operand:QI 0 "general_operand" "g"))
					   (const_int 1)
					   (match_operand:HI 1 "nonmemory_operand" "rn"))
			  (const_int 0))
		      (label_ref (match_operand 2 "" ""))
		      (pc)))]
  ""
  "btst.b	%1,%0\;beq	%l2"
  [(set_attr "cc" "clobber")])

(define_insn "fancy_btst1"
  [(set (pc)
	(if_then_else (ne (zero_extract:HI (zero_extend:HI (match_operand:QI 0 "general_operand" "g"))
					   (const_int 1)
					   (match_operand:HI 1 "nonmemory_operand" "rn"))
			  (const_int 0))
		      (label_ref (match_operand 2 "" ""))
		      (pc)))]
  ""
  "btst.b	%1,%0\;bne	%l2"
  [(set_attr "cc" "clobber")])



;; HI bitops

(define_insn "hifancybset1"
  [(set (match_operand:HI 0 "general_operand" "=g")
	(ior:HI (ashift:HI (const_int 1)
			   (match_operand:HI 1 "nonmemory_operand" "rn"))
			   (match_dup 0)))]
  ""
  "bset.w	%1,%0"
  [(set_attr "cc" "clobber")])

(define_insn "hifancybclr4"
  [(set (match_operand:HI 0 "general_operand" "=g")
	(and:HI 
	  (rotate:HI (const_int -2)
		     (match_operand:HI 2 "nonmemory_operand" "rn"))
	 (match_operand:HI 1 "general_operand" "0")))]
  ""
  "bclr.w 	%2,%0"
  [(set_attr "cc" "clobber")])


(define_insn "hifancybclr"
  [(set (match_operand:HI 0 "general_operand" "=r")
	(and:HI (not:HI (match_operand:HI 1 "general_operand" "0"))
		(match_operand:HI 2 "general_operand" "r")))]
  ""
  "not.w	%0\;and.w	%2,%0"
  [(set_attr "cc" "clobber")])


;(define_insn "fancybsetp2"
;  [(set (match_operand:QI 0 "general_operand" "=g,r")
;	(ior:QI (subreg:QI (ashift:HI (const_int 1)
;				      (match_operand:QI 1 "register_operand" "r,r")) 0)
;		(match_operand:QI 2 "general_operand" "r,g")))]
;  ""
;  "mov.b	%2,%0\;bset	%1,%0")
	
(define_insn "hifancybnot"
  [(set (match_operand:HI 0 "general_operand" "=g")
	(xor:HI (ashift:HI (const_int 1)
			   (match_operand:HI 1 "register_operand" "r"))
		(match_operand:HI 2 "general_operand" "0")))]
  ""
  "bnot.w	%1,%0"
  [(set_attr "cc" "clobber")])

(define_insn "hifancy_btst"
  [(set (pc)
	(if_then_else (eq (zero_extract:HI (match_operand:HI 0 "general_operand" "g")
					   (const_int 1)
					   (match_operand:HI 1 "nonmemory_operand" "rn"))
			  (const_int 0))
		      (label_ref (match_operand 2 "" ""))
		      (pc)))]
  ""
  "btst	%1,%0\;beq	%l2"
  [(set_attr "cc" "clobber")])

(define_insn "hifancy_btst1"
  [(set (pc)
	(if_then_else (ne (zero_extract:HI (match_operand:HI 0 "general_operand" "g")
					   (const_int 1)
					   (match_operand:HI 1 "nonmemory_operand" "rn"))
			  (const_int 0))
		      (label_ref (match_operand 2 "" ""))
		      (pc)))]
  ""
  "btst	%1,%0\;bne	%l2"
  [(set_attr "cc" "clobber")])

; peepholes

 (define_peephole
   [(set (match_operand:HI 0 "register_operand" "=r") (plus:HI (match_dup 0) (const_int -1)))
    (set (cc0) (compare:HI (match_dup 0) (const_int -1)))
    (set (pc) (if_then_else (ne (cc0) (const_int 0)) (label_ref (match_operand 1 "" "")) (pc)))]
   ""
   "scb/f	%0,%l1"
  [(set_attr "cc" "clobber")])
	

; turn the common sequence 
;	mov.w	#%off(_foo),r2
;	ldc	#%page(_foo),dp
;	mov.w	bar,@r2
; into 
;	ldc	#%page(_foo),dp
;	mov.w	bar,@(%off(_foo))

(define_peephole 
  [(set (reg:PSI 2)
	(match_operand:PSI 0 "immediate_operand" "=in"))
   (set (match_operand 1 "register_operand" "=r") 
	(mem (reg:PSI 2)))]
  "dead_or_set_p (insn, gen_rtx(REG, PSImode, 2))
   && (GET_MODE (operands[1]) == HImode || GET_MODE (operands[1]) == QImode)"
  "ldc	%S0,dp\;mov%T1	@%Q0,%1"
  [(set_attr "cc" "clobber")])

; turn 
; mov.w	#%off(foo),r2
; mov.w	#%page(foo),dp
; operator bar,@r2
;
; into
; mov.w	#%page(foo),dp
; operator bar,@off(foo)


(define_peephole 
  [(set (reg:PSI 2)
	(match_operand:PSI 0 "immediate_operand" "=in"))
   (set (mem (reg:PSI 2))
	(match_operator 1 "binop_operator"
			[(mem (reg:PSI 2)) (match_operand 2 "general_operand" "g")]))]
  "dead_or_set_p(insn, gen_rtx(REG, PSImode, 2))
	&& (GET_MODE (operands[1]) == HImode || GET_MODE (operands[1]) == QImode)"
  "ldc	%S0,dp\;%R1	%2,@%Q0"
  [(set_attr "cc" "clobber")])


; turn 
; mov.w	#%off(foo),r2
; mov.w	#%page(foo),dp
; operator @r2,reg
;
; into
; mov.w	#%page(foo),dp
; operator @off(foo),reg


(define_peephole 
  [(set (reg:PSI 2)
	(match_operand:PSI 0 "immediate_operand" "=in"))
   (set (match_operand 1 "register_operand" "=r")
	(match_operator 2 "binop_operator"
			[(match_dup 1) (mem (reg:PSI 2))]))]
  "0 && dead_or_set_p(insn, gen_rtx(REG, PSImode, 2))
	&& (GET_MODE (operands[1]) == HImode || GET_MODE (operands[1]) == QImode)"
  "ldc	%S0,dp\;%R2	@%Q0,%1"
  [(set_attr "cc" "clobber")])

(define_peephole
  [(set (reg:PSI 2)
	(match_operand:PSI 0 "immediate_operand" "=in"))
   (set (cc0) (mem:HI (reg:PSI 2)))]
  " dead_or_set_p(insn, gen_rtx(REG, PSImode, 2))"
  "ldc	%S0,dp\;tst.w	@%Q0"
  [(set_attr "cc" "clobber")])

(define_peephole
  [(set (reg:PSI 2)
	(match_operand:PSI 0 "immediate_operand" "=in"))
   (set (cc0) (mem:QI (reg:PSI 2)))]
  "dead_or_set_p(insn, gen_rtx(REG, PSImode, 2))"
  "ldc	%S0,dp\;tst.b	@%Q0"
  [(set_attr "cc" "clobber")])

  


(define_peephole 
  [(set (reg:PSI 2)
	(match_operand:PSI 0 "immediate_operand" "=in"))
   (set (mem (reg:PSI 2))
	(match_operator 2 "unop_operator"
			[(mem (reg:PSI 2))]))]
  "dead_or_set_p(insn, gen_rtx(REG, PSImode, 2))
	&& (GET_MODE (operands[2]) == HImode || GET_MODE (operands[2]) == QImode)"
  "ldc	%S0,dp\;%R2	@%Q0"
  [(set_attr "cc" "clobber")])


(define_peephole
  [(set (reg:PSI 2)
	(match_operand:PSI 0 "immediate_operand" "=in"))
   (set (cc0) (compare:QI (mem:QI (reg:PSI 2)) 
			  (match_operand:QI 1 "general_operand" "g")))]
  "dead_or_set_p(insn, gen_rtx(REG, PSImode, 2))"
  "ldc	%S0,dp\;cmp.b	%1,@%Q0"
  [(set_attr "cc" "clobber")])


(define_peephole
  [(set (reg:PSI 2)
	(match_operand:PSI 0 "immediate_operand" "=in"))
   (set (cc0) (compare:HI (mem:HI (reg:PSI 2)) 
			  (match_operand:HI 1 "general_operand" "g")))]
  "dead_or_set_p(insn, gen_rtx(REG, PSImode, 2))"
  "ldc	%S0,dp\;cmp.w	%1,@%Q0"
  [(set_attr "cc" "clobber")])



;(define_insn "combine6"
;  [(set (match_operand:HI 0 "register_operand" "=rf")
;	(call (mem:QI (zero_extend:SI (match_operand:PSI 1 "register_operand" "r")))
;	      (match_operand 2 "general_operand")))]
;  ""
;  "%Pjsr	%L1")
