/* CYGNUS LOCAL entire file */
/* Definitions of target machine for GNU compiler, for ARM with PE obj format.
   Copyright (C) 1995 Free Software Foundation, Inc.
   Contributed by Doug Evans (dje@cygnus.com).
   
This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "arm/coff.h"

/* Run-time Target Specification.  */
#undef TARGET_VERSION
#define TARGET_VERSION fputs (" (ARM/pe)", stderr)

/* Support the __declspec keyword by turning them into attributes.
   We currently only support: naked, dllimport, and dllexport.
   Note that the current way we do this may result in a collision with
   predefined attributes later on.  This can be solved by using one attribute,
   say __declspec__, and passing args to it.  The problem with that approach
   is that args are not accumulated: each new appearance would clobber any
   existing args.  */
#undef CPP_SPEC
#define CPP_SPEC "\
-D__declspec(x)=__attribute__((x)) \
-D__pe__ \
%{m6:-D__arm6__} \
%{EB:-D__big_endian__} \
"

/* Experimental addition for pr 7885.
   Ignore dllimport for functions.  */
#define TARGET_NOP_FUN_DLLIMPORT (target_flags & 0x20000)

#undef SUBTARGET_SWITCHES
#define SUBTARGET_SWITCHES \
{ "nop-fun-dllimport",		 0x20000 }, \
{ "no-nop-fun-dllimport",	-0x20000 },

#undef TARGET_DEFAULT
#define TARGET_DEFAULT (0x400 + 0x20000) /* soft-float, nop-fun-dllimport */

/* Same as arm.h except r10 is call-saved, not fixed.  */
#undef FIXED_REGISTERS
#define FIXED_REGISTERS \
{			\
  0,0,0,0,0,0,0,0,	\
  0,0,0,1,0,1,0,1,	\
  0,0,0,0,0,0,0,0,	\
  1,1,1			\
}

/* Same as arm.h except r10 is call-saved, not fixed.  */
#undef CALL_USED_REGISTERS
#define CALL_USED_REGISTERS \
{			\
  1,1,1,1,0,0,0,0,	\
  0,0,0,1,1,1,1,1,	\
  1,1,1,1,0,0,0,0,	\
  1,1,1			\
}

/* A C expression whose value is nonzero if IDENTIFIER with arguments ARGS
   is a valid machine specific attribute for DECL.
   The attributes in ATTRIBUTES have previously been assigned to DECL.  */
extern int arm_pe_valid_machine_decl_attribute ();
#undef VALID_MACHINE_DECL_ATTRIBUTE
#define VALID_MACHINE_DECL_ATTRIBUTE(DECL, ATTRIBUTES, IDENTIFIER, ARGS) \
arm_pe_valid_machine_decl_attribute (DECL, ATTRIBUTES, IDENTIFIER, ARGS)

#if 0 /* Needed when we tried type attributes.  */
/* A C expression whose value is zero if the attributes on
   TYPE1 and TYPE2 are incompatible, one if they are compatible,
   and two if they are nearly compatible (which causes a warning to be
   generated).  */
extern int arm_pe_comp_type_attributes ();
#define COMP_TYPE_ATTRIBUTES(TYPE1, TYPE2) \
arm_pe_comp_type_attributes ((TYPE1), (TYPE2))
#endif

extern union tree_node *arm_pe_merge_machine_decl_attributes ();
#define MERGE_MACHINE_DECL_ATTRIBUTES(OLD, NEW) \
arm_pe_merge_machine_decl_attributes ((OLD), (NEW))

/* In addition to the stuff done in arm.h, we must mark dll symbols specially.
   Definitions of dllexport'd objects install some info in the .drectve
   section.  References to dllimport'd objects are fetched indirectly via
   __imp_.  If both are declared, dllexport overrides.
   Note that we can be called twice on the same decl.  */
extern void arm_pe_encode_section_info ();
#undef ENCODE_SECTION_INFO
#define ENCODE_SECTION_INFO(DECL) \
arm_pe_encode_section_info (DECL)

/* Used to implement dllexport overriding dllimport semantics.  It's also used
   to handle vtables - the first pass won't do anything because
   DECL_CONTEXT (DECL) will be 0 so arm_dll{ex,im}port_p will return 0.
   It's also used to handle dllimport override semantics.  */
#if 0
#define REDO_SECTION_INFO_P(DECL) \
((DECL_MACHINE_ATTRIBUTES (DECL) != NULL_TREE) \
 || (TREE_CODE (DECL) == VAR_DECL && DECL_VIRTUAL_P (DECL)))
#else
#define REDO_SECTION_INFO_P(DECL) 1
#endif

/* Utility used only in this file.  */
#define ARM_STRIP_NAME_ENCODING(SYM_NAME) \
((SYM_NAME) + ((SYM_NAME)[0] == '@' ? 3 : 0))

/* Strip any text from SYM_NAME added by ENCODE_SECTION_INFO and store
   the result in VAR.  */
#undef STRIP_NAME_ENCODING
#define STRIP_NAME_ENCODING(VAR, SYM_NAME) \
(VAR) = ARM_STRIP_NAME_ENCODING (SYM_NAME)

/* This outputs a lot of .req's to define alias for various registers.
   Let's try to avoid this.  */
#undef ASM_FILE_START
#define ASM_FILE_START(STREAM) \
do {								\
  extern char *version_string;					\
  fprintf (STREAM, "%s Generated by gcc %s for ARM/pe\n",	\
	   ASM_COMMENT_START, version_string);			\
  output_file_directive ((STREAM), main_input_filename);	\
} while (0)

/* Output a reference to a label.  */
#undef ASM_OUTPUT_LABELREF
#define ASM_OUTPUT_LABELREF(STREAM, NAME)  \
fprintf (STREAM, "%s%s", USER_LABEL_PREFIX, ARM_STRIP_NAME_ENCODING (NAME))

/* Output a function definition label.  */
#undef ASM_DECLARE_FUNCTION_NAME
#define ASM_DECLARE_FUNCTION_NAME(STREAM, NAME, DECL) \
do {							\
  if (arm_dllexport_name_p (NAME))			\
    {							\
      drectve_section ();				\
      fprintf (STREAM, "\t.ascii \" -export:%s\"\n",	\
	       ARM_STRIP_NAME_ENCODING (NAME));		\
      function_section (DECL);				\
    }							\
  ASM_OUTPUT_LABEL ((STREAM), (NAME));			\
} while (0)

/* Output a common block.  */
#undef ASM_OUTPUT_COMMON
#define ASM_OUTPUT_COMMON(STREAM, NAME, SIZE, ROUNDED) \
do {							\
  if (arm_dllexport_name_p (NAME))			\
    {							\
      drectve_section ();				\
      fprintf ((STREAM), "\t.ascii \" -export:%s\"\n",	\
	       ARM_STRIP_NAME_ENCODING (NAME));		\
    }							\
  if (! arm_dllimport_name_p (NAME))			\
    {							\
      fprintf ((STREAM), "\t.comm\t"); 			\
      assemble_name ((STREAM), (NAME));			\
      fprintf ((STREAM), ", %d\t%s %d\n",		\
	       (ROUNDED), ASM_COMMENT_START, (SIZE));	\
    }							\
} while (0)

/* Output the label for an initialized variable.  */
#undef ASM_DECLARE_OBJECT_NAME
#define ASM_DECLARE_OBJECT_NAME(STREAM, NAME, DECL) \
do {							\
  if (arm_dllexport_name_p (NAME))			\
    {							\
      enum in_section save_section = in_section;	\
      drectve_section ();				\
      fprintf (STREAM, "\t.ascii \" -export:%s\"\n",	\
	       ARM_STRIP_NAME_ENCODING (NAME));		\
      switch_to_section (save_section, (DECL));		\
    }							\
  ASM_OUTPUT_LABEL ((STREAM), (NAME));			\
} while (0)

/* Support the ctors/dtors and other sections.  */

#define DRECTVE_SECTION_ASM_OP	"\t.section .drectve"

/* A list of other sections which the compiler might be "in" at any
   given time.  */

#undef SUBTARGET_EXTRA_SECTIONS
#define SUBTARGET_EXTRA_SECTIONS in_drectve,

/* A list of extra section function definitions.  */

#undef SUBTARGET_EXTRA_SECTION_FUNCTIONS
#define SUBTARGET_EXTRA_SECTION_FUNCTIONS \
  DRECTVE_SECTION_FUNCTION	\
  SWITCH_TO_SECTION_FUNCTION

#define DRECTVE_SECTION_FUNCTION \
void									\
drectve_section ()							\
{									\
  if (in_section != in_drectve)						\
    {									\
      fprintf (asm_out_file, "%s\n", DRECTVE_SECTION_ASM_OP);		\
      in_section = in_drectve;						\
    }									\
}

/* Switch to SECTION (an `enum in_section').

   ??? This facility should be provided by GCC proper.
   The problem is that we want to temporarily switch sections in
   ASM_DECLARE_OBJECT_NAME and then switch back to the original section
   afterwards.  */
#define SWITCH_TO_SECTION_FUNCTION \
void \
switch_to_section (section, decl) \
     enum in_section section; \
     tree decl; \
{ \
  switch (section) \
    { \
      case in_text: text_section (); break; \
      case in_data: data_section (); break; \
      case in_named: named_section (decl, NULL); break; \
      case in_rdata: rdata_section (); break; \
      case in_ctors: ctors_section (); break; \
      case in_dtors: dtors_section (); break; \
      case in_drectve: drectve_section (); break; \
      default: abort (); break; \
    } \
}
