unmount_any () {
	local partitions="`mounted_partitions`"
	if [ $? -ne 0 -o -z "$partitions" ]; then
		msgBox \
"$partitions No mounted disk partitions were detected." \
		"Problem"
		return 1
	fi
	cat >$TempFile <<EOF
	menu \\
	 "Select the disk partition to un-mount." \\
	 "Select Disk Partition" \\
EOF
	local index=0
	for p in $partitions; do
		index=`math $index 1 add`
		echo -n " "$p" " >>$TempFile
		echo " \"\" \\" >>$TempFile
	done
	echo "">>$TempFile
	local partition="`. $TempFile`"
	local status=$?
	rm -f $TempFile
	if [ $status -ne 0 -o -z "$partition" ]; then return 1; fi
	unmount_partition $partition
	return $?
}
